using System;
//This is needed for Vectors to store our bananna locations and speed
using Microsoft.DirectX;
//This is so we can tap into the key input to exit on ESC key enters
using Microsoft.DirectX.DirectInput;
//This is where the game engine is defined
using DarkStrideToolbox;


namespace BlankDSEngineTemplate
{
	public class frmMain : System.Windows.Forms.Form
	{
		#region Properties
		private System.ComponentModel.Container components = null;
		private DSGameEngine m_oGameEngine = null;

		private Vector2 m_vBananaPosition = new Vector2( 0.0f,0.0f );
		private Vector2 m_vBananaDirection = new Vector2( m_cSPEED,0.0f );

		private const int m_cBMPSIZE = 52;
		private const string m_cTXTRKEY_BANANA = "TextureKey_Banana";
		private float m_nXBoundry = 200.0f;
		private float m_nYBoundry = 200.0f;
		private const float m_cSPEED = 100.0f;

		private float m_nAngle = 0.0f;
		#endregion Properties
        

		#region System Initializations
		public frmMain()
		{
			// Required for Windows Form Designer support
			InitializeComponent();
		}

		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(336, 253);
			this.Name = "frmMain";
			this.Text = "DSGameEngine Template Project";

		}
		#endregion
		#endregion

		[STAThread]
		static void Main() 
		{
			try
			{
				using( frmMain oApp = new frmMain() )
				{                
					oApp.DSGameEngine = new DSGameEngine( oApp,DarkStrideToolbox.RenderMode.TwoD,false );
					oApp.DSGameEngine.OneTimeSceneInitialization += new EventHandler( oApp.OneTimeSceneInitialization );
					oApp.DSGameEngine.Render += new EventHandler( oApp.Render );
					oApp.DSGameEngine.FrameMove += new EventHandler( oApp.FrameMove );
					oApp.DSGameEngine.Run();
				}
			}
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( new System.Exception( "BlankDSEngineTemplate.frmMain.Main Failed.",oEx ) );
			}
		}


		//This call is made once, once the device has been created
		public void OneTimeSceneInitialization(object sender, System.EventArgs e)
		{
			//Give us a way out
			m_oGameEngine.DirectInput.RegisterDelegate_KeyboardKeyUp( new DSInputWrapper.CallbackKeyboardKeyUp( this.frmMain_KeyboardKeyUp ) );

			//Get Development path gets the current path and then if your in debug mode backs you up to
			//the root of the development path, very handy.
			DSResourceManager.GetGlobalInstance().LoadTexture( m_cTXTRKEY_BANANA,
														DSMisc.GetDevelopmentAppPath() + @"Banana.bmp",
														System.Drawing.Color.Black );

			//Calculate what our boundry should be
			m_nXBoundry = m_oGameEngine.Direct3DDevice.PresentationParameters.BackBufferWidth - 64.0f;
			m_nYBoundry = m_oGameEngine.Direct3DDevice.PresentationParameters.BackBufferHeight - 64.0f;
		}
		//This function is called by the game engine.  It moves the world forward in time.
		private void FrameMove(object sender, System.EventArgs e)
		{
			DSGameEngineArgs oArgs = (DSGameEngineArgs)e;


			//Advance our bananna 
			m_vBananaPosition += m_vBananaDirection * (float)oArgs.ElapsedTime;
 
			//If we hit the edge then change course
			if( m_vBananaPosition.X > m_nXBoundry )
			{
				m_vBananaDirection = new Vector2( 0.0f,m_cSPEED );
				m_vBananaPosition.X = m_nXBoundry;
			}
			else if( m_vBananaPosition.Y > m_nYBoundry )
			{
				m_vBananaDirection = new Vector2( -m_cSPEED,0.0f );
				m_vBananaPosition.Y = m_nYBoundry;
			}
			else if( m_vBananaPosition.X < 0 )
			{
				m_vBananaDirection = new Vector2( 0.0f,-m_cSPEED );
				m_vBananaPosition.X = 0.0f;
			}
			else if( m_vBananaPosition.Y < 0 )
			{
				m_vBananaDirection = new Vector2( m_cSPEED,0.0f );
				m_vBananaPosition.Y = 0.0f;
			}

			//Advance our rotation
			m_nAngle += .001f;
		}
		//Called once per frame, the call is the entry point for rendering. This 
		//function sets up render states, clears the viewport, and renders the scene.
		private void Render(object sender, System.EventArgs e)
		{
			System.Drawing.Rectangle oTargetRect;


			m_oGameEngine.RenderText( 0,0,System.Drawing.Color.White,m_oGameEngine.FrameStats  );

			oTargetRect = new System.Drawing.Rectangle( (int)m_vBananaPosition.X,(int)m_vBananaPosition.Y,0,0 );
			m_oGameEngine.RenderTexture2D( m_cTXTRKEY_BANANA,System.Drawing.Rectangle.Empty,
										   oTargetRect,new Vector2(),0.0f,0.0f,false,
										   System.Drawing.Color.White.ToArgb() );


			oTargetRect = new System.Drawing.Rectangle( (int)(m_nXBoundry/2),(int)(m_nYBoundry/2),0,0 );
			m_oGameEngine.RenderTexture2D( m_cTXTRKEY_BANANA,System.Drawing.Rectangle.Empty,
								oTargetRect,new Vector2( m_cBMPSIZE/2,m_cBMPSIZE/2 ),m_nAngle,
								0,false,System.Drawing.Color.White.ToArgb() );
		}


		private bool frmMain_KeyboardKeyUp( Key oKey,bool[] oState )
		{
			if( oKey == Key.Escape )
			{
				Close();
			}
			return( false );
		}



		#region Properties
		public DSGameEngine DSGameEngine
		{
			set
			{
				m_oGameEngine = value;
			}
			get
			{
				return( m_oGameEngine );
			}
		}
		#endregion
	}
}
