using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;


namespace PHPNukeContentEditor
{
	//impliment true back tracking of traits because when you enter a table you have to reasssert them, and then when you leave
	//the table you have to know if you need to close them or not.  Also make the generated HTML look beter
	public class frmMain : System.Windows.Forms.Form
	{
		long m_nSpacing = 0;
		#region Properties
		private frmResults m_oResults = null;

		static char[] hexDigits = {	  '0', '1', '2', '3', '4', '5', '6', '7',
									  '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
		#endregion

		#region System Stuff
		private System.Windows.Forms.Splitter splitTop;
		private System.Windows.Forms.Panel pnlBottom;
		private System.Windows.Forms.Button cmdConvertToPHPHTML;
		private System.Windows.Forms.Button cmdViewResults;
		private System.Windows.Forms.Panel pnlTop;
		private System.Windows.Forms.RichTextBox rtbPHPHTML;
		private System.Windows.Forms.RichTextBox rtbNormal;
		private System.Windows.Forms.Splitter spltTop;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.splitTop = new System.Windows.Forms.Splitter();
			this.pnlBottom = new System.Windows.Forms.Panel();
			this.cmdConvertToPHPHTML = new System.Windows.Forms.Button();
			this.cmdViewResults = new System.Windows.Forms.Button();
			this.pnlTop = new System.Windows.Forms.Panel();
			this.rtbNormal = new System.Windows.Forms.RichTextBox();
			this.rtbPHPHTML = new System.Windows.Forms.RichTextBox();
			this.spltTop = new System.Windows.Forms.Splitter();
			this.pnlBottom.SuspendLayout();
			this.pnlTop.SuspendLayout();
			this.SuspendLayout();
			// 
			// splitTop
			// 
			this.splitTop.Location = new System.Drawing.Point(0, 0);
			this.splitTop.Name = "splitTop";
			this.splitTop.TabIndex = 0;
			this.splitTop.TabStop = false;
			// 
			// pnlBottom
			// 
			this.pnlBottom.Controls.Add(this.cmdConvertToPHPHTML);
			this.pnlBottom.Controls.Add(this.cmdViewResults);
			this.pnlBottom.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.pnlBottom.Location = new System.Drawing.Point(0, 341);
			this.pnlBottom.Name = "pnlBottom";
			this.pnlBottom.Size = new System.Drawing.Size(752, 40);
			this.pnlBottom.TabIndex = 7;
			// 
			// cmdConvertToPHPHTML
			// 
			this.cmdConvertToPHPHTML.Location = new System.Drawing.Point(8, 8);
			this.cmdConvertToPHPHTML.Name = "cmdConvertToPHPHTML";
			this.cmdConvertToPHPHTML.Size = new System.Drawing.Size(144, 24);
			this.cmdConvertToPHPHTML.TabIndex = 2;
			this.cmdConvertToPHPHTML.Text = "&Convert To PHP HTML";
			this.cmdConvertToPHPHTML.Click += new System.EventHandler(this.cmdConvertToPHPHTML_Click);
			// 
			// cmdViewResults
			// 
			this.cmdViewResults.Location = new System.Drawing.Point(312, 8);
			this.cmdViewResults.Name = "cmdViewResults";
			this.cmdViewResults.Size = new System.Drawing.Size(144, 24);
			this.cmdViewResults.TabIndex = 1;
			this.cmdViewResults.Text = "&View Results";
			this.cmdViewResults.Click += new System.EventHandler(this.cmdViewResults_Click);
			// 
			// pnlTop
			// 
			this.pnlTop.Controls.Add(this.rtbNormal);
			this.pnlTop.Controls.Add(this.rtbPHPHTML);
			this.pnlTop.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlTop.Location = new System.Drawing.Point(0, 0);
			this.pnlTop.Name = "pnlTop";
			this.pnlTop.Size = new System.Drawing.Size(752, 341);
			this.pnlTop.TabIndex = 8;
			// 
			// rtbNormal
			// 
			this.rtbNormal.Dock = System.Windows.Forms.DockStyle.Left;
			this.rtbNormal.Location = new System.Drawing.Point(0, 0);
			this.rtbNormal.Name = "rtbNormal";
			this.rtbNormal.Size = new System.Drawing.Size(296, 341);
			this.rtbNormal.TabIndex = 3;
			this.rtbNormal.Text = "";
			// 
			// rtbPHPHTML
			// 
			this.rtbPHPHTML.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rtbPHPHTML.Location = new System.Drawing.Point(304, 0);
			this.rtbPHPHTML.Name = "rtbPHPHTML";
			this.rtbPHPHTML.Size = new System.Drawing.Size(448, 341);
			this.rtbPHPHTML.TabIndex = 1;
			this.rtbPHPHTML.Text = "";
			// 
			// spltTop
			// 
			this.spltTop.Location = new System.Drawing.Point(0, 0);
			this.spltTop.Name = "spltTop";
			this.spltTop.TabIndex = 0;
			this.spltTop.TabStop = false;
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(752, 381);
			this.Controls.Add(this.pnlTop);
			this.Controls.Add(this.pnlBottom);
			this.Name = "frmMain";
			this.Text = "WYSIWYG Word To PHP Nuke HTML Converter";
			this.pnlBottom.ResumeLayout(false);
			this.pnlTop.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
		public static void Main(string[] args)
		{
			Application.Run(new frmMain());
		}

		#endregion


		private void cmdConvertToPHPHTML_Click(object sender, System.EventArgs e)
		{
			rtbPHPHTML.Text = ConvertRTBToPHPHTML( rtbNormal );
		}

		private void cmdViewResults_Click(object sender, System.EventArgs e)
		{
			cmdViewResults.Enabled = false;

			if( m_oResults == null )
			{
				m_oResults = new frmResults();
				m_oResults.Show();
			}

			m_oResults.PopulateWebBrowser( this.rtbPHPHTML.Text );
			m_oResults.Visible = true;
			m_oResults.Focus();

			cmdViewResults.Enabled = true;
		}


		private string ConvertRTBToPHPHTML( System.Windows.Forms.RichTextBox oInputRTB )
		{
			System.Collections.Stack oStates = new System.Collections.Stack();
			CurrentIndentState oCurState = new CurrentIndentState();
			CurrentIndentState oOldState = null;
			char cCurItem = (char)0;
			char[] caChars = null;
			string sCurItem = "";
			string sOutput = "";
			bool bSkipAddingIt = false;


			m_nSpacing = 0;

			//Show our progress bar
			frmProgressBar oProgBar = new frmProgressBar();
			oProgBar.Show();

			for( int i=0 ; i<oInputRTB.Text.Length && oProgBar.UserCancelled == false ; i++ )
			{
				//Update our progress bar
				oProgBar.SetProgress( i,oInputRTB.Text.Length );
				Application.DoEvents();

				bSkipAddingIt = false;

				oInputRTB.Select( i,1 );
				
				sCurItem = oInputRTB.SelectedText;
				caChars = sCurItem.ToCharArray();
				cCurItem = caChars[ 0 ];



				//Setup the indent
				if( oCurState.Indent != oInputRTB.SelectionIndent || oCurState.HangingIndent != oInputRTB.SelectionHangingIndent )
				{
					//First find out if we are leaving an indent area and if so collapse this one
					if( oStates.Count > 0 )//&& oInputRTB.SelectionIndent < oCurState.Indent )
					{
						//Turn off anything we turned on inside this table
						sOutput += SetBoldStatus( false,oCurState.Bold );
						sOutput += SetColorStatus( false,oCurState.Color );
						sOutput += SetCenteringStatus( false,oCurState.Centering );

						//Leave this table
						m_nSpacing--;
						sOutput += "\n" + GetSpacing() + 
								   "</td></tr></table>";
						oOldState = oCurState;
						oCurState = (CurrentIndentState)oStates.Pop();

						//Update our new state with any changes from our old state
						if( oOldState.Bold != oCurState.Bold )
						{
							sOutput += SetBoldStatus( oOldState.Bold,true );
							oCurState.Bold = oOldState.Bold;
						}
						if( oOldState.Color != oCurState.Color )
						{
							sOutput += SetColorStatus( false,oCurState.Color );
							sOutput += SetColorStatus( true,oOldState.Color );
							oCurState.Color = oOldState.Color;
						}
						if( oOldState.Centering != oCurState.Centering )
						{
							sOutput += SetCenteringStatus( false,oCurState.Centering );
							sOutput += SetCenteringStatus( true,oOldState.Centering );
							oCurState.Centering = oOldState.Centering;
						}
					}

					//A new table is needed
					if( oStates.Count > 0 && oCurState.Indent == ((CurrentIndentState)oStates.Peek()).Indent &&
						oCurState.HangingIndent == ((CurrentIndentState)oStates.Peek()).HangingIndent )
					{
						//Start a new table now
						oCurState = (CurrentIndentState)oStates.Pop();

						//Set our state
						if( oCurState.Bold == true )
						{
							sOutput += "\n" + GetSpacing();
						}
						sOutput += SetBoldStatus( true,oCurState.Bold );
						sOutput += SetColorStatus( true,oCurState.Color );

					}
					else if( ( oStates.Count == 0 && oInputRTB.SelectionIndent + oInputRTB.SelectionHangingIndent > 0 ) || oStates.Count > 0 )
					{
						//Start a new table now
						oStates.Push( oCurState );
						oCurState = oCurState.Copy();
						oCurState.Indent = oInputRTB.SelectionIndent;
						oCurState.HangingIndent = oInputRTB.SelectionHangingIndent;

						//Start our table
						sOutput += "\n" + GetSpacing() +  
							"<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">" + 
							"<tr><td valign=\"top\" width=\"" + (oCurState.Indent + oCurState.HangingIndent).ToString() + "\">" + 
							"</td><td valign=\"top\">";
						m_nSpacing++;

						//Set our state
						if( oCurState.Bold == true )
						{
							sOutput += "\n" + GetSpacing();
						}
						sOutput += SetBoldStatus( true,oCurState.Bold );
						sOutput += SetColorStatus( true,oCurState.Color );
						sOutput += SetCenteringStatus( true,oCurState.Centering );
					}
					else
					{
						oCurState.Indent = oInputRTB.SelectionIndent;
						oCurState.HangingIndent = oInputRTB.SelectionHangingIndent;
					}

					//Setup our indent
					if( oCurState.HangingIndent < oCurState.Indent )
					{
						for( int n=0 ; n<(int)((double)Math.Abs(oCurState.HangingIndent - oCurState.Indent)/5.0) ; n++ )
						{
							sOutput += "&nbsp;";
						}
					}
				}

				//Setup tabs and charage returns
				if( sCurItem.CompareTo( "\n" ) == 0 )
				{
					bSkipAddingIt = true;
					sOutput += "<br>";
				}
				else if( sCurItem.CompareTo( "\t" ) == 0 )
				{
					bSkipAddingIt = true;
					sOutput += "&nbsp;&nbsp;";
				}

				//Setup the bold status
				if( oCurState.Bold != oInputRTB.SelectionFont.Bold )
				{
					sOutput += SetBoldStatus( oInputRTB.SelectionFont.Bold,true );
					oCurState.Bold = oInputRTB.SelectionFont.Bold;
				}

				//Setup the color
				if( oCurState.Color != oInputRTB.SelectionColor )
				{
					sOutput += SetColorStatus( false,oCurState.Color );
					sOutput += SetColorStatus( true,oInputRTB.SelectionColor );
					oCurState.Color = oInputRTB.SelectionColor;
				}

				//Setup centering
				if( oCurState.Centering != oInputRTB.SelectionAlignment )
				{
					sOutput += SetCenteringStatus( false,oCurState.Centering );
					sOutput += SetCenteringStatus( true,oInputRTB.SelectionAlignment );
					oCurState.Centering = oInputRTB.SelectionAlignment;
				}

				
				if( bSkipAddingIt == false )
				{
					sOutput += cCurItem;
				}
			}

			//Since were now done we have to close out any tables left open
			if( oCurState.Indent > 0 )
			{
				m_nSpacing--;
				sOutput += "\n" + GetSpacing() + 
						   "</td></tr></table>";
			}
			while( oStates.Count > 0 )
			{
				oCurState = (CurrentIndentState)oStates.Pop();

				if( oCurState.Indent > 0 )
				{
					m_nSpacing--;
					sOutput += "\n" + GetSpacing() + 
							   "</td></tr></table>";
				}
			}
	


			//If the user cancelled then abort the entire conversion			
			if( oProgBar.UserCancelled == true )
			{
				sOutput = "";
			}

			//Close the progress bar
			oProgBar.Close();
			oProgBar = null;


			return( sOutput );
		}


		public string SetBoldStatus( bool bStarting,bool bCurBoldStatus )
		{
			string sOutput = "";


			if( bCurBoldStatus == true )
			{
				if( bStarting == true )
				{
					sOutput += "<b>";
				}
				else
				{
					sOutput += "</b>";
				}
			}


			return( sOutput );
		}
		public string SetColorStatus( bool bStarting,Color nCurColor )
		{
			string sOutput = "";


			if( nCurColor != System.Drawing.Color.Black )
			{
				if( bStarting == true )
				{
					sOutput += "\n" + GetSpacing() + "<FONT COLOR=\"" + ColorToHexString( nCurColor ) + "\">";
				}
				else
				{
					sOutput += "\n" + GetSpacing() + "</FONT>";
				}
			}


			return( sOutput );
		}
		public string SetCenteringStatus( bool bStarting,System.Windows.Forms.HorizontalAlignment nCurCentering )
		{
			string sOutput = "";


			if( nCurCentering != System.Windows.Forms.HorizontalAlignment.Left )
			{
				if( bStarting == true )
				{
					if( nCurCentering == System.Windows.Forms.HorizontalAlignment.Center )
					{
						sOutput += "\n" + GetSpacing() + "<p align=center >";
					}
					else if( nCurCentering == System.Windows.Forms.HorizontalAlignment.Right )
					{
						sOutput += "\n" + GetSpacing() + "<p align=right >";
					}
				}
				else
				{
					sOutput += "</p>";
				}
			}


			return( sOutput );
		}


		private string GetSpacing()
		{
			string sOutput = "";

			for( int i=0 ; i<m_nSpacing*5 ; i++ )
			{
				sOutput += " ";
			}

			return( sOutput );
		}


		//Convert a .NET Color to a hex string.
		public static string ColorToHexString(Color color) 
		{
			byte[] bytes = new byte[3];
			bytes[0] = color.R;
			bytes[1] = color.G;
			bytes[2] = color.B;
			char[] chars = new char[bytes.Length * 2];
			for (int i = 0; i < bytes.Length; i++) 
			{
				int b = bytes[i];
				chars[i * 2] = hexDigits[b >> 4];
				chars[i * 2 + 1] = hexDigits[b & 0xF];
			}
			return new string(chars);
		}

	}
}
