using System.IO;
using System;
using System.Drawing;
using System.ComponentModel;
using System.Windows.Forms;
using Microsoft.Win32;

using AxSHDocVw;
using MSHTML;
 


namespace PHPNukeContentEditor
{
	public class frmResults : Form
	{
		#region Properties
		private bool m_bDoneLoading = true;
		#endregion

		#region Setup
		private AxWebBrowser AxWebBrowser;
		private ToolBarButton TbEdit;
		private ToolBarButton TbSeperator3;
		private ToolBarButton TbPrint;
		private ToolBarButton TbMail;
		private ToolBarButton TbSeperator2;
		private ToolBarButton TbHistory;
		private ToolBarButton TbFavorites;
		private ToolBarButton TbSearch;
		private ToolBarButton TbSeperator1;
		private ToolBarButton TbHome;
		private ToolBarButton TbRefresh;
		private ToolBarButton TbStop;
		private ToolBarButton TbForward;
		private System.Windows.Forms.Button cmdHide;
		private ToolBarButton TbBack;
		#endregion


		public frmResults()
		{
			InitializeComponent();

			((System.ComponentModel.ISupportInitialize)(AxWebBrowser)).BeginInit();

			this.AxWebBrowser.BeginInit();
      
			AxWebBrowser.EndInit();
      
			AxWebBrowser.RegisterAsBrowser = true;
			AxWebBrowser.RegisterAsDropTarget = true;
			AxWebBrowser.Silent = false;
      
			Object o = null;
      
			//Update toolbar
			AxWebBrowser.ExecWB(SHDocVw.OLECMDID.OLECMDID_UPDATECOMMANDS,
								SHDocVw.OLECMDEXECOPT.OLECMDEXECOPT_DONTPROMPTUSER,
								ref o, ref o);
		}
    
    
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmResults));
			this.AxWebBrowser = new AxSHDocVw.AxWebBrowser();
			this.TbStop = new System.Windows.Forms.ToolBarButton();
			this.TbSeperator3 = new System.Windows.Forms.ToolBarButton();
			this.TbSeperator2 = new System.Windows.Forms.ToolBarButton();
			this.TbSeperator1 = new System.Windows.Forms.ToolBarButton();
			this.TbPrint = new System.Windows.Forms.ToolBarButton();
			this.TbFavorites = new System.Windows.Forms.ToolBarButton();
			this.TbBack = new System.Windows.Forms.ToolBarButton();
			this.TbForward = new System.Windows.Forms.ToolBarButton();
			this.TbHome = new System.Windows.Forms.ToolBarButton();
			this.TbEdit = new System.Windows.Forms.ToolBarButton();
			this.TbHistory = new System.Windows.Forms.ToolBarButton();
			this.TbSearch = new System.Windows.Forms.ToolBarButton();
			this.TbRefresh = new System.Windows.Forms.ToolBarButton();
			this.TbMail = new System.Windows.Forms.ToolBarButton();
			this.cmdHide = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.AxWebBrowser)).BeginInit();
			this.SuspendLayout();
			// 
			// AxWebBrowser
			// 
			this.AxWebBrowser.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.AxWebBrowser.Enabled = true;
			this.AxWebBrowser.Location = new System.Drawing.Point(8, 8);
			this.AxWebBrowser.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("AxWebBrowser.OcxState")));
			this.AxWebBrowser.Size = new System.Drawing.Size(544, 408);
			this.AxWebBrowser.TabIndex = 1;
			this.AxWebBrowser.StatusTextChange += new AxSHDocVw.DWebBrowserEvents2_StatusTextChangeEventHandler(this.AxWebBrowser_StatusTextChange);
			this.AxWebBrowser.CommandStateChange += new AxSHDocVw.DWebBrowserEvents2_CommandStateChangeEventHandler(this.AxWebBrowser_CommandStateChange);
			this.AxWebBrowser.TitleChange += new AxSHDocVw.DWebBrowserEvents2_TitleChangeEventHandler(this.AxWebBrowser_TitleChange);
			this.AxWebBrowser.DocumentComplete += new AxSHDocVw.DWebBrowserEvents2_DocumentCompleteEventHandler(this.AxWebBrowser_DocumentComplete);
			// 
			// TbStop
			// 
			this.TbStop.ImageIndex = 2;
			this.TbStop.ToolTipText = "Stop";
			// 
			// TbSeperator3
			// 
			this.TbSeperator3.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// TbSeperator2
			// 
			this.TbSeperator2.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// TbSeperator1
			// 
			this.TbSeperator1.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// TbPrint
			// 
			this.TbPrint.ImageIndex = 7;
			this.TbPrint.ToolTipText = "Print";
			// 
			// TbFavorites
			// 
			this.TbFavorites.ImageIndex = 6;
			this.TbFavorites.ToolTipText = "Favourites";
			// 
			// TbBack
			// 
			this.TbBack.Enabled = false;
			this.TbBack.ImageIndex = 0;
			this.TbBack.Style = System.Windows.Forms.ToolBarButtonStyle.DropDownButton;
			this.TbBack.ToolTipText = "Back";
			// 
			// TbForward
			// 
			this.TbForward.Enabled = false;
			this.TbForward.ImageIndex = 1;
			this.TbForward.Style = System.Windows.Forms.ToolBarButtonStyle.DropDownButton;
			this.TbForward.ToolTipText = "Forward";
			// 
			// TbHome
			// 
			this.TbHome.ImageIndex = 4;
			this.TbHome.ToolTipText = "Home";
			// 
			// TbEdit
			// 
			this.TbEdit.ImageIndex = 15;
			this.TbEdit.ToolTipText = "Edit";
			// 
			// TbHistory
			// 
			this.TbHistory.ImageIndex = 12;
			this.TbHistory.ToolTipText = "History";
			// 
			// TbSearch
			// 
			this.TbSearch.ImageIndex = 5;
			this.TbSearch.ToolTipText = "Search";
			// 
			// TbRefresh
			// 
			this.TbRefresh.ImageIndex = 3;
			this.TbRefresh.ToolTipText = "Refresh";
			// 
			// TbMail
			// 
			this.TbMail.ImageIndex = 13;
			this.TbMail.ToolTipText = "Mail";
			// 
			// cmdHide
			// 
			this.cmdHide.Anchor = System.Windows.Forms.AnchorStyles.None;
			this.cmdHide.Location = new System.Drawing.Point(480, 424);
			this.cmdHide.Name = "cmdHide";
			this.cmdHide.Size = new System.Drawing.Size(72, 24);
			this.cmdHide.TabIndex = 2;
			this.cmdHide.Text = "&Close";
			this.cmdHide.Click += new System.EventHandler(this.cmdHide_Click);
			// 
			// frmResults
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(560, 453);
			this.ControlBox = false;
			this.Controls.Add(this.cmdHide);
			this.Controls.Add(this.AxWebBrowser);
			this.Name = "frmResults";
			this.Text = "Results";
			this.WindowState = System.Windows.Forms.FormWindowState.Minimized;
			this.Resize += new System.EventHandler(this.frmResults_Resize);
			((System.ComponentModel.ISupportInitialize)(this.AxWebBrowser)).EndInit();
			this.ResumeLayout(false);

		}


		public void PopulateWebBrowser( string sHTML )
		{
			HTMLDocumentClass oDocument = null;
			System.Object nullObject = 0;
			System.Object nullObjStr = "";
			Cursor.Current = Cursors.WaitCursor;


			Navigate( "about:blank" );

			oDocument = (HTMLDocumentClass)AxWebBrowser.Document;
			oDocument.IHTMLDocument2_write( sHTML );

			Cursor.Current = Cursors.Default;	
		}

		private void frmResults_Resize(object sender, System.EventArgs e)
		{
			AxWebBrowser.Left = 8;
			AxWebBrowser.Top = 8;
			AxWebBrowser.Width = this.Width - 8 * 2 - 8;
			AxWebBrowser.Height = this.Height - 8 * 2 - 30 - 20;

			cmdHide.Left = this.Width - cmdHide.Width - 15;
			cmdHide.Top = this.Height - cmdHide.Height - 30;
		}

		private void cmdHide_Click(object sender, System.EventArgs e)
		{
			this.Visible = false;
		}


		#region WebEvents
		protected void barStatus_DrawItem(object sender, StatusBarDrawItemEventArgs sbdevent)
		{
      	}
		protected void barStatus_PanelClick(object sender, StatusBarPanelClickEventArgs e)
		{
      
		}

		protected void AxWebBrowser_WindowSetWidth(object sender, DWebBrowserEvents2_WindowSetWidthEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowSetTop(object sender, DWebBrowserEvents2_WindowSetTopEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowSetResizable(object sender, DWebBrowserEvents2_WindowSetResizableEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowSetLeft(object sender, DWebBrowserEvents2_WindowSetLeftEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowSetHeight(object sender, DWebBrowserEvents2_WindowSetHeightEvent e)
		{
      
		}
		protected void AxWebBrowser_WindowClosing(object sender, DWebBrowserEvents2_WindowClosingEvent e)
		{
      
		}
		protected void AxWebBrowser_TitleChange(object sender, DWebBrowserEvents2_TitleChangeEvent e)
		{
		}
		protected void AxWebBrowser_StatusTextChange(object sender, DWebBrowserEvents2_StatusTextChangeEvent e)
		{
		}
		protected void AxWebBrowser_SetSecureLockIcon(object sender, DWebBrowserEvents2_SetSecureLockIconEvent e)
		{
      
		}
		protected void AxWebBrowser_PropertyChange(object sender, DWebBrowserEvents2_PropertyChangeEvent e)
		{
      
		}
		protected void AxWebBrowser_ProgressChange(object sender, DWebBrowserEvents2_ProgressChangeEvent e)
		{
      
		}
		protected void AxWebBrowser_OnVisible(object sender, DWebBrowserEvents2_OnVisibleEvent e)
		{
      
		}
		protected void AxWebBrowser_OnToolBar(object sender, DWebBrowserEvents2_OnToolBarEvent e)
		{
      
		}
		protected void AxWebBrowser_OnTheaterMode(object sender, DWebBrowserEvents2_OnTheaterModeEvent e)
		{
      
		}
		protected void AxWebBrowser_OnStatusBar(object sender, DWebBrowserEvents2_OnStatusBarEvent e)
		{
      
		}
		protected void AxWebBrowser_OnQuit(object sender, EventArgs e)
		{
      
		}
		protected void AxWebBrowser_OnMenuBar(object sender, DWebBrowserEvents2_OnMenuBarEvent e)
		{
      
		}
		protected void AxWebBrowser_OnFullScreen(object sender, DWebBrowserEvents2_OnFullScreenEvent e)
		{
      
		}
		protected void AxWebBrowser_NewWindow2(object sender, DWebBrowserEvents2_NewWindow2Event e)
		{
			e.cancel = true;
		}
		protected void AxWebBrowser_NavigateComplete2(object sender, DWebBrowserEvents2_NavigateComplete2Event e)
		{
			IHTMLDocument4 id4;
			object boxID4 = AxWebBrowser.Document;
			id4 = (IHTMLDocument4)boxID4;
			// For testing only...

		}
		protected void AxWebBrowser_FileDownload(object sender, DWebBrowserEvents2_FileDownloadEvent e)
		{
      
		}
		protected void AxWebBrowser_DownloadComplete(object sender, EventArgs e)
		{
		}
		protected void AxWebBrowser_DownloadBegin(object sender, EventArgs   e)
		{
		}
		protected void AxWebBrowser_DocumentComplete(object sender, DWebBrowserEvents2_DocumentCompleteEvent e)
		{
			m_bDoneLoading = true;
		}
		protected void AxWebBrowser_CommandStateChange(object sender, DWebBrowserEvents2_CommandStateChangeEvent e)
		{
			if(e.command.Equals(SHDocVw.CommandStateChangeConstants.CSC_NAVIGATEBACK))
			{
				TbBack.Enabled = e.enable;
			}
			if(e.command.Equals(SHDocVw.CommandStateChangeConstants.CSC_NAVIGATEFORWARD))
			{
				TbForward.Enabled = e.enable;
			}
			if(e.command.Equals(SHDocVw.CommandStateChangeConstants.CSC_UPDATECOMMANDS))
			{
				Int32 EnabledTest = Convert.ToInt32(SHDocVw.OLECMDF.OLECMDF_SUPPORTED)
					+ Convert.ToInt32(SHDocVw.OLECMDF.OLECMDF_ENABLED);
				bool RefreshTest = EnabledTest.Equals(AxWebBrowser.QueryStatusWB //Refresh
					(SHDocVw.OLECMDID.OLECMDID_REFRESH));
        
				TbRefresh.Enabled = RefreshTest;
				TbMail.Enabled = RefreshTest;
				TbEdit.Enabled = RefreshTest;
				TbStop.Enabled = AxWebBrowser.Busy;
				TbPrint.Enabled = EnabledTest.Equals(AxWebBrowser.QueryStatusWB
					(SHDocVw.OLECMDID.OLECMDID_PRINT));
			}
		}
		protected void AxWebBrowser_ClientToHostWindow(object sender, DWebBrowserEvents2_ClientToHostWindowEvent e)
		{
      
		}
		protected void AxWebBrowser_BeforeNavigate2(object sender, DWebBrowserEvents2_BeforeNavigate2Event e)
		{

		}
		#endregion


		/*private bool WebControl_Click()
		{
			return( true );
		}*/



		private void SetFontSize(Int32 nNewSize)
		{
			Object o = null;
			Object size = (object)nNewSize;
			AxWebBrowser.ExecWB(SHDocVw.OLECMDID.OLECMDID_ZOOM,
				SHDocVw.OLECMDEXECOPT.OLECMDEXECOPT_DONTPROMPTUSER,
				ref size, ref o);
		}

		private object GetControlWait( string sInnerText,double nNumMinutesToWait,bool bExactMatchRequired,string sLimitToClass )
		{
			return( GetControlWait( sInnerText,nNumMinutesToWait,false,bExactMatchRequired,sLimitToClass ) );
		}
		private object GetControlWait( string sInnerText,double nNumMinutesToWait,bool bCheckTableCells,bool bExactMatchRequired,string sLimitToClass )
		{
			DateTime dtStop;
			DateTime dtStart = DateTime.Now;
			object oRetVal = null;


			dtStop = dtStart.AddMinutes( nNumMinutesToWait );

			while( oRetVal == null && dtStop > DateTime.Now )
			{
				oRetVal = GetControlByInnerText( sInnerText,bCheckTableCells,bExactMatchRequired,sLimitToClass );

				for( int i=0 ; i<50 && oRetVal == null ; i++ )
				{
					Application.DoEvents();
				}
			}

			return( oRetVal );			
		}
		private object GetControlByInnerText( string sInnerText,bool bCheckTableCells,
											  bool bExactMatchRequired,string sLimitToClass )
		{
			object oRetVal = null;
			string sTypeName = "";
			string sLoopInnerText = "";
			HTMLDocumentClass oDocument = null;
			

			oDocument = (HTMLDocumentClass)AxWebBrowser.Document;

			oRetVal = oDocument.all.item( sInnerText,0 );
			if( oRetVal == null )
			{
				foreach( object oLoopElement in oDocument.all )
				{
					sTypeName = oLoopElement.GetType().ToString().ToUpper();

					if( sTypeName == "MSHTML.HTMLCommentElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLCommentElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLCommentElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLCommentElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLHtmlElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLHtmlElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLHeadElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLHeadElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLTitleElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLTitleElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLStyleElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLStyleElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLLinkElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLLinkElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLParaElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLParaElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLSpanElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLSpanElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLDivElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLDivElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLScriptElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLScriptElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLBodyClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLBodyClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLImgClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLImgClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLMetaElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLMetaElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLHeaderElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLHeaderElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "MSHTML.HTMLInputElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLInputElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLFormElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLFormElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLTableClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLTableClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLTableSectionClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLTableSectionClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLLabelElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLLabelElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLTableCellClass".ToUpper() )
					{
						if( bCheckTableCells == true )
						{
							sLoopInnerText = ((HTMLTableCellClass)oLoopElement).innerText;
						}
						else
						{
							sLoopInnerText = "";
						}
					}
					else if( sTypeName == "mshtml.HTMLTableRowClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLTableRowClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLBRElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLBRElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLLIElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLLIElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLUListElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLUListElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLNoShowElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLNoShowElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLPhraseElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLPhraseElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLAnchorElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLAnchorElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLButtonElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLButtonElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLBaseElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLBaseElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLFieldSetElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLFieldSetElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLFontElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLFontElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLUnknownElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLUnknownElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLObjectElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLObjectElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLHRElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLHRElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLIFrameClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLIFrameClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLMapElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLMapElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLAreaElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLAreaElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLLegendElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLLegendElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLTableCaptionClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLTableCaptionClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLBlockElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLBlockElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLSelectElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLSelectElementClass)oLoopElement).innerText;
					}
					else if( sTypeName == "mshtml.HTMLOptionElementClass".ToUpper() )
					{
						sLoopInnerText = ((HTMLOptionElementClass)oLoopElement).innerText;
					}
					else
					{
						throw new System.Exception( "Unable to identify type <" + oLoopElement.GetType().ToString() + ">" );
					}

					if( ( sLimitToClass == "" || sLimitToClass.ToUpper() == sTypeName ) &&
						(
							sInnerText == sLoopInnerText ||
							sLoopInnerText != null &&
							(
								( sLoopInnerText.IndexOf( sInnerText ) != -1 && bExactMatchRequired == false )
								|| sInnerText == sLoopInnerText 
							)
						)
					)
					{
						oRetVal = oLoopElement;
						break;
					}
				}
			}
			return( oRetVal );
		}

		private void Navigate( string sURL )
		{
			Navigate( sURL,true );
		}

		private void Navigate( string sURL,bool bWaitTillAppChanges )
		{
			object oFiller = null;


			//Always go here
			m_bDoneLoading = false;

			AxWebBrowser.Navigate( sURL,ref oFiller,ref oFiller,ref oFiller, ref oFiller );
			
			//Then wait till were done			
			while( m_bDoneLoading == false && bWaitTillAppChanges == true )
			{
				Application.DoEvents();
			}
		}

	}
}