Attribute VB_Name = "Module1"
Option Explicit

Private Declare Function DeleteFile Lib "kernel32" Alias "DeleteFileA" (ByVal lpFilename As String) As Long

Global g_bCancelHit As Boolean
Global g_sQueryChoosen As String

Global g_sCurrentFileName As String
Global g_sCurrentName As String
Global g_sCurrentExt As String

Public Declare Function CopyFile Lib "kernel32" Alias "CopyFileA" (ByVal lpExistingFileName As String, ByVal lpNewFileName As String, ByVal bFailIfExists As Long) As Long

Public Declare Function GetFileAttributes Lib "kernel32" Alias "GetFileAttributesA" (ByVal lpFilename As String) As Long
    Global Const FILE_ATTRIBUTE_DIRECTORY = &H10

Public Declare Function MoveFile Lib "kernel32" Alias "MoveFileA" (ByVal lpExistingFileName As String, ByVal lpNewFileName As String) As Long

'This is for tracking the shell in space finder
Public Declare Function GetExitCodeProcess Lib "kernel32" (ByVal hProcess As Long, lpExitCode As Long) As Long
Public Declare Function CloseHandle Lib "kernel32" (ByVal hObject As Long) As Long
Public Declare Function OpenProcess Lib "kernel32" (ByVal dwDesiredAccess As Long, ByVal bInheritHandle As Long, ByVal dwProcessId As Long) As Long
Public Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long
Public Declare Function GetParent Lib "user32" (ByVal hwnd As Long) As Long
Public Declare Function GetWindowThreadProcessId Lib "user32" (ByVal hwnd As Long, lpdwProcessId As Long) As Long
    Public Const PROCESS_QUERY_INFORMATION = &H400
    Public Const STATUS_PENDING = &H103&
Public Declare Function GetWindow Lib "user32" (ByVal hwnd As Long, ByVal wCmd As Long) As Long
    ' GetWindow() Constants
    Public Const GW_HWNDFIRST = 0
    Public Const GW_HWNDLAST = 1
    Public Const GW_HWNDNEXT = 2
    Public Const GW_HWNDPREV = 3
    Public Const GW_OWNER = 4
    Public Const GW_CHILD = 5
    Public Const GW_MAX = 5

Public Const STANDARD_RIGHTS_ALL = &H1F0000 'No special user rights needed to open t ' his process


Public Declare Function WaitForSingleObject Lib "kernel32" (ByVal hHandle As Long, ByVal dwMilliseconds As Long) As Long
Public Const WAIT_FAILED = &HFFFFFFFF 'Our WaitForSingleObject failed to wait and returned -1
Public Const WAIT_OBJECT_0 = &H0& 'The waitable object got signaled '
Public Const WAIT_ABANDONED = &H80& 'We got out of the waitable object
Public Const WAIT_TIMEOUT = &H102& 'the interval we used, timed out.


Global g_bDebugModeOn As Boolean


Public Sub LogIt(sMsg As String)

    Dim nFreeFile As Long
    
    If g_bDebugModeOn = True Then
    
        nFreeFile = FreeFile
        Open App.Path & "\tmpCToolLogging.OUT" For Append As #nFreeFile
        
            Print #nFreeFile, TimerToTime(Timer) & "    " & sMsg
        
        Close #nFreeFile
    
    End If

End Sub

Public Function IsFormOpen(colForms As Object, sFormName As String) As Boolean
    
    Dim i As Long
    IsFormOpen = False

    'Add the player to the dm listing if it is open!
    For i = 0 To colForms.Count - 1
        If colForms(i).Name = sFormName Then
            IsFormOpen = True
            Exit Function
        End If
    Next i

End Function

Public Function DeleteFileIfExists(sFileName As String) As Boolean
    DeleteFileIfExists = False
    If Len(Dir(sFileName)) > 0 Then
        Call DeleteFile(sFileName)
    End If
End Function

Public Function Between(vMin As Variant, vNumber As Variant, vMax As Variant) As Variant
    Between = Max(vMin, vNumber)
    Between = Min(vMax, Between)
End Function

Public Function Max(vVal1 As Variant, vVal2 As Variant) As Variant
    If vVal1 > vVal2 Then
        Max = vVal1
    Else
        Max = vVal2
    End If
End Function
Public Function Min(vVal1 As Variant, vVal2 As Variant) As Variant
    If vVal1 < vVal2 Then
        Min = vVal1
    Else
        Min = vVal2
    End If
End Function


Public Function TimerToTime(dTimer As Double) As String
    
    Dim nH As Long
    Dim nM As Long
    Dim nS As Long
    
    nH = Fix(dTimer / 3600)
    nM = Fix((dTimer - nH * 3600) / 60)
    nS = dTimer - nH * 3600 - nM * 60
    
    TimerToTime = TimeSerial(nH, nM, nS)

End Function

