VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsDirectory"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'All Sizes are in bytes
Private m_sName As String
Private m_nSize As Double
Private m_nSubSize As Double
Private m_oSubDirs As New Collection

Public Sub Add(sName As String, nSize As Double)
DoEvents
    Dim sTemp As String
    Dim oSubDir As clsDirectory
    Dim nWhere As Long

    If m_sName = "" And m_oSubDirs.Count = 0 Then
        nWhere = InStr(sName, "\")
        If nWhere < Len(sName) Then
            m_sName = Left(sName, nWhere)
            m_nSize = 0
            m_nSubSize = 0
            
            Call Add(sName, nSize)
        Else
            m_sName = sName
            m_nSize = nSize
            m_nSubSize = 0
        End If
    Else
        m_nSubSize = m_nSubSize + nSize
        sTemp = Mid(sName, Len(m_sName) + 1)
        
        Set oSubDir = GetSubDir(sTemp)
        If oSubDir Is Nothing Then
            Set oSubDir = New clsDirectory
            Call m_oSubDirs.Add(oSubDir)
        End If
        
        Call oSubDir.Add(sTemp, nSize)
    End If

End Sub
Private Function GetSubDir(sName As String) As clsDirectory
    
    Dim oLoopDir As clsDirectory
    
    Set GetSubDir = Nothing
    
    For Each oLoopDir In m_oSubDirs
        If oLoopDir.Name = Left(sName, Len(oLoopDir.Name)) Then
            Set GetSubDir = oLoopDir
        End If
    Next oLoopDir

End Function

Public Function GetDir(sName As String) As clsDirectory

    Set GetDir = Nothing
    Dim sTName As String

    If sName = m_sName Then
        Set GetDir = Me
    Else
        sTName = Mid(sName, Len(m_sName) + 1)
    
        Set GetDir = GetSubDir(sTName)
        If Not GetDir Is Nothing Then
            Set GetDir = GetDir.GetDir(sTName)
        End If
    End If

End Function

Public Property Get Name() As String
    Name = m_sName
End Property
Public Property Let Name(sNew As String)
    m_sName = sNew
End Property

Public Property Get SizeInGig() As Double
    SizeInGig = (m_nSubSize + m_nSize) / 1000000000
End Property

Public Function GetDisplayText(nType As Long) As String

    If nType = 0 Then
        GetDisplayText = FormatNumber(m_nSize + m_nSubSize, 0) & " bytes  " & m_sName
    ElseIf nType = 1 Then
        GetDisplayText = FormatNumber((m_nSubSize + m_nSize) / 1000000, 0) & " MB  " & m_sName
    ElseIf nType = 2 Then
        GetDisplayText = FormatNumber((m_nSubSize + m_nSize) / 1000000000, 2) & " Gig  " & m_sName
    End If

End Function

Public Property Get Size() As Double
    Size = m_nSize
End Property
Public Property Let Size(nNew As Double)
    m_nSize = nNew
End Property

Public Property Get SubSize() As Double
    SubSize = m_nSubSize
End Property
Public Property Let SubSize(nNew As Double)
    m_nSubSize = nNew
End Property

Public Property Get SubDirs() As Collection
    Set SubDirs = m_oSubDirs
End Property
