using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using DarkStrideToolbox;


namespace DSGobEditor
{
	public class frmSpriteSheetZoom : System.Windows.Forms.Form
	{
		#region Properties
		private Bitmap m_oBitmap = null;
		private int[] m_naBorders = null;

		private bool m_bLoadingScreen = false;
		#endregion

        #region System Stuff
		private System.Windows.Forms.Panel pnlSpriteSheet_Misc3;
		private System.Windows.Forms.PictureBox picSpriteSheetPreview;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button cmdDone;
		private System.Windows.Forms.RadioButton rdoPosition;
		private System.Windows.Forms.RadioButton rdoSize;
		private System.Windows.Forms.TextBox txtLeft;
		private System.Windows.Forms.TextBox txtUp;
		private System.Windows.Forms.TextBox txtDown;
		private System.Windows.Forms.TextBox txtRight;
		private System.Windows.Forms.Label lblSpriteSheetPicSize;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox txtMove;
		private System.Windows.Forms.ComboBox cmbZoomLevel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmSpriteSheetZoom()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.pnlSpriteSheet_Misc3 = new System.Windows.Forms.Panel();
			this.picSpriteSheetPreview = new System.Windows.Forms.PictureBox();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.lblSpriteSheetPicSize = new System.Windows.Forms.Label();
			this.txtRight = new System.Windows.Forms.TextBox();
			this.txtDown = new System.Windows.Forms.TextBox();
			this.txtUp = new System.Windows.Forms.TextBox();
			this.txtLeft = new System.Windows.Forms.TextBox();
			this.rdoSize = new System.Windows.Forms.RadioButton();
			this.rdoPosition = new System.Windows.Forms.RadioButton();
			this.cmdDone = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.txtMove = new System.Windows.Forms.TextBox();
			this.cmbZoomLevel = new System.Windows.Forms.ComboBox();
			this.pnlSpriteSheet_Misc3.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// pnlSpriteSheet_Misc3
			// 
			this.pnlSpriteSheet_Misc3.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlSpriteSheet_Misc3.AutoScroll = true;
			this.pnlSpriteSheet_Misc3.Controls.Add(this.picSpriteSheetPreview);
			this.pnlSpriteSheet_Misc3.Location = new System.Drawing.Point(0, 0);
			this.pnlSpriteSheet_Misc3.Name = "pnlSpriteSheet_Misc3";
			this.pnlSpriteSheet_Misc3.Size = new System.Drawing.Size(376, 200);
			this.pnlSpriteSheet_Misc3.TabIndex = 99;
			// 
			// picSpriteSheetPreview
			// 
			this.picSpriteSheetPreview.Location = new System.Drawing.Point(0, 0);
			this.picSpriteSheetPreview.Name = "picSpriteSheetPreview";
			this.picSpriteSheetPreview.Size = new System.Drawing.Size(80, 32);
			this.picSpriteSheetPreview.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picSpriteSheetPreview.TabIndex = 94;
			this.picSpriteSheetPreview.TabStop = false;
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.txtMove);
			this.groupBox1.Controls.Add(this.cmbZoomLevel);
			this.groupBox1.Controls.Add(this.lblSpriteSheetPicSize);
			this.groupBox1.Controls.Add(this.txtRight);
			this.groupBox1.Controls.Add(this.txtDown);
			this.groupBox1.Controls.Add(this.txtUp);
			this.groupBox1.Controls.Add(this.txtLeft);
			this.groupBox1.Controls.Add(this.rdoSize);
			this.groupBox1.Controls.Add(this.rdoPosition);
			this.groupBox1.Controls.Add(this.cmdDone);
			this.groupBox1.Controls.Add(this.label1);
			this.groupBox1.Location = new System.Drawing.Point(3, 200);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(372, 80);
			this.groupBox1.TabIndex = 100;
			this.groupBox1.TabStop = false;
			// 
			// lblSpriteSheetPicSize
			// 
			this.lblSpriteSheetPicSize.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblSpriteSheetPicSize.Location = new System.Drawing.Point(272, 13);
			this.lblSpriteSheetPicSize.Name = "lblSpriteSheetPicSize";
			this.lblSpriteSheetPicSize.Size = new System.Drawing.Size(88, 16);
			this.lblSpriteSheetPicSize.TabIndex = 99;
			this.lblSpriteSheetPicSize.Text = "<Pic Size>";
			this.lblSpriteSheetPicSize.TextAlign = System.Drawing.ContentAlignment.TopRight;
			// 
			// txtRight
			// 
			this.txtRight.Location = new System.Drawing.Point(264, 32);
			this.txtRight.Name = "txtRight";
			this.txtRight.Size = new System.Drawing.Size(40, 20);
			this.txtRight.TabIndex = 6;
			this.txtRight.Text = "0";
			this.txtRight.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.txtRight.TextChanged += new System.EventHandler(this.txtBorders_TextChanged);
			// 
			// txtDown
			// 
			this.txtDown.Location = new System.Drawing.Point(216, 48);
			this.txtDown.Name = "txtDown";
			this.txtDown.Size = new System.Drawing.Size(40, 20);
			this.txtDown.TabIndex = 5;
			this.txtDown.Text = "0";
			this.txtDown.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.txtDown.TextChanged += new System.EventHandler(this.txtBorders_TextChanged);
			// 
			// txtUp
			// 
			this.txtUp.Location = new System.Drawing.Point(216, 16);
			this.txtUp.Name = "txtUp";
			this.txtUp.Size = new System.Drawing.Size(40, 20);
			this.txtUp.TabIndex = 4;
			this.txtUp.Text = "0";
			this.txtUp.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.txtUp.TextChanged += new System.EventHandler(this.txtBorders_TextChanged);
			// 
			// txtLeft
			// 
			this.txtLeft.Location = new System.Drawing.Point(168, 32);
			this.txtLeft.Name = "txtLeft";
			this.txtLeft.Size = new System.Drawing.Size(40, 20);
			this.txtLeft.TabIndex = 3;
			this.txtLeft.Text = "0";
			this.txtLeft.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.txtLeft.TextChanged += new System.EventHandler(this.txtBorders_TextChanged);
			// 
			// rdoSize
			// 
			this.rdoSize.Location = new System.Drawing.Point(8, 32);
			this.rdoSize.Name = "rdoSize";
			this.rdoSize.Size = new System.Drawing.Size(112, 16);
			this.rdoSize.TabIndex = 2;
			this.rdoSize.Text = "Adjust size";
			// 
			// rdoPosition
			// 
			this.rdoPosition.Checked = true;
			this.rdoPosition.Location = new System.Drawing.Point(8, 16);
			this.rdoPosition.Name = "rdoPosition";
			this.rdoPosition.Size = new System.Drawing.Size(112, 16);
			this.rdoPosition.TabIndex = 1;
			this.rdoPosition.TabStop = true;
			this.rdoPosition.Text = "Adjust position";
			// 
			// cmdDone
			// 
			this.cmdDone.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdDone.Location = new System.Drawing.Point(312, 51);
			this.cmdDone.Name = "cmdDone";
			this.cmdDone.Size = new System.Drawing.Size(56, 24);
			this.cmdDone.TabIndex = 0;
			this.cmdDone.Text = "Done";
			this.cmdDone.Click += new System.EventHandler(this.cmdDone_Click);
			// 
			// label1
			// 
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.label1.AutoSize = true;
			this.label1.Location = new System.Drawing.Point(64, 56);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(42, 16);
			this.label1.TabIndex = 100;
			this.label1.Text = "x Zoom";
			// 
			// txtMove
			// 
			this.txtMove.Location = new System.Drawing.Point(104, 16);
			this.txtMove.Multiline = true;
			this.txtMove.Name = "txtMove";
			this.txtMove.Size = new System.Drawing.Size(40, 32);
			this.txtMove.TabIndex = 101;
			this.txtMove.Text = "";
			this.txtMove.KeyDown += new System.Windows.Forms.KeyEventHandler(this.frmSpriteSheetZoom_KeyDown);
			// 
			// cmbZoomLevel
			// 
			this.cmbZoomLevel.ItemHeight = 13;
			this.cmbZoomLevel.Items.AddRange(new object[] {
															  "1",
															  "2",
															  "4",
															  "10"});
			this.cmbZoomLevel.Location = new System.Drawing.Point(8, 52);
			this.cmbZoomLevel.Name = "cmbZoomLevel";
			this.cmbZoomLevel.Size = new System.Drawing.Size(56, 21);
			this.cmbZoomLevel.TabIndex = 100;
			this.cmbZoomLevel.Text = "1";
			this.cmbZoomLevel.TextChanged += new System.EventHandler(this.cmbZoomLevel_TextChanged);
			this.cmbZoomLevel.SelectedValueChanged += new System.EventHandler(this.cmbZoomLevel_SelectedValueChanged);
			// 
			// frmSpriteSheetZoom
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(376, 285);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.pnlSpriteSheet_Misc3);
			this.MinimumSize = new System.Drawing.Size(384, 312);
			this.Name = "frmSpriteSheetZoom";
			this.Text = "Sprite sheet zoom";
			this.Load += new System.EventHandler(this.frmSpriteSheetZoom_Load);
			this.pnlSpriteSheet_Misc3.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
		#endregion


		private void frmSpriteSheetZoom_Load(object sender, System.EventArgs e)
		{
			m_bLoadingScreen = true;
			txtLeft.Text = m_naBorders[0].ToString();
			txtUp.Text = m_naBorders[1].ToString();
			txtRight.Text = m_naBorders[2].ToString();
			txtDown.Text = m_naBorders[3].ToString();
			m_bLoadingScreen = false;

			UpdatePicture();
		}

		public void Setup( Bitmap oBitmap,int[] naBorders )
		{
			m_oBitmap = oBitmap;
			m_naBorders = naBorders;
		}


		private void UpdatePicture()
		{
			System.Drawing.Rectangle oSrcRect = System.Drawing.Rectangle.Empty;
			System.Drawing.Rectangle oDestRect = System.Drawing.Rectangle.Empty;
			Graphics oGraphics = null;
			Bitmap oFilePic = null;
			double nZoomAmount = 1;



			//Get our zoom amount
			if( DSMisc.IsNumericDouble( cmbZoomLevel.Text ) == true )
			{
				nZoomAmount = Convert.ToDouble( cmbZoomLevel.Text );
			}

			lblSpriteSheetPicSize.Text = "Size: (" + m_naBorders[2].ToString() + "," + m_naBorders[3].ToString() + ")";

			//Format our bitmap properly
			oFilePic = Globals.ConvertIndexedToRGBBitMap( m_oBitmap );

			//Get our source rect
			if( m_naBorders[0] == 0 && m_naBorders[1] == 0 && m_naBorders[2] == 0 && m_naBorders[3] == 0 )
			{
				oSrcRect = new System.Drawing.Rectangle( 0,0,oFilePic.Width,oFilePic.Height );
			}
			else
			{
				oSrcRect = new System.Drawing.Rectangle( m_naBorders[0],m_naBorders[1],m_naBorders[2],m_naBorders[3] );
			}
			//Are we zooming?
			oDestRect = new System.Drawing.Rectangle( 0,0,
										(int)( oSrcRect.Width * nZoomAmount ),
										(int)( oSrcRect.Height * nZoomAmount ) );
			

			//Draw our sub-section
			picSpriteSheetPreview.Image = new Bitmap(oDestRect.Width,oDestRect.Height);
			oGraphics = Graphics.FromImage(picSpriteSheetPreview.Image);
			picSpriteSheetPreview.Width = oDestRect.Width;
			picSpriteSheetPreview.Height = oDestRect.Height;
			oGraphics.DrawImage( oFilePic,oDestRect,oSrcRect,System.Drawing.GraphicsUnit.Pixel );
		}

		private void cmbZoomLevel_SelectedValueChanged(object sender, System.EventArgs e)
		{
			UpdatePicture();
		}
		private void cmbZoomLevel_TextChanged(object sender, System.EventArgs e)
		{
			UpdatePicture();
		}

		private void txtBorders_TextChanged(object sender, System.EventArgs e)
		{
			if( m_bLoadingScreen == false &&
				DSMisc.IsNumericLong( txtLeft.Text ) == true &&
				DSMisc.IsNumericLong( txtUp.Text ) == true &&
				DSMisc.IsNumericLong( txtRight.Text ) == true &&
				DSMisc.IsNumericLong( txtDown.Text ) == true )
			{
				m_naBorders[0] = Convert.ToInt16( txtLeft.Text );
				m_naBorders[1] = Convert.ToInt16( txtUp.Text );
				m_naBorders[2] = Convert.ToInt16( txtRight.Text );
				m_naBorders[3] = Convert.ToInt16( txtDown.Text );

				UpdatePicture();
			}
		}

		private void cmdDone_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}


		private void frmSpriteSheetZoom_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			int nTemp = 0;
			int nChangeX = 0;
			int nChangeY = 0;


			//Left
			if( e.KeyValue == 37 )
			{
				nChangeX = -1;
			}
			//Up
			else if( e.KeyValue == 38 )
			{
				nChangeY = -1;
			}
			//Right
			else if( e.KeyValue == 39 )
			{
				nChangeX = 1;
			}
			//Down
			else if( e.KeyValue == 40 )
			{
				nChangeY = 1;
			}			

			//Adjust us
			if( rdoPosition.Checked == true )
			{
				nTemp = Convert.ToInt16( txtLeft.Text ) - nChangeX;
				txtLeft.Text = nTemp.ToString();
				nTemp = Convert.ToInt16( txtUp.Text ) - nChangeY;
				txtUp.Text = nTemp.ToString();
			}
			else if( rdoSize.Checked == true )
			{
				nTemp = Convert.ToInt16( txtRight.Text ) + nChangeX;
				txtRight.Text = nTemp.ToString();
				nTemp = Convert.ToInt16( txtDown.Text ) + nChangeY;
				txtDown.Text = nTemp.ToString();
			}
		}



		#region Properties
		public int[] Borders
		{
			get
			{
				return( m_naBorders );
			}
		}
		#endregion
	}
}
