using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using System.IO;


//Examples
//"D:\src\_Mine\ShallowEnd\bin\Debug\DarkStrideToolbox.dll" "D:\src\_Mine\ShallowEnd\bin\Debug\DarkStrideToolbox.dll.New" "D:\src\_Mine\ShallowEnd\bin\Debug\RemotingTestBed.exe" "D:\src\_Mine\ShallowEnd\bin\Debug\RemotingTestBed.exe.New"  /b /d /l:"D:\src\_Mine\ShallowEnd\bin\Debug\RemotingTestBed.exe" 
//Target1.txt Replacement1.txt Target2.txt Replacement2.txt /b /l:"target1.txt" /d
namespace Recoil
{
	//Paramaters:
	//  Recoil.exe Test.exe Test.exe.replacement /b
	//  This is the name of the file to be replaced
	//  This is the name of the file its being replaced with
	//  /b means make a backup of the files you are removing
	//  /l:[FileName] means launch the exe after the backup is made
	//  /d means delete the files we are replacing with when done
	//
	//Recoil.exe Test.txt Replacement.txt Test.dll Replacement.dll /b /l:Test.txt /d
	public class frmMain : System.Windows.Forms.Form
	{
		#region Properties
		private const string m_cIOFAIL_BEGINNING	= "The process cannot access the file";
		private const string m_cIOFAIL_ENDING		= " because it is being used by another process.";

		private System.Collections.ArrayList m_oFilePairs = new System.Collections.ArrayList();
		//private string m_sTargetFile = "";
		//private string m_sReplacementFile = "";
		private bool m_bMakeBackup = false;
		//private bool m_bLaunchAfter = false;
		private bool m_bDeleteNewFile = false;

		private object m_oTicMutex = new object();
		private long m_nCurStep = 0;
		public string[] m_saParamaters = null;
		#endregion 

		#region System Stuff
		private System.Windows.Forms.Timer tmrFileLockCheck;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Button cmdCancel;
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.Label lblStep2_MakeBackup;
		private System.Windows.Forms.Label lblStep1_WaitTillFree;
		private System.Windows.Forms.Label lblStep3_ReplaceTarget;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label lblStep1_Status;
		private System.Windows.Forms.Label lblStep2_Status;
		private System.Windows.Forms.Label lblStep3_Status;
		private System.Windows.Forms.Label lblStep4_Status;
		private System.Windows.Forms.Label lblStep4_DeleteTheReplacement;
		private System.Windows.Forms.Label lblStep5_Status;
		private System.Windows.Forms.Label lblStep5_LaunchReplacement;
		private System.Windows.Forms.Label lblnfo;
		private System.ComponentModel.IContainer components;

		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmMain));
			this.tmrFileLockCheck = new System.Windows.Forms.Timer(this.components);
			this.panel1 = new System.Windows.Forms.Panel();
			this.lblStep5_Status = new System.Windows.Forms.Label();
			this.lblStep5_LaunchReplacement = new System.Windows.Forms.Label();
			this.lblStep4_Status = new System.Windows.Forms.Label();
			this.lblStep3_Status = new System.Windows.Forms.Label();
			this.lblStep2_Status = new System.Windows.Forms.Label();
			this.lblStep1_Status = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.lblStep4_DeleteTheReplacement = new System.Windows.Forms.Label();
			this.lblStep3_ReplaceTarget = new System.Windows.Forms.Label();
			this.lblStep2_MakeBackup = new System.Windows.Forms.Label();
			this.lblStep1_WaitTillFree = new System.Windows.Forms.Label();
			this.cmdCancel = new System.Windows.Forms.Button();
			this.panel2 = new System.Windows.Forms.Panel();
			this.lblnfo = new System.Windows.Forms.Label();
			this.panel1.SuspendLayout();
			this.panel2.SuspendLayout();
			this.SuspendLayout();
			// 
			// tmrFileLockCheck
			// 
			this.tmrFileLockCheck.Enabled = true;
			this.tmrFileLockCheck.Interval = 500;
			this.tmrFileLockCheck.Tick += new System.EventHandler(this.tmrFileLockCheck_Tick);
			// 
			// panel1
			// 
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.panel1.BackColor = System.Drawing.SystemColors.Info;
			this.panel1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panel1.Controls.Add(this.lblStep5_Status);
			this.panel1.Controls.Add(this.lblStep5_LaunchReplacement);
			this.panel1.Controls.Add(this.lblStep4_Status);
			this.panel1.Controls.Add(this.lblStep3_Status);
			this.panel1.Controls.Add(this.lblStep2_Status);
			this.panel1.Controls.Add(this.lblStep1_Status);
			this.panel1.Controls.Add(this.label1);
			this.panel1.Controls.Add(this.lblStep4_DeleteTheReplacement);
			this.panel1.Controls.Add(this.lblStep3_ReplaceTarget);
			this.panel1.Controls.Add(this.lblStep2_MakeBackup);
			this.panel1.Controls.Add(this.lblStep1_WaitTillFree);
			this.panel1.Location = new System.Drawing.Point(8, 8);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(320, 112);
			this.panel1.TabIndex = 1;
			// 
			// lblStep5_Status
			// 
			this.lblStep5_Status.Location = new System.Drawing.Point(263, 88);
			this.lblStep5_Status.Name = "lblStep5_Status";
			this.lblStep5_Status.Size = new System.Drawing.Size(48, 16);
			this.lblStep5_Status.TabIndex = 11;
			this.lblStep5_Status.Text = "Waiting";
			this.lblStep5_Status.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblStep5_LaunchReplacement
			// 
			this.lblStep5_LaunchReplacement.Location = new System.Drawing.Point(7, 88);
			this.lblStep5_LaunchReplacement.Name = "lblStep5_LaunchReplacement";
			this.lblStep5_LaunchReplacement.Size = new System.Drawing.Size(240, 16);
			this.lblStep5_LaunchReplacement.TabIndex = 10;
			this.lblStep5_LaunchReplacement.Text = "Step 5.)  Launch the new file";
			// 
			// lblStep4_Status
			// 
			this.lblStep4_Status.Location = new System.Drawing.Point(264, 72);
			this.lblStep4_Status.Name = "lblStep4_Status";
			this.lblStep4_Status.Size = new System.Drawing.Size(48, 16);
			this.lblStep4_Status.TabIndex = 9;
			this.lblStep4_Status.Text = "Waiting";
			this.lblStep4_Status.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblStep3_Status
			// 
			this.lblStep3_Status.Location = new System.Drawing.Point(264, 56);
			this.lblStep3_Status.Name = "lblStep3_Status";
			this.lblStep3_Status.Size = new System.Drawing.Size(48, 16);
			this.lblStep3_Status.TabIndex = 8;
			this.lblStep3_Status.Text = "Waiting";
			this.lblStep3_Status.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblStep2_Status
			// 
			this.lblStep2_Status.Location = new System.Drawing.Point(264, 40);
			this.lblStep2_Status.Name = "lblStep2_Status";
			this.lblStep2_Status.Size = new System.Drawing.Size(48, 16);
			this.lblStep2_Status.TabIndex = 7;
			this.lblStep2_Status.Text = "Waiting";
			this.lblStep2_Status.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// lblStep1_Status
			// 
			this.lblStep1_Status.Location = new System.Drawing.Point(264, 24);
			this.lblStep1_Status.Name = "lblStep1_Status";
			this.lblStep1_Status.Size = new System.Drawing.Size(48, 16);
			this.lblStep1_Status.TabIndex = 6;
			this.lblStep1_Status.Text = "Waiting";
			this.lblStep1_Status.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Underline, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(264, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(48, 16);
			this.label1.TabIndex = 5;
			this.label1.Text = "Status";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// lblStep4_DeleteTheReplacement
			// 
			this.lblStep4_DeleteTheReplacement.Location = new System.Drawing.Point(8, 72);
			this.lblStep4_DeleteTheReplacement.Name = "lblStep4_DeleteTheReplacement";
			this.lblStep4_DeleteTheReplacement.Size = new System.Drawing.Size(240, 16);
			this.lblStep4_DeleteTheReplacement.TabIndex = 4;
			this.lblStep4_DeleteTheReplacement.Text = "Step 4.)  Delete the replacement file";
			// 
			// lblStep3_ReplaceTarget
			// 
			this.lblStep3_ReplaceTarget.Location = new System.Drawing.Point(8, 56);
			this.lblStep3_ReplaceTarget.Name = "lblStep3_ReplaceTarget";
			this.lblStep3_ReplaceTarget.Size = new System.Drawing.Size(248, 16);
			this.lblStep3_ReplaceTarget.TabIndex = 3;
			this.lblStep3_ReplaceTarget.Text = "Step 3.)  Replace the target file with replacement";
			// 
			// lblStep2_MakeBackup
			// 
			this.lblStep2_MakeBackup.Location = new System.Drawing.Point(8, 40);
			this.lblStep2_MakeBackup.Name = "lblStep2_MakeBackup";
			this.lblStep2_MakeBackup.Size = new System.Drawing.Size(240, 16);
			this.lblStep2_MakeBackup.TabIndex = 2;
			this.lblStep2_MakeBackup.Text = "Step 2.)  Make backup of the target file";
			// 
			// lblStep1_WaitTillFree
			// 
			this.lblStep1_WaitTillFree.Location = new System.Drawing.Point(8, 24);
			this.lblStep1_WaitTillFree.Name = "lblStep1_WaitTillFree";
			this.lblStep1_WaitTillFree.Size = new System.Drawing.Size(248, 16);
			this.lblStep1_WaitTillFree.TabIndex = 1;
			this.lblStep1_WaitTillFree.Text = "Step 1.)  Wait until target file is no longer in use";
			// 
			// cmdCancel
			// 
			this.cmdCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdCancel.Location = new System.Drawing.Point(336, 8);
			this.cmdCancel.Name = "cmdCancel";
			this.cmdCancel.Size = new System.Drawing.Size(80, 24);
			this.cmdCancel.TabIndex = 2;
			this.cmdCancel.Text = "Cancel";
			this.cmdCancel.Click += new System.EventHandler(this.cmdCancel_Click);
			// 
			// panel2
			// 
			this.panel2.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.panel2.BackColor = System.Drawing.SystemColors.Info;
			this.panel2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panel2.Controls.Add(this.lblnfo);
			this.panel2.Location = new System.Drawing.Point(8, 128);
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(320, 80);
			this.panel2.TabIndex = 3;
			// 
			// lblnfo
			// 
			this.lblnfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblnfo.Location = new System.Drawing.Point(8, 8);
			this.lblnfo.Name = "lblnfo";
			this.lblnfo.Size = new System.Drawing.Size(302, 64);
			this.lblnfo.TabIndex = 2;
			this.lblnfo.Text = "Starting...";
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(424, 213);
			this.Controls.Add(this.panel2);
			this.Controls.Add(this.cmdCancel);
			this.Controls.Add(this.panel1);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "frmMain";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Recoil";
			this.Load += new System.EventHandler(this.frmMain_Load);
			this.panel1.ResumeLayout(false);
			this.panel2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		static void Main( string[] saArgs ) 
		{
			frmMain oNewFrmMain = new frmMain();
			oNewFrmMain.m_saParamaters = saArgs;
			Application.Run( oNewFrmMain );
		}
		#endregion


		private void cmdCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}
		private void tmrFileLockCheck_Tick(object sender, System.EventArgs e)
		{
			string sStatusMsg = "";


			//This is a cheezy way to make sure the tick doesn't happen twice at a time
			lock( m_oTicMutex )
			{
				//Decide what we should do now
				//If we are in step one then we are waiting for our file to free up
				if( m_nCurStep == 1 )
				{
					if( AllFilesAreFree( ref sStatusMsg ) == true )
					{
						lblnfo.Text = "Working...";

						//Good, we can proceed then
						if( m_bMakeBackup == true )
						{
							m_nCurStep = 2;
							UpdateLabels( lblStep1_Status,lblStep2_Status );
						}
						else
						{
							m_nCurStep = 3;
							UpdateLabels( lblStep1_Status,lblStep2_Status );
						}
					}
					else
					{
						lblnfo.Text = sStatusMsg + " (" + DateTime.Now.ToShortTimeString() + ")";
					}
				}
				//Make a backup of our target file and the replacement file
				else if( m_nCurStep == 2 )
				{
					BackupAllFiles();

					//Good, we can proceed then
					m_nCurStep = 3;
					UpdateLabels( lblStep2_Status,lblStep3_Status );					
				}
				//Replace the target file
				else if( m_nCurStep == 3 )
				{
					CopyAllFiles();

					//Good, we can proceed then
					if( m_bDeleteNewFile == true )
					{
						m_nCurStep = 4;
						UpdateLabels( lblStep3_Status,lblStep4_Status );
					}
					else
					{
						m_nCurStep = 5;
						UpdateLabels( lblStep3_Status,lblStep5_Status );
					}
				}
				//Delete the replacement file
				else if( m_nCurStep == 4 )
				{
					DeleteAllReplacementFiles();
					
					//Good, we can proceed then
					m_nCurStep = 5;
					UpdateLabels( lblStep4_Status,lblStep5_Status );
				}
				//Launch the new file
				else if( m_nCurStep == 5 )
				{
					lblnfo.Text = "Launching Files...";
					LaunchAllFiles();
					this.Close();
				}
			}
		}
		private void UpdateLabels( System.Windows.Forms.Label oLastStepLabel,System.Windows.Forms.Label oNextStepLabel )
		{
			oLastStepLabel.Text = "Done";
			oLastStepLabel.ForeColor = System.Drawing.Color.Black;

			oNextStepLabel.Text = "Working";
			oNextStepLabel.ForeColor = System.Drawing.Color.Blue;
		}

		private bool FileIsFree( string sFileName )
		{
			StreamWriter oStream = null;
			bool bFree = false;


			try
			{
				oStream = new StreamWriter( sFileName,true );
				oStream.Close();
				bFree = true;
			}
			catch( System.IO.IOException oEx )
			{
				//if( oEx.HResult != -2146232800 )
				if( oEx.Message.Substring( 0,m_cIOFAIL_BEGINNING.Length ) != m_cIOFAIL_BEGINNING ||
					oEx.Message.Substring( oEx.Message.Length - m_cIOFAIL_ENDING.Length ) != m_cIOFAIL_ENDING )
				{
					throw new System.Exception( "Failed to calculate if the file is free",oEx );
				}
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( "Failed to calculate if the file is free",oEx );
			}


			return( bFree );
		}

		private void frmMain_Load(object sender, System.EventArgs e)
		{
			long nNumberOfFilesToLaunch = 0;


			ProcessCommandLineParamaters( ref nNumberOfFilesToLaunch );

			lblStep1_Status.Text = "Waiting";
			lblStep1_Status.ForeColor = System.Drawing.Color.Blue;
			lblStep2_Status.Text = "";
			lblStep3_Status.Text = "";
			lblStep4_Status.Text = "";
			lblStep5_Status.Text = "";

			if( nNumberOfFilesToLaunch == 0 )
			{
                lblStep5_LaunchReplacement.ForeColor = System.Drawing.Color.Gray;
				lblStep5_Status.ForeColor = System.Drawing.Color.Gray;
				lblStep5_Status.Text = "Skip";
			}

			if( m_bMakeBackup == false )
			{
				lblStep2_MakeBackup.ForeColor = System.Drawing.Color.Gray;
				lblStep2_Status.ForeColor = System.Drawing.Color.Gray;
				lblStep2_Status.Text = "Skip";
			}

			m_nCurStep = 1;
		}
		private void ProcessCommandLineParamaters( ref long nNumberOfFilesToLaunch )
		{
			FilePair oCurFilePair = new FilePair();
			string sErrors = "";
			bool bFoundFileToLaunch = false;
			ArrayList saFilesToLaunch = new ArrayList();


			for( int i=0 ; i<m_saParamaters.Length ; i++ )
			{
				if( m_saParamaters[ i ].ToLower() == "/d" )
				{
					m_bDeleteNewFile = true;
				}
				else if( m_saParamaters[ i ].ToLower() == "/b" )
				{
					m_bMakeBackup = true;
				}
				else if( m_saParamaters[ i ].Substring( 0,3 ).ToLower() == "/l:" )
				{
					saFilesToLaunch.Add( m_saParamaters[ i ].Substring( 3 ) );
				}
				else if( oCurFilePair.m_sTargetFile.Length == 0 )
				{
					oCurFilePair.m_sTargetFile = m_saParamaters[ i ];
				}
				else if( oCurFilePair.m_sTargetFile.Length > 0 )
				{
					oCurFilePair.m_sReplacementFile = m_saParamaters[ i ];

                    m_oFilePairs.Add( oCurFilePair );
					oCurFilePair = new FilePair();
				}
			}


			//Verify we have some imput at least
			if( oCurFilePair.m_sTargetFile.Length > 0 && oCurFilePair.m_sReplacementFile.Length == 0 )
			{
				sErrors = "A target file was specified without a replacement file.\n";
			}

			//Verify all the target files exist
			foreach( FilePair oLoopFilePair in m_oFilePairs )
			{
				if( System.IO.File.Exists( oLoopFilePair.m_sTargetFile ) == false )
				{
					sErrors += "Unable to find the target file <" + oLoopFilePair.m_sTargetFile + ">.\n";
				}
				else if( System.IO.File.Exists( oLoopFilePair.m_sReplacementFile ) == false )
				{
					sErrors += "Unable to find the replacement file <" + oLoopFilePair.m_sReplacementFile + ">.\n";
				}                
			}

			//Handle the "Launch Me" paramaters
			foreach( string sFileToLaunch in saFilesToLaunch )
			{
				bFoundFileToLaunch = false;
				foreach( FilePair oLoopFilePair in m_oFilePairs )
				{
					if( oLoopFilePair.m_sTargetFile.ToLower() == sFileToLaunch.ToLower() ) 
					{
						oLoopFilePair.m_bLaunchAfter = true;
						bFoundFileToLaunch = true;
						break;
					}
				}

				if( bFoundFileToLaunch == false )
				{
					sErrors += "Unable to find the launch file <" + sFileToLaunch + ">.\n";
				}
			}


			//Show the user the errors
			if( sErrors.Length > 0 )
			{
				MessageBox.Show( sErrors,"Error With Command Line" );
				this.Close();
			}

			nNumberOfFilesToLaunch = saFilesToLaunch.Count;
		}

		private bool AllFilesAreFree( ref string sStatusMsg )
		{
			bool bAllFilesFree = true;
			string sMessage = "";


			foreach( FilePair oLoopFilePair in m_oFilePairs )
			{
				if( FileIsFree( oLoopFilePair.m_sTargetFile ) == false )
				{
					if( sMessage.Length > 0 ){ sMessage += "\n"; }
					sMessage += oLoopFilePair.m_sTargetFile + " is in use";
					bAllFilesFree = false;
				}
				if( FileIsFree( oLoopFilePair.m_sReplacementFile ) == false )
				{
					if( sMessage.Length > 0 ){ sMessage += "\n"; }
					sMessage += oLoopFilePair.m_sReplacementFile + " is in use";
					bAllFilesFree = false;
				}                
			}


			sStatusMsg = sMessage;
			return( bAllFilesFree );
		}
		private void BackupAllFiles()
		{
			long nFreeNum = 0;
			string sBackupFileName = "";


			foreach( FilePair oLoopFilePair in m_oFilePairs )
			{
				//Backup the target file
                if (System.IO.File.Exists(oLoopFilePair.m_sTargetFile) == true)
                {
                    nFreeNum = 1;
                    sBackupFileName = oLoopFilePair.m_sTargetFile + "." + DateTime.Now.ToString("yyyyMMdd") + ".Backup";
                    while (System.IO.File.Exists(sBackupFileName) == true)
                    {
                        sBackupFileName = oLoopFilePair.m_sTargetFile + "." + DateTime.Now.ToString("yyyyMMdd") + "." + nFreeNum.ToString() + ".Backup";
                        nFreeNum++;
                    }
                    System.IO.File.Copy(oLoopFilePair.m_sTargetFile, sBackupFileName);
                }

				//Backup the replacement file
				nFreeNum = 1;
				sBackupFileName = oLoopFilePair.m_sReplacementFile + "." + DateTime.Now.ToString( "yyyyMMdd" ) + ".Backup";
				while( System.IO.File.Exists( sBackupFileName ) == true )
				{
					sBackupFileName = oLoopFilePair.m_sReplacementFile + "." + DateTime.Now.ToString( "yyyyMMdd" ) + "." + nFreeNum.ToString() + ".Backup";
					nFreeNum++;
				}
				System.IO.File.Copy( oLoopFilePair.m_sReplacementFile,sBackupFileName );
			}
		}
		private void CopyAllFiles()
		{
			foreach( FilePair oLoopFilePair in m_oFilePairs )
			{
				lblnfo.Text = "Copying " + oLoopFilePair.m_sTargetFile + "...";
				System.IO.File.Copy( oLoopFilePair.m_sReplacementFile,oLoopFilePair.m_sTargetFile,true );
			}
		}
		private void DeleteAllReplacementFiles()
		{
			foreach( FilePair oLoopFilePair in m_oFilePairs )
			{
				lblnfo.Text = "Deleting " + oLoopFilePair.m_sReplacementFile + "...";
				System.IO.File.Delete( oLoopFilePair.m_sReplacementFile );
			}
		}
		private void LaunchAllFiles()
		{
			foreach( FilePair oLoopFilePair in m_oFilePairs )
			{
				if( oLoopFilePair.m_bLaunchAfter == true )
				{
					lblnfo.Text = "Launching " + oLoopFilePair.m_sTargetFile + "...";
					System.Diagnostics.Process.Start( oLoopFilePair.m_sTargetFile );
				}
			}
		}

	}

	public class FilePair
	{
		public string m_sTargetFile = "";
		public string m_sReplacementFile = "";
		public bool m_bLaunchAfter = false;
	}
}
