using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace DarkStrideToolbox
{
    public class DSBufferDebug
    {
        #region Member Variables
        private static DSBufferDebug m_oSingletonInstanceOfMe = null;
        private System.Collections.Generic.List<string> m_saMessages = new System.Collections.Generic.List<string>();
        private DateTime m_dtLastWriteTime = DateTime.MinValue;
        private System.Threading.Thread m_oWriteThread = null;

        private string m_sDebugPath = string.Empty;
        private bool m_bDebugMode = false;
        #endregion


        public DSBufferDebug()
        {
            this.DebugPath = "c:\\Debug.out";
        }
        ~DSBufferDebug()
		{
            while (m_oWriteThread != null)
            {
                System.Threading.Thread.Sleep(10);
            }
            FlushBuffer();
		}
        public static DSBufferDebug Inst()
        {
            if (m_oSingletonInstanceOfMe == null)
            {
                m_oSingletonInstanceOfMe = new DSBufferDebug();
            }

            return (m_oSingletonInstanceOfMe);
        }

        public void WriteToDebug(long nLevel, string sDebugMessage)
        {
            WriteToDebug(m_sDebugPath, m_bDebugMode, true, nLevel, sDebugMessage);
        }
        public void WriteToDebug(string sDebugFileName, bool bWriteToFile, string sDebugMessage)
        {
            WriteToDebug(sDebugFileName, bWriteToFile, true, 0, sDebugMessage);
        }
        public void WriteToDebug(bool bWriteToFile, long nLevel, string sDebugMessage)
        {
            WriteToDebug(m_sDebugPath, bWriteToFile, true, nLevel, sDebugMessage);
        }
        public void WriteToDebug(string sDebugFileName, bool bWriteToFile, long nLevel, string sDebugMessage)
        {
            WriteToDebug(sDebugFileName, bWriteToFile, true, nLevel, sDebugMessage);
        }
        public void WriteToDebug(string sDebugFileName, bool bWriteToFile, bool bAddTimeStamp, long nLevel, string sDebugMessage)
        {
            string sMessage = string.Empty;
            TimeSpan oSpan = TimeSpan.MinValue;


            m_sDebugPath = sDebugFileName;
            if (bWriteToFile == true)
            {
                //Format our message to write
                if (bAddTimeStamp == true)
                {
                    sMessage = DateTime.Now.ToString("hh:mm:ss.fffffff") + " - ";
                }
                sMessage += DSMisc.Repeat("   ", nLevel) + sDebugMessage;

                //Add our entry to the collection
                lock (m_saMessages)
                {
                    m_saMessages.Add(sMessage);
                    CheckAndWriteToFile();
                }
            }
        }

        public void FlushBuffer()
        {
            m_dtLastWriteTime = DateTime.MinValue;
            CheckAndWriteToFile();
        }
        private void CheckAndWriteToFile()
        {
            TimeSpan oSpan = TimeSpan.MinValue;


            lock (this)
            {
                oSpan = DateTime.Now - m_dtLastWriteTime;
                if (m_bDebugMode == true && m_oWriteThread == null && oSpan.TotalSeconds > 5.0)
                {
                    if (m_sDebugPath.Length == 0)
                    {
                        throw new System.Exception("Unable to write debug mesage because the path is blank.");
                    }

                    m_oWriteThread = new System.Threading.Thread(new System.Threading.ThreadStart(WriteToFileThread));
                    m_oWriteThread.Priority = System.Threading.ThreadPriority.Lowest;
                    m_oWriteThread.IsBackground = true;
                    m_oWriteThread.Start();
                }
            }
        }
        private void WriteToFileThread()
        {
            StreamWriter oStream = null;
            string[] saMessageCopy = null;


            try
            {
                oStream = new StreamWriter(m_sDebugPath, true);
            }
            catch //(System.Exception oEx)
            {
                //We failed to get a lock, so do it later
                oStream = null;
                System.Threading.Thread.Sleep(100);
            }

            //Ok, we got our lock, go ahead and write
            if (oStream != null)
            {
                lock (m_saMessages)
                {
                    saMessageCopy = m_saMessages.ToArray();
                    m_saMessages.Clear();
                }

                //Write to the file
                for (int i = 0; i < saMessageCopy.Length; i++)
                {
                    oStream.WriteLine(saMessageCopy[i]);
                }

                //Close our file, were done
                oStream.Close();
                m_dtLastWriteTime = DateTime.Now;
            }

            //Close down our writing thread
            lock (this)
            {
                m_oWriteThread = null;
            }
        }


        #region Properties
        public string DebugPath
        {
            get
            {
                return (m_sDebugPath);
            }
            set
            {
                if (value.Length == 0)
                {
                    m_sDebugPath = DSMisc.GetDevelopmentAppPath() +
                                   "DSBufferDebugFile_" +
                                   DateTime.Now.ToString("yyyy-MM-dd hh") + "h" +
                                   DateTime.Now.ToString("mm") + "m" +
                                   DateTime.Now.ToString("ss") + "s" +
                                   ".OUT";
                }
                else
                {
                    m_sDebugPath = value;
                }
            }
        }
        public bool DebugMode
        {
            get
            {
                return (m_bDebugMode);
            }
            set
            {
                m_bDebugMode = value;
            }
        }
        #endregion
    }
}