using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;


namespace DarkStrideToolbox
{
	public class DSInputBox : System.Windows.Forms.Form
	{
		#region Properties
		private string m_sRetVal = "";
		private bool m_bCanceled = false;
		#endregion
        
		#region Windows Init & System Functions
		private System.Windows.Forms.TextBox txtName;
		private System.Windows.Forms.Label lblMessage;
		private System.Windows.Forms.Button cmdDone;
		private System.Windows.Forms.Button cmdCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DSInputBox()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.txtName = new System.Windows.Forms.TextBox();
			this.lblMessage = new System.Windows.Forms.Label();
			this.cmdDone = new System.Windows.Forms.Button();
			this.cmdCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// txtName
			// 
			this.txtName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtName.Location = new System.Drawing.Point(8, 48);
			this.txtName.Name = "txtName";
			this.txtName.Size = new System.Drawing.Size(288, 20);
			this.txtName.TabIndex = 0;
			this.txtName.Text = "";
			// 
			// lblMessage
			// 
			this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblMessage.Location = new System.Drawing.Point(8, 8);
			this.lblMessage.Name = "lblMessage";
			this.lblMessage.Size = new System.Drawing.Size(288, 32);
			this.lblMessage.TabIndex = 1;
			this.lblMessage.Text = "<Message>";
			// 
			// cmdDone
			// 
			this.cmdDone.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdDone.Location = new System.Drawing.Point(224, 80);
			this.cmdDone.Name = "cmdDone";
			this.cmdDone.Size = new System.Drawing.Size(72, 24);
			this.cmdDone.TabIndex = 2;
			this.cmdDone.Text = "&Done";
			this.cmdDone.Click += new System.EventHandler(this.cmdDone_Click);
			// 
			// cmdCancel
			// 
			this.cmdCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cmdCancel.Location = new System.Drawing.Point(8, 80);
			this.cmdCancel.Name = "cmdCancel";
			this.cmdCancel.Size = new System.Drawing.Size(72, 24);
			this.cmdCancel.TabIndex = 3;
			this.cmdCancel.Text = "&Cancel";
			this.cmdCancel.Click += new System.EventHandler(this.cmdCancel_Click);
			// 
			// DSInputBox
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(304, 109);
			this.Controls.Add(this.cmdCancel);
			this.Controls.Add(this.cmdDone);
			this.Controls.Add(this.lblMessage);
			this.Controls.Add(this.txtName);
			this.Name = "DSInputBox";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "New Name";
			this.ResumeLayout(false);

		}
		#endregion
		#endregion


		public string InputBox( string sQuestion,string sDefaultAnswer )
		{
			lblMessage.Text = sQuestion;
			txtName.Text = sDefaultAnswer;
			this.ShowDialog();

			return( m_sRetVal );
		}


		private void cmdDone_Click(object sender, System.EventArgs e)
		{
			m_bCanceled = false;
			m_sRetVal = txtName.Text;

			this.Close();
		}

		private void cmdCancel_Click(object sender, System.EventArgs e)
		{
			m_bCanceled = true;
			m_sRetVal = "";

			this.Close();
		}



		#region Properties
		public string RetVal
		{
			get
			{
				return( m_sRetVal );
			}
		}
		public bool Canceled
		{
			get
			{
				return( m_bCanceled );
			}
		}
		#endregion
	}
}
