using System;
using System.IO;


namespace DarkStrideToolbox
{
	[Serializable]
	public class DSMemoryDebugFile
	{
		#region Properties
		private const int m_cMAXLINES = 10000;
		private string[] m_saText = null;
		private long[] m_naIndents = null;
		private DateTime[] m_daTime = null;
		private int m_nNextIndex = 0;
		private bool m_bHaveCycled = false;
		#endregion


		public DSMemoryDebugFile()
		{
			Clear();
		}


		public void Clear()
		{
			m_saText = new string[ m_cMAXLINES ];
			m_naIndents = new long[ m_cMAXLINES ];
			m_daTime = new DateTime[ m_cMAXLINES ];
			m_nNextIndex = 0;
			m_bHaveCycled = false;
		}


		public void WriteToDebugFile( string sDebugMessage )
		{
			const string sRoutineName = "DarkStrideToolbox.DSMemoryDebugFile.WriteToDebugFile";	

			try
			{
				WriteToDebugFile( true,true,0,sDebugMessage );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		public void WriteToDebugFile( bool bWriteToFile,string sDebugMessage )
		{
			const string sRoutineName = "DarkStrideToolbox.DSMemoryDebugFile.WriteToDebugFile";	

			try
			{
				WriteToDebugFile( bWriteToFile,true,0,sDebugMessage );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		public void WriteToDebugFile( bool bWriteToFile,long nLevel,string sDebugMessage )
		{
			const string sRoutineName = "DarkStrideToolbox.DSMemoryDebugFile.WriteToDebugFile";	

			try
			{
				WriteToDebugFile( bWriteToFile,true,nLevel,sDebugMessage );
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		public void WriteToDebugFile( bool bWriteToFile,bool bAddTimeStamp,long nLevel,string sDebugMessage )
		{
			const string sRoutineName = "DarkStrideToolbox.DSMemoryDebugFile.WriteToDebugFile";	


			try
			{
				if( bWriteToFile == true )
				{
					lock( this )
					{
						if( bAddTimeStamp == true )
						{
							m_daTime[ m_nNextIndex ] = DateTime.Now;
						}
						else
						{
							m_daTime[ m_nNextIndex ] = DateTime.MinValue;
						}
						m_naIndents[ m_nNextIndex ] = nLevel;
						m_saText[ m_nNextIndex ] = sDebugMessage;


						//Next!
						m_nNextIndex++;
						if( m_nNextIndex >= m_cMAXLINES )
						{
							m_nNextIndex = 0;
							m_bHaveCycled = true;
						}
					}
				}
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}

        
		public void DumpToFile( string sFileName )
		{
			const string sRoutineName = "DarkStrideToolbox.DSMemoryDebugFile.DumpToFile";	
			StreamWriter oStream = null;

			try
			{
				oStream = new StreamWriter( sFileName,true );

				if( m_bHaveCycled == true )
				{
					for( int i=m_nNextIndex ; i<m_cMAXLINES ; i++ )
					{
						WriteMessageToFile( i,oStream );
					}
				}
				for( int i=0 ; i<m_nNextIndex ; i++ )
				{
					WriteMessageToFile( i,oStream );
				}

				oStream.Close();
			}
			catch( System.Exception oEx )
			{
				throw new System.Exception( sRoutineName + " Failed.",oEx );
			}
		}
		private void WriteMessageToFile( int nIndex,StreamWriter oStream )
		{
			string sMsg = "";


			if( m_daTime[ nIndex ] != DateTime.MinValue )
			{
				sMsg =	DateTime.Now.ToString( "hh:mm:ss.fffffff" ) + " - ";
			}

			//Add in some tabs
			if( m_naIndents[ nIndex ] > 0 )
			{
				for( int i=0 ; i<m_naIndents[ nIndex ] ; i++ )
				{
					sMsg += "	";
				}
			}

			sMsg += m_saText[ nIndex ];

			oStream.WriteLine( sMsg );
		}
	}
}
