using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using DarkStrideToolbox;


namespace MenuEditor
{
	public class LoadedGobManager : System.Windows.Forms.Form
	{
		#region System Functions
		private System.Windows.Forms.Button cmdLoadGob;
		private System.Windows.Forms.Button cmdUnloadGob;
		private System.Windows.Forms.Button cmdDone;
		private System.Windows.Forms.OpenFileDialog oOpenFileDialog;
		private System.Windows.Forms.TreeView treGobFiles;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public LoadedGobManager()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdLoadGob = new System.Windows.Forms.Button();
			this.cmdUnloadGob = new System.Windows.Forms.Button();
			this.cmdDone = new System.Windows.Forms.Button();
			this.treGobFiles = new System.Windows.Forms.TreeView();
			this.oOpenFileDialog = new System.Windows.Forms.OpenFileDialog();
			this.SuspendLayout();
			// 
			// cmdLoadGob
			// 
			this.cmdLoadGob.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdLoadGob.Location = new System.Drawing.Point(280, 8);
			this.cmdLoadGob.Name = "cmdLoadGob";
			this.cmdLoadGob.Size = new System.Drawing.Size(80, 24);
			this.cmdLoadGob.TabIndex = 1;
			this.cmdLoadGob.Text = "Load Gob";
			this.cmdLoadGob.Click += new System.EventHandler(this.cmdLoadGob_Click);
			// 
			// cmdUnloadGob
			// 
			this.cmdUnloadGob.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdUnloadGob.Location = new System.Drawing.Point(280, 40);
			this.cmdUnloadGob.Name = "cmdUnloadGob";
			this.cmdUnloadGob.Size = new System.Drawing.Size(80, 24);
			this.cmdUnloadGob.TabIndex = 2;
			this.cmdUnloadGob.Text = "Un-Load Gob";
			this.cmdUnloadGob.Click += new System.EventHandler(this.cmdUnloadGob_Click);
			// 
			// cmdDone
			// 
			this.cmdDone.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.cmdDone.Location = new System.Drawing.Point(280, 232);
			this.cmdDone.Name = "cmdDone";
			this.cmdDone.Size = new System.Drawing.Size(80, 24);
			this.cmdDone.TabIndex = 3;
			this.cmdDone.Text = "Done";
			this.cmdDone.Click += new System.EventHandler(this.cmdDone_Click);
			// 
			// treGobFiles
			// 
			this.treGobFiles.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.treGobFiles.ImageIndex = -1;
			this.treGobFiles.Location = new System.Drawing.Point(8, 8);
			this.treGobFiles.Name = "treGobFiles";
			this.treGobFiles.SelectedImageIndex = -1;
			this.treGobFiles.Size = new System.Drawing.Size(264, 248);
			this.treGobFiles.TabIndex = 4;
			this.treGobFiles.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.treGobFiles_AfterSelect);
			// 
			// LoadedGobManager
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(368, 261);
			this.Controls.Add(this.treGobFiles);
			this.Controls.Add(this.cmdDone);
			this.Controls.Add(this.cmdUnloadGob);
			this.Controls.Add(this.cmdLoadGob);
			this.Name = "LoadedGobManager";
			this.Text = "Loaded Gob Files";
			this.Load += new System.EventHandler(this.LoadedGobManager_Load);
			this.ResumeLayout(false);

		}
		#endregion
		#endregion

		private void cmdLoadGob_Click(object sender, System.EventArgs e)
		{
			DSGobFile oGobFile = null;
			DSInputBox oInput = new DSInputBox();
			OpenFileDialog oOpenFileDialog = new OpenFileDialog();


			oOpenFileDialog.InitialDirectory = DSMisc.GetDevelopmentAppPath() + "*.gob";
			oOpenFileDialog.FileName = DSMisc.GetDevelopmentAppPath() + "*.gob";
			oOpenFileDialog.Filter = "Gob files (*.gob)|*.gob|All files (*.*)|*.*" ;
			oOpenFileDialog.FilterIndex = 2;
			oOpenFileDialog.RestoreDirectory = true;

			if( oOpenFileDialog.ShowDialog() == DialogResult.OK )
			{
				oGobFile = new DSGobFile();
				oGobFile.LoadGobFile( oOpenFileDialog.FileName );
				RefreshGobList();
			}
		}
		private void cmdUnloadGob_Click(object sender, System.EventArgs e)
		{
			if( treGobFiles.SelectedNode != null &&
				treGobFiles.SelectedNode.Parent == null )
			{
				DSResourceManager.GetGlobalInstance().RemoveGob( treGobFiles.SelectedNode.Text );
				RefreshGobList();
			}
		}
		private void cmdDone_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		public void RefreshGobList()
		{
			DSSortedList oTables = null;
			DSGobFile oLoopFile = null;
			DSGobTable oLoopTable = null;
			System.Windows.Forms.TreeNode oParentNode = null;
			System.Windows.Forms.TreeNode oNode = null;


			treGobFiles.Nodes.Clear();

			for( int i=0 ; i<DSResourceManager.GetGlobalInstance().GobFiles.Count ; i++ )
			{
				//Get the file
				oLoopFile = (DSGobFile)DSResourceManager.GetGlobalInstance().GobFiles.GetByIndex( i );
				oParentNode = treGobFiles.Nodes.Add( oLoopFile.FileName );

				//Now list out a count of all the types
				oTables = oLoopFile.GetTables( enumTableType.Border );
				oNode = oParentNode.Nodes.Add( "Borders - " + oTables.Count.ToString() );
				for( int nTableIndex=0 ; nTableIndex<oTables.Count ; nTableIndex++ )
				{
					oLoopTable = (DSGobTable)oTables.GetByIndex( nTableIndex );
					oNode.Nodes.Add( oLoopTable.TableName );
				}
				oNode.Expand();
				
				oTables = oLoopFile.GetTables( enumTableType.DataTable );
				oNode = oParentNode.Nodes.Add( "DataTable - " + oTables.Count.ToString() );
				for( int nTableIndex=0 ; nTableIndex<oTables.Count ; nTableIndex++ )
				{
					oLoopTable = (DSGobTable)oTables.GetByIndex( nTableIndex );
					oNode.Nodes.Add( oLoopTable.TableName );
				}

				oTables = oLoopFile.GetTables( enumTableType.Graphic );
				oNode = oParentNode.Nodes.Add( "Graphic - " + oTables.Count.ToString() );
				for( int nTableIndex=0 ; nTableIndex<oTables.Count ; nTableIndex++ )
				{
					oLoopTable = (DSGobTable)oTables.GetByIndex( nTableIndex );
					oNode.Nodes.Add( oLoopTable.TableName );
				}

				oTables = oLoopFile.GetTables( enumTableType.Other );
				oNode = oParentNode.Nodes.Add( "Other - " + oTables.Count.ToString() );
				for( int nTableIndex=0 ; nTableIndex<oTables.Count ; nTableIndex++ )
				{
					oLoopTable = (DSGobTable)oTables.GetByIndex( nTableIndex );
					oNode.Nodes.Add( oLoopTable.TableName );
				}

				oParentNode.Expand();
			}

			RefreshButtons();
		}

		public void RefreshButtons()
		{
			cmdUnloadGob.Enabled = ( treGobFiles.SelectedNode != null &&
									 treGobFiles.SelectedNode.Parent == null );
		}


		private void LoadedGobManager_Load(object sender, System.EventArgs e)
		{
			RefreshGobList();
		}

		private void treGobFiles_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			RefreshButtons();
		}
	}
}
