using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Reflection;

using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX.DirectPlay;
using Microsoft.DirectX.DirectInput;
using DarkStrideToolbox;


namespace MenuEditor
{
	public class MenuEditor : System.Windows.Forms.Form
	{
		#region Properties
		private string m_sOldFormName = "";
		private DSBaseControl m_oControlBeingEdited = null;
		private bool m_bEditMouseDownOnControl = false;
		private Vector2 m_oMouseDownPos = new Vector2( 0,0 );
		private bool m_bSysAction = false;
		private DSGameEngine m_oGameEngine = null;
		#endregion


		#region App Init & Sys Functions
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Button cmdAddButton;
		private System.Windows.Forms.Button cmdAddLabel;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.Button cmdAddCheckBox;
		private System.Windows.Forms.Button cmdAddRadioButton;
		private System.Windows.Forms.Button cmdAddComboBox;
		private System.Windows.Forms.Button cmdAddSlider;
		private System.Windows.Forms.Button cmdAddListBox;
		private System.Windows.Forms.Button cmdAddTextBox;
		private System.Windows.Forms.Button cmdAddListBoxMultiSelect;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem mnuOpen;
		private System.Windows.Forms.MenuItem mnuSave;
		private System.Windows.Forms.MenuItem mnuExit;
		private System.Windows.Forms.CheckBox chkSnapToGrid;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem mnuForms_CloseAllForms;
		private System.Windows.Forms.MenuItem mnuAddNewForm;
		private System.Windows.Forms.Button cmdAddHorzScrollBar;
		private System.Windows.Forms.Button cmdAddVertScrollBar;
		private System.Windows.Forms.Button cmdDeleteControl;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem mnuOpenGobFile;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.ComboBox cboAnchorStyles;
		private System.Windows.Forms.Label lblFormName;
		private System.Windows.Forms.TextBox txtFormName;
		private System.Windows.Forms.TextBox txtOtherProperty;
		private System.Windows.Forms.ComboBox cboForms;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ListView lvwProperties;
		private System.Windows.Forms.ColumnHeader clmnName;
		private System.Windows.Forms.ColumnHeader clmnValue;
		private System.Windows.Forms.CheckBox chkBoolProperty;
		private System.Windows.Forms.Label lblOtherProperty;
		private System.Windows.Forms.ComboBox cboBorderKey;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public MenuEditor()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.cmdAddButton = new System.Windows.Forms.Button();
			this.cmdAddLabel = new System.Windows.Forms.Button();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.mnuOpen = new System.Windows.Forms.MenuItem();
			this.mnuSave = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.mnuOpenGobFile = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.mnuExit = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.mnuForms_CloseAllForms = new System.Windows.Forms.MenuItem();
			this.mnuAddNewForm = new System.Windows.Forms.MenuItem();
			this.cmdAddCheckBox = new System.Windows.Forms.Button();
			this.cmdAddRadioButton = new System.Windows.Forms.Button();
			this.cmdAddComboBox = new System.Windows.Forms.Button();
			this.cmdAddSlider = new System.Windows.Forms.Button();
			this.cmdAddListBox = new System.Windows.Forms.Button();
			this.cmdAddTextBox = new System.Windows.Forms.Button();
			this.cmdAddListBoxMultiSelect = new System.Windows.Forms.Button();
			this.chkSnapToGrid = new System.Windows.Forms.CheckBox();
			this.cmdAddHorzScrollBar = new System.Windows.Forms.Button();
			this.cmdAddVertScrollBar = new System.Windows.Forms.Button();
			this.cmdDeleteControl = new System.Windows.Forms.Button();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.cboAnchorStyles = new System.Windows.Forms.ComboBox();
			this.lblFormName = new System.Windows.Forms.Label();
			this.txtFormName = new System.Windows.Forms.TextBox();
			this.txtOtherProperty = new System.Windows.Forms.TextBox();
			this.cboForms = new System.Windows.Forms.ComboBox();
			this.label1 = new System.Windows.Forms.Label();
			this.lvwProperties = new System.Windows.Forms.ListView();
			this.clmnName = new System.Windows.Forms.ColumnHeader();
			this.clmnValue = new System.Windows.Forms.ColumnHeader();
			this.chkBoolProperty = new System.Windows.Forms.CheckBox();
			this.lblOtherProperty = new System.Windows.Forms.Label();
			this.cboBorderKey = new System.Windows.Forms.ComboBox();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Location = new System.Drawing.Point(104, 0);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(384, 320);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Form";
			// 
			// cmdAddButton
			// 
			this.cmdAddButton.Location = new System.Drawing.Point(8, 8);
			this.cmdAddButton.Name = "cmdAddButton";
			this.cmdAddButton.Size = new System.Drawing.Size(88, 24);
			this.cmdAddButton.TabIndex = 1;
			this.cmdAddButton.Text = "Button";
			this.cmdAddButton.Click += new System.EventHandler(this.cmdAddButton_Click);
			// 
			// cmdAddLabel
			// 
			this.cmdAddLabel.Location = new System.Drawing.Point(8, 32);
			this.cmdAddLabel.Name = "cmdAddLabel";
			this.cmdAddLabel.Size = new System.Drawing.Size(88, 24);
			this.cmdAddLabel.TabIndex = 2;
			this.cmdAddLabel.Text = "Label";
			this.cmdAddLabel.Click += new System.EventHandler(this.cmdAddLabel_Click);
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem1,
																					  this.menuItem2});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.mnuOpen,
																					  this.mnuSave,
																					  this.menuItem4,
																					  this.mnuOpenGobFile,
																					  this.menuItem5,
																					  this.mnuExit});
			this.menuItem1.Text = "File";
			// 
			// mnuOpen
			// 
			this.mnuOpen.Index = 0;
			this.mnuOpen.Text = "Open Menu File...";
			this.mnuOpen.Click += new System.EventHandler(this.mnuOpen_Click);
			// 
			// mnuSave
			// 
			this.mnuSave.Index = 1;
			this.mnuSave.Text = "Save Menu File";
			this.mnuSave.Click += new System.EventHandler(this.mnuSave_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 2;
			this.menuItem4.Text = "-";
			// 
			// mnuOpenGobFile
			// 
			this.mnuOpenGobFile.Index = 3;
			this.mnuOpenGobFile.Text = "Open Gob File...";
			this.mnuOpenGobFile.Click += new System.EventHandler(this.mnuOpenGobFile_Click);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 4;
			this.menuItem5.Text = "-";
			// 
			// mnuExit
			// 
			this.mnuExit.Index = 5;
			this.mnuExit.Text = "Exit";
			this.mnuExit.Click += new System.EventHandler(this.mnuExit_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.mnuForms_CloseAllForms,
																					  this.mnuAddNewForm});
			this.menuItem2.Text = "Forms";
			// 
			// mnuForms_CloseAllForms
			// 
			this.mnuForms_CloseAllForms.Index = 0;
			this.mnuForms_CloseAllForms.Text = "Close All Forms";
			this.mnuForms_CloseAllForms.Click += new System.EventHandler(this.menuItem3_Click);
			// 
			// mnuAddNewForm
			// 
			this.mnuAddNewForm.Index = 1;
			this.mnuAddNewForm.Text = "Add New Form";
			this.mnuAddNewForm.Click += new System.EventHandler(this.mnuAddNewForm_Click);
			// 
			// cmdAddCheckBox
			// 
			this.cmdAddCheckBox.Location = new System.Drawing.Point(8, 56);
			this.cmdAddCheckBox.Name = "cmdAddCheckBox";
			this.cmdAddCheckBox.Size = new System.Drawing.Size(88, 24);
			this.cmdAddCheckBox.TabIndex = 9;
			this.cmdAddCheckBox.Text = "Checkbox";
			this.cmdAddCheckBox.Click += new System.EventHandler(this.cmdAddCheckBox_Click);
			// 
			// cmdAddRadioButton
			// 
			this.cmdAddRadioButton.Location = new System.Drawing.Point(8, 80);
			this.cmdAddRadioButton.Name = "cmdAddRadioButton";
			this.cmdAddRadioButton.Size = new System.Drawing.Size(88, 24);
			this.cmdAddRadioButton.TabIndex = 10;
			this.cmdAddRadioButton.Text = "Radio Button";
			this.cmdAddRadioButton.Click += new System.EventHandler(this.cmdAddRadioButton_Click);
			// 
			// cmdAddComboBox
			// 
			this.cmdAddComboBox.Location = new System.Drawing.Point(8, 128);
			this.cmdAddComboBox.Name = "cmdAddComboBox";
			this.cmdAddComboBox.Size = new System.Drawing.Size(88, 24);
			this.cmdAddComboBox.TabIndex = 12;
			this.cmdAddComboBox.Text = "ComboBox";
			this.cmdAddComboBox.Click += new System.EventHandler(this.cmdAddComboBox_Click);
			// 
			// cmdAddSlider
			// 
			this.cmdAddSlider.Location = new System.Drawing.Point(8, 152);
			this.cmdAddSlider.Name = "cmdAddSlider";
			this.cmdAddSlider.Size = new System.Drawing.Size(88, 24);
			this.cmdAddSlider.TabIndex = 13;
			this.cmdAddSlider.Text = "Slider";
			this.cmdAddSlider.Click += new System.EventHandler(this.cmdAddSlider_Click);
			// 
			// cmdAddListBox
			// 
			this.cmdAddListBox.Location = new System.Drawing.Point(8, 176);
			this.cmdAddListBox.Name = "cmdAddListBox";
			this.cmdAddListBox.Size = new System.Drawing.Size(88, 24);
			this.cmdAddListBox.TabIndex = 14;
			this.cmdAddListBox.Text = "ListBox (1 Sel)";
			this.cmdAddListBox.Click += new System.EventHandler(this.cmdAddListBox_Click);
			// 
			// cmdAddTextBox
			// 
			this.cmdAddTextBox.Location = new System.Drawing.Point(8, 104);
			this.cmdAddTextBox.Name = "cmdAddTextBox";
			this.cmdAddTextBox.Size = new System.Drawing.Size(88, 24);
			this.cmdAddTextBox.TabIndex = 15;
			this.cmdAddTextBox.Text = "TextBox";
			this.cmdAddTextBox.Click += new System.EventHandler(this.cmdAddTextBox_Click);
			// 
			// cmdAddListBoxMultiSelect
			// 
			this.cmdAddListBoxMultiSelect.Location = new System.Drawing.Point(8, 200);
			this.cmdAddListBoxMultiSelect.Name = "cmdAddListBoxMultiSelect";
			this.cmdAddListBoxMultiSelect.Size = new System.Drawing.Size(88, 24);
			this.cmdAddListBoxMultiSelect.TabIndex = 16;
			this.cmdAddListBoxMultiSelect.Text = "ListBox (Multi)";
			this.cmdAddListBoxMultiSelect.Click += new System.EventHandler(this.cmdAddListBoxMultiSelect_Click);
			// 
			// chkSnapToGrid
			// 
			this.chkSnapToGrid.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.chkSnapToGrid.Checked = true;
			this.chkSnapToGrid.CheckState = System.Windows.Forms.CheckState.Checked;
			this.chkSnapToGrid.Location = new System.Drawing.Point(104, 336);
			this.chkSnapToGrid.Name = "chkSnapToGrid";
			this.chkSnapToGrid.Size = new System.Drawing.Size(104, 16);
			this.chkSnapToGrid.TabIndex = 17;
			this.chkSnapToGrid.Text = "Snap To Grid";
			// 
			// cmdAddHorzScrollBar
			// 
			this.cmdAddHorzScrollBar.Location = new System.Drawing.Point(8, 224);
			this.cmdAddHorzScrollBar.Name = "cmdAddHorzScrollBar";
			this.cmdAddHorzScrollBar.Size = new System.Drawing.Size(88, 24);
			this.cmdAddHorzScrollBar.TabIndex = 21;
			this.cmdAddHorzScrollBar.Text = "Horz ScrollBar";
			this.cmdAddHorzScrollBar.Click += new System.EventHandler(this.cmdAddHorzScrollBar_Click);
			// 
			// cmdAddVertScrollBar
			// 
			this.cmdAddVertScrollBar.Location = new System.Drawing.Point(8, 248);
			this.cmdAddVertScrollBar.Name = "cmdAddVertScrollBar";
			this.cmdAddVertScrollBar.Size = new System.Drawing.Size(88, 24);
			this.cmdAddVertScrollBar.TabIndex = 22;
			this.cmdAddVertScrollBar.Text = "Vert ScrollBar";
			this.cmdAddVertScrollBar.Click += new System.EventHandler(this.cmdAddVertScrollBar_Click);
			// 
			// cmdDeleteControl
			// 
			this.cmdDeleteControl.Location = new System.Drawing.Point(8, 288);
			this.cmdDeleteControl.Name = "cmdDeleteControl";
			this.cmdDeleteControl.Size = new System.Drawing.Size(88, 24);
			this.cmdDeleteControl.TabIndex = 0;
			this.cmdDeleteControl.Text = "Delete";
			this.cmdDeleteControl.Visible = false;
			this.cmdDeleteControl.Click += new System.EventHandler(this.cmdDeleteControl_Click);
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox2.Controls.Add(this.txtOtherProperty);
			this.groupBox2.Controls.Add(this.cboBorderKey);
			this.groupBox2.Controls.Add(this.cboAnchorStyles);
			this.groupBox2.Controls.Add(this.lvwProperties);
			this.groupBox2.Controls.Add(this.label1);
			this.groupBox2.Controls.Add(this.txtFormName);
			this.groupBox2.Controls.Add(this.cboForms);
			this.groupBox2.Controls.Add(this.lblFormName);
			this.groupBox2.Controls.Add(this.chkBoolProperty);
			this.groupBox2.Controls.Add(this.lblOtherProperty);
			this.groupBox2.Location = new System.Drawing.Point(496, 0);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(216, 376);
			this.groupBox2.TabIndex = 25;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Properties";
			// 
			// cboAnchorStyles
			// 
			this.cboAnchorStyles.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cboAnchorStyles.ItemHeight = 13;
			this.cboAnchorStyles.Items.AddRange(new object[] {
																 "1 - Top",
																 "3 - Top, Bottom",
																 "7 - Top, Bottom, Left",
																 "11 - Top, Bottom, Right",
																 "5 - Top, Left",
																 "13 - Top, Left, Right",
																 "9 - Top, Right",
																 "2 - Bottom",
																 "6 - Bottom, Left",
																 "14 - Bottom, Left, Right",
																 "10 - Bottom, Right",
																 "4 - Left",
																 "12 - Left, Right",
																 "8 - Right"});
			this.cboAnchorStyles.Location = new System.Drawing.Point(8, 336);
			this.cboAnchorStyles.Name = "cboAnchorStyles";
			this.cboAnchorStyles.Size = new System.Drawing.Size(192, 21);
			this.cboAnchorStyles.TabIndex = 23;
			this.cboAnchorStyles.Visible = false;
			this.cboAnchorStyles.SelectedIndexChanged += new System.EventHandler(this.cboAnchorStyles_SelectedIndexChanged);
			// 
			// lblFormName
			// 
			this.lblFormName.Location = new System.Drawing.Point(8, 40);
			this.lblFormName.Name = "lblFormName";
			this.lblFormName.Size = new System.Drawing.Size(72, 16);
			this.lblFormName.TabIndex = 20;
			this.lblFormName.Text = "Form Name:";
			// 
			// txtFormName
			// 
			this.txtFormName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtFormName.Enabled = false;
			this.txtFormName.Location = new System.Drawing.Point(80, 48);
			this.txtFormName.Name = "txtFormName";
			this.txtFormName.Size = new System.Drawing.Size(120, 20);
			this.txtFormName.TabIndex = 19;
			this.txtFormName.Text = "";
			this.txtFormName.TextChanged += new System.EventHandler(this.txtFormName_TextChanged);
			// 
			// txtOtherProperty
			// 
			this.txtOtherProperty.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOtherProperty.Location = new System.Drawing.Point(8, 336);
			this.txtOtherProperty.Name = "txtOtherProperty";
			this.txtOtherProperty.Size = new System.Drawing.Size(192, 20);
			this.txtOtherProperty.TabIndex = 6;
			this.txtOtherProperty.Text = "";
			this.txtOtherProperty.Visible = false;
			this.txtOtherProperty.TextChanged += new System.EventHandler(this.txtOtherProperty_TextChanged);
			// 
			// cboForms
			// 
			this.cboForms.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cboForms.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cboForms.ItemHeight = 13;
			this.cboForms.Location = new System.Drawing.Point(8, 16);
			this.cboForms.Name = "cboForms";
			this.cboForms.Size = new System.Drawing.Size(192, 21);
			this.cboForms.TabIndex = 18;
			this.cboForms.SelectedIndexChanged += new System.EventHandler(this.cboForms_SelectedIndexChanged);
			// 
			// label1
			// 
			this.label1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.label1.Location = new System.Drawing.Point(8, 72);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(176, 16);
			this.label1.TabIndex = 8;
			this.label1.Text = "Properties:";
			// 
			// lvwProperties
			// 
			this.lvwProperties.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvwProperties.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							this.clmnName,
																							this.clmnValue});
			this.lvwProperties.FullRowSelect = true;
			this.lvwProperties.HideSelection = false;
			this.lvwProperties.Location = new System.Drawing.Point(8, 96);
			this.lvwProperties.Name = "lvwProperties";
			this.lvwProperties.Size = new System.Drawing.Size(192, 208);
			this.lvwProperties.TabIndex = 7;
			this.lvwProperties.View = System.Windows.Forms.View.Details;
			this.lvwProperties.SelectedIndexChanged += new System.EventHandler(this.lvwProperties_SelectedIndexChanged);
			// 
			// clmnName
			// 
			this.clmnName.Text = "Name";
			this.clmnName.Width = 104;
			// 
			// clmnValue
			// 
			this.clmnValue.Text = "Value";
			// 
			// chkBoolProperty
			// 
			this.chkBoolProperty.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.chkBoolProperty.Location = new System.Drawing.Point(8, 304);
			this.chkBoolProperty.Name = "chkBoolProperty";
			this.chkBoolProperty.Size = new System.Drawing.Size(152, 16);
			this.chkBoolProperty.TabIndex = 5;
			this.chkBoolProperty.Text = "<Name>";
			this.chkBoolProperty.Visible = false;
			this.chkBoolProperty.CheckedChanged += new System.EventHandler(this.chkBoolProperty_CheckedChanged);
			// 
			// lblOtherProperty
			// 
			this.lblOtherProperty.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblOtherProperty.Location = new System.Drawing.Point(8, 320);
			this.lblOtherProperty.Name = "lblOtherProperty";
			this.lblOtherProperty.Size = new System.Drawing.Size(192, 16);
			this.lblOtherProperty.TabIndex = 4;
			this.lblOtherProperty.Text = "PropertyName: <None>";
			this.lblOtherProperty.Visible = false;
			// 
			// cboBorderKey
			// 
			this.cboBorderKey.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cboBorderKey.ItemHeight = 13;
			this.cboBorderKey.Location = new System.Drawing.Point(8, 336);
			this.cboBorderKey.Name = "cboBorderKey";
			this.cboBorderKey.Size = new System.Drawing.Size(192, 21);
			this.cboBorderKey.TabIndex = 24;
			this.cboBorderKey.Visible = false;
			this.cboBorderKey.SelectedIndexChanged += new System.EventHandler(this.cboBorderKey_SelectedIndexChanged);
			// 
			// MenuEditor
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(720, 385);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.cmdAddVertScrollBar);
			this.Controls.Add(this.cmdAddHorzScrollBar);
			this.Controls.Add(this.chkSnapToGrid);
			this.Controls.Add(this.cmdAddListBoxMultiSelect);
			this.Controls.Add(this.cmdAddTextBox);
			this.Controls.Add(this.cmdAddListBox);
			this.Controls.Add(this.cmdAddSlider);
			this.Controls.Add(this.cmdAddComboBox);
			this.Controls.Add(this.cmdAddRadioButton);
			this.Controls.Add(this.cmdAddCheckBox);
			this.Controls.Add(this.cmdAddLabel);
			this.Controls.Add(this.cmdAddButton);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.cmdDeleteControl);
			this.Menu = this.mainMenu1;
			this.Name = "MenuEditor";
			this.Text = "Menu Editor";
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			using( MenuEditor oApp = new MenuEditor() )
			{                
				oApp.DSGameEngine = new DSGameEngine( (System.Windows.Forms.Control)oApp.groupBox1,DarkStrideToolbox.RenderMode.TwoD,false );
				oApp.OneTimeSceneInitialization();
				oApp.DSGameEngine.Run();
			}
		}
		#endregion

		#region Game Functions
		//The Device has been created.  Resources that are not lost on Reset() can be created here -- resources in Pool.Managed,
		//Pool.Scratch, or Pool.SystemMemory.  Image surfaces created via CreateImageSurface are never lost and can be created here.  Vertex
		//shaders and pixel shaders can also be created here as they are not lost on Reset().
		public void OneTimeSceneInitialization()
		{

			//Register our callback functions so we know when the engine wants us to do things... consider 
			//deligates/callbacks to be equivilant to VB events.
			m_oGameEngine.Render += new EventHandler( this.Render );
			m_oGameEngine.BackgroundClearColor = System.Drawing.Color.LightGray;

			m_oGameEngine.MouseInExclusiveMode = false;
			m_oGameEngine.ShowMouseCursor = true;

			m_oGameEngine.Forms.MouseUp += new EventHandler( OnMouseUp );
			m_oGameEngine.Forms.MouseDown += new EventHandler( OnMouseDown );
			m_oGameEngine.Forms.MouseMove += new EventHandler( OnMouseMove );
			m_oGameEngine.Forms.MouseWheelMove += new EventHandler( OnMouseWheelMove );
			m_oGameEngine.Forms.KeyDown += new EventHandler( OnKeyDown );
			m_oGameEngine.Forms.KeyUp += new EventHandler( OnKeyUp );
		}
		//Called once per frame, the call is the entry point for 3d rendering. This 
		//function sets up render states, clears the viewport, and renders the scene.
		private void Render(object sender, System.EventArgs e)
		{
			Rectangle oHighlight;


			//04/02/2005 Chris Hill  If we are in edit mode then this doesn't do the same thing
			if( m_oControlBeingEdited != null )
			{
				oHighlight = new Rectangle( (int)m_oControlBeingEdited.Location.X - 5,
											(int)m_oControlBeingEdited.Location.Y - 5,
											(int)m_oControlBeingEdited.Size.X + 10,
											(int)m_oControlBeingEdited.Size.Y + 10 );
				if( m_oControlBeingEdited != GetForm() )
				{
					oHighlight.X += GetForm().Location.X;
					oHighlight.Y += GetForm().Location.Y;
				}

				// Draw a wrapper to designate which control we are looking at
				m_oGameEngine.RenderRect2D( oHighlight,System.Drawing.Color.Gray.ToArgb() );
			}

			m_oGameEngine.RenderText( 0,0,System.Drawing.Color.White,m_oGameEngine.FrameStats  );
		}
		#endregion


		//Now add our new control
		private void cmdAddButton_Click(object sender, System.EventArgs e)
		{
			GetForm().AddControl_Button(	GetNextFreeControlName( "Command" ),
											new System.Drawing.Point( 0,0 ),
											new Vector2( 100,40 ),"Text" );
		}

		private void cmdAddLabel_Click(object sender, System.EventArgs e)
		{
			GetForm().AddControl_Label(	GetNextFreeControlName( "Label" ),
										new System.Drawing.Point( 0,0 ),
										new Vector2( 50,20 ),"Text" );		
		}

		private void cmdAddCheckBox_Click(object sender, System.EventArgs e)
		{
			GetForm().AddControl_CheckBox(	GetNextFreeControlName( "Check" ),
											new System.Drawing.Point( 0,0 ),
											new Vector2( 50,20 ),"Text" );		
		}
		private void cmdAddRadioButton_Click(object sender, System.EventArgs e)
		{
			GetForm().AddControl_RadioButton(	GetNextFreeControlName( "RadioButton" ),0,
												new System.Drawing.Point( 0,0 ),
												new Vector2( 50,20 ),"Text" );				
		}

		private void cmdAddComboBox_Click(object sender, System.EventArgs e)
		{
			GetForm().AddControl_ComboBox(	GetNextFreeControlName( "ComboBox" ),
											new System.Drawing.Point( 0,0 ),
											new Vector2( 150,30 ),"" );
		}

		private void cmdAddSlider_Click(object sender, System.EventArgs e)
		{
			GetForm().AddControl_Slider(	GetNextFreeControlName( "Slider" ),
											new System.Drawing.Point( 0,0 ),
											new Vector2( 150,20 ) );		
		}

		private void cmdAddListBox_Click(object sender, System.EventArgs e)
		{
			GetForm().AddControl_ListBox(	GetNextFreeControlName( "ListBox" ),
											new System.Drawing.Point( 0,0 ),
											new Vector2( 150,80 ),
											DarkStrideToolbox.ListBoxStyle.SingleSelection );
		}

		private void cmdAddTextBox_Click(object sender, System.EventArgs e)
		{
			GetForm().AddControl_EditBox(	GetNextFreeControlName( "TextBox" ),
											new System.Drawing.Point( 0,0 ),
											new Vector2( 150,40 ),"Text" );		
		}

		private void cmdAddListBoxMultiSelect_Click(object sender, System.EventArgs e)
		{
			GetForm().AddControl_ListBox(	GetNextFreeControlName( "ListBox" ),
											new System.Drawing.Point( 0,0 ),
											new Vector2( 150,80 ),
											DarkStrideToolbox.ListBoxStyle.Multiselection );
		}
		private void cmdAddHorzScrollBar_Click(object sender, System.EventArgs e)
		{
			DSHorzScrollBar oHorzScrollBarControl = null;
		
			oHorzScrollBarControl = new DSHorzScrollBar( m_oGameEngine.Forms,GetForm() );
			oHorzScrollBarControl.Visible = true;
			oHorzScrollBarControl.Name = GetNextFreeControlName( "HorzScrollBar" );
			oHorzScrollBarControl.SetTrackRange( 0,100 );
			oHorzScrollBarControl.Size = new Vector2( 150,20 );
			GetForm().AddControl( oHorzScrollBarControl );
		}
		private void cmdAddVertScrollBar_Click(object sender, System.EventArgs e)
		{
			DSVertScrollBar oVertScrollBarControl = null; 

			oVertScrollBarControl = new DSVertScrollBar( m_oGameEngine.Forms,GetForm() );
			oVertScrollBarControl.Visible = true;
			oVertScrollBarControl.Name = GetNextFreeControlName( "VertScrollBar" );
			oVertScrollBarControl.SetTrackRange( 0,100 );
			oVertScrollBarControl.Size = new Vector2( 20,150 );
			GetForm().AddControl( oVertScrollBarControl );
		}


		public DSForm GetForm()
		{
			DSForm oForm = null;


			//Get the form we are working on
			if( txtFormName.Text.Length == 0 )
			{
				m_bSysAction = true;
				txtFormName.Text = "Form1";
				oForm = m_oGameEngine.Forms.Add( txtFormName.Text,new Vector2( 0,0 ),new Vector2( 1000,1000 ),false );
				LoadFormsList();
				m_bSysAction = false;
			}
			else
			{
				oForm = m_oGameEngine.Forms.GetForm( txtFormName.Text );
			}


			return( oForm );
		}


		//Returns weather or not the mouse event was used by the DSForm.  The mouse cursor returned is the mouse cursor
		//the DSForm would like to have used.	
		public void OnMouseDown( object sender, EventArgs e )
		{
			DSForm oFormClickedOn = null;
			Vector2 vMousePosInFormSpace;
			Vector2 vLocation;
			DarkStrideToolbox.DSMouseClickEventArgs oArgs = (DarkStrideToolbox.DSMouseClickEventArgs)e;
 

			//Did they click on a DSForm?  If so its either a control click or a DSForm moving
			oFormClickedOn = m_oGameEngine.Forms.GetFormAt( oArgs.MousePosInControlSpace );

			//No DSForm.  Just an idle screen click.  Ignore it.
			if( oFormClickedOn != null )
			{
				vMousePosInFormSpace = new Vector2( oArgs.MousePosInControlSpace.X - oFormClickedOn.Location.X,
													oArgs.MousePosInControlSpace.Y - oFormClickedOn.Location.Y );

				//07/20/2005 Chris Hill  If they highlight the form lets edit that.
				//Make sure that we know which control has the focus
				m_oControlBeingEdited = oFormClickedOn.GetControlAt( vMousePosInFormSpace );
				if( m_oControlBeingEdited == null )
				{
					m_oControlBeingEdited = oFormClickedOn;
					m_oMouseDownPos = vMousePosInFormSpace;
				}
				else
				{
					vLocation = new Vector2( m_oControlBeingEdited.Location.X,m_oControlBeingEdited.Location.Y );
					m_oMouseDownPos = vMousePosInFormSpace - vLocation;
				}
				m_bEditMouseDownOnControl = true;
			}


			//Update the delete button
			UpdateButtonStatus();
		}

		public void OnMouseUp( object sender, EventArgs e )
		{
			System.Reflection.MemberInfo[] oaProperties = null;
			System.Windows.Forms.ListViewItem oaItem = null;
			Type oCtrlType;
			object[] oaArguments = new object[ 0 ];
			object oResult;


			lvwProperties.Items.Clear();
			chkBoolProperty.Visible = false;
			txtOtherProperty.Visible = false;
			lblOtherProperty.Visible = false;

			if( m_oControlBeingEdited != null )
			{
				oCtrlType = m_oControlBeingEdited.GetType();
				oaProperties = oCtrlType.GetProperties();

				foreach( MemberInfo mbrInfo in oaProperties )
				{
					oaItem = lvwProperties.Items.Add( mbrInfo.Name );

					try
					{
						// Dynamically Invoke the Object
						oResult = m_oControlBeingEdited.GetType().InvokeMember (
							mbrInfo.Name, 
							BindingFlags.Default | BindingFlags.GetProperty,
							null,
							m_oControlBeingEdited,
							oaArguments );

						oaItem.SubItems.Add( oResult.ToString() );
					}
					catch{}
				}

				m_bEditMouseDownOnControl = false;
			}
		}

		public void OnMouseMove( object sender, EventArgs e )
		{
			DSForm oFormMovedOver = null;
			Vector2 vMousePosInFormSpace;
			Vector2 vLocation;
			DarkStrideToolbox.DSMouseMoveEventArgs oArgs = (DarkStrideToolbox.DSMouseMoveEventArgs)e;

 
			oFormMovedOver = m_oGameEngine.Forms.GetFormAt( oArgs.MousePosInControlSpace );

			if( oFormMovedOver != null )
			{
				vMousePosInFormSpace = new Vector2( oArgs.MousePosInControlSpace.X - oFormMovedOver.Location.X,
													oArgs.MousePosInControlSpace.Y - oFormMovedOver.Location.Y );
 
				if( m_bEditMouseDownOnControl == true && m_oControlBeingEdited != null )
				{
					if( oArgs.Buttons[ 0 ] == true )
					{
						//Make sure that we know which control has the focus
						if( m_oControlBeingEdited != GetForm() )
						{
							m_oControlBeingEdited.Location = new System.Drawing.Point(	(int)(vMousePosInFormSpace.X - m_oMouseDownPos.X),
																						(int)(vMousePosInFormSpace.Y - m_oMouseDownPos.Y) );
						}
						else
						{
							m_oControlBeingEdited.Location = new Point( (int)( vMousePosInFormSpace.X + m_oControlBeingEdited.Location.X - m_oMouseDownPos.X ),
																		(int)( vMousePosInFormSpace.Y + m_oControlBeingEdited.Location.Y - m_oMouseDownPos.Y ) );
						}
						if( this.chkSnapToGrid.Checked == true )
						{
							m_oControlBeingEdited.Location = new System.Drawing.Point(	(int)( (long)((float)m_oControlBeingEdited.Location.X / 10.0f ) * 10.0f ),
																						(int)( (long)((float)m_oControlBeingEdited.Location.Y / 10.0f ) * 10.0f ) );
						}
					}
					else if( oArgs.Buttons[ 1 ] == true )
					{
						if( this.chkSnapToGrid.Checked == false )
						{
							vLocation = new Vector2( m_oControlBeingEdited.Location.X,m_oControlBeingEdited.Location.Y );
							m_oControlBeingEdited.Size = vMousePosInFormSpace - vLocation;
						}
						else
						{
							vLocation = new Vector2( m_oControlBeingEdited.Location.X,m_oControlBeingEdited.Location.Y );
							m_oControlBeingEdited.Size = vMousePosInFormSpace - vLocation;
							m_oControlBeingEdited.Size = new Vector2(	( (long)(m_oControlBeingEdited.Size.X / 10.0 ) ) * 10.0f,
																		( (long)(m_oControlBeingEdited.Size.Y / 10.0 ) ) * 10.0f );
						}

						if( m_oControlBeingEdited.Size.X < 10 )
						{
							m_oControlBeingEdited.Size = new Vector2( 10,m_oControlBeingEdited.Size.Y );
						}
						if( m_oControlBeingEdited.Size.Y < 10 )
						{
							m_oControlBeingEdited.Size = new Vector2( m_oControlBeingEdited.Size.X,10 );
						}							
					}
				}

			}
		}
		public void OnMouseWheelMove( object sender, EventArgs e )
		{
		}

		public void OnKeyDown( object sender, EventArgs e )
		{
		}
		public void OnKeyUp( object sender, EventArgs e )
		{
		}


		//Property Managment
		private void lvwProperties_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			DSSortedList oTables = null;
			DSGobTable oLoopTable = null;
			DSGobFile oLoopFile = null;
			MemberInfo mbrProperty = null;
			PropertyInfo prpProperty = null;
			object[] oaArguments = new object[ 0 ];
			object oResult = null;
			string sTemp = "";
					

			if( lvwProperties.SelectedItems.Count > 0 )
			{
				mbrProperty = GetProperty( lvwProperties.SelectedItems[ 0 ].Text );
				prpProperty = (PropertyInfo)mbrProperty;

				// Dynamically Invoke the Object
				try
				{
					oResult = m_oControlBeingEdited.GetType().InvokeMember (
										mbrProperty.Name, 
										BindingFlags.Default | BindingFlags.GetProperty,
										null,
										m_oControlBeingEdited,
										oaArguments );
				}
				catch{}

				chkBoolProperty.Visible = false;
				txtOtherProperty.Visible = false;
				lblOtherProperty.Visible = false;
				cboAnchorStyles.Visible = false;
				cboBorderKey.Visible = false;

				m_bSysAction = true;

				//02/21/2006 Chris Hill  Added support for border keys.
				if( mbrProperty.Name == "GobBorderKey" )
				{
					lblOtherProperty.Visible = true;
					cboBorderKey.Visible = true;

					lblOtherProperty.Text = mbrProperty.Name;
					cboBorderKey.Text = oResult.ToString();

					//Start by populating the list of valid keys
					for( int i=0 ; i<DSResourceManager.GetGlobalInstance().GobFiles.Count ; i++ )
					{
						//Get the file
						oLoopFile = (DSGobFile)DSResourceManager.GetGlobalInstance().GobFiles.GetByIndex( i );
						//Now list the borders
						oTables = oLoopFile.GetTables( enumTableType.Border );
						for( int nTableIndex=0 ; nTableIndex<oTables.Count ; nTableIndex++ )
						{
							oLoopTable = (DSGobTable)oTables.GetByIndex( nTableIndex );
							if( cboBorderKey.Items.Contains( oLoopTable.TableName ) == false )
							{
								cboBorderKey.Items.Add( oLoopTable.TableName );
							}
						}
					}

					//Select the one thats been picked
					cboBorderKey.SelectedIndex = -1;
					for( int i=0 ; i<cboBorderKey.Items.Count ; i++ )
					{
						if( m_oControlBeingEdited.GobBorderKey == cboBorderKey.Items[ i ].ToString() )
						{
							cboBorderKey.SelectedIndex = i;
						}
					}
				}
				else if( prpProperty.PropertyType.ToString() == "System.Boolean" )
				{
					chkBoolProperty.Visible = true;

					chkBoolProperty.Text = mbrProperty.Name;
					chkBoolProperty.Checked = (bool)oResult;
				}
				else if( prpProperty.PropertyType.ToString() == "System.String" )
				{
					txtOtherProperty.Visible = true;
					lblOtherProperty.Visible = true;
					txtOtherProperty.Enabled = true;

					lblOtherProperty.Text = mbrProperty.Name;
					txtOtherProperty.Text = (string)oResult;
				}
				//02/21/2006 Chris Hill  Added support for anchor types.
				else if( prpProperty.PropertyType.ToString() == "System.Windows.Forms.AnchorStyles" )
				{
					lblOtherProperty.Visible = true;
					cboAnchorStyles.Visible = true;

					lblOtherProperty.Text = mbrProperty.Name;
					cboAnchorStyles.Text = oResult.ToString();

					//Select the one thats been picked
					sTemp = Convert.ToInt64( m_oControlBeingEdited.Anchor ).ToString();
					cboAnchorStyles.SelectedIndex = -1;
					for( int i=0 ; i<cboAnchorStyles.Items.Count ; i++ )
					{
						if( sTemp == 
							cboAnchorStyles.Items[ i ].ToString().Substring( 0,sTemp.ToString().Length ) )
						{
							cboAnchorStyles.SelectedIndex = i;
						}
					}
				}
				else 
				{
					try
					{
						lblOtherProperty.Text = mbrProperty.Name;
						txtOtherProperty.Text = oResult.ToString();

						txtOtherProperty.Visible = true;
						lblOtherProperty.Visible = true;
						txtOtherProperty.Enabled = false;
					}
					catch{}
				}
				m_bSysAction = false;
			}
		}

		private MemberInfo GetProperty( string sName )
		{
			MemberInfo mbrRetVal = null;
			System.Reflection.MemberInfo[] oaProperties = null;
			Type oCtrlType;


			if( m_oControlBeingEdited != null )
			{
				oCtrlType = m_oControlBeingEdited.GetType();
				oaProperties = oCtrlType.GetProperties();

				foreach( MemberInfo mbrInfo in oaProperties )
				{
					if( mbrInfo.Name == sName )
					{
						mbrRetVal = mbrInfo;
						break;
					}
				}
			}

			return( mbrRetVal );
		}

		private void chkBoolProperty_CheckedChanged(object sender, System.EventArgs e)
		{
			MemberInfo mbrProperty = GetProperty( lvwProperties.SelectedItems[ 0 ].Text );
			PropertyInfo prpProperty = (PropertyInfo)mbrProperty;
			object[] oaArguments = new object[ 1 ];
			object oResult;
					

			if( m_bSysAction == false )
			{
				oaArguments[ 0 ] = chkBoolProperty.Checked;

				// Dynamically Invoke the Object
				oResult = m_oControlBeingEdited.GetType().InvokeMember (
					mbrProperty.Name, 
					BindingFlags.Default | BindingFlags.SetProperty,
					null,
					m_oControlBeingEdited,
					oaArguments );
			}
		}

		private void txtOtherProperty_TextChanged(object sender, System.EventArgs e)
		{
			MemberInfo mbrProperty = GetProperty( lvwProperties.SelectedItems[ 0 ].Text );
			PropertyInfo prpProperty = (PropertyInfo)mbrProperty;
			object[] oaArguments = new object[ 1 ];
			object oResult = null;
			DSBaseControl oControl = null;
					

			if( m_bSysAction == false )
			{
				if( mbrProperty.Name == "Name" )
				{
					oControl = m_oControlBeingEdited;
					GetForm().RemoveControl( oControl.Name );
					oControl.Name = txtOtherProperty.Text;
					GetForm().AddControl( oControl );
				}
				else
				{
					oaArguments[ 0 ] = txtOtherProperty.Text;

					// Dynamically Invoke the Object
					oResult = m_oControlBeingEdited.GetType().InvokeMember (
						mbrProperty.Name, 
						BindingFlags.Default | BindingFlags.SetProperty,
						null,m_oControlBeingEdited,
						oaArguments );
				}
			}
		}


		private void mnuOpen_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog oOpenDialog = new OpenFileDialog();

			oOpenDialog.InitialDirectory = DSMisc.GetDevelopmentAppPath();
			oOpenDialog.Filter = "Menu files (*.mnu)|*.mnu|All files (*.*)|*.*" ;
			oOpenDialog.FilterIndex = 1;
			oOpenDialog.RestoreDirectory = true;

			if( oOpenDialog.ShowDialog() == DialogResult.OK )
			{
				m_oGameEngine.Forms.LoadFromFile( oOpenDialog.FileName );
				LoadFormsList();
			}
		}

		private void mnuSave_Click(object sender, System.EventArgs e)
		{
			bool bFirstSave = true;
			SaveFileDialog oSaveFileDialog = new SaveFileDialog();
			SaveFormSelect oFormSelect = new SaveFormSelect();



			oSaveFileDialog.InitialDirectory = DSMisc.GetDevelopmentAppPath();
			oSaveFileDialog.Filter = "Menu files (*.mnu)|*.mnu|All files (*.*)|*.*" ;
			oSaveFileDialog.FilterIndex = 1;
			oSaveFileDialog.RestoreDirectory = true;


			if( m_oGameEngine.Forms.Count > 1 )
			{
				oFormSelect.GameEngine = m_oGameEngine;
				if( oFormSelect.ShowDialog() == DialogResult.OK &&
					oSaveFileDialog.ShowDialog() == DialogResult.OK )
				{
					for( int i=0 ; i<oFormSelect.FormsToSave.Length ; i++ )
					{
						m_oGameEngine.Forms.SaveToFile( oSaveFileDialog.FileName,!bFirstSave,oFormSelect.FormsToSave[ i ] );
						bFirstSave = false;
					}
				}
			}
			else
			{
				if( oSaveFileDialog.ShowDialog() == DialogResult.OK )
				{
					m_oGameEngine.Forms.SaveToFile( oSaveFileDialog.FileName,false );
				}
			}
		}

		private void mnuExit_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void mnuOpenGobFile_Click(object sender, System.EventArgs e)
		{
			LoadedGobManager oGobManagement = new LoadedGobManager();
			oGobManagement.ShowDialog();
		}


		//Form Managment
		private void cboForms_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			m_oControlBeingEdited = null;
			SetupFormsList();
		}

		private void LoadFormsList()
		{
			//Load the forms list
			cboForms.Items.Clear();
			for( int i=0 ; i<m_oGameEngine.Forms.Count ; i++ )
			{
				cboForms.Items.Add( m_oGameEngine.Forms.GetForm( i ).Name );
			}

			if( cboForms.Items.Count > 0 )
			{
				cboForms.SelectedIndex = 0;
			}
			else
			{
				SetupFormsList();
			}
		}
		private void SetupFormsList()
		{
			DSForm oForm = null;


			m_bSysAction = true;

			txtFormName.Text = cboForms.Text;
			m_sOldFormName = cboForms.Text;
			lvwProperties.Items.Clear();
			chkBoolProperty.Visible = false;
			txtOtherProperty.Visible = false;
			lblOtherProperty.Visible = false;
			txtFormName.Enabled = true;

			//Anytime we change forms we have to make sure only one is visible
			for( int i=0 ; i<m_oGameEngine.Forms.Count ; i++ )
			{
				oForm = m_oGameEngine.Forms.GetForm( i );
				oForm.Visible = (oForm.Name == cboForms.Text);
				oForm.Location = new Point( 0,0 );
			}

			m_bSysAction = false;
		}

		private void txtFormName_TextChanged(object sender, System.EventArgs e)
		{
			int nIndex = -1;

			if( m_bSysAction == false && txtFormName.Text != m_sOldFormName )
			{
				if( txtFormName.Text.Length == 0 || m_oGameEngine.Forms.GetForm( txtFormName.Text ) != null )
				{
					MessageBox.Show( "Invalid Name.  Please enter a valid form name.","Error",System.Windows.Forms.MessageBoxButtons.OK );
					txtFormName.Text = m_sOldFormName;
				}
				else
				{
					m_oGameEngine.Forms.GetForm( m_sOldFormName ).Name = txtFormName.Text;

					cboForms.Items.Remove( m_sOldFormName );
					nIndex = cboForms.Items.Add( txtFormName.Text );
					cboForms.SelectedIndex = nIndex;

					m_sOldFormName = txtFormName.Text;
				}
			}
		}
		private void cboAnchorStyles_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			string sNumber = "";

			if( m_bSysAction == false )
			{
				sNumber = cboAnchorStyles.Text.Substring( 0,2 );
				m_oControlBeingEdited.Anchor = (System.Windows.Forms.AnchorStyles)Convert.ToInt64( sNumber );
			}
		}

		private void cboBorderKey_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if( m_bSysAction == false )
			{
				m_oControlBeingEdited.GobBorderKey = cboBorderKey.Text;
				MessageBox.Show( "This menu is now dependent upon this Gob file.  It is the programmer's responsability to ensure the Gob is loaded into the system." );
			}
		}


		private void menuItem3_Click(object sender, System.EventArgs e)
		{
			while( m_oGameEngine.Forms.Count > 0 )
			{
				m_oGameEngine.Forms.Remove( m_oGameEngine.Forms.GetForm( 0 ).Name );
			}
			LoadFormsList();
		}

		private void mnuAddNewForm_Click(object sender, System.EventArgs e)
		{
			string sNewFormName = "";

			m_bSysAction = true;
			
			sNewFormName = GetNextFreeFormName( "Form" );
			m_oGameEngine.Forms.Add( sNewFormName,new Vector2( 0,0 ),new Vector2( 1000,1000 ),false );
			LoadFormsList();

			cboForms.Text = sNewFormName;
			SetupFormsList();

			m_bSysAction = false;
		}


		public string GetNextFreeControlName( string sNameDesired )
		{
			long nMod = 1;
			string sRetVal = sNameDesired;
			DSForm oForm = null;

			oForm = GetForm();

			if( oForm.GetControl( sNameDesired ) != null )
			{
				while( oForm.GetControl( sNameDesired + nMod.ToString() ) != null )
				{
					nMod++;
				}

				sRetVal = sNameDesired + nMod.ToString();
			}

			return( sRetVal );
		}

		public string GetNextFreeFormName( string sNameDesired )
		{
			long nMod = 1;
			string sRetVal = sNameDesired;

			if( m_oGameEngine.Forms.GetForm( sNameDesired ) != null )
			{
				while( m_oGameEngine.Forms.GetForm( sNameDesired + nMod.ToString() ) != null )
				{
					nMod++;
				}

				sRetVal = sNameDesired + nMod.ToString();
			}

			return( sRetVal );
		}

		public void UpdateButtonStatus()
		{
			cmdDeleteControl.Visible = ( m_oControlBeingEdited != null &&
										 m_oControlBeingEdited != GetForm() );
		}

		private void cmdDeleteControl_Click(object sender, System.EventArgs e)
		{
			GetForm().RemoveControl( m_oControlBeingEdited.Name );
			m_oControlBeingEdited = null;
			UpdateButtonStatus();
		}




		#region Properties
		public DSGameEngine DSGameEngine
		{
			set
			{
				m_oGameEngine = value;
			}
			get
			{
				return( m_oGameEngine );
			}
		}
		#endregion
	}
}