using System;
using DarkStrideToolbox;


namespace DarkStrideToolbox
{
	public class IdentificationBuoy : MarshalByRefObject
	{
		#region Properties
		private DSSortedList m_oKnownUsers = new DSSortedList();
		private DSSortedList m_oPendingUsers = new DSSortedList();
		private User m_oMyUser = null;
		#endregion

		#region Events
		public event EventHandler UpdateUserListEvent;

		protected void RaiseUpdateUserList()
		{
			EventArgs oArgs = null;

			if( UpdateUserListEvent != null )
			{
				oArgs = new EventArgs();
				UpdateUserListEvent( null, oArgs );
			}
		}

		#endregion       		


		public IdentificationBuoy()
		{
		}

		public void UpdateUserList( DSSortedList oMyUsers )
		{
			User oOldPendingUser = null;
			User oNewPendingUser = null;


			lock( m_oPendingUsers )
			{
				for( int i=0 ; i<oMyUsers.Count ; i++ )
				{
					oNewPendingUser = (User)oMyUsers.GetByIndex( i );

					//Make sure we don't dupe!
					if( m_oPendingUsers.ContainsKey( oMyUsers.GetKey( i ) ) == true )
					{
						oOldPendingUser = (User)m_oPendingUsers.GetByKey( oMyUsers.GetKey( i ) );						

						if( oOldPendingUser.TimeOfLatestInfo < oNewPendingUser.TimeOfLatestInfo )
						{
							m_oPendingUsers.Remove( oOldPendingUser.GUID );
						}
						else
						{
							oNewPendingUser = null;
						}
					}
					
					//Is this user already in our collection?
					if( oNewPendingUser != null )
					{
						m_oPendingUsers.Add( oNewPendingUser.GUID,oNewPendingUser );
					}
				}
			}

			RaiseUpdateUserList();
		}

		public void RemovePendingUser( string sGUID )
		{
			m_oPendingUsers.Remove( sGUID );
		}


		public long GetNumberOfUsersofType( enumStatus nType )
		{
			User oKnownUser = null;
			long nCount = 0;


			for( int nLoopUserIndex=0 ; nLoopUserIndex<m_oKnownUsers.Count ; nLoopUserIndex++ )
			{
				oKnownUser = (User)m_oKnownUsers.GetByIndex( nLoopUserIndex );

				if( oKnownUser.Status == nType )
				{
					nCount++;
				}
			}


			return( nCount );
		}

		public void AddUser( User oUser )
		{
			m_oKnownUsers.Add( oUser.GUID,oUser );
		}



		#region Properties
		public DSSortedList Users
		{
			get
			{
				return( m_oKnownUsers );
			}
		}
		public DSSortedList PendingUsers
		{
			get
			{
				return( m_oPendingUsers );
			}
			set
			{
				m_oPendingUsers = value;
			}
		}
		public User MyUser
		{
			get
			{
				return( m_oMyUser );
			}
			set
			{
				m_oMyUser = value;
			}
		}
		#endregion
	}
}