VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsPlayer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "clsPlayer"

'Vitals for DNDOnline
Public sUnique As String
Public sName As String
Public sVersion As String
Public nNumber As Long

'Characters I have loaded from the DB
Public m_colCharacters As New Collection
Private m_oLastCharToTalk As clsCharacter

Public Property Get LastCharToTalk() As clsCharacter

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LastCharToTalk"
    Call WriteProcStart(sRoutineName)
    
    
    If m_oLastCharToTalk Is Nothing And m_colCharacters.Count > 0 Then
        Set LastCharToTalk = m_colCharacters(1)
    ElseIf m_colCharacters.Count > 0 Then
        Set LastCharToTalk = m_oLastCharToTalk
    Else
        Call Err.Raise(-1, sRoutineName, "Player " & sName & " has no characters loaded.")
    End If
    
         
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Property
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
                
End Property
Public Property Set LastCharToTalk(oNewChar As clsCharacter)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LastCharToTalk"
    Call WriteProcStart(sRoutineName)
    
    
    Set m_oLastCharToTalk = oNewChar
         
            
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Property
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
            
End Property

Public Function Name() As String
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = "clsPlayer.Name"
    'Call WriteProcStart(sRoutineName)
    
    
    Name = "clsPlayer"


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function
'Get the persons adjusted name
Public Function PlayerName(Optional bShowVer = False) As String

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".PlayerName"
    Call WriteProcStart(sRoutineName) ' bShowVer)
    
   
    'Store the location of the begginging of the name
    PlayerName = Pad(nNumber, " ", 2) & ".)  " & sName
    
    If bShowVer = True Then
        If Len(PlayerName) > 20 Then
        Else
            PlayerName = PlayerName & String(20 - Len(PlayerName), " ") & sVersion
        End If
    End If
         
            
    Call WriteProcStop(sRoutineName) ' PlayerName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
            
End Function
Public Sub LoadCharacters(dbDND As ADODB.Connection)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LoadCharacters"
    Call WriteProcStart(sRoutineName) ' "OBJECT")
    
   
    Dim oChar As clsCharacter
    Dim rstChars As ADODB.Recordset
    Set rstChars = OpenMyRecordset(dbDND, "SELECT * FROM CharacterInfo")
    
''Chris
'Dim i As Long
'i = FreeFile
'Open App.Path & "\MattDebug3.out" For Append As #i
'    Print #i, Now() & " - clsPlayer.LOading Characters"
'Close #i
    
    Call rstChars.MoveFirst
    While rstChars.EOF() = False
        Set oChar = New clsCharacter
        Call oChar.Load(dbDND, rstChars![CharacterID])
        
'i = FreeFile
'Open App.Path & "\MattDebug3.out" For Append As #i
'    Print #i, Now() & " -      Loaded:" & oChar.sName & "," & oChar.nCharID
'Close #i

        Call AddCharacter(oChar)
        Call rstChars.MoveNext
    Wend
         
            
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Public Sub AddCharacter(oChar As clsCharacter)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".AddCharacter"
    Call WriteProcStart(sRoutineName) ' "OBJECT")
    
   
    Call m_colCharacters.Add(oChar, "#" & oChar.sGUID)
    
            
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Public Sub RemoveCharacter(oChar As clsCharacter)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".RemoveCharacter"
    Call WriteProcStart(sRoutineName) ' "OBJECT")
    
   
    Dim i As Long
    For i = m_colCharacters.Count To 1 Step -1
        If m_colCharacters.Item(i).sGUID = oChar.sGUID Then
            Call m_colCharacters.Remove(i)
        End If
    Next i
         
            
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Public Function GetCharacter(sGUID As String) As clsCharacter

    On Error GoTo NotFound
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetCharacter"
    Call WriteProcStart(sRoutineName) ' sGUID)
    

    Set GetCharacter = m_colCharacters("#" & sGUID)
         
            
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

NotFound:
    Set GetCharacter = Nothing

End Function
Public Function GetCharacterByID(nID As Long) As clsCharacter

    On Error GoTo NotFound
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetCharacterByID"
    Call WriteProcStart(sRoutineName) ' nID)
    

    Dim oChar As clsCharacter
    
    For Each oChar In m_colCharacters
        If oChar.nCharID = nID Then
            Set GetCharacterByID = oChar
        End If
    Next oChar
         
            
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

NotFound:
    Set GetCharacterByID = Nothing
    
End Function


