VERSION 5.00
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmMessage_3_2_0 
   Caption         =   "Message Window"
   ClientHeight    =   4065
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   10185
   Icon            =   "frmMessage.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4065
   ScaleWidth      =   10185
   Begin VB.Frame framStats 
      Height          =   3975
      Left            =   9240
      TabIndex        =   23
      Top             =   0
      Width           =   890
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Spell"
         Height          =   225
         Index           =   4
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   14
         Tag             =   "nSpell"
         Top             =   2880
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Breath"
         Height          =   225
         Index           =   3
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   13
         Tag             =   "nBreath"
         Top             =   2670
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Poly"
         Height          =   225
         Index           =   2
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   12
         Tag             =   "nPoly"
         Top             =   2460
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Rod"
         Height          =   225
         Index           =   1
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   11
         Tag             =   "nRod"
         Top             =   2250
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Death"
         Height          =   225
         Index           =   0
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   10
         Tag             =   "nDeath"
         Top             =   2040
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Per"
         Height          =   225
         Index           =   12
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   9
         Tag             =   "nPer"
         Top             =   1710
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Com"
         Height          =   225
         Index           =   11
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   8
         Tag             =   "nCom"
         Top             =   1500
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Chr"
         Height          =   225
         Index           =   10
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   7
         Tag             =   "nChr"
         Top             =   1290
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Wis"
         Height          =   225
         Index           =   9
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   6
         Tag             =   "nWis"
         Top             =   1080
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Int"
         Height          =   225
         Index           =   8
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   5
         Tag             =   "nInt"
         Top             =   870
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Con"
         Height          =   225
         Index           =   7
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   4
         Tag             =   "nCon"
         Top             =   660
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Dex"
         Height          =   225
         Index           =   6
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   3
         Tag             =   "nDex"
         Top             =   450
         Width           =   645
      End
      Begin VB.CommandButton cmdRollStat 
         Caption         =   "Str"
         Height          =   225
         Index           =   5
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   2
         Tag             =   "nStr"
         Top             =   240
         Width           =   645
      End
      Begin VB.CommandButton cmdViewChar 
         Caption         =   "Char"
         Height          =   225
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   17
         Top             =   3630
         Width           =   645
      End
      Begin VB.CommandButton cmdRollInit 
         Caption         =   "Init"
         Height          =   225
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   16
         Top             =   3420
         Width           =   645
      End
      Begin VB.CommandButton cmdRollAttack 
         Caption         =   "Atck"
         Height          =   225
         Left            =   120
         Style           =   1  'Graphical
         TabIndex        =   15
         Top             =   3210
         Width           =   645
      End
   End
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   1680
      Top             =   3480
      _ExtentX        =   635
      _ExtentY        =   635
      MyResizeForm    =   0   'False
   End
   Begin FOTATools.FOTARichTextBox rtbMsg 
      Height          =   3255
      Left            =   1800
      TabIndex        =   22
      Top             =   120
      Width           =   7335
      _ExtentX        =   12938
      _ExtentY        =   5741
      TextRTF         =   $"frmMessage.frx":0442
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Frame Frame2 
      Caption         =   "To"
      Height          =   1935
      Left            =   0
      TabIndex        =   21
      Top             =   2040
      Width           =   1695
      Begin FOTATools.FOTAComboBox cboTheirCharacters 
         Height          =   315
         Left            =   120
         TabIndex        =   19
         Top             =   1560
         Width           =   1455
         _ExtentX        =   2566
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Locked          =   0   'False
         PreventTyping   =   -1  'True
      End
      Begin VB.Image imgTo 
         BorderStyle     =   1  'Fixed Single
         Height          =   1305
         Left            =   120
         Stretch         =   -1  'True
         Top             =   240
         Width           =   1455
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "From"
      Height          =   1935
      Left            =   20
      TabIndex        =   20
      Top             =   0
      Width           =   1695
      Begin FOTATools.FOTAComboBox cboMyChars 
         Height          =   315
         Left            =   120
         TabIndex        =   18
         Top             =   1560
         Width           =   1455
         _ExtentX        =   2566
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Locked          =   0   'False
         PreventTyping   =   -1  'True
      End
      Begin VB.Image imgFrom 
         BorderStyle     =   1  'Fixed Single
         Height          =   1305
         Left            =   120
         Stretch         =   -1  'True
         Top             =   240
         Width           =   1455
      End
   End
   Begin VB.Timer tmrTaskBar 
      Left            =   3720
      Top             =   3360
   End
   Begin VB.TextBox txtSendString 
      Height          =   495
      Left            =   1800
      MultiLine       =   -1  'True
      TabIndex        =   0
      Top             =   3480
      Width           =   5955
   End
   Begin VB.CommandButton cmdSend 
      Caption         =   "&Send"
      Default         =   -1  'True
      Height          =   495
      Left            =   7800
      TabIndex        =   1
      Top             =   3480
      Width           =   1335
   End
End
Attribute VB_Name = "frmMessage_3_2_0"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This constant tells the VB compiler to FORCE us to declare our variables... its optional
Option Explicit

Private Const m_cNAME As String = "frmMessage_3_2_0"

'Unique key to id a message window
Private m_sName As String
'Which Icon are we displaying?
Private nIconStatus As Long
'Which character is currently talking?
Public m_oCharTalking As clsCharacter

Public Property Get IMName() As String
    IMName = m_sName
End Property
Public Property Let IMName(sNewName As String)
    m_sName = sNewName
    
    '08/28/2002 Chris Hill  Specify where we are going to log too.
    If g_bSave = True Then
        '08/28/2002 Chris Hill  Lets find out if the path is any good.
        'If TestPathIntegrity(g_sWhereToSave) = False Then
        '    Call MsgBox("File path specifed (" & App.Path & g_sWhereToSave & ") for chat room logging is not valid", vbCritical + vbOKOnly, "Error")
        '    g_sWhereToSave = ""
        'Else
            rtbMsg.LogToFile = g_cLOGDIR & Format(Now(), "yyyy-mm-dd") & "_DNDOnline.DD2"
        'End If
    End If
End Property

Private Sub cboTheirCharacters_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cboTheirCharacters_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Dim sGUID As String
    Dim oChar As clsCharacter
    sGUID = cboTheirCharacters.GetCurrentSelectedItemsKey()
    Set oChar = GetCharacter(sGUID)
    
    Set imgTo.Picture = LoadAPicture(g_cPORTRAITSDIR, oChar.sPicture)
    
    'Set the window caption
    Me.Caption = cboTheirCharacters.Text & " - MsgW"


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub cboTheirCharacters_Change()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cboTheirCharacters_Change"
    Call WriteProcStart(sRoutineName)
    
    
    Me.Caption = cboTheirCharacters.Text & " - MsgW"


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub cboMyChars_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cboMyChars_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Dim sGUID As String
    Dim oCharTo As clsCharacter
    
    sGUID = cboMyChars.GetCurrentSelectedItemsKey()
    Set m_oCharTalking = GetCharacter(sGUID)
    
    Set imgFrom.Picture = LoadAPicture(g_cPORTRAITSDIR, m_oCharTalking.sPicture)
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
        
End Sub

Private Sub cmdViewChar_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdViewChar_Click"
    Call WriteProcStart(sRoutineName)
    

    Dim i As Integer
    
    '05/06/2002 Chris Hill  If its a minion were currently using then show us the minion management screen.
    If GetPlayerForCharacter(cboMyChars.GetCurrentSelectedItemsKey()) Is Nothing Then
        If UnHideForm("frmMinions_3_27_0") = False Then
            Call frmMinions_3_27_0.Show(vbModeless)
        End If
    Else
        If UnHideForm("frmCharacter_3_37_0") = False Then
            Call frmCharacter_3_37_0.Show(vbModeless)
        End If
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub Form_Resize()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Resize"
    Call WriteProcStart(sRoutineName)
    
    
    If Me.WindowState <> vbMinimized Then
        If Me.Height < 1515 Then Me.Height = 1515
        If Me.Width < 4545 Then Me.Width = 4545

        framStats.Left = Me.Width - 1065

        cmdSend.Top = Me.Height - 450 - txtSendString.Height
        cmdSend.Left = framStats.Left - 150 - cmdSend.Width

        txtSendString.Top = cmdSend.Top
        txtSendString.Width = cmdSend.Left - 80 - txtSendString.Left

        rtbMsg.Width = (cmdSend.Left + cmdSend.Width) - rtbMsg.Left
        rtbMsg.Height = txtSendString.Top - 50 - rtbMsg.Top
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

'This is a central point for adding messages.  All font interpretation
'and scroll changes are handled here
Public Sub AddMessage(sWhoFrom As String, sMsg As String)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".AddTextMessage"
    Call WriteProcStart(sRoutineName) ' sWhoFrom, sMsg)
    
    
    Dim sName As String
    Dim sRestOfMsg As String

    'Now print out the name
    Call rtbMsg.AddTextMessage(g_oEmotes.ConvertEmotes(sWhoFrom & ": "), g_nFontNameColor, g_oFontName, False)
    'Add the message to the chat room
    Call rtbMsg.AddRTFMessage(g_oEmotes.ConvertEmotes(sMsg))
    
    'Light up the task bar!
    Call Blinky
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
   
End Sub

Private Sub Picture1_Click()

End Sub

Private Sub tmrTaskBar_Timer()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".tmrTaskBar_Timer"
    Call WriteProcStart(sRoutineName)
    
    
    If GetForegroundWindow() = Me.hwnd Then Call UnBlinky
    
    'In case the timer decides to do one last round!
    If tmrTaskBar.Interval > 0 Then
        If nIconStatus = 0 Then
            Icon = LoadAPicture(, g_cSYSGRAPHICSDIR & "DNDOnline.ico", False)
        Else 'If nIconStatus = 1 Then
            Icon = LoadAPicture(, g_cSYSGRAPHICSDIR & "BubbleI.ico", False)
        End If
    End If
    
    nIconStatus = (nIconStatus + 1) Mod 2
    
        
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Public Sub UnBlinky()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".UnBlinky"
    Call WriteProcStart(sRoutineName)
    
    
    tmrTaskBar.Interval = 0
    Icon = LoadAPicture(, g_cSYSGRAPHICSDIR & "DNDOnline.ico", False)
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub Blinky()
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Blinky"
    Call WriteProcStart(sRoutineName)
    
    
    If GetForegroundWindow() <> Me.hwnd Then
        nIconStatus = 0
        tmrTaskBar.Interval = 500
    End If
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

'Send the message to the rest of the network.  -1 means send to all
Private Sub cmdSend_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdSend_Click"
    Call WriteProcStart(sRoutineName)

    
    Call Send(m_oCharTalking)
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub ' End of cmdSend_Click
Private Sub Send(oChar As clsCharacter)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Send"
    Call WriteProcStart(sRoutineName)

    
    Dim sGUID As String
    Dim sTemp As String

    If cboTheirCharacters.ListIndex = -1 Then cboTheirCharacters.Text = ""

    'Is their anything in the field?
    If Len(txtSendString.Text) <> 0 And Len(cboTheirCharacters.Text) > 0 Then
        
        'Record the 'sendto' players id
        sGUID = cboTheirCharacters.GetCurrentSelectedItemsKey

        'We deal in RTF here so lets send the RTF message
        sTemp = TextToRTF(txtSendString.Text, oChar.m_nFontColor, oChar.m_oFont, False)
        sTemp = g_oEmotes.ConvertEmotes(sTemp)

        'Send the message to be processed
        Call MakeProcessSendMsg(g_cSendMsgCode, _
                    cboMyChars.GetCurrentSelectedItemsKey(), sGUID, sTemp)
              
        'I know I know... this is cheeting.  But how do you know what window to add this to?
        Call AddMessage(oChar.sName, sTemp)
    
        'Highlight what they just typed so they can override it just by typing
        txtSendString.SetFocus
        txtSendString.Text = ""
        
        ''Tell the rest of the world that we finished typing
        'Call MakeProcessSendMsg(g_cStoppedTypingCode,  g_nMyNumber , -1)
        'Do we disable or enable the timer for another round?
        Call frmConnectStatus.HasJustStoppedTyping
        
        'Play the sound to anounce sending a message
        Call frmConnectStatus.PlayWavFile(g_sSound_SendSound)
        
    End If 'End of length Check
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub ' End of cmdSend_Click


'Select all as the default option for the combo box (this also forces reloading of the list)
Private Sub Form_Load()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Load"
    Call WriteProcStart(sRoutineName)
    
    
    Dim i As Long
    Dim oLoopChar As clsCharacter
    Static nIMNumber As Long
    nIMNumber = nIMNumber + 1
    
    'Uniquely ID this message window
    IMName() = GetPlayer(g_nMyNumber).sName & nIMNumber
    
    '09/06/2002 Chris Hill  Condense to this new call.
    Call LoadWithAllChars_OLD(cboMyChars, True, True)
    Call LoadWithAllChars_OLD(cboTheirCharacters, False, True)
'    For i = 1 To g_oPlayers.Count
'        'Don't add myself
'        If g_oPlayers(i).nNumber <> g_nMyNumber Then
'            'Walk through all the characters for this player
'            For Each oLoopChar In g_oPlayers(i).m_colCharacters
'                'Add the player to the list and store their ID
'                Call cboTheirCharacters.AddItemWithKey(oLoopChar.sName, oLoopChar.sGUID)
'            Next oLoopChar
'        End If
'    Next i
'
'    'Now add all the minions into the mix
'    For Each oLoopChar In g_colMinions
'        '04/17/2002 Chris Hill  Actually we only want to add my minions to my spot.
'        'Other peoples minions go in the to spot.
'        If oLoopChar.nOwnerNumber = g_nMyNumber Then
'            Call cboMyChars.AddItemWithKey(oLoopChar.sName(), oLoopChar.sGUID)
'        Else
'            Call cboTheirCharacters.AddItemWithKey(oLoopChar.sName(), oLoopChar.sGUID)
'        End If
'    Next oLoopChar
'
'    'Add my chars
'    For Each oLoopChar In GetPlayer(g_nMyNumber).m_colCharacters
'        Call cboMyChars.AddItemWithKey(oLoopChar.sName(), oLoopChar.sGUID)
'    Next oLoopChar
    
    'Any options?
    If cboTheirCharacters.ListCount > 0 Then
        cboTheirCharacters.ListIndex = 0
    End If
    cboMyChars.ListIndex = 0

        
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
        
End Sub ' End of Form_Load

'They have just changed or typed something... that means we need to broadcast that they typed
Private Sub txtsendstring_Change()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".txtSendString_Change"
    Call WriteProcStart(sRoutineName)

    
    'Report to all connected that this player has just typed
    If g_bBroadcastTyping = True Then
        'Looks like we want to broadcast it
        Call frmConnectStatus.HasJustTyped("MessageWindow")
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub ' End of txtSendString_Change
Private Sub txtSendString_KeyUp(KeyCode As Integer, Shift As Integer)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".txtSendString_KeyUp"
    Call WriteProcStart(sRoutineName) ' KeyCode, Shift)
    
    
    If KeyCode >= 112 And KeyCode <= 123 Then
        If cboMyChars.ListCount >= KeyCode - 111 Then
            cboMyChars.ListIndex = KeyCode - 111 - 1
        End If
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
        
End Sub
Private Sub cmdRollStat_Click(Index As Integer)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdRollStat_Click"
    Call WriteProcStart(sRoutineName) ' Index)


    Call RollStat(m_oCharTalking, cmdRollStat(Index).Tag, cmdRollStat(Index).Caption)
    If KeyPressed(VK_SHIFT) = True Then
        Call Send(m_oCharTalking)
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub RollStat(oChar As clsCharacter, sStat As String, sStatName As String)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".RollStat"
    Call WriteProcStart(sRoutineName) ' Index)


    Dim sTemp As String
    sTemp = m_oCharTalking.RollStat(sStat, sStatName)

    If Len(txtSendString.Text) > 0 Then txtSendString.Text = txtSendString.Text & Chr(13) + Chr(10)
    txtSendString.Text = txtSendString.Text & sTemp

    'Wierd Bug
    Call txtSendString.SetFocus
    txtSendString.SelStart = Len(txtSendString.Text)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub cmdRollAttack_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdRollAttack_Click"
    Call WriteProcStart(sRoutineName)


    Call RollAttack(m_oCharTalking)
    If KeyPressed(VK_SHIFT) = True Then
        Call Send(m_oCharTalking)
    End If


    Call WriteProcStop(sRoutineName) ' txtSendString.Text)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub RollAttack(oChar As clsCharacter)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".RollAttack"
    Call WriteProcStart(sRoutineName)


    Dim sTemp As String
        
    '08/04/2004 Chris Hill  Enhance the attack to advance the round for us if we need to.
    If oChar.nLastRoundAttackedFor = Max(g_nRound, 1) And _
       Not oChar.GetNumAttacksThisRound(1, Max(g_nRound, 1)) = oChar.GetNumAttacksThisRound(1, Max(g_nRound, 1) + 1) Or _
       Not oChar.GetNumAttacksThisRound(2, Max(g_nRound, 1)) = oChar.GetNumAttacksThisRound(2, Max(g_nRound, 1) + 1) Then
       
            If MsgBox("The round has not changed since the last time you attacked with this weapon.  This weapon has a partial attack which means that the number of attacks you get changes based on the round.  Should I automatically adujust your attack for the next round?", vbQuestion + vbYesNo, "Attack Adjustment") = vbYes Then
                sTemp = oChar.CharacterAttack(Max(g_nRound, 1) + 1)
            Else
                sTemp = oChar.CharacterAttack(Max(g_nRound, 1))
            End If
    Else
            sTemp = oChar.CharacterAttack(Max(g_nRound, 1))
    End If
    
    
    If Len(txtSendString.Text) > 0 Then txtSendString.Text = txtSendString.Text & Chr(13) + Chr(10)
    txtSendString.Text = txtSendString.Text & sTemp

    'Wierd Bug
    Call txtSendString.SetFocus
    txtSendString.SelStart = Len(txtSendString.Text)


    Call WriteProcStop(sRoutineName) ' txtSendString.Text)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub cmdRollInit_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdRollInit_Click"
    Call WriteProcStart(sRoutineName)


    Call RollInit(m_oCharTalking)
    If KeyPressed(VK_SHIFT) = True Then
        Call Send(m_oCharTalking)
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub RollInit(oChar As clsCharacter)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".RollInit"
    Call WriteProcStart(sRoutineName)


    Dim nTemp As Long

    nTemp = Int((10 * Rnd) + 1)
    nTemp = nTemp - oChar.nCombatInitModifier

    If Len(txtSendString.Text) > 0 Then txtSendString.Text = txtSendString.Text & Chr(13) + Chr(10)

    If nTemp = 0 Then
        txtSendString.Text = txtSendString.Text & "[Rolls an initiative of 0 (Not 10)]"
    Else
        txtSendString.Text = txtSendString.Text & "[Rolls an initiative of " & nTemp & "]"
    End If

    'Wierd Bug
    'Call cmdSend.SetFocus
    Call txtSendString.SetFocus
    txtSendString.SelStart = Len(txtSendString.Text)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

