VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFI_Querys"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private m_oQuerys As New Collection
Private Const m_cSAVESEPERATOR As String = "[SS_]"

Private m_sGUID As String

Public Sub Save(sFileName As String)

    Dim oLoopQuery As clsFI_Query
    Dim nFree As Long
    Dim sQuery As String
    
    nFree = FreeFile
    Open sFileName For Output As #nFree
    
        For Each oLoopQuery In Col
        
            sQuery = SearchAndReplace(oLoopQuery.Query, vbCrLf, "<CRLF>")
            sQuery = SearchAndReplace(sQuery, vbCr, "<CR>")
            sQuery = SearchAndReplace(sQuery, vbLf, "<LF>")
        
            Print #nFree, oLoopQuery.Name & m_cSAVESEPERATOR & _
                          oLoopQuery.GUID & m_cSAVESEPERATOR & _
                          oLoopQuery.Active & m_cSAVESEPERATOR & _
                          sQuery & m_cSAVESEPERATOR & _
                          oLoopQuery.Tag
        Next oLoopQuery
    
    Close #nFree

End Sub

Public Sub Load(sFileName As String)

    Dim nFree As Long
    Dim oQuery As clsFI_Query
    Dim bFound As Boolean
    Dim sLineIn As String
    Dim sQuery As String
    Dim vaTemp() As String
    
    nFree = FreeFile
    Open sFileName For Input As #nFree

        While EOF(nFree) = False
            Line Input #nFree, sLineIn
            
            vaTemp = Split(sLineIn, m_cSAVESEPERATOR)
            
            Set oQuery = FindQueryByGUID(vaTemp(1))
            bFound = (Not oQuery Is Nothing)
            If bFound = False Then
                Set oQuery = New clsFI_Query
            End If
            
            oQuery.Name = vaTemp(0)
            oQuery.Active = vaTemp(2)
            sQuery = vaTemp(3)
            oQuery.Tag = vaTemp(4)
            
            sQuery = SearchAndReplace(sQuery, "<CRLF>", vbCrLf)
            sQuery = SearchAndReplace(sQuery, "<CR>", vbCr)
            oQuery.Query = SearchAndReplace(sQuery, "<LF>", vbLf)
            
            If bFound = False Then
                Call AddQuery(oQuery)
            End If
        Wend

    Close #nFree
 
End Sub

Public Function FindQueryByGUID(sGUID As String) As clsFI_Query
    
    Dim oLoopQuery As clsFI_Query
    
    For Each oLoopQuery In Col
        If UCase(sGUID) = UCase(oLoopQuery.GUID) Then
            Set FindQueryByGUID = oLoopQuery
            Exit Function
        End If
    Next oLoopQuery
    
    Set FindQueryByGUID = Nothing
    
End Function

Public Function FindQueryByName(sName As String) As clsFI_Query
    
    Dim oLoopQuery As clsFI_Query
    
    For Each oLoopQuery In Col
        If UCase(sName) = UCase(oLoopQuery.Name) Then
            Set FindQueryByName = oLoopQuery
            Exit Function
        End If
    Next oLoopQuery
    
    Set FindQueryByName = Nothing
    
End Function

Public Sub Remove(sGUID As String)

    Call m_oQuerys.Remove(sGUID)

End Sub

Public Property Get Col() As Collection
    Set Col = m_oQuerys
End Property

Public Property Get GUID() As String
    GUID = m_sGUID
End Property
Public Property Let GUID(sNewGUID As String)
    m_sGUID = sNewGUID
End Property

Public Sub AddQuery(oQuery As clsFI_Query)
    Call m_oQuerys.Add(oQuery, oQuery.GUID)
End Sub

Public Function AddNewQuery(sName As String, sQuery As String) As String
    
    Dim oQuery As clsFI_Query
    Set oQuery = New clsFI_Query
    
    AddNewQuery = oQuery.GUID
    oQuery.Name = sName
    oQuery.Query = sQuery
    
    Call AddQuery(oQuery)
    
End Function

Private Sub Class_Initialize()
    GUID = GetGUID("Querys")
End Sub
