VERSION 5.00
Begin VB.UserControl FOTACustLayout 
   BackColor       =   &H008080FF&
   ClientHeight    =   255
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2025
   ScaleHeight     =   255
   ScaleWidth      =   2025
   ToolboxBitmap   =   "FOTACustLayout.ctx":0000
   Begin VB.CheckBox chkCheckBox 
      Caption         =   "Customize Form Layout"
      Height          =   255
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   2055
   End
End
Attribute VB_Name = "FOTACustLayout"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Force variable declaration
Option Explicit

'connect to the parent form
Private WithEvents FormEventLink As Form
Attribute FormEventLink.VB_VarHelpID = -1
Public Event Click()
Public Event HookForm()
Public Event UnHookForm()

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Global Variables
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private sSaveLoc As String
Private bSaveForm As Boolean

Private bActivatedBefore As Boolean


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Properties
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Property Get Value() As Integer
    Value = chkCheckbox.Value
End Property
Property Let Value(nValue As Integer)
    chkCheckbox.Value = nValue
End Property
Property Get SaveLocation() As String
    SaveLocation = sSaveLoc
End Property
Property Let SaveLocation(sNewSaveLoc As String)
    sSaveLoc = sNewSaveLoc
End Property
Property Get SaveForm() As Boolean
    SaveForm = bSaveForm
End Property
Property Let SaveForm(bNewSaveForm As Boolean)
    bSaveForm = bNewSaveForm
End Property
Property Get hwnd() As Long
    hwnd = chkCheckbox.hwnd
End Property
Property Get PickupX() As Long
    PickupX = nLayoutPickUpX
End Property
Property Get PickupY() As Long
    PickupY = nLayoutPickUpY
End Property
Property Get Caption() As String
    Caption = chkCheckbox.Caption
End Property
Property Let Caption(sNewCaption As String)
    chkCheckbox.Caption = sNewCaption
End Property






''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Events
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub chkCheckbox_Click()

    Dim i As Integer
    
    'This code sets all objects that are mine to automatic dragdrop.  I don't know why the
    'drag code won't activate for my custom controls.  Then this whole loop could vanish!
    For i = 0 To FormEventLink.Controls.Count - 1

        'Set my controls to automatic drag drop
        If TypeOf FormEventLink.Controls(i) Is FOTACustSize Then
            FormEventLink.Controls(i).DragMode = chkCheckbox.Value
        End If

    Next i
    
    'If they check the box, pull in the message handler
    'Otherwise free it
    If chkCheckbox.Value = vbChecked Then
        Hook
    Else
        UnHook
    End If
    
    nLayoutIsChecked = chkCheckbox.Value
    
    RaiseEvent Click
    
End Sub


Private Sub FormEventLink_DragDrop(Source As Control, X As Single, Y As Single)
    
    Call DropOnMe(FormEventLink, Source, X, Y)

End Sub

'Private Sub FormEventLink_Load()
Private Sub FormEventLink_Activate()
    
    If bActivatedBefore = False Then
        bActivatedBefore = True

        'Is the form in the right mode for this control to work?  Lets check!
        'If the parent form isn't in manual startup, you can't adjust its position
        If FormEventLink.StartUpPosition <> 0 Then
            Call MsgBox("Warning!  The form " & FormEventLink.Name & " is not set to manual StartUpPosition." & Chr$(13) & _
                    "Please change this property if you wish this control to work properly.", vbOKOnly, "FOTATool Kit Warning")
        End If

        'If were saving... load it
        If bSaveForm = True Then
            Call LoadControlLayout(FormEventLink, SaveName(sSaveLoc))
        End If

    End If

End Sub

Private Sub FormEventLink_Unload(Cancel As Integer)

    'If they closed down the form without unhooking
    If nLayoutIsChecked = vbChecked Then
        nLayoutIsChecked = vbUnchecked
        UnHook
    End If

    'If were saving... do so
    If bSaveForm = True Then Call SaveControlLayout(FormEventLink, SaveName(sSaveLoc))

End Sub
'If they click on the usercontrol, register a click
Private Sub UserControl_Click()

    RaiseEvent Click
    
End Sub
'When they read in the properties, set ehf formeventlink
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)

    'Load the properties
    chkCheckbox.Caption = PropBag.ReadProperty("MyCaption", "Customize Form Layout")
    bSaveForm = PropBag.ReadProperty("MySaveForm", False)
    sSaveLoc = PropBag.ReadProperty("MySaveLoc", "FormName (Constant)")

    If Ambient.UserMode = False Then Exit Sub
   
    'This catches all the events for the form
    Set FormEventLink = Parent
            
    'This stores the form and the form handle for the module
    Set gLayoutForm = Parent
    
End Sub
'If they resize the usercontrol, resize the checkbox
Private Sub UserControl_Resize()

    'If they resize the control, resize the checkbox
    chkCheckbox.Height = UserControl.Height
    chkCheckbox.Width = UserControl.Width

End Sub
'Record the property values
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    Call PropBag.WriteProperty("MyCaption", chkCheckbox.Caption, "Customize Form Layout")
    Call PropBag.WriteProperty("MySaveForm", bSaveForm, False)
    Call PropBag.WriteProperty("MySaveLoc", sSaveLoc, "FormName (Constant)")

End Sub




''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Public Member functions
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Convert the name they give to one we will use
Private Function SaveName(sName As String) As String

    If UCase(Left(sName, 8)) = "FORMNAME" Or Len(sName) = 0 Then
        SaveName = App.Path & "\" & FormEventLink.Name & ".ini"
    Else
        SaveName = sName
    End If
    
End Function

'This function is for the user to add drop capability to container objects in there form.
'There is no DragDrop windows message to trap so this has to be left to the user.  In the
'For example, if you wished to add drop onto capability to your SSTab control, tabMyTab,
'In tabMyTab_DragDrop() you would add the line:
'call fclCustomLayout.DropOnMe(tabMyTab,Source,X,Y)
Public Sub DropOnMe(objWhoseEvent As Variant, objSource As Variant, nX As Single, nY As Single)

    'Is it comeing from a different container?
    If objSource.Container.hwnd <> objWhoseEvent.hwnd Then 'And objSource.hwnd <> objWhoseEvent.hwnd Then
        'Switch this object to the new container
        Set objSource.Container = objWhoseEvent
    End If

    'Now put it in the right place
    objSource.Left = nX - nLayoutPickUpX
    objSource.Top = nY - nLayoutPickUpY
    
    'Go through all controls.  If its a FOTAResize control, reload the form
    'This is so that if they then reload, they don't lose there changes
    Dim i As Integer
    For i = 0 To FormEventLink.Controls.Count - 1
    
        'Is it the right type?
        If TypeOf FormEventLink.Controls(i) Is FOTAFormResize Or _
           TypeName(FormEventLink.Controls(i)) = "FOTAFormResize" Then
                Call FormEventLink.Controls(i).ReLoad
        End If
        
    Next i
    
End Sub
'Intercept the message handler for the form.  We want to capture all mouse clicks
'It is IMPERATIVE that you unhook before exiting.  END is a bad thing.
Public Sub Hook()

    RaiseEvent HookForm
    
    'Create a message sink
    lpLayoutPrevWndProc = SetWindowLong(gLayoutForm.hwnd, GWL_WNDPROC, AddressOf WindowProc_Layout)
        
End Sub
'Intercept the message handler for the form.  We want to capture all mouse clicks
'It is IMPERATIVE that you unhook before exiting.  END is a bad thing.
Public Sub UnHook()

    RaiseEvent UnHookForm

    'Undo the message sink.  I am not sure why we catch the value.
    Call SetWindowLong(gLayoutForm.hwnd, GWL_WNDPROC, lpLayoutPrevWndProc)
    
End Sub
