VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.UserControl FOTANetwork 
   ClientHeight    =   1905
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3690
   ScaleHeight     =   1905
   ScaleWidth      =   3690
   ToolboxBitmap   =   "FOTANetwork.ctx":0000
   Begin VB.Timer tmrTrafficFlash 
      Interval        =   200
      Left            =   120
      Top             =   360
   End
   Begin VB.Timer tmrFileTransfer 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   0
      Top             =   1440
   End
   Begin VB.PictureBox Picture1 
      AutoSize        =   -1  'True
      BorderStyle     =   0  'None
      Height          =   330
      Left            =   1080
      Picture         =   "FOTANetwork.ctx":0312
      ScaleHeight     =   330
      ScaleWidth      =   330
      TabIndex        =   0
      Top             =   1200
      Visible         =   0   'False
      Width           =   330
   End
   Begin VB.Timer tmrStateCheck 
      Interval        =   500
      Left            =   2640
      Top             =   1320
   End
   Begin MSWinsockLib.Winsock wnsRouter 
      Left            =   2160
      Top             =   840
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin MSWinsockLib.Winsock wnsClient 
      Left            =   3120
      Top             =   1320
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin MSWinsockLib.Winsock wnsPort 
      Index           =   0
      Left            =   2160
      Top             =   1320
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.Label lblS 
      Alignment       =   2  'Center
      BackColor       =   &H00C0FFC0&
      BackStyle       =   0  'Transparent
      Caption         =   "S"
      Height          =   195
      Left            =   480
      TabIndex        =   2
      Top             =   30
      Width           =   135
   End
   Begin VB.Label lblR 
      Alignment       =   2  'Center
      BackColor       =   &H00C0FFFF&
      BackStyle       =   0  'Transparent
      Caption         =   "R"
      Height          =   195
      Left            =   120
      TabIndex        =   1
      Top             =   30
      Width           =   120
   End
   Begin VB.Shape shpReceave 
      BackColor       =   &H0000C000&
      BackStyle       =   1  'Opaque
      Height          =   255
      Left            =   0
      Shape           =   3  'Circle
      Top             =   0
      Width           =   255
   End
   Begin VB.Shape shpSend 
      BackColor       =   &H0000C000&
      BackStyle       =   1  'Opaque
      Height          =   255
      Left            =   360
      Shape           =   3  'Circle
      Top             =   0
      Width           =   255
   End
End
Attribute VB_Name = "FOTANetwork"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'This will fire whenever the state of the network fires.
'   Host: Router Close, Router Open,
'   Client: Connect To Host, Disconnected From Host
Public Event NetworkStateChange(nOldState As Long, nNewState As Long)
'This will fire when a message is received
Public Event MessageReceived(oMessage As clsNetworkMessage, oPlayerFrom As clsNetworkPlayer)
'This player was just added!
Public Event PlayerAdded(oNewPlayer As clsNetworkPlayer, bThisIsYou As Boolean)
'This player was just removed!
Public Event PlayerRemoved(oRemovedPlayer As clsNetworkPlayer)
'When we are exchanging data these are the event that gets fired
Public Event DataInflowLight(bLightOn As Boolean)
Public Event DataOutflowLight(bLightOn As Boolean)
'This is how the network connections will send back error data
Public Event Error(nNumber As Long, sDescription As String, sSource As String)

'This event launches off for occasional % updates
Public Event FileTransferProgress(oFileTransfer As clsNetworkFileTransfer, nPercent As Long)
'This event marks when a file transfer has been finished
Public Event FileTransferDone(oFileTransfer As clsNetworkFileTransfer)
'This event says we were just asked if we want this file
Public Event FileTransferRequest(oFileTransfer As clsNetworkFileTransfer, sFileName As String)
'This event says a player accepted the file transfer request
Public Event FileTransferResponse(oFileTransfer As clsNetworkFileTransfer, oPlayerResponding As clsNetworkPlayer, bAccepted As Boolean)
'This event means a file transfer was canceled
Public Event FileTransferCanceled(oFileTransfer As clsNetworkFileTransfer, oPlayerWhoCanceled As clsNetworkPlayer)

Private Const m_cDarkColor As Long = &HC000&
Private Const m_cLightColor As Long = &HFF00&

Public Enum ENUM_NETWORK_ERRORS
    ENUM_KICK_HOST_ONLY = -171
    ENUM_CONNECTION_CLOSED = -172
    ENUM_ROUTER_PORT_BUSY = -173
    ENUM_ASIGNED_PORT_BUSY = -174
    ENUM_HOST_CLOSED_PORT = -175
    ENUM_KICKED = -176
    ENUM_MSG_HAS_NO_KNOWN_SENDER = -177
    ENUM_NO_FILE_TRANSFER_STARTED = -178
    ENUM_NO_FILE_NAME = -179
    ENUM_ALL_PLAYERS_NOT_READY = -180
    ENUM_NO_PLAYERS = -181
    ENUM_ADD_PLAYER_FOR_KNOWN_PLAYER = -182
End Enum

Private m_nOutFlowRefCount As Long
Private m_nInFlowRefCount As Long

Private m_sName As String
Private m_sVersion As String
Private m_nPort As Long
Private m_nBasePort As Long
Private m_bHost As Boolean
Private m_sIP As String
Private g_nClientTryingToConnectToPortNumber As Long
Private m_nLastState As Long

Private m_bDebugMode As Boolean
Private m_sDebugFile As String

Private m_oGame As clsNetworkGame

Private m_colFileTransfers As New Collection
Private m_oStartingFileTransfer As clsNetworkFileTransfer

'Basically I need to know if we have had more network activity since last checked
Private m_bTrafficInSinceLastTime As Boolean
Private m_bTrafficOutSinceLastTime As Boolean

Private Function PortToNum(nPort As Long) As Long
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.PortToNum"
    On Error GoTo ErrorHandler
    
    PortToNum = nPort - m_nBasePort
    
    Exit Function
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Function
Private Function NumToPort(nNum As Long) As Long
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.NumToPort"
    On Error GoTo ErrorHandler
        
    NumToPort = nNum + m_nBasePort
    
    Exit Function
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Function
Private Function GetMe() As clsNetworkPlayer
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.GetMe"
    On Error GoTo ErrorHandler
        
    'Actually... if were the host, before we do anything we have to send this on...
    If m_bHost = True Then
        Set GetMe = FindPlayer(0)
    Else
        Set GetMe = FindPlayer(PortToNum(g_nClientTryingToConnectToPortNumber))
    End If

    Exit Function
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Function
Public Property Get Host() As Boolean
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.Host"
    On Error GoTo ErrorHandler
        
    Host = m_bHost
    
    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Property

'sckClosed              0   Default. Closed
Public Property Get sckFOTAClosed() As Long
    sckFOTAClosed = sckClosed
End Property
'sckOpen                1   Open
Public Property Get sckFOTAOpen() As Long
    sckFOTAOpen = sckOpen
End Property
'sckListening           2   Listening
Public Property Get sckFOTAListening() As Long
    sckFOTAListening = sckListening
End Property
'sckConnectionPending   3   Connection pending
Public Property Get sckFOTAConnectionPending() As Long
    sckFOTAConnectionPending = sckConnectionPending
End Property
'sckResolvingHost       4   Resolving host
Public Property Get sckFOTAResolvingHost() As Long
    sckFOTAResolvingHost = sckResolvingHost
End Property
'sckHostResolved        5   Host resolved
Public Property Get sckFOTAHostResolved() As Long
    sckFOTAHostResolved = sckHostResolved
End Property
'sckConnecting          6   Connecting
Public Property Get sckFOTAConnecting() As Long
    sckFOTAConnecting = sckConnecting
End Property
'sckConnected           7   Connected
Public Property Get sckFOTAConnected() As Long
    sckFOTAConnected = sckConnected
End Property
'sckClosing             8   Peer is closing the connection
Public Property Get sckFOTAClosing() As Long
    sckFOTAClosing = sckClosing
End Property
'sckError               9   Error
Public Property Get sckFOTAError() As Long
    sckFOTAError = sckError
End Property

Public Property Get State() As Long
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.State"
    On Error GoTo ErrorHandler
        
    If m_bHost = True Then
        State = wnsRouter.State
    Else
        State = wnsClient.State
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property

Private Sub tmrStateCheck_Timer()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.tmrStateCheck_Timer"
    On Error GoTo ErrorHandler
        
    If m_nLastState <> State() Then
        RaiseEvent NetworkStateChange(m_nLastState, State())
        m_nLastState = State()
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub

Public Function FindPlayer(nNumber As Long) As clsNetworkPlayer
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.FindPlayer"
    On Error GoTo ErrorHandler
        
    Set FindPlayer = m_oGame.FindPlayer(nNumber)

    Exit Function
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Function

Public Function NumberOfPlayers() As Long
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.NumberOfPlayers"
    On Error GoTo ErrorHandler
        
    NumberOfPlayers = m_oGame.Players.Count

    Exit Function
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Function

Public Property Get MsgDelim() As String
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.MsgDelim"
    On Error GoTo ErrorHandler
        
    MsgDelim = g_cMsgDelim

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property

Public Property Get NetworkGame() As clsNetworkGame
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.NetworkGame"
    On Error GoTo ErrorHandler
        
    Set NetworkGame = m_oGame

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property

Public Property Get PlayerName() As String
    
    Dim sRoutinePlayerName As String
    sRoutinePlayerName = "FOTANetworking.PlayerName"
    On Error GoTo ErrorHandler
        
        
    PlayerName = m_sName
    

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutinePlayerName & ": " & Err.Description)
    
End Property
Public Property Let PlayerName(sNewVal As String)
    
    Dim sRoutinePlayerName As String
    sRoutinePlayerName = "FOTANetworking.PlayerName"
    On Error GoTo ErrorHandler
        
        
    m_sName = sNewVal


    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutinePlayerName & ": " & Err.Description)
    
End Property
Public Property Get DebugFileName() As String
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.DebugFileName"
    On Error GoTo ErrorHandler
        
    DebugFileName = m_sDebugFile

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property
Public Property Let DebugFileName(sNewVal As String)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.DebugFileName"
    On Error GoTo ErrorHandler
        
    m_sDebugFile = sNewVal

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property

Public Property Get Version() As String
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.Version"
    On Error GoTo ErrorHandler
        
    Version = m_sVersion

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property
Public Property Let Version(sNewVal As String)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.Version"
    On Error GoTo ErrorHandler
        
    m_sVersion = sNewVal

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property

Public Property Get MyIP() As String
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.MyIP"
    On Error GoTo ErrorHandler
        
    MyIP = wnsClient.LocalIP

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property

Public Property Get IP() As String
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.IP"
    On Error GoTo ErrorHandler
        
    IP = m_sIP

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property
Public Property Let IP(sNewVal As String)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.IP"
    On Error GoTo ErrorHandler
        
    m_sIP = sNewVal

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property

Public Property Get BasePort() As Long
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.BasePort"
    On Error GoTo ErrorHandler
        
    BasePort = m_nBasePort

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property
Public Property Let BasePort(nNewVal As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.BasePort"
    On Error GoTo ErrorHandler
        
    m_nBasePort = nNewVal

    Exit Property
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Property

Public Sub CloseNetwork()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.CloseNetwork"
    On Error GoTo ErrorHandler
        
        
    Dim i As Long
    Dim oLoopPlayer As clsNetworkPlayer
        
    Call UserControl.wnsClient.Close
    Call UserControl.wnsRouter.Close
    
    Call WriteToDebug("CloseNetwork Called.")
    
    For i = 0 To UserControl.wnsPort.Count() - 1
        Call UserControl.wnsPort(i).Close
    Next i
    
    For Each oLoopPlayer In m_oGame.Players
        Call RemovePlayer(oLoopPlayer)
    Next oLoopPlayer
    

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub

Public Sub HostAGame()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.HostAGame"
    On Error GoTo ErrorHandler


    Dim oPlayer As New clsNetworkPlayer

    'I'm not sure why but we have to clear the port seperatly... probabely shut down time for the system.
    'The length of this function may not be sufficient for some slower machines.
    Call wnsRouter.Close
    Call wnsPort(0).Close
    '04/29/2002 Chris Hill  Do Events is evil.
    'Do Events
    
    'Start up the router
    wnsRouter.LocalPort = m_nBasePort
    Call wnsRouter.Listen
    
    'Add ourselves as a host of this game
    m_bHost = True
    oPlayer.IP = m_sIP
    oPlayer.Version = m_sVersion
    oPlayer.Port = m_nBasePort
    oPlayer.Number = 0
    If Len(m_sName) = 0 Then
        oPlayer.Name = "Unknown" & m_nBasePort
    Else
        oPlayer.Name = m_sName
    End If
    
    Call WriteToDebug("HostAGame  IP(" & oPlayer.IP & ") Ver(" & oPlayer.Version & ") Port(" & oPlayer.Port & ") Name(" & oPlayer.Name & ")")
    
    Call AddPlayer(oPlayer, True)

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub
Public Sub ClientToAGame()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.ClientToAGame"
    On Error GoTo ErrorHandler
        
    If Not wnsClient.State = sckClosed Then
        Call wnsClient.Close
    End If
            
    'Set it to try the first port on the host machine
    g_nClientTryingToConnectToPortNumber = m_nBasePort
                
    Call WriteToDebug("ClientAGame Port(" & m_nBasePort & ") IP(" & m_sIP & ")")
    
    'Try to connect to the target IP
    Call wnsClient.Connect(m_sIP, g_nClientTryingToConnectToPortNumber)

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
            
End Sub

Public Sub Kick(oPlayer As clsNetworkPlayer)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.Kick"
    On Error GoTo ErrorHandler
        
    Call WriteToDebug("Kicking Port(" & oPlayer.Number() & ")")
        
    If m_bHost = True Then
        Call SendMessage(GetMe().Number(), g_cKickPlayerCode, oPlayer.Number())
    Else
        Call ErrorOccured(ENUM_KICK_HOST_ONLY, "FOTANetwork.Kick", "Only the host is allowed to kick players.")
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub

Public Sub SendMessageEx(oMessage As clsNetworkMessage)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.SendMessageEx"
    On Error GoTo ErrorHandler
        
    If GetMe() Is Nothing Then
        Call ErrorOccured(-1, sRoutineName, "Unable To Locate [Me] In Network Game")
    Else
        Call SendMessage(GetMe().Number(), oMessage.MsgType, oMessage.FormatForSending())
    End If
    
    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub
'This one is for coder consumption... its stupid proof
Private Sub SendMessage(nSenderNumber As Long, sType As String, Optional sMsg As String)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.SendMessage"
    On Error GoTo ErrorHandler
        
    Dim i As Long
    Dim sWhoTo As String

    'Incrament the reference count
    Call OutFlowLight(1)

    'If were host we have to send the message to everyone
    If m_bHost = True Then
    
        For i = 0 To wnsPort.UBound
        'For Each oLoopPlayer In m_oGame.Players
            'If oLoopPlayer.Port <> m_nBasePort Then
            If wnsPort(i).State = sckConnected Then
                sWhoTo = sWhoTo & i & ","
                Call SendData(wnsPort(i), nSenderNumber, sType, sMsg)
                'Call SendData(wnsPort(PortToNum(oLoopPlayer.Port)), nSenderNumber, sType, sMsg)
            End If
            'End If
        'Next oLoopPlayer
        Next i
        
        Call WriteToDebug("SendMessage Sender1(" & nSenderNumber & ") Type(" & sType & ") WhoTo(" & sWhoTo & ") Msg(" & sMsg & ")")
    
    Else
        Call WriteToDebug("SendMessage Sender2(" & nSenderNumber & ") Type(" & sType & ") Msg(" & sMsg & ")")
        
        Call SendData(wnsClient, nSenderNumber, sType, sMsg)
    End If

    'Decrament the reference count
    Call OutFlowLight(-1)

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub
'This one is for internal use since you have to specify the winsock connection
Private Sub SendData(wnsWinSock As Winsock, nSenderNumber As Long, sType As String, sMsg As String)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.SendData"
    On Error GoTo ErrorHandler
        
    Dim sTempMsg As String
    
    'Incrament the reference count
    Call OutFlowLight(1)
    
    'Is the socket connected?
    If wnsWinSock.State = sckConnected Then
    
        If Len(sMsg) > 0 Then
            sTempMsg = sMsg
            If Not right(sTempMsg, Len(g_cMsgDelim)) = g_cMsgDelim Then
                sTempMsg = sTempMsg & g_cMsgDelim
            End If
        Else
            sTempMsg = ""
        End If
        
        'Send the message out
        Call wnsWinSock.SendData(g_cMsgHeader & sType & g_cMsgDelim & nSenderNumber & g_cMsgDelim & sTempMsg & g_cMsgTrailer)
        '10/30/2005 Chris Hilll  Turns out this neccessary to get the message sent.
        'Allow the system to catch up on events
        '04/24/2002 Chris Hill  Not allowed!!  It never finished adding the player.  Messages were not being processed.
        DoEvents
    Else
        Call ErrorOccured(ENUM_CONNECTION_CLOSED, "FOTANetwork.SendData", "Targeted connection is closed and cannot send the message.")
    End If 'End of socket state check

    'Decrament the reference count
    Call OutFlowLight(-1)

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub ' End of SendData

Private Sub tmrTrafficFlash_Timer()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.tmrTrafficFlash_Timer"
    On Error GoTo ErrorHandler
        
    'InFlow Light
    'Check to see if we need to turn the light on
    If (m_nInFlowRefCount > 0 And UserControl.shpReceave.BackColor = m_cDarkColor) Or _
    m_bTrafficInSinceLastTime = True Then
        UserControl.shpReceave.BackColor = m_cLightColor
        RaiseEvent DataInflowLight(True)
    End If
    'Check to see if we can turn the light off
    If m_bTrafficInSinceLastTime = True Then
        m_bTrafficInSinceLastTime = False
    ElseIf m_nInFlowRefCount <= 0 And UserControl.shpReceave.BackColor = m_cLightColor Then
        UserControl.shpReceave.BackColor = m_cDarkColor
        RaiseEvent DataInflowLight(False)
    End If
    
    'OutFlow Light
    'Check to see if we need to turn the light on
    If (m_nOutFlowRefCount > 0 And UserControl.shpSend.BackColor = m_cDarkColor) Or _
    m_bTrafficOutSinceLastTime = True Then
        UserControl.shpSend.BackColor = m_cLightColor
        RaiseEvent DataOutflowLight(True)
    End If
    'Check to see if we can turn the light off
    If m_bTrafficOutSinceLastTime = True Then
        m_bTrafficOutSinceLastTime = False
    ElseIf m_nOutFlowRefCount <= 0 And UserControl.shpSend.BackColor = m_cLightColor Then
        UserControl.shpSend.BackColor = m_cDarkColor
        RaiseEvent DataOutflowLight(False)
    End If
    
    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub

Private Sub UserControl_Resize()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.UserControl_Resize"
    On Error GoTo ErrorHandler
        

    UserControl.shpReceave.Width = UserControl.Width * 0.42
    UserControl.shpReceave.Height = UserControl.Height
    
    UserControl.shpSend.left = UserControl.Width * 0.58
    UserControl.shpSend.Width = UserControl.Width * 0.42
    UserControl.shpSend.Height = UserControl.Height
    
    UserControl.lblR.left = 0
    UserControl.lblR.top = 0
    UserControl.lblR.Width = UserControl.shpReceave.Width
    UserControl.lblR.Height = UserControl.shpReceave.Height
    UserControl.lblR.FontSize = UserControl.shpReceave.Width / 30

    UserControl.lblS.top = 0
    UserControl.lblS.left = UserControl.shpSend.left
    UserControl.lblS.Width = UserControl.shpSend.Width
    UserControl.lblS.Height = UserControl.shpSend.Height
    UserControl.lblS.FontSize = UserControl.shpSend.Width / 30
    
    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub

Private Sub wnsRouter_Close()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsRouter_Close"
    On Error GoTo ErrorHandler
        
    Call WriteToDebug("Setup Router To Listen")
    
    'Close the socket.  Can't have an open socket that isn't doing anything
    Call wnsRouter.Close
    '04/29/2002 Chris Hill  Do Events is evil.
    'Do Events
    'Reopen the port for buisnes
    Call wnsRouter.Listen
    '04/29/2002 Chris Hill  Do Events is evil.
    'Do Events

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub

'(Host Only)  This is the router so if they tried to join here give them a new place to live
Private Sub wnsRouter_ConnectionRequest(ByVal requestID As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsRouter_ConnectionRequest"
    On Error GoTo ErrorHandler
        
    'If their trying to join a socket that isn't closed, close it.  I don't know why you have to do this... it doesn't make sence.  But you do.
    If wnsRouter.State <> sckClosed Then wnsRouter.Close

    'Accept the connection from the user
    Call wnsRouter.Accept(requestID)

    'Open up a new port for them to connect to now
    Call Load(wnsPort(wnsPort.UBound + 1))
    wnsPort(wnsPort.UBound).LocalPort = NumToPort(wnsPort.UBound)
    Call wnsPort(wnsPort.UBound).Listen
    '04/29/2002 Chris Hill  Do Events is evil.
    'Do Events

    Call WriteToDebug("Router_ConnectionRequest NewRouterAddy(" & Str(NumToPort(wnsPort.UBound)) & ")")

    'tell them the new port number
    Call SendData(wnsRouter, GetMe().Number(), g_cNewRouterAddress, Str(NumToPort(wnsPort.UBound)))

    'Close down the router port and get it ready for the next person
    'Call wnsRouter.Close
    'Do Events
    'Call wnsRouter.Listen
    'Do Events

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub ' wnsRouter_ConnectionRequest

Private Sub wnsRouter_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsRouter_Error"
    On Error GoTo ErrorHandler
        
    Call WriteToDebug("RouterError Num(" & Number & ") Source(" & Source & ") Desc(" & Description & ")")
        
    'Raise an error so the error handler will catch it.  Be aware this method will
    'cause the rest of this function to be ignored (which is ok)
    Call ErrorOccured(Number, Source, Description)
    'Close the socket.  Can't have an open socket that isn't doing anything
    Call wnsRouter.Close
    '04/29/2002 Chris Hill  Do Events is evil.
    'Do Events
    'Reopen the port for buisnes
    Call wnsRouter.Listen
    '04/29/2002 Chris Hill  Do Events is evil.
    'Do Events

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub ' End of wnsRouter error

'This executes every 2 seconds.  It checks the status of the ports and updates
'the status bar.  A bit of CPU stealing but this way we have an accurate status
'bar, NOT just what I tell it.
'Private Sub tmrStateCheck_Timer()
'
'    'Variables for connection status check
'    Dim i As Long
'    Dim bTemp As Boolean
'    Dim nSocketType(0 To 9) As Long
'
'    'Scan all the network links and record their state
'    If g_bAmIHost = True Then
'        If wnsPort.UBound > 0 Then
'            For i = 1 To wnsPort.UBound
'                'Record the status of this port (and the number of this type
'                nSocketType(wnsPort(i).State) = nSocketType(wnsPort(i).State) + 1
'            Next i
'        End If
'        nSocketType(wnsRouter.State) = nSocketType(wnsRouter.State) + 1
'    Else
'        nSocketType(wnsClient.State) = 1
'    End If
'
'    'Check for the message of what we are doing... We only show one so pick the best
'    If nSocketType(3) + nSocketType(4) + nSocketType(5) > 0 Then '(3 Connection pending,4 Resolving host , 5 Host resolved)
'        StatusBar.Panels(1).Text = "Connecting To Player"
'
'    ElseIf nSocketType(6) > 0 Then '(6 Connecting)
'        StatusBar.Panels(1).Text = "Trying Connection " & g_nMyNumber & " To Port " & g_cStartingPort + g_nMyNumber
'
'    ElseIf nSocketType(2) > 0 Then '(2 Listening)
'        StatusBar.Panels(1).Text = "Listening For Player(s)"
'
'    ElseIf nSocketType(7) > 0 Then '(7 Connected)
'        StatusBar.Panels(1).Text = "Connected To Player(s)"
'
'    Else '(0 Closed, 1 Open, 8 Peer is closing the connection, 9 Error)
'        StatusBar.Panels(1).Text = "Socket Error (No Activity)"
'
'    End If
'
'    'Add on the count of connected people
'    StatusBar.Panels(2).Text = nSocketType(7) '& "/" & frmconnectstatus.wnsPort.ubound + 1
'
'    'Decide weather or not to load the pictures.
'        'Picture 1, are we the host or not?
'        If g_bAmIHost = True Then
'            'StatusBar.Panels(3).Picture = picHost.Picture
'        Else
'            'StatusBar.Panels(3).Picture = picClient.Picture
'        End If
'
'        'Picture 2, are we connected?
'        If nSocketType(7) > 0 Or nSocketType(2) > 0 Then
'            'We are connected... so show the right picture and verify the menu options
'            'StatusBar.Panels(4).Picture = picConnected.Picture
'
'            'Is the menu set right?
'            bTemp = True
'            frmMain.mnuConnect.Enabled = False
'            frmMain.mnuDisconnect.Enabled = False
'            'Enable the special menu options
'            frmMain.mnuDMControl.Enabled = (chkIAmTheDM.Value = vbChecked)
'            frmMain.mnuLoadBM.Enabled = (chkIAmTheDM.Value = vbChecked)
'        Else
'            'We are not connected... so hide stuff
'            'StatusBar.Panels(4).Picture = picNotConnected.Picture
'
'            'Is the menu set right?
'            bTemp = False
'            frmMain.mnuConnect.Enabled = True
'            frmMain.mnuDisconnect.Enabled = True
'            frmMain.mnuDMControl.Enabled = False
'            frmMain.mnuLoadBM.Enabled = False
'        End If
'
'        frmMain.mnuCreateChat.Enabled = bTemp
'        frmMain.mnuMsg.Enabled = bTemp
'        frmMain.mnuLoadCharacter.Enabled = bTemp
'        frmMain.mnuCreateNewChar.Enabled = bTemp
'        frmMain.mnuDemo.Enabled = bTemp
'        frmMain.mnuOnlineRef.Enabled = bTemp
'        frmMain.mnuAutoGenNames.Enabled = bTemp
'        frmMain.mnuPictoralConversation.Enabled = bTemp
'
'
'End Sub ' End of tmrConnCheck_Timer

''We are no longer receiveing data so change the color back to normal
'Public Sub ReceiveDataStop()
'
'    Dim sRoutineName As String
'    sRoutineName = Me.Name & ".ReceiveDataStop"
'    Call WriteProcStart(sRoutineName)
'
'
'    'Set the color to Red, we are nolonger receive data
'    shpReceave.BackColor = &HFF&
'    shpReceave.Refresh
'
'
'    'Exit the sub... on an error we will jump over this function
'    Exit Sub
'ErrorHandler:
'    Call ErrorTrapper(sRoutineName)
'
'End Sub
''We are about to start receiveing data, change the color
'Public Sub ReceiveDataStart()
'
'    Dim sRoutineName As String
'    sRoutineName = Me.Name & ".ReceiveDataStart"
'    Call WriteProcStart(sRoutineName)
'
'
'    'Set the color to Pink, we are receivnig data
'    shpReceave.BackColor = &HC0C0FF
'    shpReceave.Refresh
'
'
'    'Exit the sub... on an error we will jump over this function
'    Exit Sub
'ErrorHandler:
'    Call ErrorTrapper(sRoutineName)
'
'End Sub

Private Sub UserControl_Initialize()

    m_bDebugMode = False
    m_sDebugFile = App.Path & "\FOTANetwork_Debug.Out"
    m_nBasePort = 3001
    Set m_oGame = New clsNetworkGame

End Sub

'(Host Only)  These are the permanite addresses, if they tried to join here let them.
Private Sub wnsPort_ConnectionRequest(Index As Integer, ByVal requestID As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsPort_ConnectionRequest"
    On Error GoTo ErrorHandler
        
    Dim i As Long
    Dim oPlayer As New clsNetworkPlayer

    Call WriteToDebug("Port_ConnectionRequest Index(" & Index & ")")

    'If their trying to join a socket that isn't closed, close it.  I don't know why you have to do this... it doesn't make sence.  But you do.
    If wnsPort(Index).State <> sckClosed Then wnsPort(Index).Close

    'Accept the connection from the user
    Call wnsPort(Index).Accept(requestID)
    '04/29/2002 Chris Hill  Do Events is evil.
    'Do Events
    
    'We leave it to them to announce themselves

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub 'End wnsPort connection request

'We have received some data over the network.  Unfortunitly when the winsock protocal
'sends data over the network it concationates the messages if they come with any
'haste whatso ever.  So we have to seperate them.  (Client/Host)
Private Sub wnsPort_DataArrival(Index As Integer, ByVal bytesTotal As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsPort_DataArrival"
    On Error GoTo ErrorHandler
        
    Dim sIncomingMsg As String

    'Get the data from the socket
    Call wnsPort(Index).GetData(sIncomingMsg, vbString)
    
    Call WriteToDebug("DataArrival Index(" & Index & ")")
    
    'Process the data
    Call WinsockDataArival(sIncomingMsg, CLng(Index))

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub ' End of Winsock_DataArrival

Private Sub wnsPort_Error(Index As Integer, ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsPort_Error"
    On Error GoTo ErrorHandler
        
    Call WriteToDebug("Port_Error Index(" & Index & ") Number(" & Number & ") Desc(" & Description & ") Source(" & Source & ")")
        
    'Player has been lost for some reason
    '10054 = Connection reset
    If Number = 10053 Or Number = 438 Or Number = 0 Or Number = 10054 Then

        'Shut down the port, we don't reuse them
        Call wnsPort(Index).Close
        'Call Unload(wnsPort(Index))
        '04/29/2002 Chris Hill  Do Events is evil.
        'Do Events

        'Process the message, this will mean dropping the player
        'Call ProcessSingleMessage(g_cRemoveMeCode & Pad(CLng(Index), "0", 2) & g_cMsgDelim, -1)
        'Call SendMessage(GetMe().Number(), g_cRemovePlayerCode, PortToNum(wnsPort(Index).LocalPort))
        Call RemovePlayer(m_oGame.FindPlayer(PortToNum(wnsPort(Index).LocalPort)))
    Else
        'Close the socket.  Can't have an open socket that isn't doing anything
        wnsPort(Index).Close
        'Call Unload(wnsPort(Index))
        'Raise an error so the error handler will catch it.  Be aware this method will
        'cause the rest of this function to be ignored (which is ok)
        Call ErrorOccured(Number, Source, Description)
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub ' End of wnsPort_Error
'A remote user closed their socket.
Private Sub wnsPort_Close(Index As Integer)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsPort_Close"
    On Error GoTo ErrorHandler
        
    Call WriteToDebug("Port_Close Index(" & Index & ")")
        
    'Close that socket, we don't need it anymore since noone is on the other end
    Call wnsPort(Index).Close
    '04/29/2002 Chris Hill  Do Events is evil.
    'Do Events
    
    'Remove this player
    Call RemovePlayer(m_oGame.FindPlayer(CLng(Index)))

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub ' Exit wnsPort_Close

'This is received when the connection is finalized for the client. (Client)
'Basically the Host has accepted you into the fold.  :)
Private Sub wnsClient_Connect()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsClient_Connect"
    On Error GoTo ErrorHandler
        
    Dim oMsg As clsNetworkMessage

    'This means we connected to the router.  Now we wait for a message from the
    'host telling us our new port number to connect to.
    If g_nClientTryingToConnectToPortNumber = m_nBasePort Then
        
    'This means we have connected to our final port
    Else
        Call WriteToDebug("Client_Connected Port(" & g_nClientTryingToConnectToPortNumber & ")")
    
        'We connected!  Yea!
        m_nPort = g_nClientTryingToConnectToPortNumber
        'After we connect the host expects us to send our name... its our only reponsability
        'though we should get an inflow of other players names very quickly from the host
        Set oMsg = New clsNetworkMessage
        oMsg.MsgType = g_cAddPlayerCode
        Call oMsg.AddParamater(m_sName)
        Call oMsg.AddParamater(m_sVersion)
        '02/19/2003 Chris Hill  This is the same as the sender number
        '02/23/2003 Chris Hill  This ISN'T the same as the sender number.  The host eventually
        'has to send on this add player request to all the players.  When he does so the sender
        'number gets overwritten with his number.  We MUST pass in our port.
        Call oMsg.AddParamater(PortToNum(m_nPort))
        Call SendMessageEx(oMsg)
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub ' Exit wnsClient_Connect

'We have received some data over the network.  Unfortunitly when the winsock protocal
'sends data over the network it concationates the messages if they come with any
'haste whatso ever.  So we have to seperate them.  (Client/Host)
Private Sub wnsClient_DataArrival(ByVal bytesTotal As Long)

    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsClient_DataArrival"
    On Error GoTo ErrorHandler

    Dim sIncomingMsg As String

    'Sometimes it seems to get here even if we aren't done connecting yet.
    'This has got to be an event timing issue... anyway you can't do this.
    If wnsClient.State = sckFOTAConnected() Then
    
        'Get the data from the socket
        Call wnsClient.GetData(sIncomingMsg, vbString)
        
        Call WriteToDebug("Client_DataArrival Msg(" & sIncomingMsg & ")")
        
        'Process it
        Call WinsockDataArival(sIncomingMsg, 0)
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description & " " & Erl)

End Sub ' End of wnsClient_DataArrival

Private Sub wnsClient_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsClient_Error"
    On Error GoTo ErrorHandler
        
    Dim i As Long

    Call WriteToDebug("Client_Error Number(" & Number & ") Desc(" & Description & ") Source(" & Source & ")")

    'Winsock error 10061 is that the connection can't be made
    'Connection has been lost for some reason
    If Number = 10061 Or Number = 10053 Or Number = 438 Or Number = 0 Then
        'We failed!!!  This should never happen anymore
        If g_nClientTryingToConnectToPortNumber = m_nBasePort Then
            Call ErrorOccured(ENUM_ROUTER_PORT_BUSY, "FOTANetwork.wnsClient_Error", "The Host's Router port is busy.  This means that someone else is currently connecting to the host or the host is not ready.  Please attempt to connect again.")
            'Call ErrorTrapper(sRoutineName, False, "The Host's Router port is busy.  This means that someone else is currently connectiont to the host.  Please attempt to connect again now.")
        Else
            Call ErrorOccured(ENUM_ASIGNED_PORT_BUSY, "FOTANetwork.wnsClient_Error", "The port that the Host assigned to you is busy.  Please try to reconnect.")
            'Call ErrorTrapper(sRoutineName, False, "The port that the Host assigned to you is busy.  Please try to reconnect.")
        End If

        'Close then reopen the port.  Try the next port
        Call wnsClient.Close
    '10054 = Connection reset
    ElseIf Number = 10054 Then
        'For i = 0 To g_objPlayers.Count - 1
        '    'Process the message, this will mean dropping the player
        '    Call ProcessSingleMessage(g_cRemoveMeCode & Pad(i, "0", 2) & g_cMsgDelim, -1)
        'Next i
        Call ErrorOccured(ENUM_HOST_CLOSED_PORT, "FOTANetwork.wnsClient_Error", "The Host has closed your connection.  This means the session crashed, was closed or you were kicked out.")
        'Call ErrorTrapper(sRoutineName, False, "The Host has closed your connection.  This means the session crashed, was closed or you were kicked out.")
    Else
        'Close the socket.  Can't have an open socket that isn't doing anything
        wnsClient.Close
        'Raise an error so the error handler will catch it.  Be aware this method will
        'cause the rest of this function to be ignored (which is ok)
        Call ErrorOccured(Number, Source, Description)
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub ' End of wnsClient_Error

'A remote user closed their socket.  (Client)
Private Sub wnsClient_Close()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.wnsClient_Close"
    On Error GoTo ErrorHandler
        
    Dim i As Long
    Dim oLoopPlayer As clsNetworkPlayer

    Call WriteToDebug("Client_Close")

    'Close that socket, we don't need it anymore since noone is on the other end
    Call wnsClient.Close

    If g_nClientTryingToConnectToPortNumber > m_nBasePort Then
        'If your not the host (i.e. a client), then you need to know the host is gone.
        Call ErrorOccured(ENUM_HOST_CLOSED_PORT, "FOTANetwork.wnsClient_Close", "The Host has closed your connection.  This means the session crashed, was closed or you were kicked out.")
        
        'Fire a message saying everyone else is gone
        For Each oLoopPlayer In m_oGame.Players
            Call RemovePlayer(oLoopPlayer)
        Next oLoopPlayer
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub ' Exit wnsClient_Close

'This handles data arival for all winsock ports
'03/16/2002 Chris Hill  Actually I could replace all instances of sRemainingMessage with
'oBitStreamFrom.PartialMessage, but thats more risky than I care to get right now.
Private Sub WinsockDataArival(sOriginalMsg As String, nPort As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.WinsockDataArival"
    On Error GoTo ErrorHandler
        
    Dim oMsg As clsNetworkMessage
    Dim sMsg As String
    Dim sRemainingMsg As String
    Dim oBitStreamFrom As clsNetworkPlayer, oMsgFrom As clsNetworkPlayer
    Dim oLoopPlayer As clsNetworkPlayer
    Dim sTemp As String
    
    'Incrament the reference count
    Call InFlowLight(1)

    Call WriteToDebug("DataArrival port(" & nPort & ")")

    'What if this message is "AddMe"?
    'Get the player who sent this.
    Set oBitStreamFrom = m_oGame.FindPlayer(nPort)
    If oBitStreamFrom Is Nothing Then
        Call WriteToDebug("     This Player Is New")
        Set oBitStreamFrom = New clsNetworkPlayer
        oBitStreamFrom.Port = -1
    End If
    
    Call WriteToDebug("     BitStreamFrom(" & oBitStreamFrom.Number & "," & oBitStreamFrom.Name & ")")
    Call WriteToDebug("     InitialPartialMessage PMsg(" & oBitStreamFrom.PartialMessage & ")")
    'Was their any peices of message we needed to add to this?
    oBitStreamFrom.PartialMessage = oBitStreamFrom.PartialMessage & sOriginalMsg
    'sRemainingMsg = oBitStreamFrom.PartialMessage & sOriginalMsg
    Call WriteToDebug("     Message Msg(" & sOriginalMsg & ")")
    Call WriteToDebug("     AfterPartialMessage PMsg(" & oBitStreamFrom.PartialMessage & ")")

    'Pull out the start location of the next message (determined by the g_cMsgHeader)
    '05/13/2002 Chris Hill  It looks like messages were arriving while we are processing.
    'This is bad but can't be prevented.  So we have to always assume more could be added
    'to the partial message at any time.
    sRemainingMsg = oBitStreamFrom.PartialMessage
    oBitStreamFrom.PartialMessage = ""
        
    While ParseIncomingStream(sRemainingMsg, sMsg, sTemp) = True
                
        Call WriteToDebug("     Returned From ParseIncoming(" & sRemainingMsg & "," & sMsg & "," & sTemp & ")")
                
        '05/13/2002 Chris Hill  It looks like messages were arriving while we are processing.
        'This is bad but can't be prevented.  So we have to always assume more could be added
        'to the partial message at any time.
        oBitStreamFrom.PartialMessage = sTemp & oBitStreamFrom.PartialMessage
        
        Call WriteToDebug("          PartialMessage1 Now(" & oBitStreamFrom.PartialMessage & ")")
        
       'Pass this new message and the socket that sent it to us to be processed
        Set oMsg = New clsNetworkMessage
        Call oMsg.ParseMessage(sMsg)
            
        'Now lets find the player who REALLY sent this to us
        '02/19/2003 Chris Hill  Lets use the player object we have already created
        Call ProcessSystemMessages(oMsg, oBitStreamFrom, nPort)
        'Set oMsgFrom = FindPlayer(oMsg.SenderNumber())
        'Call ProcessSystemMessages(oMsg, oMsgFrom, nPort)

        'Actually... if were the host, before we do anything we have to send this on...
        Call HostSendOn(sMsg, nPort)

        '05/13/2002 Chris Hill  It looks like messages were arriving while we are processing.
        'This is bad but can't be prevented.  So we have to always assume more could be added
        'to the partial message at any time.
        Call WriteToDebug("          PartialMessage2 Now(" & oBitStreamFrom.PartialMessage & ")")
        sRemainingMsg = oBitStreamFrom.PartialMessage
        oBitStreamFrom.PartialMessage = ""

        Call WriteToDebug("          PartialMessage3 Now(" & sRemainingMsg & "," & oBitStreamFrom.PartialMessage & ")")
    Wend ' End of Is their any more message?

    'If we didn't have a player before... we should have one now.  Means the add player message
    'was received.  Hmm... Unless it got truncated.
    If oBitStreamFrom.Port = -1 And Len(sTemp) > 0 Then
        Set oBitStreamFrom = m_oGame.FindPlayer(nPort)
        If oBitStreamFrom Is Nothing Then
            Call Err.Raise(-1, "FOTANetwork.WinsockDataArival", "Message was recieved from unknown player that was not an add player message and a partial message was involved.")
        End If
    End If

    Call WriteToDebug("                  NewPartialMessage(" & sTemp & ")")
    Call WriteToDebug("                  For(" & oBitStreamFrom.Number & "," & oBitStreamFrom.Name & ")")
    'oBitStreamFrom.PartialMessage = sTemp
    '05/13/2002 Chris Hill  It looks like messages were arriving while we are processing.
    'This is bad but can't be prevented.  So we have to always assume more could be added
    'to the partial message at any time.
    oBitStreamFrom.PartialMessage = sTemp & oBitStreamFrom.PartialMessage

    'Decrament the reference count
    Call InFlowLight(-1)

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub

Private Sub InFlowLight(nChange As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.InFlowLight"
    On Error GoTo ErrorHandler
        
    'Incrament the reference count
    m_nInFlowRefCount = m_nInFlowRefCount + nChange
    'Mark the timer if it was a posative change
    If nChange > 0 Then
        m_bTrafficInSinceLastTime = True
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub
Private Sub OutFlowLight(nChange As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.OutFlowLight"
    On Error GoTo ErrorHandler
        
    'Incrament the reference count
    m_nOutFlowRefCount = m_nOutFlowRefCount + nChange
    'Mark the timer if it was a posative change
    If nChange > 0 Then
        m_bTrafficOutSinceLastTime = True
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub
Private Sub ProcessSystemMessages(oMsg As clsNetworkMessage, oPlayer As clsNetworkPlayer, nNumber As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.ProcessSystemMessages"
    On Error GoTo ErrorHandler
        
    Dim bTemp As Boolean
    Dim oLoopFT As clsNetworkFileTransfer
    Dim oFileT As clsNetworkFileTransfer
    Dim oNewMsg As clsNetworkMessage
    Dim oTempPlr As clsNetworkPlayer
        
    Call WriteToDebug("          ProcessSystemMessages Type(" & oMsg.MsgType & ") P1(" & oMsg.Paramater(1) & ") P2(" & oMsg.Paramater(2) & ") P3(" & oMsg.Paramater(3) & ") P4(" & oMsg.Paramater(4) & ")")
        
    'Was this message from a new player?
    If oMsg.MsgType = g_cRemovePlayerCode Then
        If m_oGame.FindPlayer(oMsg.Paramater(1)) Is Nothing Then
            Call ErrorOccured(-1, "FOTANetwork.ProcessSystemMessages", "Attempted to remove player " & oMsg.Paramater(1) & " but was unable to locate that player in the session.")
        Else
            Call RemovePlayer(m_oGame.FindPlayer(oMsg.Paramater(1)))
        End If
    ElseIf oMsg.MsgType = g_cNewRouterAddress Then
        Set oPlayer = New clsNetworkPlayer
        oPlayer.Port = CLng(oMsg.Paramater(1))
        oPlayer.Number = PortToNum(oPlayer.Port)
        oPlayer.Name = m_sName
    
        'Set it to try the first port on the host machine
        g_nClientTryingToConnectToPortNumber = oPlayer.Port
        
        Call AddPlayer(oPlayer, True)
        'Close the socket.  Can't have an open socket that isn't doing anything
        Call wnsRouter.Close
        'Do Events
        
        If Not wnsClient.State = sckClosed Then
            Call wnsClient.Close
        End If
        
        'Try to connect to the target IP
        Call wnsClient.Connect(m_sIP, g_nClientTryingToConnectToPortNumber)
        
    ElseIf oMsg.MsgType = g_cAddPlayerCode Then
        '02/19/2003 Chris Hill  Now oPlayer can be nothing, OR the port can be -1
        If oPlayer Is Nothing Then
            bTemp = True
        Else
            bTemp = (oPlayer.Port = -1)
        End If
    
        'We don't want who sent this... the host sent it, duh.
        'Set oTempPlr = FindPlayer(oMsg.Paramater(3))
        'If we didn't find this player then lets add them.  Otherwise we have an error.
        '02/19/2003 Chris Hill  Why search for this?  We already have it in oPlayer
        If bTemp = True Then
        'If oTempPlr Is Nothing Then
            If m_bHost = True Then
                Dim oLoopPlayer As clsNetworkPlayer
                'If i'm the host then I have to tell them who else is in the game
                For Each oLoopPlayer In m_oGame.Players
                    If oLoopPlayer.Port <> NumToPort(nNumber) Then
                        Set oNewMsg = New clsNetworkMessage
                        oNewMsg.MsgType = g_cAddPlayerCode
                        Call oNewMsg.AddParamater(oLoopPlayer.Name)
                        Call oNewMsg.AddParamater(oLoopPlayer.Version)
                        '02/19/2003 Chris Hill  This is the same as the sender number
                        '02/23/2003 Chris Hill  This ISN'T the same as the sender number.  The host eventually
                        'has to send on this add player request to all the players.  When he does so the sender
                        'number gets overwritten with his number.  We MUST pass in our port.
                        Call oNewMsg.AddParamater(oLoopPlayer.Number)
                        Call SendMessageEx(oNewMsg)
                    End If
                Next oLoopPlayer
            End If
        End If
            
        'Add this player to our list... be warned it may be us.
        '02/19/2003 Chris Hill  Only create a new player if this one is null
        If oPlayer Is Nothing Or Not nNumber = oMsg.Paramater(3) Then
            Set oPlayer = New clsNetworkPlayer
        End If
        oPlayer.Name = oMsg.Paramater(1)
        oPlayer.Version = oMsg.Paramater(2)
        '02/23/2003 Chris Hill  This ISN'T the same as the sender number.  The host eventually
        'has to send on this add player request to all the players.  When he does so the sender
        'number gets overwritten with his number.  We MUST pass in our port.
        oPlayer.Number = oMsg.Paramater(3)
        'oPlayer.Number = nNumber
        oPlayer.Port = NumToPort(oPlayer.Number)
            
        Call AddPlayer(oPlayer, (oPlayer.Number = g_nClientTryingToConnectToPortNumber))
        'Else
            '04/09/2002 Chris Hill  We can't do this.  The host sends to everyone so we WILL get this duplicate intinionally.
            'Call ErrorOccured(ENUM_ADD_PLAYER_FOR_KNOWN_PLAYER, "FOTANetwork.ProcessSystemMessages", "The system received an add player message for a player that already exists.")
        'End If
    ElseIf oMsg.MsgType = g_cKickPlayerCode Then
        If GetMe.Number() = oMsg.Paramater(1) Then
            Call wnsClient.Close
            Call ErrorOccured(ENUM_KICKED, "FOTANetwork.ProcessSystemMessages", "Host has kicked you from the game.")
        End If
    ElseIf oMsg.MsgType = g_cFileTransferRequestCode Then
        'Yep!  This is being delivered to me
        If GetMe.Number() = oMsg.Paramater(1) Then
        
            Set oFileT = New clsNetworkFileTransfer
            oFileT.GUID = oMsg.Paramater(2)
            oFileT.filename = oMsg.Paramater(3)
            oFileT.SourceFileSize = oMsg.Paramater(4)
            oFileT.ForceToAccept = oMsg.Paramater(5)
            oFileT.SilentSend = oMsg.Paramater(6)
            Call m_colFileTransfers.Add(oFileT, oFileT.GUID)
        
            RaiseEvent FileTransferRequest(oFileT, oMsg.Paramater(3))
        End If
    ElseIf oMsg.MsgType = g_cAcceptFileTransferRequestCode Then
        If Not m_oStartingFileTransfer Is Nothing Then
            If m_oStartingFileTransfer.GUID = oMsg.Paramater(1) Then
                Call m_oStartingFileTransfer.PlayerResponded(oPlayer, True)
                RaiseEvent FileTransferResponse(m_oStartingFileTransfer, oPlayer, True)
            End If
        End If
    ElseIf oMsg.MsgType = g_cDeclineFileTransferRequestCode Then
        If Not m_oStartingFileTransfer Is Nothing Then
            If m_oStartingFileTransfer.GUID = oMsg.Paramater(1) Then
                Call m_oStartingFileTransfer.PlayerResponded(oPlayer, False)
                RaiseEvent FileTransferResponse(m_oStartingFileTransfer, oPlayer, False)
            End If
        End If
    ElseIf oMsg.MsgType = g_cCancelFileTransferCodeCode Then
        Set oFileT = FindFileTransfer(oMsg.Paramater(1))
        RaiseEvent FileTransferCanceled(oFileT, oPlayer)
        
    'Chris
    ElseIf oMsg.MsgType = g_cAcknoledgePacketCode Then
        'Make sure we don't receive the message we just sent!
        If Not GetMe.Number() = oMsg.SenderNumber Then
            'Are we receiving this file?
            For Each oLoopFT In m_colFileTransfers
                If oLoopFT.GUID = oMsg.Paramater(1) Then
                    Call oLoopFT.WaitListMarkoff(oMsg.SenderNumber)
                End If
            Next oLoopFT
        End If
    ElseIf oMsg.MsgType = g_cFileTransferPacketCode Then
        'Make sure we don't receive the message we just sent!
        If Not GetMe.Number() = oMsg.SenderNumber Then
            'Are we receiving this file?
            For Each oLoopFT In m_colFileTransfers
                If oLoopFT.GUID = oMsg.Paramater(1) Then
                    Call oLoopFT.WriteNextFilePacket(oMsg)
                    RaiseEvent FileTransferProgress(oLoopFT, oLoopFT.PercentDone)
                    
                    'Chris
                    Set oNewMsg = New clsNetworkMessage
                    oNewMsg.MsgType = g_cAcknoledgePacketCode
                    Call oNewMsg.AddParamater(oLoopFT.GUID)
                    Call SendMessageEx(oNewMsg)
                End If
            Next oLoopFT
        End If
        
    ElseIf oMsg.MsgType = g_cFinishedTransferCode Then
        'Are we receiving this file?
        For Each oLoopFT In m_colFileTransfers
            If oLoopFT.GUID = oMsg.Paramater(1) Then
                RaiseEvent FileTransferDone(oLoopFT)
                Call m_colFileTransfers.Remove(oLoopFT.GUID)
            End If
        Next oLoopFT
        
    ElseIf nNumber = -1 Then
        Call ErrorOccured(ENUM_MSG_HAS_NO_KNOWN_SENDER, "FOTANetwork.WinsockDataArival", "Received message from a non-existant player that isn't an Add New Player message.")
    Else
        RaiseEvent MessageReceived(oMsg, oPlayer)
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub

Private Sub RemovePlayer(oPlayer As clsNetworkPlayer)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.RemovePlayer"
    On Error GoTo ErrorHandler
        
        
    Dim oLoopFT As clsNetworkFileTransfer
    
    For Each oLoopFT In m_colFileTransfers
        Call oLoopFT.RemovePlayer(oPlayer)
    Next oLoopFT
    
    Call WriteToDebug("RemovePlayer Number(" & oPlayer.Number & ") Name(" & oPlayer.Name & ")")
    
    Call m_oGame.RemovePlayer(oPlayer)
    
    'If were host we have to inform everyone else that a player left as long as it isn't us.
    If m_bHost = True And Not GetMe() Is Nothing Then
        Call SendMessage(GetMe().Number(), g_cRemovePlayerCode, oPlayer.Number)
    End If
    
    RaiseEvent PlayerRemoved(oPlayer)

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub
Private Sub AddPlayer(oPlayer As clsNetworkPlayer, bIsMe As Boolean)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.AddPlayer"
    On Error GoTo ErrorHandler
        
    If m_oGame.FindPlayer(oPlayer.Number()) Is Nothing Then
        Call m_oGame.AddPlayer(oPlayer)
        
        Call WriteToDebug("AddPlayer Number(" & oPlayer.Number & ") Name(" & oPlayer.Name & ")")
        
        RaiseEvent PlayerAdded(oPlayer, bIsMe)
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub




''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' File transfer stuff
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Public Function PrepareToStartFileTransfer(sFileName As String, Optional bForceToAccept As Boolean = False, Optional bSilentSend As Boolean = False) As String
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.PrepareToStartFileTransfer"
    On Error GoTo ErrorHandler
        
    Set m_oStartingFileTransfer = New clsNetworkFileTransfer
    PrepareToStartFileTransfer = m_oStartingFileTransfer.GUID
    m_oStartingFileTransfer.filename = sFileName
    m_oStartingFileTransfer.ForceToAccept = bForceToAccept
    m_oStartingFileTransfer.SilentSend = bSilentSend

    Exit Function
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Function
Public Sub ErrorOccured(nNumber As Integer, sSource As String, sDescription As String)
    RaiseEvent Error(CLng(nNumber), sDescription, sSource)
    'Call Err.Raise(nNumber, sSource, sDescription)
End Sub
Public Sub AddPlayerToFileTransfer(nPlayerNum As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.AddPlayerToFileTransfer"
    On Error GoTo ErrorHandler
        
    Dim oMsg As New clsNetworkMessage
    Dim oPlayer As New clsNetworkPlayer
    
    Set oPlayer = FindPlayer(nPlayerNum)
    
    If m_oStartingFileTransfer Is Nothing Then
        Call ErrorOccured(ENUM_NO_FILE_TRANSFER_STARTED, "FOTATools.FOTANetwork", "No file transfer has been prepared.  Please call PrepareToStartFileTransfer first.")
    Else
        Call m_oStartingFileTransfer.AddPlayer(oPlayer)
        
        'Notify this new player you want to send him a file...
        oMsg.MsgType = g_cFileTransferRequestCode
        Call oMsg.AddParamater(oPlayer.Number)
        Call oMsg.AddParamater(m_oStartingFileTransfer.GUID)
        Call oMsg.AddParamater(m_oStartingFileTransfer.filename)
        Call oMsg.AddParamater(m_oStartingFileTransfer.SourceFileSize)
        Call oMsg.AddParamater(m_oStartingFileTransfer.ForceToAccept)
        Call oMsg.AddParamater(m_oStartingFileTransfer.SilentSend)
        Call SendMessageEx(oMsg)
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub
Public Sub StartFileTransfer()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.StartFileTransfer"
    On Error GoTo ErrorHandler
        
    If Len(m_oStartingFileTransfer.filename) = 0 Then
        Call ErrorOccured(ENUM_NO_FILE_NAME, "FOTATools.clsNetworkFileTransfer", "You must first specify a file name.")
    ElseIf m_oStartingFileTransfer.PlayersRequestingCount() > 0 Then
        Call ErrorOccured(ENUM_ALL_PLAYERS_NOT_READY, "FOTATools.clsNetworkFileTransfer", "All players must accept or decline before you can begin transfer.")
    ElseIf m_oStartingFileTransfer.PlayersAcceptedCount() = 0 Then
        Call ErrorOccured(ENUM_NO_PLAYERS, "FOTATools.clsNetworkFileTransfer", "You must have at least one player accepted to begin transfer.")
    Else
        Call m_colFileTransfers.Add(m_oStartingFileTransfer, m_oStartingFileTransfer.GUID)
        Call m_oStartingFileTransfer.SYS_SetStartingCriteria
        Set m_oStartingFileTransfer = Nothing
        tmrFileTransfer.Enabled = True
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub
Public Sub CancelFileTransferByGUID(sGUID As String)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTANetworking.CancelFileTransferByGUID"                                                 '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Dim oFileT As clsNetworkFileTransfer
    
    Set oFileT = Me.FindFileTransfer(sGUID)
    Call CancelFileTransfer(oFileT)
                                                                                                                            '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub
Public Sub CancelFileTransfer(oFileTransfer As clsNetworkFileTransfer)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTANetworking.CancelFileTransfer"                                                 '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    If oFileTransfer Is Nothing Then
        Set m_oStartingFileTransfer = Nothing
    Else
        If oFileTransfer.Started() = False Then
            Set m_oStartingFileTransfer = Nothing
        Else
            Call SendMessage(GetMe().Number(), g_cCancelFileTransferCodeCode, oFileTransfer.GUID())
        End If
    End If
                                                                                                                            '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub
Private Sub tmrFileTransfer_Timer()
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.tmrFileTransfer_Timer"
    On Error GoTo ErrorHandler
        
    Dim oLoopFT As clsNetworkFileTransfer
    Dim oMsg As clsNetworkMessage
    Dim bFinished As Boolean
    Dim i As Long
    
    For i = 1 To m_colFileTransfers.Count
        If i > m_colFileTransfers.Count Then Exit For
        Set oLoopFT = m_colFileTransfers(i)
    
        If oLoopFT.WaitListLength() = 0 Then
            Call oLoopFT.WaitListReset
        
            Set oMsg = New clsNetworkMessage
            oMsg.MsgType = g_cFileTransferPacketCode
            Call oMsg.AddParamater(oLoopFT.GUID)
            'This returns if we finished this file transfer!
            bFinished = oLoopFT.GetNextFilePacket(oMsg)
            
            'But first send the packets we got
            Call SendMessageEx(oMsg)
            
            If bFinished = True Then
                '08/08/2002 Chris Hill  We need to be able to remove file transfers that finish.
                Call m_colFileTransfers.Remove(i)
                
                Call SendMessage(GetMe().Number, g_cFinishedTransferCode, oLoopFT.GUID)
                RaiseEvent FileTransferDone(oLoopFT)
            Else
                RaiseEvent FileTransferProgress(oLoopFT, oLoopFT.PercentDone())
            End If
        End If
    Next i

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub
Public Sub AcceptFileTransferRequest(bAccept As Boolean, sGUID As String, sSaveToFileName As String)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.AcceptFileTransferRequest"
    On Error GoTo ErrorHandler
        
    Dim oFileT As clsNetworkFileTransfer
    Set oFileT = m_colFileTransfers(sGUID)
    
    If bAccept = True Then
        oFileT.filename = sSaveToFileName
        Call SendMessage(GetMe().Number(), g_cAcceptFileTransferRequestCode, sGUID)
    Else
        Call m_colFileTransfers.Remove(sGUID)
        Call SendMessage(GetMe().Number(), g_cDeclineFileTransferRequestCode, sGUID)
    End If

    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)
    
End Sub
Public Function FindFileTransfer(sGUID As String) As clsNetworkFileTransfer
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.FindFileTransfer"
    On Error GoTo ErrorHandler
        
    
    Dim oLoopFT As clsNetworkFileTransfer
    
    For Each oLoopFT In m_colFileTransfers
        If oLoopFT.GUID() = sGUID Then
            Set FindFileTransfer = oLoopFT
        End If
    Next oLoopFT
    
    
    Exit Function
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Function

Public Property Get DebugMode() As Boolean
    DebugMode = m_bDebugMode
End Property
Public Property Let DebugMode(bOn As Boolean)
    m_bDebugMode = bOn
End Property

Private Sub WriteToDebug(sMsg As String)

    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.WriteToDebug"
    On Error GoTo ErrorHandler

    
    Dim sTime As String
    Dim nF As Long
    Dim sFileError As String
    sFileError = m_sDebugFile
    nF = FreeFile
    
    If m_bDebugMode = True Then
        Open m_sDebugFile For Append As #nF
        
            'Is the message blank?
            If Len(sMsg) = 0 Then
                Print #nF, ""
            Else
                'Calculate the time
                sTime = "[" & Format(Now(), "mm/dd/yyyy hh:mm:ss") & _
                        CInt(Timer - (Minute(Now) * 60 + Hour(Now()) * 60 * 60)) & "] "
                'Print out the line
                Print #nF, sTime & " " & sMsg
            End If
    
        Close #nF
    End If
    
    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description & "  (" & sFileError & ")")
    
End Sub
Private Sub HostSendOn(sMsg As String, nPort As Long)
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.HostSendOn"
    On Error GoTo ErrorHandler


    Dim sSentTo As String
    Dim oLoopPlayer As clsNetworkPlayer

    If m_bHost = True Then
    
        For Each oLoopPlayer In m_oGame.Players
        
            'Don't try to send this to the host (thats us) or the player that sent it to us
            If oLoopPlayer.Port <> NumToPort(nPort) And oLoopPlayer.Port <> m_nBasePort Then
                If wnsPort(PortToNum(oLoopPlayer.Port)).State = sckConnected Then
                    Call wnsPort(PortToNum(oLoopPlayer.Port)).SendData(g_cMsgHeader & sMsg & g_cMsgTrailer)
                    
                    '10/30/2005 Chris Hilll  Turns out this neccessary to get the message sent.
                    DoEvents
                End If
            End If
            
        Next oLoopPlayer
        
        Call WriteToDebug("     HostSendOn To(" & sSentTo & ")")
    End If


    Exit Sub
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Sub
'A new symbology is being used now.  H = header, T = trailer, h = part of header ~ = msg body
Public Function ParseIncomingStream(sIncomingStream As String, _
                                    ByRef sMsg As String, ByRef sLeftOvers As String) As Boolean
    
    Dim sRoutineName As String
    sRoutineName = "FOTANetworking.ParseIncomingStream"
    On Error GoTo ErrorHandler


    Dim nStartOfFirstMsg As Long, nStartOfSecMsg As Long, nStartOfThirdMsg As Long
    Dim nEndOfFirstMsg As Long, nEndOfSecMsg As Long
    Dim sCutMsg As String
    Dim sTemp As String
    Dim sTempLeftOvers As String

    'Get some parsing information for future calculations.
    nStartOfSecMsg = 0
    nStartOfThirdMsg = 0
    nEndOfSecMsg = 0
    
    nStartOfFirstMsg = InStr(1, sIncomingStream, g_cMsgHeader) '- 1
    If nStartOfFirstMsg > 0 Then
        nStartOfSecMsg = InStr(nStartOfFirstMsg + 1, sIncomingStream, g_cMsgHeader) '- 1
        If nStartOfSecMsg > 0 Then
            nStartOfThirdMsg = InStr(nStartOfSecMsg + 1, sIncomingStream, g_cMsgHeader) '- 1
        End If
    End If
    nEndOfFirstMsg = InStr(1, sIncomingStream, g_cMsgTrailer) '- 1
    If nEndOfFirstMsg > 0 Then
        nEndOfSecMsg = InStr(nEndOfFirstMsg + 1, sIncomingStream, g_cMsgTrailer) '- 1
    End If

    Call WriteToDebug("          ParseIncoming    Start(" & nStartOfFirstMsg & "," & nStartOfSecMsg & "," & nStartOfThirdMsg & ") End(" & nEndOfFirstMsg & "," & nEndOfSecMsg & ")")
    Call WriteToDebug("                 Incoming Stream(" & sIncomingStream & ")")

    'This means were done parsing... stop without an error.
    If Len(Trim(sIncomingStream)) = 0 Then
        Call WriteToDebug("                     Option 6():  Blank message")
        'Do nothing.
        sMsg = ""
        sLeftOvers = ""
        ParseIncomingStream = False
        
    'We have here a partial header...
    'h  For example  [H
    ElseIf InStr(1, g_cMsgHeader, sIncomingStream) = 1 Then
        'We don't do anything
        Call WriteToDebug("                     Option 8(h)")
        sMsg = ""
        sLeftOvers = sIncomingStream
        ParseIncomingStream = False
        
    'This means the first thing in the buffer is not a header.  This should theoretically be impossible.
    '~TH~T... but not h
    ElseIf nStartOfFirstMsg > 1 Then
        Call WriteToDebug("                     Option 1(~TH~T): Error the first part of this incoming stream is not a message.  Message was lost, attempting to recover.")
        
        '02/18/2003 Chris Hill  Attempting to fix this bug... so at least they can TRY to go on.
        sMsg = ""
        sLeftOvers = Mid(sIncomingStream, nStartOfFirstMsg)
        ParseIncomingStream = True
        
        Call Err.Raise(-1, "FOTANetwork.ParseIncomingSteam", "The first part of this incoming stream is not a message header.  This should be theoretically impossible.  Attempting to recover.")
    
    'This means a message came in and cut off a previsouly incoming message.
    'H~H~T~ or H~H~T~H or H~H~T~HH~ or H~H~H~T~T~T
    '/--------\
    '  /-\/-\
    'H~H~TH~T~T
    ElseIf nStartOfFirstMsg > 0 And nStartOfSecMsg > 0 And nEndOfFirstMsg > nStartOfSecMsg Then
        sCutMsg = Mid(sIncomingStream, nStartOfSecMsg, nEndOfFirstMsg - nStartOfSecMsg + Len(g_cMsgTrailer))
        sTemp = left(sIncomingStream, nStartOfSecMsg - 1) & _
                Mid(sIncomingStream, nEndOfFirstMsg + Len(g_cMsgTrailer))
                
        Call WriteToDebug("                     Option 2(H~H~TH~T~T or H~H~T~ or H~H~T~H or H~H~T~HH~ or H~H~H~T~T~T)")
        Call WriteToDebug("                             Cut(" & sCutMsg & ")")
        Call WriteToDebug("                             LeftOvers(" & sTemp & ")")
        Call WriteToDebug("                             Recurse")
                
        ParseIncomingStream = ParseIncomingStream(sTemp, sMsg, sTempLeftOvers)
        
        If ParseIncomingStream = True Then
            Call WriteToDebug("                             Found Message (" & sCutMsg & "," & sTempLeftOvers & ")")
            sLeftOvers = sCutMsg & sTempLeftOvers
        Else
            Call WriteToDebug("                             Didn't Find Message (" & sCutMsg & "," & sTempLeftOvers & ")")
            sLeftOvers = sTempLeftOvers & sCutMsg
        End If
    
    'The end of this message is not in this packet....
    'H~ or H~H~ or H~h~ or H~H~H~H~H~H~H~H~ ....
    'ElseIf nStartOfFirstMsg > 0 And nStartOfSecMsg = 0 And nEndOfFirstMsg = 0 Then
    ElseIf nStartOfFirstMsg > 0 And nEndOfFirstMsg = 0 Then
        Call WriteToDebug("                     Option 3(H~)")
        sMsg = ""
        sLeftOvers = sIncomingStream
        ParseIncomingStream = False

    'This means their is a message after this message in the stream
    'H~TH~ or H~TH~T...
    ElseIf nStartOfFirstMsg > 0 And nEndOfFirstMsg > 0 And ((nEndOfFirstMsg < nStartOfSecMsg And nStartOfSecMsg > 0) Or (nEndOfFirstMsg < Len(sIncomingStream) - Len(g_cMsgTrailer) + 1)) Then
        Call WriteToDebug("                     Option 4(H~TH~ or H~TH~T...)")
        'Get the next message
        sMsg = Mid(sIncomingStream, Len(g_cMsgHeader) + 1, nEndOfFirstMsg - 1 - Len(g_cMsgTrailer))
        'Remove this current message from the remaining message
        sLeftOvers = Mid(sIncomingStream, nEndOfFirstMsg + Len(g_cMsgTrailer))
        ParseIncomingStream = True

    'This means the entire stream is a single message, no more no less
    'H~T
    ElseIf nStartOfFirstMsg > 0 And nEndOfFirstMsg > 0 And nStartOfSecMsg = 0 And nEndOfSecMsg = 0 Then
        Call WriteToDebug("                     Option 5(H~T)")
        'Strip off the header and trailer bits
        sMsg = Mid(sIncomingStream, Len(g_cMsgHeader) + 1, Len(sIncomingStream) - Len(g_cMsgHeader) - Len(g_cMsgTrailer))
        sLeftOvers = ""
        ParseIncomingStream = True
    
    Else
        Call WriteToDebug("                     Option 7():  Error, none of the above choices.")
        'Error.  This shoudlen't be possible.
        Call Err.Raise(-1, "FOTANetwork.ParseIncomingSteam", "None of above choosen.  This should be theoretically impossible.")
    End If 'End of 'Is their any more?'

    Call WriteToDebug("                 Returning sMsg(" & sMsg & ")")
    Call WriteToDebug("                      Remaining(" & sLeftOvers & ")")
    Call WriteToDebug("                      FoundMsg(" & ParseIncomingStream & ")")


    Exit Function
ErrorHandler:
    Call ErrorOccured(Err.Number, Err.Source, sRoutineName & ": " & Err.Description)

End Function
