VERSION 5.00
Begin VB.UserControl FOTAStars 
   BackColor       =   &H00E0E0E0&
   ClientHeight    =   360
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   360
   InvisibleAtRuntime=   -1  'True
   Picture         =   "FOTAStars.ctx":0000
   ScaleHeight     =   360
   ScaleWidth      =   360
   ToolboxBitmap   =   "FOTAStars.ctx":0682
   Begin VB.Timer T 
      Interval        =   10
      Left            =   1155
      Top             =   105
   End
End
Attribute VB_Name = "FOTAStars"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Global Variables
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim bInitedStars As Boolean
Dim nStars() As Long
Dim nBackColor As Long

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Properties
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim g_nNumOfStars As Integer
Dim g_bEnabled As Boolean
Dim g_nStardelay As Integer
Dim g_nStarFocus As Integer
Dim g_nStarColor As Long

Property Let NumberOfStars(nNum As Integer)
    g_nNumOfStars = nNum
End Property
Property Get NumberOfStars() As Integer
    NumberOfStars = g_nNumOfStars
End Property
Property Let Enabled(bNewEnabled As Boolean)
    g_bEnabled = bNewEnabled
    T.Enabled = g_bEnabled
End Property
Property Get Enabled() As Boolean
    Enabled = g_bEnabled
End Property
Property Let StarDelay(nDelay As Integer)
    g_nStardelay = nDelay
End Property
Property Get StarDelay() As Integer
    StarDelay = g_nStardelay
End Property
Property Let StarFocus(nFocus As Integer)
    g_nStarFocus = nFocus
End Property
Property Get StarFocus() As Integer
    StarFocus = g_nStarFocus
End Property
Property Let StarColor(cColor As OLE_COLOR)
    g_nStarColor = cColor
End Property
Property Get StarColor() As OLE_COLOR
    StarColor = g_nStarColor
End Property


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Events
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub T_Timer()

    Dim i As Integer
    Dim j As Integer

    'Keep it from runnnig in debug mode
    If Ambient.UserMode = False Then
        T.Enabled = False
        Exit Sub
    'Have we initialized yet?
    ElseIf bInitedStars = False Then
        'Dim the array and set the base random values
        ReDim nStars(1 To 2, 0 To g_nNumOfStars) As Long
        bInitedStars = True
        For i = 0 To g_nNumOfStars
            nStars(1, i) = Int((UserControl.Parent.Width * Rnd) + 1)
            nStars(2, i) = Int((UserControl.Parent.Height * Rnd) + 1)
        Next i
        nBackColor = UserControl.Parent.BackColor
    End If
    
    'Is the control enabled?
    'If g_bEnabled = True Then
        
        'Erase, Move Draw all the stars
        For i = 0 To g_nNumOfStars
            UserControl.Parent.PSet (nStars(1, i), nStars(2, i)), nBackColor
            Call MovePixel(nStars(1, i), nStars(2, i))
            UserControl.Parent.PSet (nStars(1, i), nStars(2, i)), g_nStarColor 'RGB(255, 255, 255)
        Next i
    'End If
    
End Sub
Private Sub MovePixel(ByRef nX As Long, ByRef nY As Long)
    'Move the star
    nX = nX + ((nX - (UserControl.Parent.Width / 2)) / g_nStardelay)
    nY = nY + ((nY - (UserControl.Parent.Height / 2)) / g_nStardelay)
    
    'Is star off of screen?
    If nX > UserControl.Parent.Width Or nX < 0 Or nY > UserControl.Parent.Height Or nY < 0 Then
        'Replace star
        nX = (UserControl.Parent.Width / 2) + _
            Int(((UserControl.Parent.Width / g_nStarFocus) * Rnd) + 1) - (UserControl.Parent.Width / (g_nStarFocus * 2))
        nY = (UserControl.Parent.Height / 2) + _
            Int(((UserControl.Parent.Height / g_nStarFocus) * Rnd) + 1) - (UserControl.Parent.Height / (g_nStarFocus * 2))
    End If
End Sub
Private Sub UserControl_Initialize()
    bInitedStars = False
End Sub


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Events
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Set the propeties to what the users will most likely use
Private Sub UserControl_InitProperties()

    g_nStardelay = 30
    g_nNumOfStars = 100
    g_bEnabled = True
    g_nStarFocus = 2
    g_nStarColor = RGB(255, 255, 255)

End Sub

'Read in the properties, and if were running the code hook into the form
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)

    g_nStardelay = PropBag.ReadProperty("MyStarDelay", 30)
    g_nNumOfStars = PropBag.ReadProperty("MyNumOfStars", 100)
    g_bEnabled = PropBag.ReadProperty("MyEnabled", True)
    g_nStarFocus = PropBag.ReadProperty("MyStarFocus", 2)
    g_nStarColor = PropBag.ReadProperty("MyStarColor", RGB(255, 255, 255))
    
    T.Enabled = g_bEnabled

End Sub
'If the designer tries to resize this control... prevent him
Private Sub UserControl_Resize()

    UserControl.Height = 360
    UserControl.Width = 360

End Sub
'Record the properties of the form
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    Call PropBag.WriteProperty("MyStarDelay", g_nStardelay, 30)
    Call PropBag.WriteProperty("MyNumOfStars", g_nNumOfStars, 100)
    Call PropBag.WriteProperty("MyEnabled", g_bEnabled, True)
    Call PropBag.WriteProperty("MyStarFocus", g_nStarFocus, 2)
    Call PropBag.WriteProperty("MyStarColor", g_nStarColor, RGB(255, 255, 255))

End Sub
