VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFOTAProgressBar"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Public Event ClickedCancel()

Private m_bStopClicked As Boolean
Private m_oFunctions As New clsFunctions
Private m_oProgBarForm As frmProgressBar

Private Sub Class_Initialize()
    Set m_oProgBarForm = New frmProgressBar
    Call m_oProgBarForm.DisplayMe(Me)
End Sub

Public Sub ClickCancel()
    m_bStopClicked = True
    RaiseEvent ClickedCancel
    Call CloseMe
End Sub

Private Sub Class_Terminate()
    Call Unload(m_oProgBarForm)
End Sub

Public Sub DisplayMe(Optional nXCenter As Long = -1, Optional nYCenter As Long = -1)
    m_bStopClicked = False
    If nXCenter = -1 Then
        m_oProgBarForm.Left = Screen.Width / 2 - (m_oProgBarForm.Width / 2)
    Else
        m_oProgBarForm.Left = (nXCenter - m_oProgBarForm.Width / 2)
    End If
    If nYCenter = -1 Then
        m_oProgBarForm.Top = (Screen.Height / 2 - m_oProgBarForm.Height / 2)
    Else
        m_oProgBarForm.Top = (nYCenter - m_oProgBarForm.Height / 2)
    End If
    m_oProgBarForm.Visible = True
    Call m_oProgBarForm.Refresh
End Sub

Public Function CloseMe()
    m_oProgBarForm.Visible = False
End Function

Public Property Let TotalLabel(sNewLabel As String)
    m_oProgBarForm.lblTotalLabel.Caption = sNewLabel
    Call m_oProgBarForm.Refresh
End Property
Public Property Get TotalLabel() As String
    TotalLabel = m_oProgBarForm.lblTotalLabel.Caption
End Property

Public Property Let TotalPercent(nNewPercent As Double)
    m_oProgBarForm.prgTotal.Value = m_oFunctions.Min(m_oFunctions.Max(nNewPercent, 0), 100)
    m_oProgBarForm.lblTotalPercent.Caption = FormatNumber(m_oFunctions.Min(m_oFunctions.Max(nNewPercent, 0), 100), 1) & "%"
    Call m_oProgBarForm.Refresh
End Property
Public Property Get TotalPercent() As Double
    TotalPercent = m_oProgBarForm.prgTotal.Value
End Property

Public Property Let CurrentLabel(sNewLabel As String)
    m_oProgBarForm.lblCurrentLabel.Caption = sNewLabel
    Call m_oProgBarForm.Refresh
End Property
Public Property Get CurrentLabel() As String
    CurrentLabel = m_oProgBarForm.lblCurrentLabel.Caption
End Property

Public Property Let CurrentPercent(nNewPercent As Double)
    m_oProgBarForm.prgCurrent.Value = m_oFunctions.Min(m_oFunctions.Max(nNewPercent, 0), 100)
    m_oProgBarForm.lblCurrentPercent.Caption = m_oFunctions.Min(m_oFunctions.Max(nNewPercent, 0), 100) & "%"
    Call m_oProgBarForm.Refresh
End Property
Public Property Get CurrentPercent() As Double
    CurrentPercent = m_oProgBarForm.prgCurrent.Value
End Property

Public Property Get StopClicked() As Boolean
    StopClicked = m_bStopClicked
End Property
