VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsMultiControl"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private m_nMax As Long
Private m_saKey() As String
Private m_baIsInUse() As Boolean
Private m_oControl As Object

Public Property Get SourceControl() As Object
    Set SourceControl = m_oControl
End Property
Public Property Let SourceControl(oSetobject As Object)

    On Error GoTo NotAnArray
        m_nMax = oSetobject.ubound
    On Error GoTo NormalError
    
    ReDim m_saKey(0 To m_nMax) As String
    ReDim m_baIsInUse(0 To m_nMax) As Boolean
    Dim i As Integer
    
    'Ok if we made it this far we know its an indexed object
    Set m_oControl = oSetobject
    
    For i = 0 To m_nMax
        m_saKey(i) = ""
        m_baIsInUse(i) = False
        'm_oControl(i).Enabled = False
        m_oControl(i).Visible = False
    Next i
    
    Exit Property
NotAnArray:
    'Call MsgBox(oSetobject.Name & "Source object does not have an index.  Set the Index property to 0 on the control.", vbInformation + vbOKOnly, "clsMultiControl::SourceControl")
    Call Err.Raise(-1, "clsMultiControl::SourceControl", "Source object does not have an index.  Set the Index property to 0 on the control.")
    
NormalError:
    
End Property
Public Function GetControlForKey(sKey As String) As Object

    Dim i As Long
    Dim nNewKey As Long
    
    For i = 0 To m_nMax
        If m_saKey(i) = sKey And m_baIsInUse(i) = True Then
            Set GetControlForKey = m_oControl(i)
            Exit Function
        End If
    Next i
    
    Set GetControlForKey = GetFreeControl()
    m_saKey(GetControlForKey.Index) = sKey
    
End Function
Public Function GetKeyForIndex(nIndex As Long) As String
    GetKeyForIndex = m_saKey(nIndex)
End Function
Public Function GetKeyForControl(oControl As Object) As String
    GetKeyForControl = GetKeyForIndex(oControl.Index)
End Function
Public Function GetIndexForKey(sKey As String) As Long

    Dim i As Long
    Dim nNewCont As Long
    
    For i = 0 To m_nMax
        If m_saKey(i) = sKey Then
            GetIndexForKey = i
            Exit Function
        End If
    Next i
    
    Call Err.Raise(-1, "Key Not Found In Collection")
    
End Function
Public Function GetFreeControl() As Object

    Dim i As Long
    Dim nNewKey As Long
    Dim bFound As Boolean
    
    For i = 0 To m_nMax
        If m_baIsInUse(i) = False Then
            m_saKey(i) = ""
            m_baIsInUse(i) = True
            m_oControl(i).Visible = True
            Set GetFreeControl = m_oControl(i)
            Exit Function
        End If
    Next i
    
    nNewKey = AddNewControl
    Set GetFreeControl = m_oControl(nNewKey)

End Function
Public Property Get PrimaryKey(nIndex As Long) As String
    PrimaryKey = m_saKey(nIndex)
End Property
Public Property Let PrimaryKey(nIndex As Long, ByVal sNewKey As String)
    m_saKey(nIndex) = sNewKey
End Property
Public Property Get IsInUse(nIndex As Long) As Boolean
    IsInUse = m_baIsInUse(nIndex)
End Property
Public Property Let IsInUse(nIndex As Long, ByVal bNewVal As Boolean)
    m_baIsInUse(nIndex) = bNewVal
    'm_oControl(nIndex).Enabled = bNewVal
    m_oControl(nIndex).Visible = bNewVal
End Property
Private Function AddNewControl() As Long

    Dim i As Long

    For i = 0 To m_nMax
        If m_baIsInUse(i) = False Then
            m_saKey(i) = ""
            m_baIsInUse(i) = True
            AddNewControl = i
            m_oControl(i).Visible = True
            Exit Function
        End If
    Next i

    m_nMax = m_nMax + 1
    Call Load(m_oControl(m_nMax))
    m_oControl(m_nMax).Visible = True
    ReDim Preserve m_saKey(0 To m_nMax) As String
    ReDim Preserve m_baIsInUse(0 To m_nMax) As Boolean
    m_baIsInUse(m_nMax) = True
    
    AddNewControl = m_nMax

End Function

Private Sub Class_Initialize()
    ReDim m_saKey(0 To 0) As String
    ReDim m_baIsInUse(0 To 0) As Boolean
End Sub
