VERSION 5.00
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.UserControl FOTANetwork 
   ClientHeight    =   1395
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2400
   ScaleHeight     =   1395
   ScaleWidth      =   2400
   Begin VB.Timer tmrStateCheck 
      Left            =   1080
      Top             =   360
   End
   Begin MSWinsockLib.Winsock wnsRouter 
      Left            =   120
      Top             =   120
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin MSWinsockLib.Winsock wnsClient 
      Left            =   1800
      Top             =   600
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin MSWinsockLib.Winsock wnsPort 
      Index           =   0
      Left            =   120
      Top             =   600
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
End
Attribute VB_Name = "FOTANetwork"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'This will fire whenever the state of the network fires.
'   Host: Router Close, Router Open,
'   Client: Connect To Host
'Public Event NetworkStateChange()

'This will fire when a message is received
Public Event MessageReceived(oMessage As clsMessage, oPlayerFrom As clsPlayer)
'This player was just added!
Public Event PlayerAdded(oNewPlayer As clsPlayer)


'Constants for transmitted code  僱>"
'Private Const g_cByteStrSep As String = "_"
Private Const g_cMsgDelim As String = "[D ]"
Private Const g_cMsgHeader As String = "[H ]"
Private Const g_cMsgTrailer As String = "[T ]"
'Private System Messages Coder never sees
Private Const g_cNewRouterAddress As String = "<NewRouterAddress >"
Private Const g_cAddPlayerCode As String = "<AddPlayerCode >"
'Private Const g_cRemoveMeCode As String = "<RemoveMeCode >"


Private m_sName As String
Private m_nTryNumber As Long
Private m_nBasePort As Long
Private m_bHost As Boolean
Private m_sIP As String
Private g_nClientTryingToConnectToPortNumber As Long

Private m_oGame As clsGame

Public Property Get Host() As Boolean
    Host = m_bHost
End Property

Public Property Get IP() As String
    IP = m_sIP
End Property
Public Property Let IP(sNewVal As String)
    m_sIP = sNewVal
End Property

Public Property Get Name() As String
    Name = m_sName
End Property
Public Property Let Name(sNewVal As String)
    m_sName = sNewVal
End Property

Public Property Get BasePort() As Long
    BasePort = m_nBasePort
End Property
Public Property Let BasePort(nNewVal As Long)
    m_nBasePort = nNewVal
End Property

Public Sub HostAGame()

    Dim oPlayer As New clsPlayer

    'I'm not sure why but we have to clear the port seperatly... probabely shut down time for the system.
    'The length of this function may not be sufficient for some slower machines.
    Call wnsRouter.Close
    Call wnsPort(0).Close
    DoEvents
    
    'Start up the router
    wnsRouter.LocalPort = m_nBasePort
    Call wnsRouter.Listen
    
    'Add ourselves as a host of this game
    oPlayer.Host = True
    oPlayer.IP = m_sIP
    oPlayer.Port = m_nBasePort
    If Len(m_sName) = 0 Then
        oPlayer.Name = "Unknown" & m_nBasePort
    Else
        oPlayer.Name = m_sName
    End If
    Call m_oGame.AddPlayer(oPlayer)
    
End Sub
Public Sub ClientToAGame()
            
    If Not wnsClient.State = sckClosed Then
        Call wnsClient.Close
    End If
            
    'Set it to try the first port on the host machine
    g_nClientTryingToConnectToPortNumber = m_nBasePort
                
    'Try to connect to the target IP
    Call wnsClient.Connect(m_sIP, g_nClientTryingToConnectToPortNumber)
            
End Sub
'This one is for coder consumption... its stupid proof
Public Sub SendMessage(sType As String, sMsg As String)
    
    Dim oLoopPlayer As clsPlayer

    'If were host we have to send the message to everyone
    If m_bHost = True Then
    
        For Each oLoopPlayer In m_oGame.Col
            If oPlayer.Port <> oLoopPlayer.Port Then
                Call SendData(wnsPort(oLoopPlayer.Port), sType, sMsg)
            End If
        Next oLoopPlayer
    
    Else
        Call SendData(wnsClient, sType, sMsg)
    End If

End Sub
'This one is for internal use since you have to specify the winsock connection
Private Sub SendData(wnsWinSock As Winsock, sType As String, sMsg As String)
    
    Dim sTempMsg As String
    
    'Is the socket connected?
    If wnsWinSock.State = sckConnected Then
    
        sTempMsg = sMsg
        If Not Right(sTempMsg, Len(g_cMsgDelim)) = g_cMsgDelim Then
            sTempMsg = sTempMsg & g_cMsgDelim
        End If
        
        'Send the message out
        Call wnsWinSock.SendData(g_cMsgHeader & sType & g_cMsgDelim & sTempMsg & g_cMsgTrailer)
        'Allow the system to catch up on events
        DoEvents
    Else
        Call Err.Raise(-1, "SendData", "Targeted connection is closed and cannot send the message.")
    End If 'End of socket state check

End Sub ' End of SendData
Private Sub wnsRouter_Close()

    'Close the socket.  Can't have an open socket that isn't doing anything
    Call wnsRouter.Close
    DoEvents
    'Reopen the port for buisnes
    Call wnsRouter.Listen
    DoEvents

End Sub
'(Host Only)  This is the router so if they tried to join here give them a new place to live
Private Sub wnsRouter_ConnectionRequest(ByVal requestID As Long)

    'If their trying to join a socket that isn't closed, close it.  I don't know why you have to do this... it doesn't make sence.  But you do.
    If wnsRouter.State <> sckClosed Then wnsRouter.Close

    'Accept the connection from the user
    Call wnsRouter.Accept(requestID)

    'Open up a new port for them to connect to now
    Call Load(wnsPort(wnsPort.UBound + 1))
    wnsPort(wnsPort.UBound).LocalPort = wnsPort.UBound + m_nBasePort
    Call wnsPort(wnsPort.UBound).Listen
    DoEvents

    'tell them the new port number
    Call SendData(wnsRouter, g_cNewRouterAddress & Str(wnsPort.UBound + m_nBasePort))

    'Close down the router port and get it ready for the next person
    Call wnsRouter.Close
    DoEvents
    Call wnsRouter.Listen
    DoEvents

End Sub ' wnsRouter_ConnectionRequest

Private Sub wnsRouter_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)

    'Raise an error so the error handler will catch it.  Be aware this method will
    'cause the rest of this function to be ignored (which is ok)
    Call Err.Raise(Number, App.EXEName, Description)
    'Close the socket.  Can't have an open socket that isn't doing anything
    Call wnsRouter.Close
    DoEvents
    'Reopen the port for buisnes
    Call wnsRouter.Listen
    DoEvents

End Sub ' End of wnsRouter error

'This executes every 2 seconds.  It checks the status of the ports and updates
'the status bar.  A bit of CPU stealing but this way we have an accurate status
'bar, NOT just what I tell it.
'Private Sub tmrStateCheck_Timer()
'
'    'Variables for connection status check
'    Dim i As Long
'    Dim bTemp As Boolean
'    Dim nSocketType(0 To 9) As Long
'
'    'Scan all the network links and record their state
'    If g_bAmIHost = True Then
'        If wnsPort.UBound > 0 Then
'            For i = 1 To wnsPort.UBound
'                'Record the status of this port (and the number of this type
'                nSocketType(wnsPort(i).State) = nSocketType(wnsPort(i).State) + 1
'            Next i
'        End If
'        nSocketType(wnsRouter.State) = nSocketType(wnsRouter.State) + 1
'    Else
'        nSocketType(wnsClient.State) = 1
'    End If
'
'    'Check for the message of what we are doing... We only show one so pick the best
'    If nSocketType(3) + nSocketType(4) + nSocketType(5) > 0 Then '(3 Connection pending,4 Resolving host , 5 Host resolved)
'        StatusBar.Panels(1).Text = "Connecting To Player"
'
'    ElseIf nSocketType(6) > 0 Then '(6 Connecting)
'        StatusBar.Panels(1).Text = "Trying Connection " & g_nMyNumber & " To Port " & g_cStartingPort + g_nMyNumber
'
'    ElseIf nSocketType(2) > 0 Then '(2 Listening)
'        StatusBar.Panels(1).Text = "Listening For Player(s)"
'
'    ElseIf nSocketType(7) > 0 Then '(7 Connected)
'        StatusBar.Panels(1).Text = "Connected To Player(s)"
'
'    Else '(0 Closed, 1 Open, 8 Peer is closing the connection, 9 Error)
'        StatusBar.Panels(1).Text = "Socket Error (No Activity)"
'
'    End If
'
'    'Add on the count of connected people
'    StatusBar.Panels(2).Text = nSocketType(7) '& "/" & frmconnectstatus.wnsPort.ubound + 1
'
'    'Decide weather or not to load the pictures.
'        'Picture 1, are we the host or not?
'        If g_bAmIHost = True Then
'            'StatusBar.Panels(3).Picture = picHost.Picture
'        Else
'            'StatusBar.Panels(3).Picture = picClient.Picture
'        End If
'
'        'Picture 2, are we connected?
'        If nSocketType(7) > 0 Or nSocketType(2) > 0 Then
'            'We are connected... so show the right picture and verify the menu options
'            'StatusBar.Panels(4).Picture = picConnected.Picture
'
'            'Is the menu set right?
'            bTemp = True
'            frmMain.mnuConnect.Enabled = False
'            frmMain.mnuDisconnect.Enabled = False
'            'Enable the special menu options
'            frmMain.mnuDMControl.Enabled = (chkIAmTheDM.Value = vbChecked)
'            frmMain.mnuLoadBM.Enabled = (chkIAmTheDM.Value = vbChecked)
'        Else
'            'We are not connected... so hide stuff
'            'StatusBar.Panels(4).Picture = picNotConnected.Picture
'
'            'Is the menu set right?
'            bTemp = False
'            frmMain.mnuConnect.Enabled = True
'            frmMain.mnuDisconnect.Enabled = True
'            frmMain.mnuDMControl.Enabled = False
'            frmMain.mnuLoadBM.Enabled = False
'        End If
'
'        frmMain.mnuCreateChat.Enabled = bTemp
'        frmMain.mnuMsg.Enabled = bTemp
'        frmMain.mnuLoadCharacter.Enabled = bTemp
'        frmMain.mnuCreateNewChar.Enabled = bTemp
'        frmMain.mnuDemo.Enabled = bTemp
'        frmMain.mnuOnlineRef.Enabled = bTemp
'        frmMain.mnuAutoGenNames.Enabled = bTemp
'        frmMain.mnuPictoralConversation.Enabled = bTemp
'
'
'End Sub ' End of tmrConnCheck_Timer

''We are no longer receiveing data so change the color back to normal
'Public Sub ReceiveDataStop()
'
'    On Error GoTo ErrorHandler
'    Dim sRoutineName As String
'    sRoutineName = Me.Name & ".ReceiveDataStop"
'    Call WriteProcStart(sRoutineName)
'
'
'    'Set the color to Red, we are nolonger receive data
'    shpReceave.BackColor = &HFF&
'    shpReceave.Refresh
'
'
'    'Exit the sub... on an error we will jump over this function
'    Exit Sub
'ErrorHandler:
'    Call ErrorTrapper(sRoutineName)
'
'End Sub
''We are about to start receiveing data, change the color
'Public Sub ReceiveDataStart()
'
'    On Error GoTo ErrorHandler
'    Dim sRoutineName As String
'    sRoutineName = Me.Name & ".ReceiveDataStart"
'    Call WriteProcStart(sRoutineName)
'
'
'    'Set the color to Pink, we are receivnig data
'    shpReceave.BackColor = &HC0C0FF
'    shpReceave.Refresh
'
'
'    'Exit the sub... on an error we will jump over this function
'    Exit Sub
'ErrorHandler:
'    Call ErrorTrapper(sRoutineName)
'
'End Sub

Private Sub UserControl_Initialize()

    m_nPort = 3001
    Set m_oGame = New clsGame

End Sub

'(Host Only)  This is the router so if they tried to join here give them a new place to live
Private Sub wnsPort_ConnectionRequest(Index As Integer, ByVal requestID As Long)

    Dim i As Long
    Dim oPlayer As New clsPlayer

    'If their trying to join a socket that isn't closed, close it.  I don't know why you have to do this... it doesn't make sence.  But you do.
    If wnsPort(Index).State <> sckClosed Then wnsPort(Index).Close

    'Accept the connection from the user
    Call wnsPort(Index).Accept(requestID)
    DoEvents
    
    'We leave it to them to announce themselves

End Sub 'End wnsPort connection request

'We have received some data over the network.  Unfortunitly when the winsock protocal
'sends data over the network it concationates the messages if they come with any
'haste whatso ever.  So we have to seperate them.  (Client/Host)
Private Sub wnsPort_DataArrival(Index As Integer, ByVal bytesTotal As Long)

    Dim sIncomingMsg As String

    'Get the data from the socket
    Call wnsPort(Index).GetData(sIncomingMsg, vbString)
    'Process the data
    Call WinsockDataArival(sIncomingMsg, CLng(Index))

End Sub ' End of Winsock_DataArrival

Private Sub wnsPort_Error(Index As Integer, ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)

    'Player has been lost for some reason
    '10054 = Connection reset
    If Number = 10053 Or Number = 438 Or Number = 0 Or Number = 10054 Then

        'Shut down the port, we don't reuse them
        Call wnsPort(Index).Close
        'Call Unload(wnsPort(Index))
        DoEvents

        'Process the message, this will mean dropping the player
        'Call ProcessSingleMessage(g_cRemoveMeCode & Pad(CLng(Index), "0", 2) & g_cMsgDelim, -1)

    Else
        'Close the socket.  Can't have an open socket that isn't doing anything
        wnsPort(Index).Close
        'Call Unload(wnsPort(Index))
        'Raise an error so the error handler will catch it.  Be aware this method will
        'cause the rest of this function to be ignored (which is ok)
        Call Err.Raise(Number, App.EXEName, Description)
    End If

End Sub ' End of wnsPort_Error
'A remote user closed their socket.
Private Sub wnsPort_Close(Index As Integer)

    'Close that socket, we don't need it anymore since noone is on the other end
    Call wnsPort(Index).Close
    'Call Unload(wnsPort(Index))
    DoEvents

    'Process the message, this will mean dropping the player(s)
    'Call ProcessSingleMessage(g_cRemoveMeCode & Pad(CLng(Index), " ", 2) & g_cMsgDelim, CLng(Index))

End Sub ' Exit wnsPort_Close

'This is received when the connection is finalized for the client. (Client)
'Basically the Host has accepted you into the fold.  :)
Private Sub wnsClient_Connect()

    'This means we connected to the router.  Now we wait for a message from the
    'host telling us our new port number to connect to.
    If g_nClientTryingToConnectToPortNumber = m_nBasePort Then
        
    'This means we have connected to our final port
    Else
        'After we connect the host expects us to send our name... its our only reponsability
        'though we should get an inflow of other players names very quickly from the host
        'Call SendData(wnsClient, g_cAddMeCode & Pad(g_nMyNumber, " ", 2) & g_sMyName & g_cMsgDelim & App.Major & "." & App.Minor & "." & App.Revision & g_cMsgDelim)
        '
        ''Also pass down that we think we are the DM
        'If frmConnectStatus.chkIAmTheDM.Value = vbChecked Then
        '    'Pass to the network that I think I am the DM
        '    Call SendData(wnsClient, g_cIAmTheDMCode & Pad(g_nMyNumber, " ", 2) & g_cMsgDelim)
        'End If
    End If

End Sub ' Exit wnsClient_Connect

'We have received some data over the network.  Unfortunitly when the winsock protocal
'sends data over the network it concationates the messages if they come with any
'haste whatso ever.  So we have to seperate them.  (Client/Host)
Private Sub wnsClient_DataArrival(ByVal bytesTotal As Long)

    Dim sIncomingMsg As String

    'Get the data from the socket
    Call wnsClient.GetData(sIncomingMsg, vbString)
    'Process it
    Call WinsockDataArival(sIncomingMsg, 0)

End Sub ' End of wnsClient_DataArrival

Private Sub wnsClient_Error(ByVal Number As Integer, Description As String, ByVal Scode As Long, ByVal Source As String, ByVal HelpFile As String, ByVal HelpContext As Long, CancelDisplay As Boolean)

    Dim i As Long

    'Winsock error 10061 is that the connection can't be made
    'Connection has been lost for some reason
    If Number = 10061 Or Number = 10053 Or Number = 438 Or Number = 0 Then
        'We failed!!!  This should never happen anymore
        If g_nTryNumber = 1 Then
            Call ErrorTrapper(sRoutineName, False, "The Host's Router port is busy.  This means that someone else is currently connectiont to the host.  Please attempt to connect again now.")
        Else
            Call ErrorTrapper(sRoutineName, False, "The port that the Host assigned to you is busy.  Please try to reconnect.")
        End If

        'Close then reopen the port.  Try the next port
        Call wnsClient.Close
        Call wnsClient.Connect(g_sMyIPAddress, g_cHostPort)
    '10054 = Connection reset
    ElseIf Number = 10054 Then
        'For i = 0 To g_objPlayers.Count - 1
        '    'Process the message, this will mean dropping the player
        '    Call ProcessSingleMessage(g_cRemoveMeCode & Pad(i, "0", 2) & g_cMsgDelim, -1)
        'Next i
        Call ErrorTrapper(sRoutineName, False, "The Host has closed your connection.  This means the session crashed, was closed or you were kicked out.")
    Else
        'Close the socket.  Can't have an open socket that isn't doing anything
        wnsClient.Close
        'Raise an error so the error handler will catch it.  Be aware this method will
        'cause the rest of this function to be ignored (which is ok)
        Call Err.Raise(Number, App.EXEName, Description)
    End If

End Sub ' End of wnsClient_Error

'A remote user closed their socket.  (Client,Host)
Private Sub wnsClient_Close()
    
    Dim i As Long

    'Close that socket, we don't need it anymore since noone is on the other end
    Call wnsClient.Close

    If g_nTryNumber = 2 Then
        'If your not the host (i.e. a client), then you need to know the host is gone.
        Call ErrorTrapper(sRoutineName, False, "The Host has dropped or lost your connection.  This" & Chr(13) & "occurs due to a crash or a shut down of the hosts software.")

        ''Remove all the players
        'For i = 0 To g_objPlayers.Count - 1
        '    Call ProcessSingleMessage(g_cRemoveMeCode & Pad(i, "0", 2) & g_cMsgDelim, -1)
        'Next i
    End If

End Sub ' Exit wnsClient_Close

'This handles data arival for all winsock ports
Private Sub WinsockDataArival(sOriginalMsg As String, nPort As Long)
    
    Dim oMsg As clsMessage
    Dim sMsg As String
    Dim nStartOfNextMsg As Long
    Dim nEndOfThisMsg As Long
    Dim sRemainingMsg As String
    Dim oPlayer As clsPlayer

    'Loop while their is still message to parse out
    sRemainingMsg = sOriginalMsg

    Set oPlayer = m_oGame.FindPlayer(nPort)
    'What if this message is "AddMe"?
    If oPlayer = Nothing Then
        'This means more than likely it IS add me.
        If m_bHost = False Then
            Call Err.Raise(-1, "WinsockDataArival", "Received message from a non-existant player that isn't an Add New Player message.")
        Else
            Set oPlayer = New clsPlayer
            oPlayer.Port = -1
        End If
    Else
    
    'Was their any peices of message we needed to add to this?
    sRemainingMsg = oPlayer.PartialMessage & sRemainingMsg
    oPlayer.PartialMessage.PartialMsg = ""

    While Len(sRemainingMsg) > 0
        
        'Pull out the start location of the next message (determined by the g_cMsgHeader
        nStartOfNextMsg = InStr(2, sRemainingMsg, g_cMsgHeader) - 1
        nEndOfThisMsg = InStr(2, sRemainingMsg, g_cMsgTrailer) - 1
        'Is their another message after this one or is this the last?
        If nEndOfThisMsg <= 0 Or InStr(1, sRemainingMsg, g_cMsgHeader) > nEndOfThisMsg Then
            'The end of this message is not in this packet....
            oPlayer.PartialMessage = oPlayer.PartialMessage & sRemainingMsg
            sRemainingMsg = ""

        ElseIf nStartOfNextMsg > 0 Then
            'Get the next message
            sMsg = Mid(sRemainingMsg, Len(g_cMsgHeader) + 1, nStartOfNextMsg - Len(g_cMsgHeader) - Len(g_cMsgTrailer))
            'Remove this current message from the remaining message
            sRemainingMsg = Right(sRemainingMsg, Len(sRemainingMsg) - nEndOfThisMsg - Len(g_cMsgHeader))
        Else
            'Their is no more so copy over this one
            sMsg = Mid(sRemainingMsg, Len(g_cMsgHeader) + 1, Len(sRemainingMsg) - Len(g_cMsgHeader) - Len(g_cMsgTrailer))
            sRemainingMsg = ""
        End If 'End of 'Is their any more?'

        'Pass this new message and the socket that sent it to us to be processed
        If Len(sMsg) > 0 Then
            Set oMsg = New clsMessage
            Call oMsg.ParseMessage(sMsg)
            
            'Was this message from a new player?
            If oPlayer.Port = -1 And oMsg.MsgType = g_cAddPlayerCode Then
                oPlayer.Port = nPort
                oPlayer.Name = oMsg.Paramater(0)
            ElseIf oPlayer.Port - 1 Then
                Call Err.Raise(-1, "WinsockDataArival", "Received message from a non-existant player that isn't an Add New Player message.")
            Else
                RaiseEvent MessageReceived(oMsg, oPlayer)
            End If
            
            sMsg = ""
            Set oMsg = Nothing
        End If

    Wend ' End of Is their any more message?

End Sub
Private Sub AddPlayer(oPlayer As clsPlayer)
    
    'If were host we have to inform everyone else that their is a new player
    If m_bHost = True Then
        Call SendMessage(g_cAddPlayerCode, oPlayer.Name)
    End If
    
    RaiseEvent PlayerAdded(oPlayer)
    
End Sub
