VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsClasses"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "clsClasss"

Private m_colClasses As New Collection

Public Sub AddClass(oClass As clsClass)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".AddClass"
    Call WriteProcStart(sRoutineName)


    Call m_colClasses.Add(oClass, CStr(oClass.m_nClassID))


    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Public Sub PopulateWithList(oListboxOrComboBox As Object)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".PopulateWithList"
    Call WriteProcStart(sRoutineName)


    Dim oLoopClass As clsClass
    
    If Not TypeOf oListboxOrComboBox Is FOTAComboBox Then
        Call oListboxOrComboBox.Clear
    End If
    
    For Each oLoopClass In m_colClasses
        If TypeOf oListboxOrComboBox Is FOTAComboBox Or TypeOf oListboxOrComboBox Is FOTAListControl Then
            Call oListboxOrComboBox.AddItemWithKey(oLoopClass.m_sClassName, CStr(oLoopClass.m_nClassID))
        Else
            Call oListboxOrComboBox.AddItem(oLoopClass.m_sClassName)
            oListboxOrComboBox.ItemData(oListboxOrComboBox.NewIndex) = oLoopClass.m_nClassID
        End If
    Next oLoopClass


    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Public Function Init(oDB As ADODB.Connection)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Init"
    Call WriteProcStart(sRoutineName)


    Dim oRSet As ADODB.Recordset
    Dim oClass As clsClass

    Set oRSet = OpenMyRset(oDB, "SELECT nClassID FROM Classes")
    Call oRSet.MoveFirst
    While oRSet.EOF() = False
        Set oClass = New clsClass
        Call oClass.Load(oDB, oRSet![nClassID])
        Call m_colClasses.Add(oClass)
        Call oRSet.MoveNext
    Wend


    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function
Public Function GetClassByID(nClassID As Long) As clsClass

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetClassByID"
    Call WriteProcStart(sRoutineName)


    Dim oLoopClass As clsClass
    For Each oLoopClass In m_colClasses
        If oLoopClass.m_nClassID = nClassID Then
            Set GetClassByID = oLoopClass
        End If
    Next oLoopClass


    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function
