VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsItems"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "clsItems"

'Constant used for serializing and deserializing this character
Private Const m_cItemSep As String = "[M ]"

Private m_nCharacterID As Long
Private m_colItems As New Collection

Public Sub Remove(sGUID As String)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Remove"
    Call WriteProcStart(sRoutineName)
    
    
    Call m_colItems.Remove(sGUID)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub RemoveAll()
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".RemoveAll"
    Call WriteProcStart(sRoutineName)
    
    
    While m_colItems.Count() > 0
        Call m_colItems.Remove(1)
    Wend


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Function Col() As Collection
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Col"
    Call WriteProcStart(sRoutineName)
    
    
    Set Col = m_colItems


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Function Name() As String
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = "clsItems.Name"
    Call WriteProcStart(sRoutineName)
    
    
    Name = "clsItems"


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Sub Load(dbDND As ADODB.Connection, nCharacterID As Long)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Load"
    Call WriteProcStart(sRoutineName)
    
    
    Dim rstItems As ADODB.Recordset
    Dim oItem As clsItem
    
    'Empty out any Items we already have
    Call RemoveAll
    
    m_nCharacterID = nCharacterID
    Set rstItems = OpenMyRecordset(dbDND, "SELECT * FROM CharacterItems WHERE CharacterID = " & m_nCharacterID)
    
    If rstItems.RecordCount > 0 Then
        Call rstItems.MoveFirst
    
        While rstItems.EOF = False
            Set oItem = New clsItem
            Call oItem.Load(dbDND, rstItems![ItemID])
            Call Add(oItem)
        
            Call rstItems.MoveNext
        Wend
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub Add(oItem As clsItem)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Item"
    Call WriteProcStart(sRoutineName) ' "OBJECT")
    
    
    Call m_colItems.Add(oItem, oItem.m_sGUID)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub Save(dbDND As ADODB.Connection)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Save"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oItem As clsItem
    
    'No go and save all the Items in this collection
    For Each oItem In m_colItems
        Call oItem.Save(dbDND)
    Next oItem
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Function Serialize() As String

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Serialize"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oItem As clsItem
    
    'No go and save all the Items in this collection
    For Each oItem In m_colItems
        Serialize = Serialize & oItem.Serialize() & m_cItemSep
    Next oItem
    
    
    Call WriteProcStop(sRoutineName) ' Serialize)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Function FindItemByName(sName As String) As clsItem

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".FindItemByName"
    Call WriteProcStart(sRoutineName) ' sGUID)


    Dim oLoopItem As clsItem
    
    For Each oLoopItem In m_colItems
        If oLoopItem.ItemName() = sName Then
            Set FindItemByName = oLoopItem
        End If
    Next oLoopItem
        
    
    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Function FindItem(sGUID As String) As clsItem

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".FindItem"
    Call WriteProcStart(sRoutineName) ' sGUID)


    Dim oLoopItem As clsItem
    
    For Each oLoopItem In m_colItems
        If oLoopItem.m_sGUID = sGUID Then
            Set FindItem = oLoopItem
        End If
    Next oLoopItem
        
    
    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function
Public Function GetItemByID(nID As Long) As clsItem

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetItemByID"
    Call WriteProcStart(sRoutineName) ' sGUID)


    Dim oLoopItem As clsItem
    
    For Each oLoopItem In m_colItems
        If oLoopItem.m_nItemID = nID Then
            Set GetItemByID = oLoopItem
        End If
    Next oLoopItem
        
    
    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Function DeSerialize(sItem As String) As String

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".DeSerialize"
    Call WriteProcStart(sRoutineName) ' sItem)


    Dim sRemStr As String
    Dim sTemp As String
    Dim sGUID As String
    Dim oItem As clsItem
    sRemStr = sItem
    
    Call RemoveAll
    
    While InStr(1, sRemStr, m_cItemSep) > 0
        'This is our item!
        sGUID = Left(sRemStr, InStr(1, sRemStr, m_cItemSep) - 1)
        sTemp = Left(sRemStr, InStr(sRemStr, m_cItemSep) - 1)
            sRemStr = Right(sRemStr, Len(sRemStr) - InStr(sRemStr, m_cItemSep) - Len(m_cItemSep) + 1)
        Set oItem = FindItem(sGUID)
        
        'We didn't find it so it must be new
        If oItem Is Nothing Then
            Set oItem = New clsItem
            Call Add(oItem)
        End If
        
        'Populate it and continue the loop
        Call oItem.DeSerialize(sTemp)
    Wend
    
    
    Call WriteProcStop(sRoutineName) ' sRemStr)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

