VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTables"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "clsTables"

Private m_oTables As New clsFOTAArray
Private m_colTables As New Collection

Public Property Get Col() As Collection

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Col"
    Call WriteProcStart(sRoutineName)
   
    
    Set Col = m_colTables
        
    
    Call WriteProcStop(sRoutineName)
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Property

Public Property Get GetIndex() As clsFOTAArray

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetIndex"
    Call WriteProcStart(sRoutineName)
   
       
    Set GetIndex = m_oTables
        
    
    Call WriteProcStop(sRoutineName)
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Property

Public Function GetTableByFile(sFileName As String) As clsTable

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetTableByFile"
    Call WriteProcStart(sRoutineName) ' sFName, sTableName)
   
       
    Dim oLoopTable As clsTable
    
    For Each oLoopTable In m_colTables
        If oLoopTable.m_sFileName = sFileName Then
            Exit For
        End If
    Next oLoopTable
    
    If oLoopTable Is Nothing Then
        Set oLoopTable = LoadTableByNode(m_oTables.GetTextForKey(sFileName))
    End If
    
    Set GetTableByFile = oLoopTable
        
    
    Call WriteProcStop(sRoutineName)
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function
Public Function GetTableByNode(sNodeName As String) As clsTable

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetTableByNode"
    Call WriteProcStart(sRoutineName) ' sFName, sTableName)
   
       
    Dim oLoopTable As clsTable
    
    For Each oLoopTable In m_colTables
        If oLoopTable.m_sNodeName = sNodeName Then
            Exit For
        End If
    Next oLoopTable
    
    If oLoopTable Is Nothing Then
        Set oLoopTable = LoadTableByNode(sNodeName)
    End If
    
    Set GetTableByNode = oLoopTable
        
    
    Call WriteProcStop(sRoutineName)
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function
Public Function LoadTableByNode(sNodeName As String) As clsTable

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LoadTable"
    Call WriteProcStart(sRoutineName) ' sFName, sTableName)
   
   
    Dim nFile As Long
    Dim oTable As clsTable
    Dim sFileName As String
    Dim saNewTable() As String, sTemp As String
    Dim nX As Long, nTempX As Long, nY As Long
   
    sFileName = m_oTables.GetFirstKeyForText(sNodeName)
   
    If Dir(g_cDATADIR & sFileName) <> "" Then
    
        nFile = FreeFile
        Open g_cDATADIR & sFileName For Input As #nFile
        
            Input #nFile, nX
            nY = 0

            While EOF(nFile) = False
                nY = nY + 1
                ReDim Preserve saNewTable(1 To nX, 1 To nY) As String
                For nTempX = 1 To nX
                    Input #nFile, sTemp
                    sTemp = SearchAndReplace(sTemp, Chr(9), " ")
                    saNewTable(nTempX, nY) = sTemp
                Next nTempX
            Wend
            
        Close #nFile

        Set oTable = New clsTable
        oTable.AllData() = saNewTable
        oTable.m_sFileName = sFileName
        oTable.m_sNodeName = sNodeName
        Call m_colTables.Add(oTable, sFileName)
        Set LoadTableByNode = oTable
    Else
        Call g_oErrors.AddError("Unable to locate OnlineReference table " & sNodeName & " (" & g_cDATADIR & sFileName & ") file, unable to preceed.", -1, sRoutineName): GoTo ErrorHandler
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function

Private Sub Class_Initialize()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Class_Initialize"
    Call WriteProcStart(sRoutineName) ' sFindNodeName)


    Dim nFreeFile As Long
    Dim nChildOf As Long, nKey As Long
    Dim sFileName As String
    Dim sMessage As String
    Dim sNodeName As String, sTableName As String

    sFileName = g_cDATADIR & "OnlineR.DAT"

    If Dir(sFileName) <> "" Then
        nFreeFile = FreeFile
        Open sFileName For Input As #nFreeFile
        Input #nFreeFile, sMessage

            While EOF(nFreeFile) = False
                Input #nFreeFile, nKey, nChildOf, sNodeName

                If nChildOf < 0 Then
                    Input #nFreeFile, sTableName
                    Call m_oTables.Add(sNodeName, sTableName)
                End If
            Wend

        Close #nFreeFile
    Else
        Call Err.Raise(-1, "DNDOnline.clsTables.Initialize", "Unable to locate <" & sFileName & ">")
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
