VERSION 5.00
Begin VB.UserControl FOTAComboBox 
   ClientHeight    =   555
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   3825
   ScaleHeight     =   555
   ScaleWidth      =   3825
   ToolboxBitmap   =   "FOTAComboBox.ctx":0000
   Begin VB.ComboBox cboInternal 
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Text            =   "cboInternal"
      Top             =   0
      Width           =   3495
   End
End
Attribute VB_Name = "FOTAComboBox"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Event Declarations:
Event Change()
Event Click() 'MappingInfo=cboInternal,cboInternal,-1,Click
Attribute Click.VB_Description = "Occurs when the user presses and then releases a mouse button over an object."
Event DblClick() 'MappingInfo=cboInternal,cboInternal,-1,DblClick
Attribute DblClick.VB_Description = "Occurs when the user presses and releases a mouse button and then presses and releases it again over an object."
Event KeyDown(KeyCode As Integer, Shift As Integer) 'MappingInfo=cboInternal,cboInternal,-1,KeyDown
Attribute KeyDown.VB_Description = "Occurs when the user presses a key while an object has the focus."
Event KeyPress(KeyAscii As Integer) 'MappingInfo=cboInternal,cboInternal,-1,KeyPress
Attribute KeyPress.VB_Description = "Occurs when the user presses and releases an ANSI key."
Event KeyUp(KeyCode As Integer, Shift As Integer) 'MappingInfo=cboInternal,cboInternal,-1,KeyUp
Attribute KeyUp.VB_Description = "Occurs when the user releases a key while an object has the focus."


'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' My Stuff
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private m_sInitText As String
Private m_nLastValidIndex As Long
Private m_bPreventTyping As Boolean

Private m_nMax As Long
Private m_saPrimaryKey() As String
Private m_nAutoIncrament As Long
'Default Property Values:
Const m_def_Name = ""
'Property Variables:
Dim m_Name As String


'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=cboInternal,cboInternal,-1,BackColor
Public Property Get BackColor() As OLE_COLOR
Attribute BackColor.VB_Description = "Returns/sets the background color used to display text and graphics in an object."
    BackColor = cboInternal.BackColor
End Property

Public Property Let BackColor(ByVal New_BackColor As OLE_COLOR)
    cboInternal.BackColor() = New_BackColor
    PropertyChanged "BackColor"
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=cboInternal,cboInternal,-1,ForeColor
Public Property Get ForeColor() As OLE_COLOR
Attribute ForeColor.VB_Description = "Returns/sets the foreground color used to display text and graphics in an object."
    ForeColor = cboInternal.ForeColor
End Property

Public Property Let ForeColor(ByVal New_ForeColor As OLE_COLOR)
    cboInternal.ForeColor() = New_ForeColor
    PropertyChanged "ForeColor"
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=cboInternal,cboInternal,-1,Enabled
Public Property Get Enabled() As Boolean
Attribute Enabled.VB_Description = "Returns/sets a value that determines whether an object can respond to user-generated events."
    Enabled = cboInternal.Enabled
End Property

Public Property Let Enabled(ByVal New_Enabled As Boolean)
    cboInternal.Enabled() = New_Enabled
    PropertyChanged "Enabled"
End Property

Public Property Get PreventTyping() As Boolean
    PreventTyping = m_bPreventTyping
End Property

Public Property Let PreventTyping(ByVal bPreventTyping As Boolean)
    m_bPreventTyping = bPreventTyping
End Property


'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=cboInternal,cboInternal,-1,Font
Public Property Get Font() As Font
Attribute Font.VB_Description = "Returns a Font object."
Attribute Font.VB_UserMemId = -512
    Set Font = cboInternal.Font
End Property

Public Property Set Font(ByVal New_Font As Font)
    Set cboInternal.Font = New_Font
    PropertyChanged "Font"
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=cboInternal,cboInternal,-1,Refresh
Public Sub Refresh()
Attribute Refresh.VB_Description = "Forces a complete repaint of a object."
    cboInternal.Refresh
End Sub

Private Sub cboInternal_Change()

    If m_bPreventTyping = True Then
        If m_nLastValidIndex = -1 Then
            If cboInternal.ListIndex = -1 Then
                cboInternal.Text = m_sInitText
            Else
                m_nLastValidIndex = cboInternal.ListIndex
            End If
        Else
            If cboInternal.ListIndex = -1 Then
                cboInternal.ListIndex = m_nLastValidIndex
            Else
                m_nLastValidIndex = cboInternal.ListIndex
            End If
        End If
    End If
    
    RaiseEvent Change
End Sub

Private Sub cboInternal_Click()

    If m_bPreventTyping = True Then
        If m_nLastValidIndex = -1 Then
            If cboInternal.ListIndex = -1 Then
                cboInternal.Text = m_sInitText
            Else
                m_nLastValidIndex = cboInternal.ListIndex
            End If
        Else
            If cboInternal.ListIndex = -1 Then
                cboInternal.ListIndex = m_nLastValidIndex
            Else
                m_nLastValidIndex = cboInternal.ListIndex
            End If
        End If
    End If
    
    RaiseEvent Click
End Sub

Private Sub cboInternal_DblClick()
    RaiseEvent DblClick
End Sub

Private Sub cboInternal_KeyDown(KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyDown(KeyCode, Shift)
End Sub

Private Sub cboInternal_KeyPress(KeyAscii As Integer)
    RaiseEvent KeyPress(KeyAscii)
End Sub

Private Sub cboInternal_KeyUp(KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyUp(KeyCode, Shift)
End Sub

Private Sub UserControl_Initialize()
    m_nLastValidIndex = -1
End Sub

'Load property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    cboInternal.BackColor = PropBag.ReadProperty("BackColor", &H80000005)
    cboInternal.ForeColor = PropBag.ReadProperty("ForeColor", &H80000008)
    cboInternal.Enabled = PropBag.ReadProperty("Enabled", True)
    Set cboInternal.Font = PropBag.ReadProperty("Font", Ambient.Font)
    cboInternal.Text = PropBag.ReadProperty("Text", "")
    m_sInitText = cboInternal.Text
    cboInternal.Locked = PropBag.ReadProperty("Locked", False)
    m_bPreventTyping = PropBag.ReadProperty("PreventTyping", False)
End Sub
Private Sub UserControl_Resize()
    cboInternal.Width = UserControl.Width
    UserControl.Height = cboInternal.Height
End Sub
'Write property values to storage
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    Call PropBag.WriteProperty("BackColor", cboInternal.BackColor, &H80000005)
    Call PropBag.WriteProperty("ForeColor", cboInternal.ForeColor, &H80000008)
    Call PropBag.WriteProperty("Enabled", cboInternal.Enabled, True)
    Call PropBag.WriteProperty("Font", cboInternal.Font, Ambient.Font)
    Call PropBag.WriteProperty("Text", cboInternal.Text, "")
    Call PropBag.WriteProperty("Locked", cboInternal.Locked, "")
    Call PropBag.WriteProperty("PreventTyping", m_bPreventTyping, False)
End Sub
Public Sub AddItemWithKey(strString As String, strKey As String)

    'Did they find a key?  No?  Make one.
    If m_nAutoIncrament >= m_nMax Then
        m_nMax = (m_nMax + 1) * 2
        ReDim Preserve m_saPrimaryKey(0 To m_nMax) As String
    End If

    'Add the item to the list control
    Call cboInternal.AddItem(strString)
    cboInternal.ItemData(cboInternal.NewIndex) = m_nAutoIncrament
    m_saPrimaryKey(m_nAutoIncrament) = strKey
    'Incrament the autoincramenting (:)) number
    m_nAutoIncrament = m_nAutoIncrament + 1

End Sub

Public Sub RemoveItemCurrent()

    If cboInternal.ListIndex > -1 Then
        RemoveItemByKeyIfFound ( _
                        m_saPrimaryKey(cboInternal.ListIndex) _
                                )
    End If

End Sub
'Remove all entries
Public Sub RemoveAll()

    Dim i As Long
    Dim n As Long
    
    '06/06/2002 Chris Hill  If the listcount is empty then we may not have even initialized
    'some of our internal storage objets yet.  So don't do anything.
    If cboInternal.ListCount > 0 Then
    
        For i = 0 To m_nAutoIncrament
            For n = 0 To cboInternal.ListCount - 1
                'If we remove items... the list box count will be off
                If n >= cboInternal.ListCount Then Exit For
                'Does this players ID match the one were deleting?
                If i = cboInternal.ItemData(n) Then
                    m_saPrimaryKey(i) = ""
                    Call cboInternal.RemoveItem(n)
                    n = n - 1
                End If
            Next n 'Move to the next player
        Next i
        
    End If
        
End Sub
'Remove a name from a list box where the id matches the item data.  Return weather
'or not we removed anyone.
Public Function RemoveItemByKeyIfFound(strKey As String) As Boolean
    
    Dim i As Long
    Dim n As Long
    RemoveItemByKeyIfFound = False
    
    '06/06/2002 Chris Hill  If the listcount is empty then we may not have even initialized
    'some of our internal storage objets yet.  So don't do anything.
    If cboInternal.ListCount > 0 Then
    
        For i = 0 To m_nAutoIncrament
            If m_saPrimaryKey(i) = strKey Then
                
                For n = 0 To cboInternal.ListCount - 1
                    'If we remove items... the list box count will be off
                    If n >= cboInternal.ListCount Then Exit For
                    'Does this players ID match the one were deleting?
                    If i = cboInternal.ItemData(n) Then
                        m_saPrimaryKey(i) = ""
                        Call cboInternal.RemoveItem(n)
                        RemoveItemByKeyIfFound = True
                        n = n - 1
                    End If
                Next n 'Move to the next player
                
            End If
        Next i
    
    End If
    
End Function
'Remove a name from a list box where the id matches the item data.  Return weather
'or not we removed anyone.
Public Function RemoveItemByTextIfFound(strText As String) As Boolean
    
    Dim i As Long
    RemoveItemByTextIfFound = False
    
    For i = 0 To cboInternal.ListCount - 1
        'If we remove items... the list box count will be off
        If i >= cboInternal.ListCount Then Exit For
        'Does this players ID match the one were deleting?
        If strText = cboInternal.List(i) Then
            m_saPrimaryKey(cboInternal.ItemData(i)) = ""
            Call cboInternal.RemoveItem(i)
            i = i - 1
            RemoveItemByTextIfFound = True
        End If
    Next i 'Move to the next player

End Function
Public Function IsInListBoxKeyText(strText As String) As Boolean

    Dim i As Long
    IsInListBoxKeyText = False
    
    'Are their any enteries?
    If cboInternal.ListCount > 0 Then

        'Step through every player in the list box
        For i = 0 To cboInternal.ListCount - 1
            'Does this players ID match the one were deleting?
            If strText = cboInternal.List(i) Then
                'Record that we removed them
                IsInListBoxKeyText = True
                Exit Function
            End If
        Next i 'Move to the next player
        
    End If
        
End Function
'Is this text in the list box?
Public Function IsInListBoxKey(strKey As String) As Boolean

    Dim i As Long
    IsInListBoxKey = False

    If cboInternal.ListCount > 0 Then
        'Step through every player in the list box
        For i = 0 To m_nAutoIncrament

            'Does this players ID match the one were deleting?
            If m_saPrimaryKey(i) = strKey Then
                'Record that we removed them
                IsInListBoxKey = True
                Exit Function
            End If
    
        Next i 'Move to the next player
    End If

End Function
'Is this text in the list box?
Public Sub SelItemByKey(strKey As String)

    Dim i As Long
    Dim n As Long
    Dim bFound As Boolean

    bFound = False

    If cboInternal.ListCount > 0 Then
        'Step through every player in the list box
        For i = 0 To m_nAutoIncrament
    
            'Does this players ID match the one were deleting?
            If m_saPrimaryKey(i) = strKey Then
                'Now search for the index of the key we found
                For n = 0 To cboInternal.ListCount - 1
                    If cboInternal.ItemData(n) = i Then
                        ListIndex = n
                        bFound = True
                    End If
                Next n
            End If

        Next i 'Move to the next player
        
        If bFound = False Then
            cboInternal.ListIndex = -1
        End If
    End If

End Sub

Public Function GetCurrentSelectedItemsKey() As String

    Dim nIndex As Long
    If cboInternal.ListIndex = -1 Then
        GetCurrentSelectedItemsKey = ""
    Else
        nIndex = cboInternal.ItemData(cboInternal.ListIndex)
        GetCurrentSelectedItemsKey = m_saPrimaryKey(nIndex)
    End If

End Function
Public Property Let Text(sNewText As String)
    cboInternal.Text = sNewText
End Property
Public Property Get Text() As String
    Text = cboInternal.Text
End Property

Public Property Let ListIndex(nListIndex As Long)
    cboInternal.ListIndex = nListIndex
End Property
Public Property Get ListIndex() As Long
    ListIndex = cboInternal.ListIndex
End Property

Public Function ListCount() As Long
    ListCount = cboInternal.ListCount
End Function

Public Sub AddItem(sText As String)
    cboInternal.AddItem (sText)
End Sub
Public Property Get ItemData(nIndex As Long) As Long
    ItemData = cboInternal.ItemData(nIndex)
End Property
Public Property Let ItemData(nIndex As Long, nItemData As Long)
    cboInternal.ItemData(nIndex) = nItemData
End Property

'Gets the ist box index for the key
Public Function GetLstIndexForKey(sKey As String) As Long

    Dim i As Long
    Dim n As Long
    GetLstIndexForKey = -1

    i = GetIndexForKey(sKey)
    
    'Now search for the index of the key we found
    For n = 0 To cboInternal.ListCount - 1
        If cboInternal.ItemData(n) = i Then
            GetLstIndexForKey = n
            Exit Function
        End If
    Next n

End Function

'Gets the internal index for the key
Public Function GetIndexForKey(sKey As String) As Long

    Dim i As Long
    GetIndexForKey = -1

    If cboInternal.ListCount > 0 Then
        'Step through every player in the list box
        For i = 0 To m_nAutoIncrament
    
            'Does this players ID match the one were deleting?
            If m_saPrimaryKey(i) = sKey Then
                'Record that we removed them
                GetIndexForKey = i
                Exit Function
            End If
    
        Next i 'Move to the next player
    End If

End Function

Public Property Get ListByKey(sKey As String) As String
    Dim nIndex As Long
    nIndex = GetLstIndexForKey(sKey)
    If nIndex > -1 Then
        ListByKey = cboInternal.List(nIndex)
    End If
End Property
Public Property Let ListByKey(sKey As String, sNewStr As String)
    Dim nIndex As Long
    nIndex = GetLstIndexForKey(sKey)
    If nIndex > -1 Then
        cboInternal.List(nIndex) = sNewStr
    End If
End Property


Public Property Get List(nIndex As Long) As String
    List = cboInternal.List(nIndex)
End Property
Public Property Let List(nIndex As Long, sNewStr As String)
    cboInternal.List(nIndex) = sNewStr
End Property

Public Property Get NewIndex() As Long
    NewIndex = cboInternal.NewIndex
End Property

Public Property Let Locked(bLocked As Boolean)
    cboInternal.Locked = bLocked
End Property
Public Property Get Locked() As Boolean
    Locked = cboInternal.Locked
End Property
