VERSION 5.00
Begin VB.UserControl FOTAListControl 
   ClientHeight    =   2430
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2445
   ScaleHeight     =   2430
   ScaleWidth      =   2445
   ToolboxBitmap   =   "FOTAListControl.ctx":0000
   Begin VB.ListBox lstInternal 
      Height          =   1860
      Index           =   5
      ItemData        =   "FOTAListControl.ctx":0312
      Left            =   0
      List            =   "FOTAListControl.ctx":0314
      Sorted          =   -1  'True
      Style           =   1  'Checkbox
      TabIndex        =   5
      Top             =   0
      Width           =   2430
   End
   Begin VB.ListBox lstInternal 
      Height          =   1620
      Index           =   4
      ItemData        =   "FOTAListControl.ctx":0316
      Left            =   0
      List            =   "FOTAListControl.ctx":0318
      MultiSelect     =   2  'Extended
      Sorted          =   -1  'True
      TabIndex        =   4
      Top             =   0
      Visible         =   0   'False
      Width           =   2430
   End
   Begin VB.ListBox lstInternal 
      Height          =   1620
      Index           =   3
      ItemData        =   "FOTAListControl.ctx":031A
      Left            =   0
      List            =   "FOTAListControl.ctx":031C
      Sorted          =   -1  'True
      TabIndex        =   3
      Top             =   0
      Visible         =   0   'False
      Width           =   2430
   End
   Begin VB.ListBox lstInternal 
      Height          =   1620
      Index           =   1
      ItemData        =   "FOTAListControl.ctx":031E
      Left            =   0
      List            =   "FOTAListControl.ctx":0320
      MultiSelect     =   2  'Extended
      TabIndex        =   2
      Top             =   0
      Visible         =   0   'False
      Width           =   2430
   End
   Begin VB.ListBox lstInternal 
      Height          =   1860
      Index           =   2
      ItemData        =   "FOTAListControl.ctx":0322
      Left            =   0
      List            =   "FOTAListControl.ctx":0324
      Style           =   1  'Checkbox
      TabIndex        =   1
      Top             =   0
      Visible         =   0   'False
      Width           =   2430
   End
   Begin VB.ListBox lstInternal 
      Height          =   2205
      Index           =   0
      ItemData        =   "FOTAListControl.ctx":0326
      Left            =   0
      List            =   "FOTAListControl.ctx":0328
      TabIndex        =   0
      Top             =   0
      Width           =   2430
   End
End
Attribute VB_Name = "FOTAListControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'Event Declarations:
Event Resize()
Attribute Resize.VB_Description = "Occurs when the user presses and then releases a mouse button over an object."
Event Click() 'MappingInfo=lstInternal,lstInternal,-1,Click
Event DblClick() 'MappingInfo=lstInternal,lstInternal,-1,DblClick
Event KeyDown(KeyCode As Integer, Shift As Integer) 'MappingInfo=lstInternal,lstInternal,-1,KeyDown
Event KeyPress(KeyAscii As Integer) 'MappingInfo=lstInternal,lstInternal,-1,KeyPress
Event KeyUp(KeyCode As Integer, Shift As Integer) 'MappingInfo=lstInternal,lstInternal,-1,KeyUp
Event MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single) 'MappingInfo=lstInternal,lstInternal,-1,MouseDown
Event MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single) 'MappingInfo=lstInternal,lstInternal,-1,MouseMove
Event MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single) 'MappingInfo=lstInternal,lstInternal,-1,MouseUp
Event Scroll() 'MappingInfo=lstInternal,lstInternal,-1,Scroll
Event ItemCheck(Item As Integer) 'MappingInfo=lstInternal,lstInternal,-1,ItemCheck

Public Enum enumStyle
    Standard = 0
    CheckBox = 1
End Enum

Public Enum enumMulitSelect
    None = 0
    Simple = 1
    Extended = 2
End Enum

Private Const m_cNUMLST As Long = 5

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' My Stuff
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private m_nMax As Long
Private m_saPrimaryKey() As String
Private m_nAutoIncrament As Long
'Default Property Values:
Private Const m_def_Name = ""
'Property Variables:
Private m_Name As String
Private m_nStyle As Long
Private m_nMultiSelect As enumMulitSelect
Private m_bSorted As Boolean

Private m_bChangingStyle As Boolean

Private Sub UserControl_Initialize()
    ReDim Preserve m_saPrimaryKey(0 To m_nMax) As String
End Sub

Public Sub AddItemWithKey(strString As String, strKey As String)

    Dim i As Long

    'Did they find a key?  No?  Make one.
    If m_nAutoIncrament > m_nMax Then
        m_nMax = (m_nMax + 1) * 2
        ReDim Preserve m_saPrimaryKey(0 To m_nMax) As String
    End If

    'Add the item to the list control
    For i = 0 To m_cNUMLST
        Call lstInternal(i).AddItem(strString)
        lstInternal(i).ItemData(lstInternal(i).NewIndex) = m_nAutoIncrament
    Next i
    
    m_saPrimaryKey(m_nAutoIncrament) = strKey
    'Incrament the autoincramenting (:)) number
    m_nAutoIncrament = m_nAutoIncrament + 1

End Sub
Public Sub RemoveItemCurrent()

    If GetListBox().ListIndex() > -1 Then
        RemoveItemByKeyIfFound ( _
                        m_saPrimaryKey(GetListBox().ListIndex()) _
                                )
    End If

End Sub
'Remove a name from a list box where the id matches the item data.  Return weather
'or not we removed anyone.
Public Function RemoveItemByKeyIfFound(strKey As String) As Boolean
    
    Dim i As Long
    RemoveItemByKeyIfFound = False
    
    If GetListBox().ListCount > 0 Then
        For i = 0 To GetListBox().ListCount - 1
            If i >= GetListBox().ListCount Then Exit For
            If m_saPrimaryKey(GetListBox().ItemData(i)) = strKey Then
                RemoveItemByKeyIfFound = True
                m_saPrimaryKey(GetListBox().ItemData(i)) = ""
                Call GetListBox().RemoveItem(i)
                i = i - 1
            End If
        Next i
    End If
    
End Function
'Remove a name from a list box where the id matches the item data.  Return weather
'or not we removed anyone.
Public Function RemoveItemByTextIfFound(strText As String) As Boolean
    
    Dim i As Long
    RemoveItemByTextIfFound = False
    
    For i = 0 To GetListBox().ListCount - 1
        'If we remove items... the list box count will be off
        If i >= GetListBox().ListCount Then Exit For
        'Does this players ID match the one were deleting?
        If strText = GetListBox().List(i) Then
            m_saPrimaryKey(GetListBox().ItemData(i)) = ""
            Call GetListBox().RemoveItem(i)
            i = i - 1
            RemoveItemByTextIfFound = True
        End If
    Next i 'Move to the next player

End Function
'Is this text in the list box?
Public Function IsInListBoxKey(strKey As String) As Boolean

    Dim i As Long
    IsInListBoxKey = False

    'Step through every player in the list box
    For i = 0 To m_nAutoIncrament - 1
        'Does this players ID match the one were deleting?
        If m_saPrimaryKey(i) = strKey Then
            'Record that we removed them
            IsInListBoxKey = True
            Exit Function
        End If
    Next i 'Move to the next player

End Function
'Is this text in the list box?
Public Function IsInListBoxKeyText(strText As String) As Boolean

    Dim i As Long
    IsInListBoxKeyText = False
    
    'Are their any enteries?
    If GetListBox().ListCount > 0 Then

        'Step through every player in the list box
        For i = 0 To GetListBox().ListCount - 1
            'Does this players ID match the one were deleting?
            If strText = GetListBox().List(i) Then
                'Record that we removed them
                IsInListBoxKeyText = True
                Exit Function
            End If
        Next i 'Move to the next player
        
    End If
        
End Function

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'' Wizard Generated Functions
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=lstInternal,lstInternal,-1,ForeColor
Public Property Get ForeColor() As OLE_COLOR
Attribute ForeColor.VB_Description = "Returns/sets the foreground color used to display text and graphics in an object."
    ForeColor = GetListBox().ForeColor
End Property

Public Property Let ForeColor(ByVal New_ForeColor As OLE_COLOR)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).ForeColor() = New_ForeColor
    Next i
    PropertyChanged "ForeColor"
End Property

Public Property Get Enabled() As Boolean
Attribute Enabled.VB_Description = "Returns/sets a value that determines whether an object can respond to user-generated events."
    Enabled = GetListBox().Enabled
End Property
Public Property Let Enabled(ByVal New_Enabled As Boolean)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).Enabled() = New_Enabled
    Next i
    PropertyChanged "Enabled"
End Property

Public Property Get Font() As Font
Attribute Font.VB_Description = "Returns a Font object."
Attribute Font.VB_UserMemId = -512
    Set Font = GetListBox().Font
End Property
Public Property Set Font(ByVal New_Font As Font)
    Dim i As Long
    For i = 0 To m_cNUMLST
        Set lstInternal(i).Font() = New_Font
    Next i
    PropertyChanged "Font"
End Property

Private Sub lstInternal_Click(Index As Integer)
    If m_bChangingStyle = False Then
        RaiseEvent Click
    End If
End Sub

Private Sub lstInternal_DblClick(Index As Integer)
    RaiseEvent DblClick
End Sub

Private Sub lstInternal_KeyDown(Index As Integer, KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyDown(KeyCode, Shift)
End Sub

Private Sub lstInternal_KeyPress(Index As Integer, KeyAscii As Integer)
    RaiseEvent KeyPress(KeyAscii)
End Sub

Private Sub lstInternal_KeyUp(Index As Integer, KeyCode As Integer, Shift As Integer)
    RaiseEvent KeyUp(KeyCode, Shift)
End Sub

Private Sub lstInternal_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseDown(Button, Shift, X, Y)
End Sub

Private Sub lstInternal_MouseMove(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseMove(Button, Shift, X, Y)
End Sub

Private Sub lstInternal_MouseUp(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
    RaiseEvent MouseUp(Button, Shift, X, Y)
End Sub

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=lstInternal,lstInternal,-1,TopIndex
Public Property Get TopIndex() As Integer
Attribute TopIndex.VB_Description = "Returns/sets which item in a control is displayed in the topmost position."
    TopIndex = GetListBox().TopIndex
End Property

Public Property Let TopIndex(ByVal New_TopIndex As Integer)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).TopIndex() = New_TopIndex
    Next i
    PropertyChanged "TopIndex"
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=lstInternal,lstInternal,-1,ToolTipText
Public Property Get ToolTipText() As String
Attribute ToolTipText.VB_Description = "Returns/sets the text displayed when the mouse is paused over the control."
    ToolTipText = GetListBox().ToolTipText
End Property

Public Property Let ToolTipText(ByVal New_ToolTipText As String)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).ToolTipText() = New_ToolTipText
    Next i
    PropertyChanged "ToolTipText"
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=lstInternal,lstInternal,-1,Text
Public Property Get Text() As String
Attribute Text.VB_Description = "Returns/sets the text contained in the control."
    Text = GetListBox().Text
End Property

Public Property Let Text(ByVal New_Text As String)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).Text() = New_Text
    Next i
    PropertyChanged "Text"
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=lstInternal,lstInternal,-1,Sorted
Public Property Get Sorted() As Boolean
Attribute Sorted.VB_Description = "Indicates whether the elements of a control are automatically sorted alphabetically."
    Sorted = GetListBox().Sorted()
End Property
Public Property Let Sorted(bVal As Boolean)
    m_bSorted = bVal
    Call SetVisibility
End Property

'WARNING! DO NOT REMOVE OR MODIFY THE FOLLOWING COMMENTED LINES!
'MappingInfo=lstInternal,lstInternal,-1,Selected
Public Property Get Selected(ByVal Index As Integer) As Boolean
Attribute Selected.VB_Description = "Returns/sets the selection status of an item in a control."
    Selected = GetListBox().Selected(Index)
End Property

Public Property Let Selected(ByVal Index As Integer, ByVal New_Selected As Boolean)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).Selected(Index) = New_Selected
    Next i
    PropertyChanged "Selected"
End Property

'MappingInfo=lstInternal,lstInternal,-1,Selected
Public Property Get SelectedByKey(sKey As String) As Boolean
    Dim nIndex As Long
    nIndex = IndexForKey(sKey)
    SelectedByKey = GetListBox().Selected(nIndex)
End Property

Public Property Let SelectedByKey(sKey As String, ByVal New_Selected As Boolean)

    Dim nIndex As Long
    Dim i As Long
    nIndex = IndexForKey(sKey)
    
    For i = 0 To m_cNUMLST
        lstInternal(i).Selected(nIndex) = New_Selected
    Next i
    PropertyChanged "Selected"
End Property

Public Property Get SelCount() As Integer
Attribute SelCount.VB_Description = "Returns the number of selected items in a ListBox control."
    SelCount = GetListBox().SelCount
End Property

Private Sub lstInternal_Scroll(Index As Integer)
    RaiseEvent Scroll
End Sub

Public Sub RemoveItem(ByVal Index As Integer)
Attribute RemoveItem.VB_Description = "Removes an item from a ListBox or ComboBox control or a row from a Grid control."
    Dim i As Long
    For i = 0 To m_cNUMLST
        Call lstInternal(i).RemoveItem(Index)
    Next i
End Sub

Public Property Get NewIndex() As Integer
Attribute NewIndex.VB_Description = "Returns the index of the item most recently added to a control."
    NewIndex = GetListBox().NewIndex
End Property

Public Property Get MultiSelect() As enumMulitSelect
Attribute MultiSelect.VB_Description = "Returns/sets a value that determines whether a user can make multiple selections in a control."
    MultiSelect = m_nMultiSelect
End Property
Public Property Let MultiSelect(nNewVal As enumMulitSelect)
    m_nMultiSelect = nNewVal
    Call SetVisibility
End Property

Public Property Get MousePointer() As Integer
Attribute MousePointer.VB_Description = "Returns/sets the type of mouse pointer displayed when over part of an object."
    MousePointer = GetListBox().MousePointer()
End Property

Public Property Let MousePointer(ByVal New_MousePointer As Integer)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).MousePointer() = New_MousePointer
    Next i
    PropertyChanged "MousePointer"
End Property

Public Property Get MouseIcon() As Picture
Attribute MouseIcon.VB_Description = "Sets a custom mouse icon."
    Set MouseIcon = GetListBox().MouseIcon()
End Property
Public Property Set MouseIcon(ByVal New_MouseIcon As Picture)
    Dim i As Long
    For i = 0 To m_cNUMLST
        Set lstInternal(i).MouseIcon() = New_MouseIcon
    Next i
    PropertyChanged "MouseIcon"
End Property

Public Property Get ListIndex() As Integer
Attribute ListIndex.VB_Description = "Returns/sets the index of the currently selected item in the control."
    ListIndex = GetListBox().ListIndex()
End Property
Public Property Let ListIndex(ByVal New_ListIndex As Integer)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).ListIndex() = New_ListIndex
    Next i
    PropertyChanged "ListIndex"
End Property

Public Property Get ListCount() As Integer
Attribute ListCount.VB_Description = "Returns the number of items in the list portion of a control."
    ListCount = GetListBox().ListCount()
End Property

Public Property Get List(ByVal Index As Integer) As String
Attribute List.VB_Description = "Returns/sets the items contained in a control's list portion."
    List = GetListBox().List(Index)
End Property
Public Property Let List(ByVal Index As Integer, ByVal New_List As String)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).List(Index) = New_List
    Next i
    PropertyChanged "List"
End Property

Public Property Get ItemData(ByVal Index As Integer) As Long
Attribute ItemData.VB_Description = "Returns/sets a specific number for each item in a ComboBox or ListBox control."
    ItemData = GetListBox().ItemData(Index)
End Property
Public Property Let ItemData(ByVal Index As Integer, ByVal New_ItemData As Long)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).ItemData(Index) = New_ItemData
    Next i
    PropertyChanged "ItemData"
End Property

Private Sub lstInternal_ItemCheck(Index As Integer, Item As Integer)
    RaiseEvent ItemCheck(Item)
End Sub

Public Property Get FontUnderline() As Boolean
Attribute FontUnderline.VB_Description = "Returns/sets underline font styles."
    FontUnderline = GetListBox().FontUnderline()
End Property
Public Property Let FontUnderline(ByVal New_FontUnderline As Boolean)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).FontUnderline() = New_FontUnderline
    Next i
    PropertyChanged "FontUnderline"
End Property

Public Property Get FontStrikethru() As Boolean
Attribute FontStrikethru.VB_Description = "Returns/sets strikethrough font styles."
    FontStrikethru = GetListBox().FontStrikethru()
End Property
Public Property Let FontStrikethru(ByVal New_FontStrikethru As Boolean)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).FontStrikethru() = New_FontStrikethru
    Next i
    PropertyChanged "FontStrikethru"
End Property

Public Property Get FontSize() As Single
Attribute FontSize.VB_Description = "Specifies the size (in points) of the font that appears in each row for the given level."
    FontSize = GetListBox().FontSize()
End Property
Public Property Let FontSize(ByVal New_FontSize As Single)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).FontSize() = New_FontSize
    Next i
    PropertyChanged "FontSize"
End Property

Public Property Get FontName() As String
Attribute FontName.VB_Description = "Specifies the name of the font that appears in each row for the given level."
    FontName = GetListBox().FontName()
End Property
Public Property Let FontName(ByVal New_FontName As String)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).FontName() = New_FontName
    Next i
    PropertyChanged "FontName"
End Property

Public Property Get FontItalic() As Boolean
Attribute FontItalic.VB_Description = "Returns/sets italic font styles."
    FontItalic = GetListBox().FontItalic()
End Property
Public Property Let FontItalic(ByVal New_FontItalic As Boolean)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).FontItalic() = New_FontItalic
    Next i
    PropertyChanged "FontItalic"
End Property

Public Property Get FontBold() As Boolean
Attribute FontBold.VB_Description = "Returns/sets bold font styles."
    FontBold = GetListBox().FontBold()
End Property
Public Property Let FontBold(ByVal New_FontBold As Boolean)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).FontBold() = New_FontBold
    Next i
    PropertyChanged "FontBold"
End Property

Public Sub Clear()
Attribute Clear.VB_Description = "Clears the contents of a control or the system Clipboard."
    Dim i As Long
    For i = 0 To m_cNUMLST
        Call lstInternal(i).Clear
    Next i
End Sub

'Load property values from storage
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)

    Dim Index As Integer
    Dim i As Long

    For i = 0 To m_cNUMLST
        lstInternal(i).ForeColor = PropBag.ReadProperty("ForeColor", &H80000008)
        lstInternal(i).Enabled = PropBag.ReadProperty("Enabled", True)
        Set lstInternal(i).Font = PropBag.ReadProperty("Font", Ambient.Font)
        lstInternal(i).TopIndex = PropBag.ReadProperty("TopIndex", 0)
        lstInternal(i).ToolTipText = PropBag.ReadProperty("ToolTipText", "")
        lstInternal(i).Text = PropBag.ReadProperty("Text", "")
        'lstInternal(i).Selected(Index) = PropBag.ReadProperty("Selected" & Index, 0)
        lstInternal(i).MousePointer = PropBag.ReadProperty("MousePointer", 0)
        Set MouseIcon = PropBag.ReadProperty("MouseIcon", Nothing)
        'lstInternal(i).ListIndex = PropBag.ReadProperty("ListIndex", 0)
        'lstInternal(i).List(Index) = PropBag.ReadProperty("List" & Index, "")
        'lstInternal(i).ItemData(Index) = PropBag.ReadProperty("ItemData" & Index, 0)
        lstInternal(i).FontUnderline = PropBag.ReadProperty("FontUnderline", 0)
        lstInternal(i).FontStrikethru = PropBag.ReadProperty("FontStrikethru", 0)
        lstInternal(i).FontSize = PropBag.ReadProperty("FontSize", 8)
        lstInternal(i).FontName = PropBag.ReadProperty("FontName", "Times New Roman")
        lstInternal(i).FontItalic = PropBag.ReadProperty("FontItalic", 0)
        lstInternal(i).FontBold = PropBag.ReadProperty("FontBold", 0)
        lstInternal(i).BackColor = PropBag.ReadProperty("BackColor", &H80000005)
    Next i
    
    m_Name = PropBag.ReadProperty("Name", m_def_Name)
    Style() = PropBag.ReadProperty("MyStyle", 0)
    MultiSelect() = PropBag.ReadProperty("MyNewMultiSelect", 0)
    Sorted() = PropBag.ReadProperty("MySorted", False)

End Sub

Private Sub UserControl_Resize()
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).Width = UserControl.Width
        lstInternal(i).Height = UserControl.Height
    Next i
    UserControl.Width = lstInternal(0).Width
    UserControl.Height = lstInternal(0).Height
End Sub

'Write property values to storage
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    Dim Index As Integer

    Call PropBag.WriteProperty("BackColor", GetListBox().BackColor, &H80000005)
    Call PropBag.WriteProperty("ForeColor", GetListBox().ForeColor, &H80000008)
    Call PropBag.WriteProperty("Enabled", GetListBox().Enabled, True)
    Call PropBag.WriteProperty("Font", GetListBox().Font, Ambient.Font)
    Call PropBag.WriteProperty("TopIndex", GetListBox().TopIndex, 0)
    Call PropBag.WriteProperty("ToolTipText", GetListBox().ToolTipText, "")
    Call PropBag.WriteProperty("Text", GetListBox().Text, "")
    'Call PropBag.WriteProperty("Selected" & Index, getlistbox().Selected(Index), 0)
    Call PropBag.WriteProperty("MousePointer", GetListBox().MousePointer, 0)
    Call PropBag.WriteProperty("MouseIcon", MouseIcon, Nothing)
    'Call PropBag.WriteProperty("ListIndex", getlistbox().ListIndex, 0)
    Call PropBag.WriteProperty("List" & Index, GetListBox().List(Index), "")
    'Call PropBag.WriteProperty("ItemData" & Index, getlistbox().ItemData(Index), 0)
    Call PropBag.WriteProperty("FontUnderline", GetListBox().FontUnderline, 0)
    Call PropBag.WriteProperty("FontStrikethru", GetListBox().FontStrikethru, 0)
    Call PropBag.WriteProperty("FontSize", GetListBox().FontSize, 0)
    Call PropBag.WriteProperty("FontName", GetListBox().FontName, "")
    Call PropBag.WriteProperty("FontItalic", GetListBox().FontItalic, 0)
    Call PropBag.WriteProperty("FontBold", GetListBox().FontBold, 0)
    Call PropBag.WriteProperty("Appearance", GetListBox().Appearance, 1)
    Call PropBag.WriteProperty("BackColor", GetListBox().BackColor, &H80000005)
    
    Call PropBag.WriteProperty("Name", m_Name, m_def_Name)
    Call PropBag.WriteProperty("MyStyle", m_nStyle, 0)
    Call PropBag.WriteProperty("MyNewMultiSelect", m_nMultiSelect, 0)
    Call PropBag.WriteProperty("MySorted", m_bSorted, False)
    
End Sub

Public Property Get BackColor() As OLE_COLOR
Attribute BackColor.VB_Description = "Returns/sets the background color used to display text and graphics in an object."
    BackColor = GetListBox().BackColor()
End Property
Public Property Let BackColor(ByVal New_BackColor As OLE_COLOR)
    Dim i As Long
    For i = 0 To m_cNUMLST
        lstInternal(i).BackColor() = New_BackColor
    Next i
    PropertyChanged "BackColor"
End Property

Public Sub AddItem(ByVal Item As String, Optional ByVal Index As Variant)
    Dim i As Long
    For i = 0 To m_cNUMLST
        Call lstInternal(i).AddItem(Item, Index)
    Next i
End Sub

Public Property Get Name() As String
    Name = m_Name
End Property
Public Property Let Name(ByVal New_Name As String)
    m_Name = New_Name
    PropertyChanged "Name"
End Property

'Initialize Properties for User Control
Private Sub UserControl_InitProperties()
    m_Name = m_def_Name
End Sub

Public Function GetCurrentSelectedItemsKey() As String

    Dim nIndex As Long

    If GetListBox().ListIndex() > -1 Then
        nIndex = GetListBox().ItemData(GetListBox().ListIndex)
        
        GetCurrentSelectedItemsKey = m_saPrimaryKey(nIndex)
    End If

End Function

Public Property Get Style() As enumStyle
Attribute Style.VB_Description = "Returns/sets a value that determines whether checkboxes are displayed inside a ListBox control."
    Style = m_nStyle
End Property
Public Property Let Style(nNewStyle As enumStyle)
    m_bChangingStyle = True
        Dim i As Long
        For i = 0 To m_cNUMLST
            lstInternal(i).ListIndex = GetListBox().ListIndex
        Next i
    
        m_nStyle = nNewStyle
        Call SetVisibility
    m_bChangingStyle = False
End Property

Private Sub SetVisibility()

    lstInternal(0).Visible() = (m_bSorted = False And m_nStyle = 0) 'Normal
    lstInternal(1).Visible() = (m_bSorted = False And m_nMultiSelect > 0) 'MultiSelect
    lstInternal(2).Visible() = (m_bSorted = False And m_nStyle = 1) 'CheckBox
    lstInternal(3).Visible() = (m_bSorted = True And m_nStyle = 0) 'Normal
    lstInternal(4).Visible() = (m_bSorted = True And m_nMultiSelect > 0) 'MultiSelect
    lstInternal(5).Visible() = (m_bSorted = True And m_nStyle = 1) 'CheckBox

End Sub

Public Function KeyForIndex(nIndex As Long) As String
    KeyForIndex = m_saPrimaryKey(GetListBox().ItemData(nIndex))
End Function

Public Function IndexForKey(sKey As String) As Long

    Dim i As Long
    Dim n As Long
    
    IndexForKey = -1
    
    For i = 0 To m_nAutoIncrament - 1
        If m_saPrimaryKey(i) = sKey Then
            
            For n = 0 To GetListBox().ListCount - 1
                'Does this players ID match the one were deleting?
                If i = GetListBox().ItemData(n) Then
                    IndexForKey = n
                    Exit Function
                End If
            Next n 'Move to the next player
            
        End If
    Next i

End Function

Private Function GetListBox() As ListBox

    If m_bSorted = True Then
        If m_nStyle = 1 Then
            Set GetListBox = lstInternal(5)
        ElseIf m_nMultiSelect > 0 Then
            Set GetListBox = lstInternal(4)
        Else
            Set GetListBox = lstInternal(3)
        End If
    Else
        If m_nStyle = 1 Then
            Set GetListBox = lstInternal(2)
        ElseIf m_nMultiSelect > 0 Then
            Set GetListBox = lstInternal(1)
        Else
            Set GetListBox = lstInternal(0)
        End If
    End If
    
End Function
