VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFOTAINIHandler"
Attribute VB_GlobalNameSpace = True
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const m_cVERSION As String = "FOTA INI File v1.0"

Private m_oLists As New Collection
Private m_oValues As New clsFOTAArray
Private m_sFileName As String


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Value Functions
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Public Function IsKeyDefined(sKey As String) As Boolean
1           IsKeyDefined = (Not m_oValues.GetIndexForKey(sKey) = -1)
End Function
Public Function GetValueForKey(sKey As String, Optional sValueIfKeyNotFound As String = "") As String
1           If m_oValues.KeyInList(sKey) = True Then
2               GetValueForKey = m_oValues.GetTextForKey(sKey)
3           Else
4               GetValueForKey = sValueIfKeyNotFound
5           End If
End Function
Public Sub RemoveValue(sKey As String)
1           Call m_oValues.Remove(sKey)
End Sub
Public Sub AddValue(sKey As String, sValue As String)
1           If IsKeyDefined(sKey) = True Then
2               Call RemoveValue(sKey)
3           End If
4           Call m_oValues.Add(sValue, sKey)
End Sub


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'List Functions
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Public Function IsListDefined(sListKey As String) As Boolean
'
'    Dim i As Long
'
'    IsListDefined = False
'
'    For i = 0 To m_oLists.Count - 1
'        If m_oLists.Item(i).Key = sListKey Then
'            IsListDefined = True
'        End If
'    Next i
'
'End Function
'Public Function GetListElementCount(sListKey As String) As Long
''
'End Function
'Public Function GetListElementForIndex(sListKey As String, nElementIndex As Long) As String
''
'End Function
'Public Sub RemoveList(sListKey As String)
'
'    If IsListDefined(sListKey) = True Then
'        Call m_oLists.Remove(sListKey)
'    End If
'
'End Sub
'Public Sub RemoveListElement(sListKey As String, nElementIndex As Long)
''
'End Sub
'Public Sub AddList(sListKey As String)
'
'    Dim oList As New clsFOTAArray
'
'    If IsListDefined(sListKey) = True Then
'        Call RemoveList(sListKey)
'    End If
'    Call m_oLists.Add(oList, sListKey)
'
'End Sub
'Public Sub AddListElement(sListKey As String, sElementValue As String, Optional bCreateListIfListNotFound As Boolean = True)
'
'    Dim oList As clsFOTAArray
'
'    Set oList = GetList(sListKey, bCreateListIfListNotFound)
'
'    If oList Is Nothing Then
'        Call Err.Raise(-1, "FOTATools.clsFOTAINIHandler.AddListElement", "List <" & sListKey & "> not found.")
'        Exit Sub
'    End If
'
'    Call oList.Add(sElementValue)
'
'End Sub
'Private Function GetList(sListKey As String, bCreateListIfListNotFound As Boolean)
'
'    Set GetList = Nothing
'
'    If IsListDefined(sListKey) = True Then
'        Set GetList = m_oLists(sListKey)
'    ElseIf bCreateListIfListNotFound = True Then
'        Call AddList(sListKey)
'        Set GetList = m_oLists(sListKey)
'    End If
'
'End Function



''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Other Functions
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Public Sub SaveINIFile(Optional sFileName As String = "")
1
2           Dim nFreeFile As Long
3           Dim i As Long
4
5           If Len(sFileName) = 0 And Len(m_sFileName) = 0 Then
6               Call Err.Raise(-1, "FOTATools.clsFOTAINIHandler.OpenINIFile", "No file name was specified for saving the INI file")
7           ElseIf Len(sFileName) > 0 Then
8               m_sFileName = sFileName
9           Else
10              sFileName = m_sFileName
11          End If
12
13          nFreeFile = FreeFile
14          Open sFileName For Output As #nFreeFile
15
16              Write #nFreeFile, m_cVERSION
17
18              For i = 1 To m_oValues.Count
19                  Write #nFreeFile, m_oValues.GetKeyForIndex(i), m_oValues.GetTextForIndex(i)
20              Next i
21
22          Close #nFreeFile
23
End Sub

Public Sub OpenINIFile(sFileName As String)
1
2           Dim nFreeFile As Long
3           Dim sKey As String, sValue As String
4           Dim sTemp As String
5
6           m_sFileName = sFileName
7           Call m_oValues.RemoveAll
8
9           If Len(Dir(sFileName)) > 0 Then
10              nFreeFile = FreeFile
11              Open sFileName For Input As #nFreeFile
12
13                  If EOF(nFreeFile) = False Then
14                      Input #nFreeFile, sTemp
15                      If sTemp = m_cVERSION Then
16                          While EOF(nFreeFile) = False
17                              Input #nFreeFile, sKey, sValue
18                              Call m_oValues.Add(sValue, sKey)
19                          Wend
20                      Else
21                          Close #nFreeFile
22                          Call Err.Raise(-1, "FOTATools.clsFOTAINIHandler.OpenINIFile", "File <" & sFileName & "> was not a valid FOTA INI file")
23                      End If
24
25                      Close #nFreeFile
26                  Else
27                      Close #nFreeFile
28                      Call Err.Raise(-1, "FOTATools.clsFOTAINIHandler.OpenINIFile", "File <" & sFileName & "> was not a valid FOTA INI file, it was empty")
29                  End If
30          Else
31              'Call Err.Raise(-1, "FOTATools.clsFOTAINIHandler.OpenINIFile", "INI file <" & sFileName & "> was not found")
32          End If
33
End Sub
