VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFOTAVector2D"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Const m_cSEPERATOR As String = "[S_]"

Private m_nX As Double
Private m_nY As Double

Public Function Copy() As clsFOTAVector2D
    Set Copy = New clsFOTAVector2D
    Copy.X = X
    Copy.Y = Y
End Function

Public Property Get X() As Double
    X = m_nX
End Property
Public Property Let X(nNewX As Double)
    m_nX = nNewX
End Property
Public Property Get Y() As Double
    Y = m_nY
End Property
Public Property Let Y(nNewY As Double)
    m_nY = nNewY
End Property

Public Function Minus(B As clsFOTAVector2D) As clsFOTAVector2D
    Set Minus = New clsFOTAVector2D
    Minus.X = X - B.X
    Minus.Y = Y - B.Y
End Function
Public Function Plus(B As clsFOTAVector2D) As clsFOTAVector2D
    Set Plus = New clsFOTAVector2D
    Plus.X = X + B.X
    Plus.Y = Y + B.Y
End Function
Public Function Multiply(A As Double) As clsFOTAVector2D
    Set Multiply = New clsFOTAVector2D
    Multiply.X = A * X
    Multiply.Y = A * Y
End Function
Public Function Divide(B As Double) As clsFOTAVector2D
    Set Divide = New clsFOTAVector2D
    Divide.X = X / B
    Divide.Y = Y / B
End Function
'Cos(theta) = DotProduct(v1, v2) / (length(v1) * length(v2))
Public Function SimilarTo(B As clsFOTAVector2D) As Double
    Dim nTheta As Double
    Dim nAng1 As Double, nAng2 As Double
    Dim oFunc As New clsFunctions

    nAng1 = oFunc.CalcAngle(0, 0, X, Y)
    nAng2 = oFunc.CalcAngle(0, 0, B.X, B.Y)

    nTheta = oFunc.CalcAngleDiff(nAng1, nAng2, ENUM_ANGDIFF_SHORTEST)

    SimilarTo = oFunc.DegCos(nTheta) '* Distance(0, 0, X, Y) * Distance(0, 0, B.X, B.Y)
End Function
Public Function DotProduct(B As clsFOTAVector2D) As Double
    DotProduct = X * B.X + Y * B.Y
End Function
'This isn't a perp dot product!!
'Public Function PerpDotProduct(B As clsFOTAVector2D) As Double
'    Set PerpDotProduct = DotProduct(B.getperpindicular)
'    'PerpDotProduct = X * B.Y - Y * B.X
'End Function
Public Function PerpDotProduct(B As clsFOTAVector2D) As Double
    PerpDotProduct = DotProduct(B.GetPerpendicular())
End Function
Public Function GetPerpendicular() As clsFOTAVector2D
    Set GetPerpendicular = New clsFOTAVector2D
    GetPerpendicular.X = -Y
    GetPerpendicular.Y = X
End Function
Public Function View(Optional bShowAllDecimals As Boolean = False) As String
    If bShowAllDecimals = True Then
        View = "(" & X & "," & Y & ")"
    Else
        View = "(" & Format(X, "0.00") & "," & Format(Y, "0.00") & ")"
    End If
End Function
Public Function GetLength() As Double
    GetLength = Sqr(X * X + Y * Y)
End Function
Public Function GetNormal() As clsFOTAVector2D
    Dim nOneOverLength As Double
    Dim nLength As Double
    Set GetNormal = New clsFOTAVector2D
    nLength = GetLength()
    If nLength = 0 Then
        nOneOverLength = 0
    Else
        nOneOverLength = 1 / nLength
    End If
    GetNormal.X = nOneOverLength * X
    GetNormal.Y = nOneOverLength * Y
End Function
Public Function MultiplyMatrix(A As clsFOTAMatrix2x2) As clsFOTAVector2D
    Set MultiplyMatrix = New clsFOTAVector2D
    MultiplyMatrix.X = A.nElements(0, 0) * X + A.nElements(0, 1) * Y
    MultiplyMatrix.Y = A.nElements(1, 0) * X + A.nElements(1, 1) * Y
End Function
Private Sub Class_Initialize()
    X = 0
    Y = 0
End Sub
Public Function Serialize() As String
    Serialize = X & m_cSEPERATOR
    Serialize = Serialize & Y & m_cSEPERATOR
End Function

Public Function DeSerialize(sVector As String) As String

    Dim sRemStr As String
    sRemStr = sVector
    
    X = Left(sRemStr, InStr(sRemStr, m_cSEPERATOR) - 1)
        sRemStr = Right(sRemStr, Len(sRemStr) - InStr(sRemStr, m_cSEPERATOR) - Len(m_cSEPERATOR) + 1)
    Y = Left(sRemStr, InStr(sRemStr, m_cSEPERATOR) - 1)
        sRemStr = Right(sRemStr, Len(sRemStr) - InStr(sRemStr, m_cSEPERATOR) - Len(m_cSEPERATOR) + 1)

    DeSerialize = sRemStr

End Function
