Attribute VB_Name = "modPing"
Option Explicit

Private Const IP_SUCCESS As Long = 0
Private Const IP_STATUS_BASE As Long = 11000
Private Const IP_BUF_TOO_SMALL As Long = (11000 + 1)
Private Const IP_DEST_NET_UNREACHABLE As Long = (11000 + 2)
Private Const IP_DEST_HOST_UNREACHABLE As Long = (11000 + 3)
Private Const IP_DEST_PROT_UNREACHABLE As Long = (11000 + 4)
Private Const IP_DEST_PORT_UNREACHABLE As Long = (11000 + 5)
Private Const IP_NO_RESOURCES As Long = (11000 + 6)
Private Const IP_BAD_OPTION As Long = (11000 + 7)
Private Const IP_HW_ERROR As Long = (11000 + 8)
Private Const IP_PACKET_TOO_BIG As Long = (11000 + 9)
Private Const IP_REQ_TIMED_OUT As Long = (11000 + 10)
Private Const IP_BAD_REQ As Long = (11000 + 11)
Private Const IP_BAD_ROUTE As Long = (11000 + 12)
Private Const IP_TTL_EXPIRED_TRANSIT As Long = (11000 + 13)
Private Const IP_TTL_EXPIRED_REASSEM As Long = (11000 + 14)
Private Const IP_PARAM_PROBLEM As Long = (11000 + 15)
Private Const IP_SOURCE_QUENCH As Long = (11000 + 16)
Private Const IP_OPTION_TOO_BIG As Long = (11000 + 17)
Private Const IP_BAD_DESTINATION As Long = (11000 + 18)
Private Const IP_ADDR_DELETED As Long = (11000 + 19)
Private Const IP_SPEC_MTU_CHANGE As Long = (11000 + 20)
Private Const IP_MTU_CHANGE As Long = (11000 + 21)
Private Const IP_UNLOAD As Long = (11000 + 22)
Private Const IP_ADDR_ADDED As Long = (11000 + 23)
Private Const IP_GENERAL_FAILURE As Long = (11000 + 50)
Private Const MAX_IP_STATUS As Long = (11000 + 50)
Private Const IP_PENDING As Long = (11000 + 255)
Private Const PING_TIMEOUT As Long = 500
Private Const WS_VERSION_REQD As Long = &H101
Private Const MIN_SOCKETS_REQD As Long = 1
Private Const SOCKET_ERROR As Long = -1
Private Const INADDR_NONE As Long = &HFFFFFFFF
Private Const MAX_WSADescription As Long = 256
Private Const MAX_WSASYSStatus As Long = 128

Private Type ICMP_OPTIONS
    Ttl             As Byte
    Tos             As Byte
    Flags           As Byte
    OptionsSize     As Byte
    OptionsData     As Long
End Type

Public Type ICMP_ECHO_REPLY
    Address         As Long
    status          As Long
    RoundTripTime   As Long
    DataSize        As Long 'formerly integer
   'Reserved        As Integer
    DataPointer     As Long
    Options         As ICMP_OPTIONS
    Data            As String * 250
End Type

Private Type WSADATA
   wVersion As Integer
   wHighVersion As Integer
   szDescription(0 To MAX_WSADescription) As Byte
   szSystemStatus(0 To MAX_WSASYSStatus) As Byte
   wMaxSockets As Long
   wMaxUDPDG As Long
   dwVendorInfo As Long
End Type

Private Declare Function IcmpCreateFile Lib "icmp.dll" () As Long
Private Declare Function IcmpCloseHandle Lib "icmp.dll" (ByVal IcmpHandle As Long) As Long
Private Declare Function IcmpSendEcho Lib "icmp.dll" (ByVal IcmpHandle As Long, ByVal DestinationAddress As Long, ByVal RequestData As String, ByVal RequestSize As Long, ByVal RequestOptions As Long, ReplyBuffer As ICMP_ECHO_REPLY, ByVal ReplySize As Long, ByVal Timeout As Long) As Long
Private Declare Function WSAGetLastError Lib "wsock32" () As Long
Private Declare Function WSAStartup Lib "wsock32" (ByVal wVersionRequired As Long, lpWSADATA As WSADATA) As Long
Private Declare Function WSACleanup Lib "wsock32" () As Long
Private Declare Function gethostname Lib "wsock32" (ByVal szHost As String, ByVal dwHostLen As Long) As Long
Private Declare Function gethostbyname Lib "wsock32" (ByVal szHost As String) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (xDest As Any, xSource As Any, ByVal nbytes As Long)
Private Declare Function inet_addr Lib "wsock32" (ByVal s As String) As Long
    

Public Function GetStatusCode(status As Long) As String

   Dim Msg As String
   
   Select Case status
      Case IP_SUCCESS:               Msg = "IP Success"
      Case INADDR_NONE:              Msg = "INet Address: Bad IP Format"
      Case IP_BUF_TOO_SMALL:         Msg = "IP Buffer Too Small"
      Case IP_DEST_NET_UNREACHABLE:  Msg = "IP Destination Net Unreachable"
      Case IP_DEST_HOST_UNREACHABLE: Msg = "IP Destination Host Unreachable"
      Case IP_DEST_PROT_UNREACHABLE: Msg = "IP Destination Prot Unreachable"
      Case IP_DEST_PORT_UNREACHABLE: Msg = "IP Destination Port Unreachable"
      Case IP_NO_RESOURCES:          Msg = "IP No Resources"
      Case IP_BAD_OPTION:            Msg = "IP Bad Option"
      Case IP_HW_ERROR:              Msg = "IP HW Error"
      Case IP_PACKET_TOO_BIG:        Msg = "IP Packet Too Big"
      Case IP_REQ_TIMED_OUT:         Msg = "IP Request Timed Out"
      Case IP_BAD_REQ:               Msg = "IP Bad Request"
      Case IP_BAD_ROUTE:             Msg = "IP Bad Route"
      Case IP_TTL_EXPIRED_TRANSIT:   Msg = "IP TTL Expired Transit"
      Case IP_TTL_EXPIRED_REASSEM:   Msg = "IP TTL Expired Reassem"
      Case IP_PARAM_PROBLEM:         Msg = "IP Param Problem"
      Case IP_SOURCE_QUENCH:         Msg = "IP Source Quench"
      Case IP_OPTION_TOO_BIG:        Msg = "IP Option Too Big"
      Case IP_BAD_DESTINATION:       Msg = "IP Bad Destination"
      Case IP_ADDR_DELETED:          Msg = "IP Addr Deleted"
      Case IP_SPEC_MTU_CHANGE:       Msg = "IP Spec MTU Change"
      Case IP_MTU_CHANGE:            Msg = "IP MTU Change"
      Case IP_UNLOAD:                Msg = "IP Unload"
      Case IP_ADDR_ADDED:            Msg = "IP Address Added"
      Case IP_GENERAL_FAILURE:       Msg = "IP General Failure"
      Case IP_PENDING:               Msg = "IP Pending"
      Case PING_TIMEOUT:             Msg = "Ping Timeout"
      Case Else:                     Msg = "Unknown Message Returned"
   End Select
   
   GetStatusCode = CStr(status) & "   [ " & Msg & " ]"
   
End Function
'If Ping succeeds :
'.RoundTripTime = time in ms for the ping to complete,
'.Data is the data returned (NULL terminated)
'.Address is the Ip address that actually replied
'.DataSize is the size of the string in .Data
'.Status will be 0
'If Ping fails .Status will be the error code
Public Function SystemPing(sAddress As String) As Boolean  ', sDataToSend As String, ECHO As ICMP_ECHO_REPLY) As Long
   
    Dim hPort As Long
    Dim dwAddress As Long
    Dim ECHO As ICMP_ECHO_REPLY
    Dim pos As Long
    Dim sDataToSend As String
    
    sDataToSend = "<IPTest01>"
    SystemPing = False
   
    If SocketsInitialize() Then
      'Convert the address into a long representation
      dwAddress = inet_addr(sAddress)
     
      'If a valid address..
      If dwAddress <> INADDR_NONE Then
     
          'Open a port
          hPort = IcmpCreateFile()
          'And if successful,
          If hPort Then
              'Ping it.
              Call IcmpSendEcho(hPort, dwAddress, sDataToSend, Len(sDataToSend), _
                              0, ECHO, Len(ECHO), PING_TIMEOUT)
              'Return the status as ping succes and close
              If ECHO.status = IP_SUCCESS Then
                SystemPing = True
              Else
                Call Err.Raise(ECHO.status, "FOTATools.FOTANetworking.Ping", GetStatusCode(ECHO.status))
              End If
              
              Call IcmpCloseHandle(hPort)
          End If
      Else
          'The address format was probably invalid
          'Ping = INADDR_NONE
          Call Err.Raise(-1, "FOTATools.FOTANetworking.Ping", GetStatusCode(INADDR_NONE))
      End If
      
      Call SocketsCleanup
   Else
        Call Err.Raise(-1, "FOTATools.FOTANetworking.Ping", "Windows Sockets for 32 bit Windows environments is not successfully responding.")
   End If
   
End Function
Private Sub SocketsCleanup()
   If WSACleanup() <> 0 Then
       Call Err.Raise(-1, "FOTATools.FOTANetworking.SocketsCleanUp", "Windows Sockets error occurred in Cleanup.")
   End If
End Sub
Private Function SocketsInitialize() As Boolean
   Dim WSAD As WSADATA
   SocketsInitialize = WSAStartup(WS_VERSION_REQD, WSAD) = IP_SUCCESS
End Function
