VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsMultiControl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private m_nMax As Long
Private m_saKey() As String
Private m_baIsInUse() As Boolean
Private m_oControl As Object



Public Property Get SourceControl() As Object
    Set SourceControl = m_oControl
End Property
Public Property Let SourceControl(ByVal oSetobject As Object)

    On Error GoTo NotAnArray
        
    m_nMax = oSetobject.ubound
    
    ReDim m_saKey(0 To m_nMax) As String
    ReDim m_baIsInUse(0 To m_nMax) As Boolean
    Dim i As Integer
    
    'Ok if we made it this far we know its an indexed object
    Set m_oControl = SourceControl
    
    For i = 0 To m_nMax
        m_saKey(i) = ""
        m_baIsInUse(i) = False
        m_oControl(i).Enabled = False
        m_oControl(i).Visible = False
    Next i
    
    Exit Property
NotAnArray:
    Call Err.Raise(-1, "clsMultiControl::SourceControl", oSetobject.Name & " does not have an index.  Set the Index property to 0 on the control.")
    
End Property
Public Function GetControlForKey(sKey As String) As Object

    Dim i As Long
    
    For i = 0 To m_nMax
        If m_saKey(i) = sKey Then
            Set GetControlForKey = m_oControl(i)
            Exit Function
        End If
    Next i
    
    Call AddNewControl
    Set GetControlForKey = m_oControl(m_nMax)
    m_saKey(m_nMax) = sKey
    
End Function
Public Function GetIndexForKey(sKey As String) As Long

    Dim i As Long
    
    For i = 0 To m_nMax
        If m_saKey(i) = sKey Then
            GetIndexForKey = i
            Exit Function
        End If
    Next i
    
    Call AddNewControl
    GetIndexForKey = m_nMax
    m_saKey(m_nMax) = sKey
    
End Function
Public Function GetFreeControl() As Object

    Dim i As Long
    Dim bFound As Boolean
    
    For i = 0 To m_nMax
        If m_baIsInUse(i) = False Then
            m_saKey(i) = ""
            m_baIsInUse(i) = True
            Set GetFreeControl = m_oControl(i)
            Exit Function
        End If
    Next i
    
    Call AddNewControl
    Set GetFreeControl = m_oControl(m_nMax)

End Function
Public Property Get PrimaryKey(nIndex As Long) As String
    PrimaryKey = m_saKey(nIndex)
End Property
Public Property Let PrimaryKey(nIndex As Long, ByVal sNewKey As String)
    m_saKey(nIndex) = sNewKey
End Property
Public Property Get IsInUse(nIndex As Long) As Boolean
    IsInUse = m_baIsInUse(nIndex)
End Property
Public Property Let IsInUse(nIndex As Long, ByVal bNewVal As Boolean)
    m_baIsInUse(nIndex) = bNewVal
    m_oControl(nIndex).Enabled = bNewVal
    m_oControl(nIndex).Visible = bNewVal
End Property
Private Sub AddNewControl()

    m_nMax = m_nMax + 1
    Call Load(m_oControl(m_nMax))
    m_oControl(m_nMax).Enabled = True
    m_oControl(m_nMax).Visible = True
    ReDim m_saKey(0 To m_nMax) As String
    ReDim m_baIsInUse(0 To m_nMax) As Boolean

End Sub
