VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSpells"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "clsSpells"

Private m_nCharacterID As Long
Private m_colSpells As New Collection

Public Sub RemoveSpell(oSpell As clsSpell)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".RemoveSpell"
    Call WriteProcStart(sRoutineName)
    
    
    Call m_colSpells.Remove(oSpell.sGUID)


    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Public Sub AddSpell(oSpell As clsSpell)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".AddSpell"
    Call WriteProcStart(sRoutineName)
    
    
    Call m_colSpells.Add(oSpell, oSpell.sGUID)


    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Public Function FindSpell(sName As String, sType As String) As clsSpell
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".FindSpell"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oLoopSpell As clsSpell
    
    For Each oLoopSpell In Col
        If Trim(oLoopSpell.sSpellName) = Trim(sName) And Trim(oLoopSpell.sSpellType) = Trim(sType) Then
            Set FindSpell = oLoopSpell
        End If
    Next oLoopSpell


    Call WriteProcStop(sRoutineName) ' "OBJECT")
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Function SPUsed() As Long
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".SPUsed"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oLoopSpell As clsSpell
    SPUsed = 0
    For Each oLoopSpell In m_colSpells
        SPUsed = SPUsed + oLoopSpell.nCost
    Next oLoopSpell


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function
Public Function Col() As Collection
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Col"
    Call WriteProcStart(sRoutineName)
    
    
    Set Col = m_colSpells


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Function Name() As String
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = "clsSpells.Name"
    Call WriteProcStart(sRoutineName)
    
    
    Name = "clsSpells"


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Public Sub Load(dbDND As ADODB.Connection, nCharacterID As Long)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Load"
    Call WriteProcStart(sRoutineName)
    
    
    Dim rstSpells As ADODB.Recordset
    Dim oSpell As clsSpell
    
    'Empty out any spells we already have
    While m_colSpells.Count() > 0
        Call m_colSpells.Remove(0)
    Wend
    
    m_nCharacterID = nCharacterID
    Set rstSpells = OpenMyRecordset(dbDND, "SELECT * FROM Spells WHERE CharacterID = " & m_nCharacterID)
    
    If rstSpells.RecordCount > 0 Then
        Call rstSpells.MoveFirst
    
        While rstSpells.EOF = False
            Set oSpell = New clsSpell
            oSpell.sSpellType = IfNotNull(rstSpells![SpellType], "")
            oSpell.sSpellName = rstSpells![SpellName]
                If Left(oSpell.sSpellName, 9) = "MageSpell" Then
                    oSpell.sSpellName = Mid(oSpell.sSpellName, 9 + 1)
                    oSpell.sSpellType = "Mage"
                ElseIf Left(oSpell.sSpellName, 11) = "PriestSpell" Then
                    oSpell.sSpellName = Mid(oSpell.sSpellName, 11 + 1)
                    oSpell.sSpellType = "Priest"
                End If
            oSpell.nSpellLevel = IfNotNull(rstSpells![SpellLevel], 0)
            oSpell.nSpellQuantity = rstSpells![SpellQuantity]
            oSpell.nCost = IfNotNull(rstSpells![Cost], 0)
            Call AddSpell(oSpell)

            Call rstSpells.MoveNext
        Wend
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Public Sub Save(dbDND As ADODB.Connection)
  
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Save"
    Call WriteProcStart(sRoutineName)
    
    
    Dim rstSpells As ADODB.Recordset
    Dim oSpell As clsSpell
    
    'Empty out all the spells that we used to have in their
    Call dbDND.Execute("DELETE * FROM Spells WHERE CharacterID = " & m_nCharacterID)
    Set rstSpells = OpenMyRset(dbDND, "SELECT * FROM Spells WHERE 1=2")
                
    'No go and save all the spells in this collection
    For Each oSpell In m_colSpells
        'Add this entry
        Call rstSpells.AddNew
            rstSpells![CharacterID] = m_nCharacterID
            rstSpells![SpellName] = oSpell.sSpellName
            rstSpells![SpellQuantity] = oSpell.nSpellQuantity
            rstSpells![SpellLevel] = oSpell.nSpellLevel
            rstSpells![Cost] = oSpell.nCost
            rstSpells![SpellType] = oSpell.sSpellType
        Call rstSpells.Update
    Next oSpell
        
    'Close the collection
    Call rstSpells.Close
        

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
