VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTable"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "clsTable"

Private m_saData() As String
Public m_sFileName As String
Public m_sNodeName As String

Public Property Get varTable() As String()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".AllData"
    Call WriteProcStart(sRoutineName)

    
    varTable = m_saData


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Property
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Property
Public Property Let AllData(vNewData() As String)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".AllData"
    Call WriteProcStart(sRoutineName)

    
    m_saData = vNewData


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Property
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Property

Public Property Get Data(nCol As Long, nRow As Long) As String

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Data"
    Call WriteProcStart(sRoutineName)

    
    Data = m_saData(nCol, nRow)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Property
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Property

Public Property Get Rows() As Long

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Rows"
    Call WriteProcStart(sRoutineName)

    
    Rows = UBound(m_saData, 2)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Property
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Property
Public Property Get Cols() As Long

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Cols"
    Call WriteProcStart(sRoutineName)


    Cols = UBound(m_saData, 1)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Property
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Property

Public Function ReturnSorted(nSortCol As Long) As String()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".ReturnSorted"
    Call WriteProcStart(sRoutineName)


    Dim saRetVal() As String
    Dim baUsed() As Boolean
    Dim nLowest As Long
    Dim bStillSome As Boolean
    Dim sMsg As String
    Dim nX As Long, nY As Long
    Dim nNextFree As Long

    ReDim saRetVal(1 To Cols(), 1 To Rows()) As String
    ReDim baUsed(1 To Rows() + 1) As Boolean
    bStillSome = True
    nNextFree = 2

    'Copy the header information
    For nX = 1 To Cols()
        saRetVal(nX, 1) = Data(nX, 1)
    Next nX

    'Step through and sort it all now
    While bStillSome = True
        bStillSome = False
        nLowest = 2 'Start at 2 to ignore the header information

        'Find the lowest element
        For nY = 2 To Rows()
            If baUsed(nY) = False Then bStillSome = True
            If (Data(nSortCol, nY) < Data(nSortCol, nLowest) And baUsed(nY) = False) Or baUsed(nLowest) = True Then
                nLowest = nY
            End If
        Next nY

        DoEvents

        'Copy the columns over to the new table
        If bStillSome = True Then
            For nX = 1 To Cols()
                saRetVal(nX, nNextFree) = Data(nX, nLowest)
            Next nX
        End If
        baUsed(nLowest) = True
        nNextFree = nNextFree + 1
    Wend

    ReturnSorted = saRetVal


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function
Public Function FindValue(sRowVal As String, sColVal As String) As String

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".FindValue"
    Call WriteProcStart(sRoutineName)


    Dim nRowIndex As Long
    Dim nColIndex As Long
    
    nRowIndex = FindRow(sRowVal)
    nColIndex = FindColumn(sColVal)
    
    If nRowIndex = -1 Or nRowIndex = -1 Then
        Call Err.Raise(-1, "DNDOnline.clsTable.FindValue", "Table value in table " & m_sNodeName & " not found <" & sRowVal & "," & sColVal & ">")
    Else
        FindValue = Data(nRowIndex, nColIndex)
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function

Public Function FindColumn(vSearchValue As Variant, Optional nRow As Long = 1) As Long

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".FindColumn"
    Call WriteProcStart(sRoutineName)


    Dim i As Long
    
    FindColumn = -1
    'Find the column for our level
    For i = 1 To Cols()
        If CompareTwoValues(vSearchValue, Data(i, nRow)) = True Then
            FindColumn = i
            Exit For
        End If
    Next i


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function
Public Function FindRow(vSearchValue As Variant, Optional nColumn As Long = 1) As Long

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".FindRow"
    Call WriteProcStart(sRoutineName)


    Dim i As Long
    
    FindRow = -1
    'Find the column for our level
    For i = 2 To Rows()
        If CompareTwoValues(vSearchValue, Data(nColumn, i)) = True Then
            FindRow = i
            Exit For
        End If
    Next i


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function

Private Function CompareTwoValues(vSearchValue As Variant, vFoundValue As Variant) As Boolean

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".CompareTwoValues"
    Call WriteProcStart(sRoutineName)


    Dim sTemp As String
    Dim sMin As String, sMax As String

    If IsNumeric(vSearchValue) = True And (IsNumeric(vFoundValue) = False Or (IsNumeric(Left(vFoundValue, Len(vFoundValue) - 1)) = True And Right(vFoundValue, 1) = "+")) Then
        If InStr(1, vFoundValue, "+") > 0 Then
            sTemp = Left(vFoundValue, InStr(1, vFoundValue, "+") - 1)
            If IsNumeric(sTemp) = True Then
                CompareTwoValues = (CLng(vSearchValue) >= CLng(sTemp))
            Else
                Call Err.Raise(-1, "DNDOnline.clsTable.CompareTwoValues", "Searching for <" & vSearchValue & "> in column <" & vFoundValue & "> came to a type mismatch")
            End If
        ElseIf InStr(1, vFoundValue, "-") > 0 Then
            sMin = Left(vFoundValue, InStr(1, vFoundValue, "-") - 1)
            sMax = Mid(vFoundValue, InStr(1, vFoundValue, "-") + 1)
            If IsNumeric(sMin) = True And IsNumeric(sMax) = True Then
                CompareTwoValues = (CLng(vSearchValue) >= CLng(sMin) And CLng(vSearchValue) <= CLng(sMax))
            Else
                CompareTwoValues = (Trim(UCase(vFoundValue)) Like Trim(UCase(vSearchValue)) Or _
                                    Trim(UCase(vFoundValue)) = Trim(UCase(vSearchValue)))
            End If
        Else
            CompareTwoValues = (Trim(UCase(vFoundValue)) Like Trim(UCase(vSearchValue)) Or _
                                Trim(UCase(vFoundValue)) = Trim(UCase(vSearchValue)))
        End If
    ElseIf IsNumeric(vSearchValue) = False Or IsNumeric(vFoundValue) = False Then
        CompareTwoValues = (Trim(UCase(vFoundValue)) Like Trim(UCase(vSearchValue)) Or _
                            Trim(UCase(vFoundValue)) = Trim(UCase(vSearchValue)))
    Else
        CompareTwoValues = (CLng(vFoundValue) = CLng(vSearchValue))
    End If
       

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function
