VERSION 5.00
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "tabctl32.ocx"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmManageMacros_3_33_0 
   Caption         =   "Manage Macros"
   ClientHeight    =   5520
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11670
   Icon            =   "frmManageMacros.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5520
   ScaleWidth      =   11670
   Begin VB.CommandButton cmdDone 
      Caption         =   "Apply Changes"
      Height          =   375
      Left            =   10080
      TabIndex        =   14
      Top             =   5040
      Width           =   1455
   End
   Begin TabDlg.SSTab SSTab1 
      Height          =   4740
      Left            =   4080
      TabIndex        =   1
      Top             =   120
      Width           =   7485
      _ExtentX        =   13203
      _ExtentY        =   8361
      _Version        =   393216
      Tabs            =   2
      TabHeight       =   520
      TabCaption(0)   =   "Macros"
      TabPicture(0)   =   "frmManageMacros.frx":0442
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "cmdAddNew"
      Tab(0).Control(0).Enabled=   0   'False
      Tab(0).Control(1)=   "Frame1"
      Tab(0).Control(1).Enabled=   0   'False
      Tab(0).Control(2)=   "cmdSave"
      Tab(0).Control(2).Enabled=   0   'False
      Tab(0).Control(3)=   "cmdCancel"
      Tab(0).Control(3).Enabled=   0   'False
      Tab(0).Control(4)=   "cmdEdit"
      Tab(0).Control(4).Enabled=   0   'False
      Tab(0).Control(5)=   "cmdDelete"
      Tab(0).Control(5).Enabled=   0   'False
      Tab(0).ControlCount=   6
      TabCaption(1)   =   "Characters"
      TabPicture(1)   =   "frmManageMacros.frx":045E
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "lstCharacters"
      Tab(1).Control(1)=   "Label5"
      Tab(1).Control(2)=   "Label4"
      Tab(1).ControlCount=   3
      Begin FOTATools.FOTAListControl lstCharacters 
         Height          =   3375
         Left            =   -74640
         TabIndex        =   16
         Top             =   840
         Width           =   3255
         _ExtentX        =   5741
         _ExtentY        =   5953
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         FontSize        =   8.25
         FontName        =   "MS Sans Serif"
      End
      Begin VB.CommandButton cmdDelete 
         Caption         =   "Delete"
         Height          =   375
         Left            =   6240
         TabIndex        =   13
         Top             =   1035
         Width           =   1095
      End
      Begin VB.CommandButton cmdEdit 
         Caption         =   "Edit"
         Height          =   375
         Left            =   6240
         TabIndex        =   12
         Top             =   1515
         Width           =   1095
      End
      Begin VB.CommandButton cmdCancel 
         Caption         =   "Cancel"
         Height          =   375
         Left            =   6240
         TabIndex        =   11
         Top             =   2475
         Width           =   1095
      End
      Begin VB.CommandButton cmdSave 
         Caption         =   "Save"
         Height          =   375
         Left            =   6240
         TabIndex        =   10
         Top             =   1995
         Width           =   1095
      End
      Begin VB.Frame Frame1 
         Height          =   4095
         Left            =   240
         TabIndex        =   3
         Top             =   480
         Width           =   5895
         Begin VB.TextBox txtMacroName 
            Height          =   285
            Left            =   960
            TabIndex        =   6
            Top             =   360
            Width           =   4695
         End
         Begin FOTATools.FOTAComboBox cboEvent 
            Height          =   315
            Left            =   960
            TabIndex        =   4
            Top             =   720
            Width           =   4695
            _ExtentX        =   8281
            _ExtentY        =   556
            BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
               Name            =   "MS Sans Serif"
               Size            =   8.25
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Locked          =   0   'False
            PreventTyping   =   -1  'True
         End
         Begin RichTextLib.RichTextBox rtbQuery 
            Height          =   2775
            Left            =   960
            TabIndex        =   5
            Top             =   1080
            Width           =   4695
            _ExtentX        =   8281
            _ExtentY        =   4895
            _Version        =   393217
            Enabled         =   -1  'True
            ScrollBars      =   3
            AutoVerbMenu    =   -1  'True
            TextRTF         =   $"frmManageMacros.frx":047A
         End
         Begin VB.Label Label1 
            Caption         =   "Name:"
            Height          =   255
            Left            =   240
            TabIndex        =   9
            Top             =   360
            Width           =   1095
         End
         Begin VB.Label Label2 
            Caption         =   "Query:"
            Height          =   255
            Left            =   240
            TabIndex        =   8
            Top             =   1080
            Width           =   1095
         End
         Begin VB.Label Label3 
            Caption         =   "Event:"
            Height          =   255
            Left            =   240
            TabIndex        =   7
            Top             =   720
            Width           =   1095
         End
      End
      Begin VB.CommandButton cmdAddNew 
         Caption         =   "Add New"
         Height          =   375
         Left            =   6240
         TabIndex        =   2
         Top             =   555
         Width           =   1095
      End
      Begin VB.Label Label5 
         Caption         =   "Characters:"
         Height          =   255
         Left            =   -74640
         TabIndex        =   17
         Top             =   600
         Width           =   1935
      End
      Begin VB.Label Label4 
         Caption         =   $"frmManageMacros.frx":04FC
         Height          =   855
         Left            =   -71160
         TabIndex        =   15
         Top             =   840
         Width           =   3255
      End
   End
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   0
      Top             =   0
      _ExtentX        =   635
      _ExtentY        =   635
   End
   Begin FOTATools.FOTAListControl lstMacros 
      Height          =   5325
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3855
      _ExtentX        =   6800
      _ExtentY        =   9393
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      FontSize        =   8.25
      FontName        =   "MS Sans Serif"
   End
End
Attribute VB_Name = "frmManageMacros_3_33_0"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "frmManageMacros_3_33_0"
Private m_bLoading As Boolean
Private m_oMacroEditing As clsMacro

Private Sub cboEvent_Change()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cboEvent_Change"
    Call WriteProcStart(sRoutineName)
    
    
    Call EventWarning
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub cboEvent_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cboEvent_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Call EventWarning
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub EventWarning()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".EventWarning"
    Call WriteProcStart(sRoutineName)
    

    If (cboEvent.GetCurrentSelectedItemsKey() = g_cMACROEVENTS_ROLLATTACK Or _
        cboEvent.GetCurrentSelectedItemsKey() = g_cMACROEVENTS_ROLLINIT Or _
        cboEvent.GetCurrentSelectedItemsKey() = g_cMACROEVENTS_ROLLSTAT) And _
        cboEvent.Enabled = True Then
            Call MsgBox("Warning!  This event overides the basic DNDOnline functionality.  Only the actions of your macro will occur.", vbOKOnly + vbExclamation, "Warning!  Basic Function Override")
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub Form_Unload(Cancel As Integer)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Unload"
    Call WriteProcStart(sRoutineName)
    
    
    Dim i As Long
    Dim oChar As clsCharacter
    
    If Not m_oMacroEditing Is Nothing Then
        Call SaveRecordValues
    End If
    

    
    Call g_oMacros.Save(g_oDB)
    
    'Now go through all the characters and update their macros listings
    For i = 0 To lstCharacters.ListCount - 1
        Set oChar = GetCharacter(lstCharacters.KeyForIndex(i))
        Call oChar.Save(g_oDB)
        Call oChar.m_oMacros.Load(g_oDB, oChar.nCharID)
    Next i
    
    'Now refresh all the chat rooms macros!!
    For i = 0 To Forms.Count() - 1
        If Forms(i).Name = "frmChatRoom_3_0_0" Then
            Call Forms(i).UpdateMacros
        End If
    Next i
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub lstCharacters_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lstCharacters_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oChar As clsCharacter
    Dim oMacro As clsMacro
    Dim i As Long
    
    m_bLoading = True
        Call SetAttributes(lstMacros, True)
        lstMacros.Style = CheckBox
    
        Set oChar = GetCharacter(lstCharacters.GetCurrentSelectedItemsKey())
    
        If oChar Is Nothing Then
            Call Err.Raise(-1, sRoutineName, "Unable to find character for macro selection")
        Else
            For i = 0 To lstMacros.ListCount - 1
                Set oMacro = oChar.m_oMacros.GetMacroByID(lstMacros.KeyForIndex(i))
                lstMacros.Selected(i) = (Not oMacro Is Nothing)
            Next i
        End If
        
    m_bLoading = False

    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub lstMacros_ItemCheck(Item As Integer)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lstMacros_ItemCheck"
    Call WriteProcStart(sRoutineName)
    
    
    Dim sKey As String
    Dim oQuery As clsMacro
    Dim oChar As clsCharacter
    Dim oMacro As clsMacro
    
    If m_bLoading = False Then
        Set oChar = GetCharacter(lstCharacters.GetCurrentSelectedItemsKey())
        
        If oChar Is Nothing Then
            Call Err.Raise(-1, sRoutineName, "Unable to find character for macro selection")
        Else
            sKey = lstMacros.KeyForIndex(CInt(Item))
            Set oQuery = g_oMacros.GetMacroByID(CLng(sKey))
        
            If lstMacros.Selected(lstMacros.ListIndex) = True Then
                Set oMacro = oQuery.Copy()
                Call oChar.m_oMacros.Add(oMacro)
            Else
                Call oChar.m_oMacros.RemoveByID(oQuery.m_nMacroID)
            End If
        End If
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub cmdAddNew_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdAddNew_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Set m_oMacroEditing = New clsMacro
    Call Mode(True)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub cmdCancel_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdCancel_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Call Mode(False)
    Set m_oMacroEditing = Nothing
    Call lstMacros_Click
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub cmdDelete_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDelete_Click"
    Call WriteProcStart(sRoutineName)
    
    
    
    If MsgBox("Are you sure you wish to delete this macro?", vbYesNo + vbInformation, "Delete Confirmation") = vbYes Then
        Call g_oMacros.RemoveByID(lstMacros.GetCurrentSelectedItemsKey())
        Call UpdateMacros
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub cmdDone_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDone_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Call Unload(Me)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub cmdEdit_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdEdit_Click"
    Call WriteProcStart(sRoutineName)
    
    
    If Len(lstMacros.GetCurrentSelectedItemsKey()) > 0 Then
        Set m_oMacroEditing = g_oMacros.GetMacroByID(lstMacros.GetCurrentSelectedItemsKey())
        Call Mode(True)
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub cmdSave_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdSave_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Call SaveRecordValues
    Set m_oMacroEditing = Nothing
    Call Mode(False)
    Call UpdateMacros
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub Form_Load()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Load"
    Call WriteProcStart(sRoutineName)
    
    
    Call SetAttributes(cboEvent, False)
    
    '08/06/2002 Chris Hill  This is a list of Macro events
    Call cboEvent.AddItemWithKey("<None>", g_cMACROEVENTS_NONE)
    Call cboEvent.AddItemWithKey("<Define Function>", g_cMACROEVENTS_FUNCTION)
    Call cboEvent.AddItemWithKey("Combat Begins", g_cMACROEVENTS_COMBATBEGINS)
    Call cboEvent.AddItemWithKey("Combat Next Round (nRound)", g_cMACROEVENTS_NEXTCOMBATROUND)
    Call cboEvent.AddItemWithKey("Combat Ends", g_cMACROEVENTS_COMBATENDS)
    Call cboEvent.AddItemWithKey("Player Joins (sPlayersName)", g_cMACROEVENTS_PLAYERJOINSCHAT)
    Call cboEvent.AddItemWithKey("Received IM (sCharFrom)", g_cMACROEVENTS_RECEIVEDIM)
    Call cboEvent.AddItemWithKey("Pressed Roll Attack Button (sAttackText)", g_cMACROEVENTS_ROLLATTACK)
    Call cboEvent.AddItemWithKey("Pressed Roll Init Button (sInitText,nInitRolled)", g_cMACROEVENTS_ROLLINIT)
    Call cboEvent.AddItemWithKey("Pressed Roll Stat Button (sStatName,nStatScore,sStatRollText)", g_cMACROEVENTS_ROLLSTAT)

    Call UpdateMacros
    Call Mode(False)
    
    Call LoadWithAllChars_OLD(lstCharacters, True, False)
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Public Sub UpdateMacros()
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".UpdateMacros"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oLoopMacro As clsMacro
    Dim sID As String
    
    m_bLoading = True
    
    sID = lstMacros.GetCurrentSelectedItemsKey()
    Call lstMacros.Clear
    
    For Each oLoopMacro In g_oMacros.Col
        Call lstMacros.AddItemWithKey(oLoopMacro.m_sMacroName, CStr(oLoopMacro.m_nMacroID))
    Next oLoopMacro

    m_bLoading = False

    If lstMacros.IndexForKey(sID) > -1 Then
        lstMacros.ListIndex = lstMacros.IndexForKey(sID)
        cmdEdit.Enabled = True
        cmdDelete.Enabled = True
    ElseIf lstMacros.ListCount > 0 Then
        lstMacros.ListIndex = 0
        cmdEdit.Enabled = True
        cmdDelete.Enabled = True
        Call lstMacros_Click
    Else
        cmdEdit.Enabled = False
        cmdDelete.Enabled = False
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub AssignRecordValues(oQuery As clsMacro)
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".AssignRecordValues"
    Call WriteProcStart(sRoutineName)
    
    
    If m_bLoading = False Then
        txtMacroName.Text = oQuery.m_sMacroName
        rtbQuery.Text = oQuery.m_sMacroCode
        Call cboEvent.SelItemByKey(oQuery.m_sMacroEvent)
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Sub Mode(bEditMode As Boolean)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Mode"
    Call WriteProcStart(sRoutineName)
    
    
    'Edit controls
    Call SetAttributes(txtMacroName, bEditMode)
    Call SetAttributes(cboEvent, bEditMode)
    Call SetAttributes(rtbQuery, bEditMode)
    Call SetAttributes(lstMacros, (Not bEditMode))

    cmdEdit.Enabled = (Not bEditMode And lstMacros.ListIndex > -1)
    cmdSave.Enabled = bEditMode
    cmdCancel.Enabled = bEditMode
    cmdAddNew.Enabled = (Not bEditMode)
    cmdDelete.Enabled = (Not bEditMode And lstMacros.ListIndex > -1)
    cmdDone.Enabled = (Not bEditMode)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Function GetBackColor(bEnabled As Boolean) As Long

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetBackColor"
    Call WriteProcStart(sRoutineName)
    
    
    If bEnabled = True Then
        GetBackColor = &H80000005
    Else
        GetBackColor = &H8000000F
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function

Private Sub lstMacros_Click()
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lstMacros_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oQuery As clsMacro
    
    Set oQuery = g_oMacros.GetMacroByID(lstMacros.GetCurrentSelectedItemsKey())
    Call AssignRecordValues(oQuery)
    
    cmdEdit.Enabled = True
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub SaveRecordValues()
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".SaveRecordValues"
    Call WriteProcStart(sRoutineName)
    
    
    If Not m_oMacroEditing Is Nothing Then
        m_oMacroEditing.m_sMacroName = txtMacroName.Text
        m_oMacroEditing.m_sMacroCode = rtbQuery.Text
        m_oMacroEditing.m_sMacroEvent = cboEvent.GetCurrentSelectedItemsKey()
    
        If g_oMacros.GetMacroByGUID(m_oMacroEditing.m_sGUID) Is Nothing Then
            Call m_oMacroEditing.SaveMacro(g_oDB)
            Call g_oMacros.Add(m_oMacroEditing)
        End If
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub SSTab1_Click(PreviousTab As Integer)
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".SSTab1_Click"
    Call WriteProcStart(sRoutineName)
    
    
    If SSTab1.Tab = 1 Then
        Call SetAttributes(lstMacros, (lstCharacters.SelCount > 0))
        lstMacros.Style = CheckBox
    Else
        Call SetAttributes(lstMacros, True)
        lstMacros.Style = Standard
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
