VERSION 5.00
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmMaps 
   Caption         =   "Maps"
   ClientHeight    =   6840
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   10755
   Icon            =   "frmMaps.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6840
   ScaleWidth      =   10755
   Begin VB.PictureBox picMask 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   9480
      ScaleHeight     =   33
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   41
      TabIndex        =   22
      Top             =   5760
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.PictureBox picTemp 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   8760
      ScaleHeight     =   33
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   41
      TabIndex        =   21
      Top             =   5760
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.CommandButton cmdZoomOut 
      Caption         =   "Zoom Out"
      Enabled         =   0   'False
      Height          =   375
      Left            =   9600
      TabIndex        =   11
      Top             =   4440
      Width           =   975
   End
   Begin VB.CheckBox chkDeleteItem 
      Caption         =   "Del Item"
      Height          =   375
      Left            =   9600
      Style           =   1  'Graphical
      TabIndex        =   13
      Top             =   5400
      Width           =   975
   End
   Begin VB.CheckBox chkAddMapItem 
      Caption         =   "Add Item"
      Height          =   375
      Left            =   9600
      Style           =   1  'Graphical
      TabIndex        =   12
      Top             =   4920
      Width           =   975
   End
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   10200
      Top             =   5040
      _ExtentX        =   635
      _ExtentY        =   635
      MyResizeForm    =   0   'False
   End
   Begin VB.TextBox txtMapName 
      Height          =   285
      Left            =   1920
      TabIndex        =   1
      Top             =   4320
      Width           =   7455
   End
   Begin VB.CheckBox chkShowDetail 
      Caption         =   "Show Detail"
      Height          =   255
      Left            =   9480
      TabIndex        =   19
      Top             =   5520
      Width           =   1215
   End
   Begin VB.PictureBox picMapSource 
      Appearance      =   0  'Flat
      AutoSize        =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   495
      Left            =   10440
      ScaleHeight     =   33
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   41
      TabIndex        =   18
      Top             =   4560
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.CommandButton cmdUpdate 
      Caption         =   "Send Updated Version"
      Enabled         =   0   'False
      Height          =   855
      Left            =   9600
      TabIndex        =   10
      Top             =   3480
      Width           =   975
   End
   Begin VB.Frame framControls 
      Height          =   2775
      Left            =   9480
      TabIndex        =   17
      Top             =   120
      Width           =   1215
      Begin VB.CommandButton cmdDelete 
         Caption         =   "Delete"
         Height          =   375
         Left            =   120
         TabIndex        =   8
         Top             =   2160
         Width           =   975
      End
      Begin VB.CommandButton cmdEdit 
         Caption         =   "Edit"
         Enabled         =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   5
         Top             =   720
         Width           =   975
      End
      Begin VB.CommandButton cmdSave 
         Caption         =   "Save"
         Enabled         =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   6
         Top             =   1200
         Width           =   975
      End
      Begin VB.CommandButton cmdAddNew 
         Caption         =   "Add New"
         Height          =   375
         Left            =   120
         TabIndex        =   4
         Top             =   240
         Width           =   975
      End
      Begin VB.CommandButton cmdCancel 
         Caption         =   "Cancel"
         Enabled         =   0   'False
         Height          =   375
         Left            =   120
         TabIndex        =   7
         Top             =   1680
         Width           =   975
      End
   End
   Begin VB.CommandButton cmdFindMap 
      Caption         =   "..."
      Height          =   255
      Left            =   9120
      TabIndex        =   15
      Top             =   4680
      Width           =   255
   End
   Begin VB.TextBox txtMapPic 
      Height          =   285
      Left            =   1920
      TabIndex        =   2
      Top             =   4680
      Width           =   7215
   End
   Begin VB.PictureBox picMap 
      AutoRedraw      =   -1  'True
      Height          =   4095
      Left            =   1920
      ScaleHeight     =   4035
      ScaleWidth      =   7395
      TabIndex        =   14
      Top             =   120
      Width           =   7455
      Begin VB.Label lblMeasuring 
         Appearance      =   0  'Flat
         AutoSize        =   -1  'True
         BackColor       =   &H00C0FFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Distance"
         ForeColor       =   &H80000008&
         Height          =   225
         Left            =   1200
         TabIndex        =   24
         Top             =   360
         Visible         =   0   'False
         Width           =   660
      End
      Begin VB.Line lneMeasuring 
         BorderStyle     =   3  'Dot
         Visible         =   0   'False
         X1              =   1080
         X2              =   2520
         Y1              =   240
         Y2              =   840
      End
      Begin VB.Label lblScale 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "1 Day"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H0000FFFF&
         Height          =   195
         Left            =   75
         TabIndex        =   23
         Top             =   120
         Visible         =   0   'False
         Width           =   510
      End
      Begin VB.Line lneScaleHorz 
         BorderColor     =   &H0000FFFF&
         BorderWidth     =   2
         Visible         =   0   'False
         X1              =   120
         X2              =   840
         Y1              =   480
         Y2              =   480
      End
      Begin VB.Line lneScaleVertRight 
         BorderColor     =   &H0000FFFF&
         BorderWidth     =   2
         Visible         =   0   'False
         X1              =   840
         X2              =   840
         Y1              =   360
         Y2              =   600
      End
      Begin VB.Line lneScaleVertLeft 
         BorderColor     =   &H0000FFFF&
         BorderWidth     =   2
         Visible         =   0   'False
         X1              =   120
         X2              =   120
         Y1              =   360
         Y2              =   600
      End
      Begin VB.Shape shpOutline 
         Height          =   615
         Left            =   360
         Top             =   840
         Visible         =   0   'False
         Width           =   615
      End
      Begin VB.Label lblLabel 
         Appearance      =   0  'Flat
         AutoSize        =   -1  'True
         BackColor       =   &H00C0FFFF&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Haven's Heart"
         ForeColor       =   &H80000008&
         Height          =   225
         Index           =   0
         Left            =   1320
         TabIndex        =   16
         Top             =   960
         Visible         =   0   'False
         Width           =   1050
      End
   End
   Begin VB.CommandButton cmdDone 
      Caption         =   "Done"
      Height          =   375
      Left            =   9600
      TabIndex        =   9
      Top             =   3000
      Width           =   975
   End
   Begin VB.ListBox lstItems 
      Height          =   5520
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1695
   End
   Begin RichTextLib.RichTextBox rtbDescription 
      Height          =   615
      Left            =   1920
      TabIndex        =   3
      Top             =   5040
      Width           =   7455
      _ExtentX        =   13150
      _ExtentY        =   1085
      _Version        =   393217
      BorderStyle     =   0
      Appearance      =   0
      TextRTF         =   $"frmMaps.frx":0442
   End
   Begin VB.Label lblInstructions 
      Alignment       =   2  'Center
      Caption         =   "(Left-Click Drag-Drop to zoom, Righ-Click Drag-Drop to measure distances, Right-Click to center, Double-Click To View Node)"
      Height          =   255
      Left            =   120
      TabIndex        =   25
      Top             =   6600
      Width           =   9015
   End
   Begin VB.Label Label1 
      Caption         =   "Loading..."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   1920
      TabIndex        =   20
      Top             =   120
      Width           =   2895
   End
End
Attribute VB_Name = "frmMaps"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private WithEvents m_oFormManager As clsFOTAStdFormManager
Attribute m_oFormManager.VB_VarHelpID = -1
Public m_oLabels As New FOTATools.clsMultiControl

Private Const m_cNAME As String = "frmMaps"
Private m_bLoadingForm As Boolean
Private m_sLastLoadedPictureIntoSource As String

Private m_nLastMouseMoveX As Long
Private m_nLastMouseMoveY As Long
Private m_bMouseDownOnParty As Boolean
Private m_bMouseDownAddingItem As Boolean
Private m_bMouseDownZooming As Boolean
Private m_bMouseDownMeasuring As Boolean
Private m_nMouseDownX As Long
Private m_nMouseDownY As Long

Private m_nZoomLeft As Long
Private m_nZoomTop As Long
Private m_nZoomHeight As Long
Private m_nZoomWidth As Long

Public m_oCurMap As clsMap

Private Const m_cPARTYXSIZE As Long = 150

Private Sub chkAddMapItem_Click()
         
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".chkAddMapItem_Click"
    Call WriteProcStart(sRoutineName)
    
        
    If chkAddMapItem.Value = vbChecked Then
        chkDeleteItem.Value = vbUnchecked
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub chkDeleteItem_Click()
         
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".chkShowDetail_Click"
    Call WriteProcStart(sRoutineName)
    
        
    If chkDeleteItem.Value = vbChecked Then
        chkAddMapItem.Value = vbUnchecked
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub chkShowDetail_Click()
         
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".chkShowDetail_Click"
    Call WriteProcStart(sRoutineName)
    
        
    Call UpdateAllLabels
    g_bShowAllLabels = (chkShowDetail.Value = vbChecked)
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub cmdAddNew_Click()
     
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdAddNew_Click"
    Call WriteProcStart(sRoutineName)
    
        
    Set m_oCurMap = New clsMap
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub cmdDone_Click()
     
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDone_Click"
    Call WriteProcStart(sRoutineName)
    
        
    Call Unload(Me)
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub cmdUpdate_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdUpdate_Click"
    Call WriteProcStart(sRoutineName)
    

    Call MakeProcessSendMsg(g_cUpdatedOverlandMapCode, m_oCurMap.Serialize())
    
    Call MsgBox("Update of map " & m_oCurMap.m_sName & " has been sent.", vbOKOnly + vbInformation, "Map Update Sent")
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub cmdZoomOut_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdZoomOut_Click"
    Call WriteProcStart(sRoutineName)
    

    cmdZoomOut.Enabled = False
    
    m_nZoomLeft = 0
    m_nZoomTop = 0
    m_nZoomHeight = 0
    m_nZoomWidth = 0
    
    Call ReloadGUI
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_QueryUnload"
    Call WriteProcStart(sRoutineName)
    

    If IsFormOpen(Forms, "frmMapItem") = True Then
        Call Unload(frmMapItem)
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Public Sub ReloadGUI()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".ReloadGUI"
    Call WriteProcStart(sRoutineName)
    
                    
    Dim oMapItem As clsMapItem
    Dim nTempX1 As Long, nTempY1 As Long
    Dim nTempX2 As Long, nTempY2 As Long

    If Not m_oCurMap Is Nothing Then
        picMap.Visible = False
        Me.Refresh
    
        'Fill out the text properties
        txtMapName.Text = m_oCurMap.m_sName
        txtMapPic.Text = m_oCurMap.m_sPicture
        rtbDescription.Text = m_oCurMap.m_sDescription
    
        'Load the primary picture
        If Not m_sLastLoadedPictureIntoSource = g_cMAPDIR & m_oCurMap.m_sPicture Then
            m_sLastLoadedPictureIntoSource = g_cMAPDIR & m_oCurMap.m_sPicture
            Set picMapSource.Picture = LoadAPicture(g_cMAPDIR, m_oCurMap.m_sPicture)
        End If
                    
        If Not picMapSource.Picture = 0 Then
            If m_nZoomHeight = 0 Then m_nZoomHeight = picMapSource.Height
            If m_nZoomWidth = 0 Then m_nZoomWidth = picMapSource.Width
            Call picMap.PaintPicture(picMapSource.Picture, 0, 0, picMap.Width, picMap.Height, _
                                     m_nZoomLeft, m_nZoomTop, m_nZoomWidth, m_nZoomHeight)
        Else
            Set picMap.Picture = LoadPicture()
        End If
        
        'Place the party X spot
        Call WorldPtToMapPt(m_oCurMap.m_nPartyX, m_oCurMap.m_nPartyY, nTempX1, nTempY1)
        Call WorldPtToMapPt(m_oCurMap.m_nPartyX + m_cPARTYXSIZE, m_oCurMap.m_nPartyY + m_cPARTYXSIZE, nTempX2, nTempY2)
        nTempX2 = nTempX2 - nTempX1
        nTempY2 = nTempY2 - nTempY1
        
        Set picTemp.Picture = LoadAPicture(g_cMAPDIR, "PartyX.BMP")
        Call TransparentPaint(picTemp, picMask, picMap, nTempX1, nTempY1, nTempX2, nTempY2)

        'Now place all of the map items
        For Each oMapItem In m_oCurMap.Col()
            Call WorldPtToMapPt(oMapItem.m_nX, oMapItem.m_nY, nTempX1, nTempY1)
            Call WorldPtToMapPt(oMapItem.m_nX + oMapItem.m_nWidth, oMapItem.m_nY + oMapItem.m_nHeight, nTempX2, nTempY2)
            nTempX2 = nTempX2 - nTempX1
            nTempY2 = nTempY2 - nTempY1
            
            Set picTemp.Picture = LoadAPicture(g_cMAPDIR, oMapItem.m_sPicture)
            Call TransparentPaint(picTemp, picMask, picMap, nTempX1, nTempY1, Max(10, nTempX2), Max(10, nTempY2))
        Next oMapItem

        'Now place the scale
        Dim nDays As Double
        If m_oCurMap.m_nLenEqualOneDay = 0 Then
            nDays = 1
        Else
            nDays = GetDaysAtCurrentZoom()
        End If
        lblScale.Caption = m_oCurMap.GetMapScale(nDays)
        lneScaleHorz.Visible = (Len(Trim(lblScale.Caption)) > 0)
        lneScaleVertLeft.Visible = (Len(Trim(lblScale.Caption)) > 0)
        lneScaleVertRight.Visible = (Len(Trim(lblScale.Caption)) > 0)
        lblScale.Visible = (Len(Trim(lblScale.Caption)) > 0)

        cmdUpdate.Enabled = True
        picMap.Visible = True
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    picMap.Visible = True

End Sub

Private Sub Form_Resize()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Resize"
    Call WriteProcStart(sRoutineName)
    
                    
    Static bResizing As Boolean
    
    If bResizing = False Then
        bResizing = True
        
        If Me.WindowState = vbNormal Then
            Me.Width = Max(6500, Me.Width)
            Me.Height = Max(3800, Me.Height)
        End If
        
        If Not Me.WindowState = vbMinimized Then
            framControls.Left = Me.Width - 180 - framControls.Width
            cmdDone.Left = framControls.Left + cmdAddNew.Left
            cmdUpdate.Left = cmdDone.Left
            cmdZoomOut.Left = cmdDone.Left
            chkAddMapItem.Left = cmdUpdate.Left
            chkDeleteItem.Left = chkAddMapItem.Left
            picMap.Width = framControls.Left - 105 - picMap.Left
            rtbDescription.Width = picMap.Width
            cmdFindMap.Left = picMap.Width + picMap.Left - cmdFindMap.Width
            txtMapPic.Width = cmdFindMap.Left - txtMapPic.Left
            txtMapName.Width = picMap.Width
    
            lblInstructions.Left = 0
            lblInstructions.Width = Me.Width
            lblInstructions.Top = Me.Height - lblInstructions.Height - 400
    
            rtbDescription.Top = Me.Height - 1125 - lblInstructions.Height
            txtMapPic.Top = rtbDescription.Top - 360
            txtMapName.Top = txtMapPic.Top - 360
            cmdFindMap.Top = txtMapPic.Top
            picMap.Height = txtMapPic.Top - 470
            lstItems.Height = Me.Height - 645 - lblInstructions.Height
        
            chkShowDetail.Left = Me.Width - 180 - chkShowDetail.Width
            chkShowDetail.Top = Me.Height - lblInstructions.Height - 388 - chkShowDetail.Height
        
            If Not m_oCurMap Is Nothing Then
                Call ReloadGUI
                Call UpdateAllLabels
            End If
        End If
        
        bResizing = False
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub lblScale_DblClick()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lbeScale_DblClick"
    Call WriteProcStart(sRoutineName)
    
    
    Dim nDays As Double
    
        If m_oCurMap.m_nLenEqualOneDay = 0 Then
            nDays = 1
        Else
            nDays = GetDaysAtCurrentZoom()
        End If
        
        nDays = InputBox("Please enter time it would take to travel the distance of the yellow line at the current scale in days...", "Update Scale", nDays)
        lblScale.Caption = m_oCurMap.GetMapScale(nDays)

        'This is the #days to travel the length of the screen
        nDays = nDays * (picMap.Width / (lneScaleHorz.X2 - lneScaleHorz.X1))
        'This is the #days to travel the world
        nDays = nDays * (m_nZoomWidth / picMapSource.Width)
        'This is the length you can travel during one day
        m_oCurMap.m_nLenEqualOneDay = picMapSource.Width / nDays
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub m_oFormManager_DeleteItem()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_DeleteItem"
    Call WriteProcStart(sRoutineName)
    
    
    Call m_oCurMap.Delete(g_oDB)
    Call lstItems.RemoveItem(lstItems.ListIndex)
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub m_oFormManager_SaveExistingItemEx(bSaveWasSuccessfull As Boolean)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_SaveExistingItem"
    Call WriteProcStart(sRoutineName)
    
    
    If Len(Trim(txtMapName.Text)) > 0 Then
        Call ScreenToObject(m_oCurMap)
        m_oCurMap.m_nVersion = m_oCurMap.m_nVersion + 1
        Call m_oCurMap.Save(g_oDB)
        
        lstItems.List(lstItems.ListIndex) = m_oCurMap.m_sName
        
        If IsFormOpen(Forms, "frmMapItem") = True Then
            Call frmMapItem.Save
        End If
        
        bSaveWasSuccessfull = True
    Else
        Call MsgBox("Please specify a map name.", vbOKOnly + vbInformation, "Error Saving")
        bSaveWasSuccessfull = False
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub ScreenToObject(oMap As clsMap)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".ScreenToObject"
    Call WriteProcStart(sRoutineName)
                        
    
    oMap.m_sPicture = txtMapPic.Text
    oMap.m_sDescription = rtbDescription.Text
    oMap.m_sName = txtMapName.Text
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub m_oFormManager_SaveNewItemEx(bSaveWasSuccessfull As Boolean)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_SaveNewItemEx"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oMap As New clsMap
    
    If Len(Trim(txtMapName.Text)) > 0 Then
        Call ScreenToObject(oMap)
        oMap.m_nVersion = 0
        Call lstItems.AddItem(oMap.m_sName)
        lstItems.ItemData(lstItems.NewIndex) = oMap.Save(g_oDB)
        
        bSaveWasSuccessfull = True
    Else
        Call MsgBox("Please specify a map name.", vbOKOnly + vbInformation, "Error Saving")
        bSaveWasSuccessfull = False
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub m_oFormManager_SetState(bNewStateOfItem As Boolean)
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_SetState"
    Call WriteProcStart(sRoutineName)
    
    
    Call SetAttributes(txtMapPic, False)
    Call SetAttributes(cmdFindMap, bNewStateOfItem)
    Call SetAttributes(rtbDescription, bNewStateOfItem)
    Call SetAttributes(txtMapName, bNewStateOfItem)
    chkAddMapItem.Visible = bNewStateOfItem
    chkAddMapItem.Value = vbUnchecked
    chkDeleteItem.Visible = bNewStateOfItem
    chkDeleteItem.Value = vbUnchecked
    
    If IsFormOpen(Forms, "frmMapItem") = True Then
        Call SetAttributes(frmMapItem.txtName, bNewStateOfItem)
        Call SetAttributes(frmMapItem.rtbDesc, bNewStateOfItem)
        Call SetAttributes(frmMapItem.rtbHistory, bNewStateOfItem)
    End If
    
    cmdUpdate.Enabled = (Not bNewStateOfItem And lstItems.ListIndex > -1)
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub m_oFormManager_UpdateItem()
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".m_oFormManager_UpdateItem"
    Call WriteProcStart(sRoutineName)
    
    
    Dim bLoadMap As Boolean
    
    picMap.Visible = False
    If Me.Visible = False Then Me.Visible = True
    Me.Refresh
    
    If m_oCurMap Is Nothing Then
        bLoadMap = True
    Else
        bLoadMap = (Not m_oCurMap.m_nMapID = lstItems.ItemData(lstItems.ListIndex))
    End If
    
    If bLoadMap = True Then
        Set m_oCurMap = New clsMap
        Call m_oCurMap.Load(g_oDB, lstItems.ItemData(lstItems.ListIndex))
    End If
    
    m_nZoomLeft = 0
    m_nZoomTop = 0
    m_nZoomHeight = 0
    m_nZoomWidth = 0
    
    Call ReloadGUI
    Call UpdateAllLabels
    
    picMap.Visible = True
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub Form_Load()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Load"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oRst As ADODB.Recordset
    
    m_oLabels.SourceControl = lblLabel
    m_sLastLoadedPictureIntoSource = ""
    Set m_oCurMap = Nothing
    
    'Load the form manager
    Set m_oFormManager = New clsFOTAStdFormManager
    Call m_oFormManager.Initialize(Me)
    
    'Load a list of all the maps
    Call ReloadList
    chkShowDetail.Value = BoolToInt(g_bShowAllLabels)
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub ReloadList()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Load"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oRst As ADODB.Recordset
    Dim nIDDisplayed As Long
    Dim i As Long
    
    If lstItems.ListIndex > -1 Then
        nIDDisplayed = lstItems.ItemData(lstItems.NewIndex)
    Else
        nIDDisplayed = -1
    End If
    
    'Load a list of all the maps
    Set oRst = OpenMyRset(g_oDB, "SELECT * FROM Maps")
    Call lstItems.Clear
    If oRst.RecordCount() > 0 Then
        Call oRst.MoveFirst
        While oRst.EOF() = False
            Call lstItems.AddItem(oRst![sName])
            lstItems.ItemData(lstItems.NewIndex) = oRst![nMapID]
            Call oRst.MoveNext
        Wend
        
        'Now select the item we had selected
        If nIDDisplayed = -1 Then
            'lstItems.ListIndex = 0
        Else
            For i = 0 To lstItems.ListCount - 1
                If lstItems.ItemData(i) = nIDDisplayed Then
                    lstItems.ListIndex = i
                    Exit For
                End If
            Next i
        End If
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub picMap_DblClick()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".picMap_DblClick"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oMapItem As clsMapItem

    m_bMouseDownOnParty = False
    m_bMouseDownAddingItem = False
    
    Set oMapItem = GetMapItemAt(m_nLastMouseMoveX, m_nLastMouseMoveY)
    If Not oMapItem Is Nothing Then
        'Easiest way to know my state for now is to check the enabled status of a control
        If IsFormOpen(Forms, "frmMapItem") = False Then
            Call frmMapItem.Show
        End If
        Call frmMapItem.DisplayMe(oMapItem)
    End If
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub picMap_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".picMap_DblClick"
    Call WriteProcStart(sRoutineName)
    
    
    Dim nTempX1 As Long, nTempY1 As Long

    If Not m_oCurMap Is Nothing Then
        Call MapPtToWorldPt(CLng(X), CLng(Y), nTempX1, nTempY1)
        
        m_bMouseDownMeasuring = (Button = 2)
        m_bMouseDownOnParty = (Button = 1 And Distance(nTempX1, nTempY1, m_oCurMap.m_nPartyX + m_cPARTYXSIZE / 2, m_oCurMap.m_nPartyY + m_cPARTYXSIZE / 2) < Distance(0, 0, m_cPARTYXSIZE, m_cPARTYXSIZE) / 2)
        m_bMouseDownAddingItem = (Button = 1 And m_bMouseDownOnParty = False And chkAddMapItem.Value = vbChecked)
        m_bMouseDownZooming = (Button = 1 And m_bMouseDownOnParty = False And m_bMouseDownAddingItem = False)
        m_nMouseDownX = X
        m_nMouseDownY = Y
    End If
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub picMap_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".picMap_MouseMove"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oMapItem As clsMapItem
    Dim oLabel As Label
    Dim nTempX2 As Long, nTempY2 As Long
    Dim nTempX1 As Long, nTempY1 As Long
    Dim nDays As Double
    
    If Not m_oCurMap Is Nothing Then
        Call WorldPtToMapPt(m_oCurMap.m_nPartyX, m_oCurMap.m_nPartyY, nTempX1, nTempY1)
        Call WorldPtToMapPt(m_oCurMap.m_nPartyX + m_cPARTYXSIZE, m_oCurMap.m_nPartyY + m_cPARTYXSIZE, nTempX2, nTempY2)
        nTempX2 = nTempX2 - nTempX1
        nTempY2 = nTempY2 - nTempY1
        m_nLastMouseMoveX = X
        m_nLastMouseMoveY = Y
    
        If m_bMouseDownAddingItem = True Or m_bMouseDownZooming = True Then
            shpOutline.Left = m_nMouseDownX
            shpOutline.Top = m_nMouseDownY
            shpOutline.Width = Max((10 / m_nZoomWidth) * picMap.Width, X - shpOutline.Left)
            shpOutline.Height = Max((10 / m_nZoomHeight) * picMap.Height, Y - shpOutline.Top)
            shpOutline.Visible = True
        ElseIf m_bMouseDownOnParty = True Then
            shpOutline.Width = nTempX2
            shpOutline.Height = nTempY2
            shpOutline.Left = X - (m_nMouseDownX - nTempX1)
            shpOutline.Top = Y - (m_nMouseDownY - nTempY1)
            shpOutline.Visible = True
        ElseIf m_bMouseDownMeasuring = True Then
            lneMeasuring.X1 = m_nMouseDownX
            lneMeasuring.Y1 = m_nMouseDownY
            lneMeasuring.X2 = X
            lneMeasuring.Y2 = Y
            lneMeasuring.Visible = True
            
            Call MapPtToWorldPt(m_nMouseDownX, m_nMouseDownY, nTempX1, nTempY1)
            Call MapPtToWorldPt(CLng(X), CLng(Y), nTempX2, nTempY2)
            
            nDays = Distance(nTempX1, nTempY1, nTempX2, nTempY2) / m_oCurMap.m_nLenEqualOneDay
            
            lblMeasuring.Caption = " " & m_oCurMap.GetMapScale(nDays)
            If X + 120 + lblMeasuring.Width > picMap.Width Then
                lblMeasuring.Left = X - 120 - lblMeasuring.Width
            Else
                lblMeasuring.Left = X + 120
            End If
            lblMeasuring.Top = Between(0, Y - lblMeasuring.Height / 2, picMap.Height)
            lblMeasuring.Visible = True
        ElseIf Not chkShowDetail.Value = vbChecked And rtbDescription.Enabled = False Then
            Call UpdateAllLabels(X, Y)
        End If
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub cmdFindMap_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdFindMap_Click"
    Call WriteProcStart(sRoutineName)
  
  
    Dim sTemp As String
    
    sTemp = GetFile(g_cMAPDIR, False, g_cGRAPHICFILTER, True)
        
    If Len(Trim(sTemp)) > 0 Then
        txtMapPic.Text = sTemp
        m_oCurMap.m_sPicture = sTemp
        Set picMapSource.Picture = LoadAPicture(g_cMAPDIR, sTemp)
        m_nZoomHeight = 0
        m_nZoomWidth = 0
        Call ReloadGUI
    End If
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Private Function GetMapItemAt(nMapX As Long, nMapY As Long) As clsMapItem

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".GetMapItemAt"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oMapItem As clsMapItem
    Dim oLabel As Label
    Dim nTempX1 As Long, nTempY1 As Long
    
    Call MapPtToWorldPt(nMapX, nMapY, nTempX1, nTempY1)

    If Not m_oCurMap Is Nothing Then
        For Each oMapItem In m_oCurMap.Col()
            If Distance(nTempX1, nTempY1, oMapItem.m_nX + oMapItem.m_nWidth / 2, oMapItem.m_nY + oMapItem.m_nHeight / 2) < Distance(0, 0, oMapItem.m_nWidth, oMapItem.m_nHeight) Then
                Set GetMapItemAt = oMapItem
                Exit For
            End If
        Next oMapItem
    End If
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Function

Private Sub picMap_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".picMap_MouseUp"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oMapItem As clsMapItem
    Dim oLabel As Label
    Dim nTempX1 As Long, nTempY1 As Long
    Dim nTempX2 As Long, nTempY2 As Long
    Dim nTempX3 As Long, nTempY3 As Long

    If Not m_oCurMap Is Nothing Then
        
        If chkDeleteItem.Value = vbChecked Then
            chkDeleteItem.Value = vbUnchecked
            Set oMapItem = GetMapItemAt(CLng(X), CLng(Y))
            If Not oMapItem Is Nothing Then
                Call oMapItem.Delete(g_oDB)
                Call m_oCurMap.RemoveMapItem(oMapItem)
            End If
            
            m_bMouseDownZooming = False
            
            Call ReloadGUI
            m_oLabels.GetControlForKey(oMapItem.m_nMapItemID).Visible = False
                    
        ElseIf Distance(X, Y, m_nMouseDownX, m_nMouseDownY) < 10 Then
            m_bMouseDownOnParty = False
            m_bMouseDownAddingItem = False
            m_bMouseDownZooming = False
            m_bMouseDownMeasuring = False
            shpOutline.Visible = False
            lneMeasuring.Visible = False
            lblMeasuring.Visible = False
                
            '02/23/2003 Chris Hill  If we have this be both buttons, then it becomes nearly impossible
            'to double-click on a node to edit it.
            If Button = 2 Then
                Call MapPtToWorldPt(CLng(X), CLng(Y), nTempX1, nTempY1)
                nTempX1 = Between(m_nZoomWidth / 2, nTempX1 - (m_nZoomWidth / 2), picMapSource.Width - m_nZoomWidth)
                nTempY1 = Between(m_nZoomHeight / 2, nTempY1 - (m_nZoomHeight / 2), picMapSource.Height - m_nZoomHeight)
                If Not nTempX1 = m_nZoomLeft Or Not nTempY1 = m_nZoomTop Then
                    m_nZoomLeft = nTempX1
                    m_nZoomTop = nTempY1
                    Call ReloadGUI
                    Call UpdateAllLabels
                End If
            End If
            
        ElseIf m_bMouseDownOnParty = True Then
            Call WorldPtToMapPt(m_oCurMap.m_nPartyX, m_oCurMap.m_nPartyY, nTempX1, nTempY1)
            Call WorldPtToMapPt(m_oCurMap.m_nPartyX + m_cPARTYXSIZE, m_oCurMap.m_nPartyY + m_cPARTYXSIZE, nTempX2, nTempY2)
            nTempX2 = nTempX2 - nTempX1
            nTempY2 = nTempY2 - nTempY1
    
            Call MapPtToWorldPt(X - (m_nMouseDownX - nTempX1), Y - (m_nMouseDownY - nTempY1), nTempX3, nTempY3)
            m_oCurMap.m_nPartyX = nTempX3
            m_oCurMap.m_nPartyY = nTempY3
            
            shpOutline.Visible = False
            m_bMouseDownOnParty = False
            
            'Broadcast the changes
            Call MakeProcessSendMsg(g_cPartyUpdatedOverlandMapCode, m_oCurMap.m_sGUID(), m_oCurMap.m_nMapID, m_oCurMap.m_nPartyX, m_oCurMap.m_nPartyY)
            
        ElseIf m_bMouseDownAddingItem = True Then
            Call MapPtToWorldPt(m_nMouseDownX, m_nMouseDownY, nTempX1, nTempY1)
            Call MapPtToWorldPt(CLng(X), CLng(Y), nTempX2, nTempY2)
        
            Set oMapItem = New clsMapItem
            oMapItem.m_nMapID = m_oCurMap.m_nMapID
            oMapItem.m_sDescription = ""
            oMapItem.m_sHistory = ""
            oMapItem.m_sName = "New Item"
            oMapItem.m_sPicture = "City.BMP"
            oMapItem.m_nWidth = nTempX2 - nTempX1
            oMapItem.m_nHeight = nTempY2 - nTempY1
            oMapItem.m_nX = nTempX1
            oMapItem.m_nY = nTempY1
            
            Call oMapItem.Save(g_oDB)
            Call m_oCurMap.Add(oMapItem)
            m_bMouseDownAddingItem = False
            shpOutline.Visible = False
            
            Set picTemp.Picture = LoadAPicture(g_cMAPDIR, oMapItem.m_sPicture)
            Call picMap.PaintPicture(picTemp.Picture, m_nMouseDownX, m_nMouseDownY, X - m_nMouseDownX, Y - m_nMouseDownY)
            
            'Automatically launch a node edit
            If IsFormOpen(Forms, "frmMapItem") = False Then
                Call frmMapItem.Show
            End If
            Call frmMapItem.DisplayMe(oMapItem)
            
        ElseIf m_bMouseDownMeasuring = True Then
            lneMeasuring.Visible = False
            lblMeasuring.Visible = False
            m_bMouseDownMeasuring = False
            
        ElseIf m_bMouseDownZooming = True Then
            'Don't do anything if the values are negative
            If Not X < m_nMouseDownX And Not Y < m_nMouseDownY Then
                Call MapPtToWorldPt(m_nMouseDownX, m_nMouseDownY, nTempX1, nTempY1)
                Call MapPtToWorldPt(Max((10 / m_nZoomWidth) * picMap.Width + m_nMouseDownX, CLng(X)), Max((10 / m_nZoomHeight) * picMap.Height + m_nMouseDownY, CLng(Y)), nTempX2, nTempY2)
    
                If nTempX2 - nTempX1 < 10 Or nTempY2 - nTempY1 < 10 Then
                    Call MsgBox("Unable to Zoom in this much.", vbOKOnly + vbCritical, "Error Zooming")
                Else
                    m_nZoomLeft = nTempX1
                    m_nZoomTop = nTempY1
                    m_nZoomWidth = nTempX2 - nTempX1
                    m_nZoomHeight = nTempY2 - nTempY1
                    
                    Call UpdateAllLabels
                    Call ReloadGUI
                    
                    cmdZoomOut.Enabled = True
                End If

            End If
            m_bMouseDownZooming = False
            shpOutline.Visible = False
        End If
        
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub MapPtToWorldPt(nMapX As Long, nMapY As Long, ByRef nWorldX As Long, ByRef nWorldY As Long)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".MapPtToWorldPt"
    Call WriteProcStart(sRoutineName)
    
    
    If m_nZoomHeight = 0 Then m_nZoomHeight = picMapSource.Height
    If m_nZoomWidth = 0 Then m_nZoomWidth = picMapSource.Width
                
    nWorldX = (nMapX / picMap.Width) * m_nZoomWidth + m_nZoomLeft
    nWorldY = (nMapY / picMap.Height) * m_nZoomHeight + m_nZoomTop


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub WorldPtToMapPt(nWorldX As Long, nWorldY As Long, ByRef nMapX As Long, ByRef nMapY As Long)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".WorldPtToMapPt"
    Call WriteProcStart(sRoutineName)


    If m_nZoomHeight = 0 Then m_nZoomHeight = picMapSource.Height
    If m_nZoomWidth = 0 Then m_nZoomWidth = picMapSource.Width
    
    nMapX = nWorldX - m_nZoomLeft
    nMapX = picMap.Width * (nMapX / m_nZoomWidth)

    nMapY = nWorldY - m_nZoomTop
    nMapY = picMap.Height * (nMapY / m_nZoomHeight)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub rtbDescription_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".rtbDescription_MouseMove"
    Call WriteProcStart(sRoutineName)
    
    
    Call EraseAllLabels
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub txtMapPic_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".txtMapPic_MouseMove"
    Call WriteProcStart(sRoutineName)
    
    
    Call EraseAllLabels
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub framControls_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".framControls_MouseMove"
    Call WriteProcStart(sRoutineName)
    
    
    Call EraseAllLabels
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub lstItems_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lstItems_MouseMove"
    Call WriteProcStart(sRoutineName)
    
    
    Call EraseAllLabels
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_MouseMove"
    Call WriteProcStart(sRoutineName)
    
    
    Call EraseAllLabels
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub EraseAllLabels()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".EraseAllLabels"
    Call WriteProcStart(sRoutineName)
    
    
    Dim i As Long
            
    If Not chkShowDetail.Value = vbChecked Then
        For i = 0 To lblLabel.UBound()
            lblLabel(i).Visible = False
        Next i
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub UpdateAllLabels(Optional nX As Single = -10000, Optional nY As Single = -10000)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".UpdateAllLabels"
    Call WriteProcStart(sRoutineName)
    
    
    Dim oMapItem As clsMapItem
    Dim nTempX1 As Long, nTempY1 As Long
    Dim nTempX2 As Long, nTempY2 As Long
    Dim oLabel As Label
    
    Call MapPtToWorldPt(CLng(nX), CLng(nY), nTempX1, nTempY1)
    
    If Not m_oCurMap Is Nothing Then
        For Each oMapItem In m_oCurMap.Col()
            
            'Setup the positioning and caption of this label
            Set oLabel = m_oLabels.GetControlForKey(oMapItem.m_nMapItemID)
            oLabel.Visible = False
            oLabel.Caption = " " & oMapItem.m_sName & " "
            
            Call WorldPtToMapPt(oMapItem.m_nX + oMapItem.m_nWidth, oMapItem.m_nY + oMapItem.m_nHeight / 2, nTempX2, nTempY2)
            oLabel.Left = nTempX2
            oLabel.Top = nTempY2 - (oLabel.Height / 2)
                
            If chkShowDetail.Value = vbChecked Then
                oLabel.BorderStyle = 0
                oLabel.BackStyle = 0
                oLabel.Visible = True
            ElseIf nTempX1 >= oMapItem.m_nX And nTempX1 <= oMapItem.m_nX + oMapItem.m_nWidth And _
                   nTempY1 >= oMapItem.m_nY And nTempY1 <= oMapItem.m_nY + oMapItem.m_nHeight And _
                   Len(Trim(oMapItem.m_sName)) > 0 Then
                        oLabel.BorderStyle = 1
                        oLabel.BackStyle = 1
                        oLabel.Visible = True
            Else
                oLabel.Visible = False
            End If
        Next oMapItem
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
                    
End Sub
Public Function GetDaysAtCurrentZoom() As Double

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".EraseAllLabels"
    Call WriteProcStart(sRoutineName)
    
        
    'This is the #days to travel screen
    GetDaysAtCurrentZoom = m_nZoomWidth / m_oCurMap.m_nLenEqualOneDay
    'This is the #days to travel the length of the scale
    GetDaysAtCurrentZoom = GetDaysAtCurrentZoom * ((lneScaleHorz.X2 - lneScaleHorz.X1) / picMap.Width)

    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
       
End Function
