VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmSpellCasting 
   Caption         =   "Spell Casting"
   ClientHeight    =   6495
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8445
   Icon            =   "frmSpellCasting.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6495
   ScaleWidth      =   8445
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   3120
      Top             =   6000
      _ExtentX        =   635
      _ExtentY        =   635
   End
   Begin VB.CommandButton cmdDone 
      Caption         =   "Done"
      Height          =   375
      Left            =   6960
      TabIndex        =   17
      Top             =   6000
      Width           =   1335
   End
   Begin VB.Frame Frame3 
      Caption         =   "Step 3.)  Cast Spell"
      Height          =   1575
      Left            =   5280
      TabIndex        =   4
      Top             =   4320
      Width           =   3015
      Begin VB.CommandButton cmdCast 
         Caption         =   "Cast Spell"
         Enabled         =   0   'False
         Height          =   375
         Left            =   240
         TabIndex        =   7
         Top             =   960
         Width           =   2535
      End
      Begin VB.CheckBox chkRemoveFromMemory 
         Caption         =   "Remove Spell From Memory"
         Height          =   255
         Left            =   240
         TabIndex        =   6
         Top             =   360
         Width           =   2295
      End
      Begin VB.CheckBox chkAutoSend 
         Caption         =   "Automatically Send When Cast"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   600
         Width           =   2655
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Step 2.)  Select Target    (Optional)"
      Height          =   4095
      Left            =   5280
      TabIndex        =   3
      Top             =   120
      Width           =   3015
      Begin VB.TextBox txtTarget 
         Height          =   285
         Left            =   480
         TabIndex        =   16
         Top             =   3600
         Width           =   2295
      End
      Begin FOTATools.FOTAListControl lstTarget 
         Height          =   2595
         Left            =   480
         TabIndex        =   13
         Top             =   600
         Width           =   2295
         _ExtentX        =   4048
         _ExtentY        =   4577
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         FontSize        =   8.25
         FontName        =   "MS Sans Serif"
         MyNewMultiSelect=   2
      End
      Begin VB.Label Label4 
         Caption         =   "Character"
         Height          =   255
         Left            =   240
         TabIndex        =   15
         Top             =   360
         Width           =   975
      End
      Begin VB.Label Label3 
         Caption         =   "Other:"
         Height          =   255
         Left            =   240
         TabIndex        =   14
         Top             =   3360
         Width           =   855
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Step 1.)  Select Spell"
      Height          =   5775
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   5055
      Begin VB.CommandButton cmdSearch 
         Caption         =   "Apply Filters"
         Height          =   855
         Left            =   3960
         TabIndex        =   12
         Top             =   360
         Width           =   855
      End
      Begin VB.CheckBox chkPriest 
         Caption         =   "Priest"
         Height          =   255
         Left            =   3000
         TabIndex        =   11
         Top             =   960
         Value           =   1  'Checked
         Width           =   855
      End
      Begin VB.CheckBox chkMage 
         Caption         =   "Mage"
         Height          =   255
         Left            =   3000
         TabIndex        =   10
         Top             =   720
         Value           =   1  'Checked
         Width           =   855
      End
      Begin FOTATools.FOTAComboBox cboSpellLevel 
         Height          =   315
         Left            =   720
         TabIndex        =   9
         Top             =   795
         Width           =   2055
         _ExtentX        =   3625
         _ExtentY        =   556
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Text            =   "cboInternal"
         Locked          =   0   'False
         PreventTyping   =   -1  'True
      End
      Begin VB.ComboBox cboFilters 
         Height          =   315
         ItemData        =   "frmSpellCasting.frx":0442
         Left            =   720
         List            =   "frmSpellCasting.frx":044F
         TabIndex        =   1
         Top             =   360
         Width           =   3135
      End
      Begin MSComctlLib.ListView lvwSpells 
         Height          =   4215
         Left            =   240
         TabIndex        =   20
         Top             =   1320
         Width           =   4575
         _ExtentX        =   8070
         _ExtentY        =   7435
         SortKey         =   3
         View            =   3
         Sorted          =   -1  'True
         MultiSelect     =   -1  'True
         LabelWrap       =   0   'False
         HideSelection   =   0   'False
         FullRowSelect   =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         NumItems        =   5
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "Lvl"
            Object.Width           =   707
         EndProperty
         BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   1
            Text            =   "Typ"
            Object.Width           =   794
         EndProperty
         BeginProperty ColumnHeader(3) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   2
            Text            =   "#"
            Object.Width           =   707
         EndProperty
         BeginProperty ColumnHeader(4) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   3
            Text            =   "Name"
            Object.Width           =   4058
         EndProperty
         BeginProperty ColumnHeader(5) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   4
            Text            =   "Macro"
            Object.Width           =   1184
         EndProperty
      End
      Begin VB.Label Label2 
         Caption         =   "Level"
         Height          =   255
         Left            =   240
         TabIndex        =   8
         Top             =   800
         Width           =   495
      End
      Begin VB.Label Label1 
         Caption         =   "Filter:"
         Height          =   255
         Left            =   240
         TabIndex        =   2
         Top             =   360
         Width           =   975
      End
   End
   Begin VB.Label lblAfterCastingSpellPoints 
      AutoSize        =   -1  'True
      Caption         =   "Spell Points After Casting:  "
      Height          =   195
      Left            =   120
      TabIndex        =   19
      Top             =   6240
      Width           =   1905
   End
   Begin VB.Label lblCurrentSpellPoints 
      AutoSize        =   -1  'True
      Caption         =   "Current Spell Points:  "
      Height          =   195
      Left            =   120
      TabIndex        =   18
      Top             =   6000
      Width           =   1515
   End
End
Attribute VB_Name = "frmSpellCasting"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "frmSpellCasting"
Public m_oChatRoom As frmChatRoom_3_0_0

Private Sub cmdCast_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdCast_Click"
    Call WriteProcStart(sRoutineName)
    

    Dim i As Long
    Dim sTargets As String
    Dim nTarget As Long
    Dim nSpell As Long
    
    If SpellSelCount() > 5 Then
        Call MsgBox("I'm sorry but only five spells may be cast at one time.", vbOKOnly + vbInformation, "Error")
    Else
        'Compile our list of targets
        sTargets = txtTarget.Text & ", "
        If lstTarget.SelCount > 0 Then
            For nTarget = 0 To lstTarget.ListCount - 1
                If lstTarget.Selected(nTarget) = True Then
                    sTargets = sTargets & lstTarget.List(nTarget) & ", "
                End If
            Next nTarget
        End If
        'Trip off the last ", "
        sTargets = Left(sTargets, Len(sTargets) - 2)
        If Len(txtTarget.Text) = 0 Then
            sTargets = Mid(sTargets, 3)
        End If
    
        'Now cast all our spells
        For nSpell = 1 To lvwSpells.ListItems.Count()
            If lvwSpells.ListItems.Item(nSpell).Selected = True Then
                Call Cast(lvwSpells.ListItems.Item(nSpell).Key(), sTargets)
            End If
        Next nSpell
        
        'Update the GUI
        Call UpdateSpellPoints
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Function SpellSelCount() As Long
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".SpellSelCount"
    Call WriteProcStart(sRoutineName)


    Dim nSpell As Long
    SpellSelCount = 0
    
    'Now cast all our spells
    For nSpell = 1 To lvwSpells.ListItems.Count()
        If lvwSpells.ListItems.Item(nSpell).Selected = True Then
            SpellSelCount = SpellSelCount + 1
        End If
    Next nSpell
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function

Private Sub Cast(sKey As String, Optional sTargetName As String = "")
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Cast"
    Call WriteProcStart(sRoutineName)

    
    Dim sTemp As String
    Dim nMacroIndex As Long
    Dim nNameIndex As Long
    Dim nCostIndex As Long
    Dim oTable As clsTable
    Dim sMacro As String
    Dim oChat As frmChatRoom_3_0_0
    Dim oSpell As clsSpell
    Dim i As Long
    Dim nRow As Long
    
    If FindSpell(sKey, oTable, nRow) = True Then
         'Now cast the spell!
         nMacroIndex = oTable.FindColumn("Macro")
         nNameIndex = oTable.FindColumn("Spell")
         nCostIndex = oTable.FindColumn("Spl Pts")
         sMacro = oTable.Data(nMacroIndex, nRow)
         
         'Is their a macro?  If not we just send a simple command out.
         If Len(sMacro) > 0 Then
            sTemp = sMacro
            sTemp = SearchAndReplace(sTemp, "<CRLF>", vbCrLf)
            sTemp = SearchAndReplace(sTemp, "<PAREN>", """")
            sTemp = SearchAndReplace(sTemp, "[SPELLTARGET]", """" & sTargetName & """")
            
            If chkAutoSend.Value = vbChecked Then
                'Replace the prepareToSend with Send
                sTemp = SearchAndReplace(sTemp, "PrepareToSend(", "Send(", True)
            Else
                'First make sure that everything in the macro is a send...
                sTemp = SearchAndReplace(sTemp, "PrepareToSend(", "Send(", True)
                'Now make it all a preparetosend.  This is important because otherwise "PreapreToSend(" will become "prepareToPrepareToSend("
                sTemp = SearchAndReplace(sTemp, "Send(", "PrepareToSend(", True)
            End If
            
            Call m_oChatRoom.RunQuery(sTemp)
         Else
            sTemp = "[Begins to chant and casts " & oTable.Data(nNameIndex, nRow)
            If Len(sTargetName) > 0 Then
                sTemp = sTemp & " on " & sTargetName & "]"
            Else
                sTemp = sTemp & "]"
            End If
            
            If chkAutoSend.Value = vbChecked Then
                 'Get us setup to format the spell casting
                 m_oChatRoom.rtbTempUse.Text = sTemp
                 'Because we are now allowing formating of your sending string we have to
                 'set the default font and colors.
                 Call ResetFontToCharacterDefault(m_oChatRoom.rtbTempUse, m_oChatRoom.m_oCharTalking)
                 'Send the message to be processed
                 Call MakeProcessSendMsg(g_cSendChatMsgCode, m_oChatRoom.m_oCharTalking.sGUID, _
                                         m_oChatRoom.ChatRoomName(), _
                                         g_oEmotes.ConvertEmotes(m_oChatRoom.rtbTempUse.TextRTF))
            Else
                If Len(m_oChatRoom.rtbSendString.Text) > 0 Then
                    m_oChatRoom.rtbSendString.Text = m_oChatRoom.rtbSendString.Text & vbCrLf
                End If
                m_oChatRoom.rtbSendString.Text = m_oChatRoom.rtbSendString.Text & sTemp
            End If
             
        End If
        
        'Now remove it from our book if we were told too
        If chkRemoveFromMemory.Value = vbChecked Then
        
            Set oSpell = m_oChatRoom.m_oCharTalking.m_oSpells.FindSpell(ParseString(sKey, ";", 3), ParseString(sKey, ";", 2))
            If oSpell Is Nothing Then
                Set oSpell = m_oChatRoom.m_oCharTalking.m_oSpells.FindSpell("Free " & NumberToSpellPronoun(ParseString(sKey, ";", 1)) & " Level", ParseString(sKey, ";", 2))
                If oSpell Is Nothing Then
                    
                End If
            End If
            
            'Decrament the spell casting
            If Not oSpell Is Nothing Then
                oSpell.nSpellQuantity = Max(1, oSpell.nSpellQuantity - 1)
                'Update the list view
                For i = 1 To lvwSpells.ListItems.Count()
                    If lvwSpells.ListItems.Item(i).Key = oSpell.GetKey() Then
                        lvwSpells.ListItems.Item(i).SubItems(2) = oSpell.nSpellQuantity - 1
                    End If
                Next i
            End If
            
            'Update the spell points we have remaining
            m_oChatRoom.m_oCharTalking.nSP = m_oChatRoom.m_oCharTalking.nSP - oTable.Data(nCostIndex, nRow)
            'Now send it on to the world!
            Call MakeProcessSendMsg(g_cSerizlizedCharacterCode, g_nMyNumber, _
                                    m_oChatRoom.m_oCharTalking.sGUID, m_oChatRoom.m_oCharTalking.Serialize(), "True")
            Call m_oChatRoom.m_oCharTalking.Save(g_oDB)
        
        End If
        
    Else
        Call Err.Raise(1, sRoutineName, "Spell " & sKey & " was not found")
    End If
                    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Function NumberToSpellPronoun(nNum As Long) As String
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".NumberToSpellPronoun"
    Call WriteProcStart(sRoutineName)
    
    
    If nNum = 1 Then
        NumberToSpellPronoun = "First"
    ElseIf nNum = 2 Then
        NumberToSpellPronoun = "Second"
    ElseIf nNum = 3 Then
        NumberToSpellPronoun = "Third"
    ElseIf nNum = 4 Then
        NumberToSpellPronoun = "Fourth"
    ElseIf nNum = 5 Then
        NumberToSpellPronoun = "Fifth"
    ElseIf nNum = 6 Then
        NumberToSpellPronoun = "Sixth"
    ElseIf nNum = 7 Then
        NumberToSpellPronoun = "Seventh"
    ElseIf nNum = 8 Then
        NumberToSpellPronoun = "Eighth"
    ElseIf nNum = 9 Then
        NumberToSpellPronoun = "Ninth"
    Else
        NumberToSpellPronoun = "Error"
    End If


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Function
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Function

Private Sub cmdDone_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDone_Click"
    Call WriteProcStart(sRoutineName)


    Call Unload(Me)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
        
End Sub

Private Sub cmdSearch_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdSearch_Click"
    Call WriteProcStart(sRoutineName)


    Dim oLoopSpell As clsSpell
    Dim oTablePriestSpells As clsTable
    Dim oTableMageSpells As clsTable
    Dim oTable As clsTable
    Dim nLevelIndex As Long
    Dim nNameIndex As Long
    Dim nMacroIndex As Long
    Dim oItem  As Object
    Dim bLevelMatches As Boolean
    Dim sKey As String
    Dim nRow As Long
    
    While lvwSpells.ListItems.Count() > 0
        Call lvwSpells.ListItems.Remove(1)
    Wend
    
    'Spells Memorized or Spells in Book
    If cboFilters.ListIndex = 1 Or cboFilters.ListIndex = 2 Then
    
        For Each oLoopSpell In m_oChatRoom.m_oCharTalking.m_oSpells.Col
            'Make sure this matches our filter
            If oLoopSpell.nSpellQuantity > 1 Or cboFilters.ListIndex = 2 Then
                'Match the spell type
                If (chkMage.Value = vbChecked And oLoopSpell.IsMage() = True) Or _
                   (chkPriest.Value = vbChecked And oLoopSpell.IsPriest() = True) Then
                        'Now check the level filter
                        bLevelMatches = (cboSpellLevel.GetCurrentSelectedItemsKey() = "All")
                        If IsNumeric(cboSpellLevel.GetCurrentSelectedItemsKey()) = True Then
                            bLevelMatches = (cboSpellLevel.GetCurrentSelectedItemsKey() = oLoopSpell.nSpellLevel)
                        End If
                        'Do we include this spell?
                        If bLevelMatches = True Then
                            Set oItem = lvwSpells.ListItems.Add(, oLoopSpell.GetKey(), oLoopSpell.nSpellLevel)
                            oItem.SubItems(1) = Left(oLoopSpell.sSpellType, 1)
                            oItem.SubItems(2) = oLoopSpell.nSpellQuantity - 1
                            oItem.SubItems(3) = oLoopSpell.sSpellName
                            
                            If FindSpell(oLoopSpell.GetKey(), oTable, nRow) = True Then
                                nMacroIndex = oTable.FindColumn("Macro")
                                If InStr(1, oTable.Data(nMacroIndex, nRow), "[SPELLTARGET]") > 0 Then
                                    oItem.SubItems(4) = "Tar"
                                ElseIf Len(oTable.Data(nMacroIndex, nRow)) > 0 Then
                                    oItem.SubItems(4) = "Yes"
                                Else
                                    oItem.SubItems(4) = ""
                                End If
                            Else
                                oItem.SubItems(4) = "?"
                            End If
                        End If
                End If
            End If
        Next oLoopSpell
    
    'Display all spells or Search by whatever they typed in
    Else
    
        If chkPriest.Value = vbChecked Then
            'Load our spells
            Set oTablePriestSpells = g_oTables.GetTableByFile("PriestSpells.DAT")
            nLevelIndex = oTablePriestSpells.FindColumn("Level")
            nNameIndex = oTablePriestSpells.FindColumn("Spell")
            nMacroIndex = oTablePriestSpells.FindColumn("Macro")

            'Add the spells to the tree
            For nRow = 2 To oTablePriestSpells.Rows() - 1

                'Now check the level filter
                bLevelMatches = (cboSpellLevel.GetCurrentSelectedItemsKey() = "All")
                If IsNumeric(cboSpellLevel.GetCurrentSelectedItemsKey()) = True Then
                    bLevelMatches = (cboSpellLevel.GetCurrentSelectedItemsKey() = oLoopSpell.nSpellLevel)
                End If
                'Do we include this spell?
                If bLevelMatches = True Then
                   
                    'Now check the source filter
                    If cboFilters.ListIndex > -1 Or UCase(cboFilters.Text) = UCase(Left(oTablePriestSpells.Data(nNameIndex, nRow), Len(cboFilters.Text))) Then
                        sKey = oTablePriestSpells.Data(nLevelIndex, nRow) & ";Priest;" & oTablePriestSpells.Data(nNameIndex, nRow)
                        
                        Set oItem = lvwSpells.ListItems.Add(, sKey, oTablePriestSpells.Data(nLevelIndex, nRow))
                        oItem.SubItems(1) = "P"
                        
                        Set oLoopSpell = m_oChatRoom.m_oCharTalking.m_oSpells.FindSpell(oTablePriestSpells.Data(nNameIndex, nRow), "Priest")
                        If oLoopSpell Is Nothing Then
                            oItem.SubItems(2) = ""
                        Else
                            oItem.SubItems(2) = oLoopSpell.nSpellQuantity - 1
                        End If

                        oItem.SubItems(3) = oTablePriestSpells.Data(nNameIndex, nRow)
                        
                        If InStr(1, oTablePriestSpells.Data(nMacroIndex, nRow), "[SPELLTARGET]") > 0 Then
                            oItem.SubItems(4) = "Tar"
                        ElseIf Len(oTablePriestSpells.Data(nMacroIndex, nRow)) > 0 Then
                            oItem.SubItems(4) = "Yes"
                        Else
                            oItem.SubItems(4) = ""
                        End If
                    End If
                End If

            Next nRow
        End If
    
        If chkMage.Value = vbChecked Then
            'Load our spells
            Set oTableMageSpells = g_oTables.GetTableByFile("MageSpells.DAT")
            nLevelIndex = oTableMageSpells.FindColumn("Level")
            nNameIndex = oTableMageSpells.FindColumn("Spell")
            nMacroIndex = oTableMageSpells.FindColumn("Macro")

            'Add the spells to the tree
            For nRow = 2 To oTableMageSpells.Rows() - 1

                'Now check the level filter
                If cboSpellLevel.GetCurrentSelectedItemsKey() = "All" Or _
                   cboSpellLevel.GetCurrentSelectedItemsKey() = oTableMageSpells.Data(nLevelIndex, nRow) Then
                    
                        'Now check the source filter
                        If cboFilters.ListIndex > -1 Or UCase(cboFilters.Text) = UCase(Left(oTableMageSpells.Data(nNameIndex, nRow), Len(cboFilters.Text))) Then
                            sKey = oTableMageSpells.Data(nLevelIndex, nRow) & ";Mage;" & oTableMageSpells.Data(nNameIndex, nRow)
                            
                            Set oItem = lvwSpells.ListItems.Add(, sKey, oTableMageSpells.Data(nLevelIndex, nRow))
                            oItem.SubItems(1) = "M"
                            
                            Set oLoopSpell = m_oChatRoom.m_oCharTalking.m_oSpells.FindSpell(oTableMageSpells.Data(nNameIndex, nRow), "Mage")
                            If oLoopSpell Is Nothing Then
                                oItem.SubItems(2) = ""
                            Else
                                oItem.SubItems(2) = oLoopSpell.nSpellQuantity - 1
                            End If
                            
                            oItem.SubItems(3) = oTableMageSpells.Data(nNameIndex, nRow)
                             
                            If InStr(1, oTableMageSpells.Data(nMacroIndex, nRow), "[SPELLTARGET]") > 0 Then
                                oItem.SubItems(4) = "Tar"
                            ElseIf Len(oTableMageSpells.Data(nMacroIndex, nRow)) > 0 Then
                                oItem.SubItems(4) = "Yes"
                            Else
                                oItem.SubItems(4) = ""
                            End If
                        End If
                End If

            Next nRow
        End If
    
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Public Sub DisplayMe(oChatRoom As frmChatRoom_3_0_0)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".DisplayMe"
    Call WriteProcStart(sRoutineName)
    
    
    Set m_oChatRoom = oChatRoom
    
    Call cboSpellLevel.AddItemWithKey("All Levels", "All")
    Call cboSpellLevel.AddItemWithKey("Level 1 Spells", "1")
    Call cboSpellLevel.AddItemWithKey("Level 2 Spells", "2")
    Call cboSpellLevel.AddItemWithKey("Level 3 Spells", "3")
    Call cboSpellLevel.AddItemWithKey("Level 4 Spells", "4")
    Call cboSpellLevel.AddItemWithKey("Level 5 Spells", "5")
    Call cboSpellLevel.AddItemWithKey("Level 6 Spells", "6")
    Call cboSpellLevel.AddItemWithKey("Level 7 Spells", "7")
    Call cboSpellLevel.AddItemWithKey("Level 8 Spells", "8")
    Call cboSpellLevel.AddItemWithKey("Level 9 Spells", "9")
   
    Call LoadWithAllChars_OLD(lstTarget, True, True)
    Call LoadWithAllChars_OLD(lstTarget, False, True)
    Call lstTarget.RemoveItemByKeyIfFound(g_cDMMINIONGUID)
    
    cboFilters.ListIndex = g_nCast_FilterDefault
    Call cboSpellLevel.SelItemByKey(g_sCast_LevelDefault)
    chkMage.Value = BoolToInt(g_bCast_Mage)
    chkPriest.Value = BoolToInt(g_bCast_Priest)
    chkAutoSend.Value = BoolToInt(g_bCast_AutoSend)
    chkRemoveFromMemory.Value = BoolToInt(g_bCast_MarkOff)
        
    '03/25/2003 Chris Hill  Added a memory for the way you sort.
    lvwSpells.SortKey = g_nCast_SortColumn
    lvwSpells.Sorted = True
    Call cmdSearch_Click
    Call UpdateSpellPoints
    
    Me.Visible = True
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Private Sub Form_Unload(Cancel As Integer)
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".Form_Unload"
    Call WriteProcStart(sRoutineName)
    

    g_nCast_FilterDefault = cboFilters.ListIndex
    g_sCast_LevelDefault = cboSpellLevel.GetCurrentSelectedItemsKey()
    g_bCast_Mage = (chkMage.Value = vbChecked)
    g_bCast_Priest = (chkPriest.Value = vbChecked)
    g_bCast_AutoSend = (chkAutoSend.Value = vbChecked)
    g_bCast_MarkOff = (chkRemoveFromMemory.Value = vbChecked)
    Call SaveOptions

    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Public Sub UpdateSpellPoints()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".UpdateSpellPoints"
    Call WriteProcStart(sRoutineName)
    
    Dim nSPToUse As Long
    Dim nSpell As Long
    Dim oTable As clsTable
    Dim nCostIndex As Long
    Dim nRow As Long
    
    'Now add up all the spell points were about to use
    For nSpell = 1 To lvwSpells.ListItems.Count()
        If lvwSpells.ListItems.Item(nSpell).Selected = True Then
            If FindSpell(lvwSpells.ListItems.Item(nSpell).Key(), oTable, nRow) = True Then
                nCostIndex = oTable.FindColumn("Spl Pts")
                nSPToUse = nSPToUse + CLng(oTable.Data(nCostIndex, nRow))
            Else
                Call Err.Raise(-1, sRoutineName, "Unable to find spell <" & lvwSpells.ListItems.Item(nSpell).Key() & ">")
            End If
        End If
    Next nSpell
    
    'Also go calculate how many spell points we have left
    lblCurrentSpellPoints.Caption = "Current Spell Points: " & m_oChatRoom.m_oCharTalking.nSP & " / " & m_oChatRoom.m_oCharTalking.nMaxSP
    lblAfterCastingSpellPoints.Caption = "Spell Points After Casting: " & m_oChatRoom.m_oCharTalking.nSP - nSPToUse & " / " & m_oChatRoom.m_oCharTalking.nMaxSP
    
    If m_oChatRoom.m_oCharTalking.nSP < 0 Then
        lblCurrentSpellPoints.ForeColor = vbRed
    Else
        lblCurrentSpellPoints.ForeColor = vbBlack
    End If
    
    If m_oChatRoom.m_oCharTalking.nSP - nSPToUse < 0 Then
        lblAfterCastingSpellPoints.ForeColor = vbRed
    Else
        lblAfterCastingSpellPoints.ForeColor = vbBlack
    End If

    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Private Sub lvwSpells_ColumnClick(ByVal ColumnHeader As MSComctlLib.ColumnHeader)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lvwSpells_ColumnClick"
    Call WriteProcStart(sRoutineName)


    lvwSpells.SortKey = ColumnHeader.Index - 1
    lvwSpells.Sorted = True
    g_nCast_SortColumn = ColumnHeader.Index - 1


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub lvwSpells_Click()
        
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".lvwSpells_Click"
    Call WriteProcStart(sRoutineName)
    
    
    Dim nMacroIndex As Long
    Dim oTable As clsTable
    Dim sMacro As String
    Dim nRow As Long
    Dim nSpell As Long
    Dim bShowFields As Boolean
    
    cmdCast.Enabled = Not (lvwSpells.SelectedItem Is Nothing)
    
    'Also go calculate how many spell points we have left
    Call UpdateSpellPoints
    
    'Check to see if any of these spells use [SPELLTARGET], if not grey it out.
    bShowFields = False
    For nSpell = 1 To lvwSpells.ListItems.Count()
        If lvwSpells.ListItems.Item(nSpell).Selected = True Then
            If FindSpell(lvwSpells.ListItems.Item(nSpell).Key(), oTable, nRow) = True Then
                'Now find out if the macro has [SPELLTARGET] in it.
                nMacroIndex = oTable.FindColumn("Macro")
                sMacro = oTable.Data(nMacroIndex, nRow)
                
                If InStr(1, sMacro, "[SPELLTARGET]") > 0 Then
                    bShowFields = True
                End If
            End If
        End If
    Next nSpell
                    
    'Do we need the spell target fields?
    Call SetAttributes(lstTarget, bShowFields)
    Call SetAttributes(txtTarget, bShowFields)
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
