VERSION 5.00
Object = "{3D1B9A04-A58F-47CD-944E-362138909DD0}#1.7#0"; "FOTATools.ocx"
Begin VB.Form frmViewer 
   Caption         =   "Log Viewer"
   ClientHeight    =   6240
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   8595
   Icon            =   "frmViewer.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6240
   ScaleWidth      =   8595
   Begin VB.CommandButton cmdSaveAsRTF 
      Caption         =   "Save As RTF"
      Height          =   375
      Left            =   5760
      TabIndex        =   1
      Top             =   5760
      Visible         =   0   'False
      Width           =   1215
   End
   Begin FOTATools.FOTARichTextBox rtbLog 
      Height          =   5535
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Visible         =   0   'False
      Width           =   8295
      _ExtentX        =   14631
      _ExtentY        =   9763
      Text            =   "RichText"
      TextRTF         =   $"frmViewer.frx":0442
      AutoVerbMenu    =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.PictureBox picToShow 
      AutoSize        =   -1  'True
      Height          =   5535
      Left            =   120
      ScaleHeight     =   5475
      ScaleWidth      =   8205
      TabIndex        =   3
      Top             =   120
      Visible         =   0   'False
      Width           =   8265
   End
   Begin VB.CommandButton cmdDone 
      Caption         =   "Done"
      Height          =   375
      Left            =   7200
      TabIndex        =   2
      Top             =   5760
      Width           =   1215
   End
   Begin FOTATools.FOTAFormResize FOTAFormResize1 
      Left            =   2160
      Top             =   5760
      _ExtentX        =   635
      _ExtentY        =   635
   End
   Begin VB.Label lblComplete 
      AutoSize        =   -1  'True
      Caption         =   "Loading..."
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   360
      Left            =   120
      TabIndex        =   4
      Top             =   120
      Width           =   1245
   End
End
Attribute VB_Name = "frmViewer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const m_cNAME As String = "frmViewer"

Private m_sLogFileLoaded As String

Private Sub cmdDone_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".cmdDone_Click"
    Call WriteProcStart(sRoutineName)

    
    Call Unload(Me)


    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
Public Sub LoadInLogFile(sFileName As String)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LoadInLogFile"
    Call WriteProcStart(sRoutineName) ' sFileName)

    
    Dim nFile As Long
    Dim sLineIn As String
    Dim sMsg As String
    Dim nFileSize As Long
    Dim nPerc As Long
    
    Me.Visible = True
    m_sLogFileLoaded = sFileName
    
    If rtbLog.IsValidLogFile(sFileName) = True Then
        Call rtbLog.LoadFromLogFile(sFileName)
    Else
        nFile = FreeFile
        nFileSize = FileLen(sFileName)
    
        Open sFileName For Input As #nFile
        
            While EOF(nFile) = False
                Line Input #nFile, sLineIn
                If InStr(1, sLineIn, ":") > 0 Then sMsg = sMsg & " \par "
                sMsg = sMsg & sLineIn
                
                If Not nPerc = (Loc(nFile) / (nFileSize / 128)) * 100 Then
                     nPerc = (Loc(nFile) / (nFileSize / 128)) * 100
                     lblComplete.Caption = "Loading... (" & nPerc & "%)"
                End If
                DoEvents
            Wend
        
            rtbLog.TextRTF = "{\rtf1\ansi\deff0\deftab720{\fonttbl{\f0\fswiss MS Sans Serif;}{\f1\froman\fcharset2 Symbol;}{\f2\fswiss MS Sans Serif;}}" & _
                            "{\colortbl\red0\green0\blue0;}" & _
                            "\deflang1033\pard\plain\f2\fs17 " & _
                            sMsg & "\par }"
        Close #nFile
    End If
    
    'Configure the screen for log viewing
    cmdSaveAsRTF.Visible = True
    rtbLog.Visible = True
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub

Public Sub LoadInPictureFile(sFileName As String)
    
    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LoadInPictureFile"
    Call WriteProcStart(sRoutineName) ' sFileName)


    Me.Visible = True
    
    picToShow.Picture = LoadAPicture(, sFileName)
    
    Me.Width = 105 + picToShow.Width + 225
    Me.Height = 105 + picToShow.Height + 1005
    
    cmdDone.Top = Me.Height - 810
    cmdDone.Width = Me.Width - 225 - 105
    
    'Configure the screen for picture viewing
    picToShow.Visible = True
    

    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub
Public Sub LoadInVersionChangesFile()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".LoadInVersionChangesFile"
    Call WriteProcStart(sRoutineName)
    
    
    Me.Visible = True
    Call rtbLog.LoadFromRTFFile(g_cDNDONLINEDIR & "VerChg.txt")
    'Configure the screen for our use
    rtbLog.Visible = True
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub cmdSaveAsRTF_Click()

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".rtbLog_LogFileLoadPercent"
    Call WriteProcStart(sRoutineName) ' nPercent)
    
    
    Dim sFileTemp As String
    
    sFileTemp = m_sLogFileLoaded
    sFileTemp = Left(sFileTemp, Len(sFileTemp) - 3) & "RTF"

    sFileTemp = GetFile(sFileTemp, True, "Rich Text File (*.RTF)|*.RTF|All Files (*.*)|*.*")

    'Check to see... does this players DB exist?
    If sFileTemp <> sFileTemp Then
        Call rtbLog.SaveToRTFFile(sFileTemp)
        Call MsgBox("Log File Saved As '" & sFileTemp & "'", vbOKOnly + vbInformation, "File Saved")
    End If
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount

End Sub

Private Sub rtbLog_LogFileLoadPercent(nPercent As Long)

    On Error GoTo ErrorHandler
    Dim sRoutineName As String
    sRoutineName = m_cNAME & ".rtbLog_LogFileLoadPercent"
    Call WriteProcStart(sRoutineName) ' nPercent)
    
    
    lblComplete.Caption = "Loading... (" & nPercent & "%)"
    DoEvents
    
    
    Call WriteProcStop(sRoutineName)
    'Exit the sub... on an error we will jump over this function
    Exit Sub
ErrorHandler:
    Call LogErrorToFile(sRoutineName & "." & Err.Description): Call g_oErrors.HandleErrorWithSource(Err, sRoutineName): Call g_oErrors.DisplayErrorCount
    
End Sub
