VERSION 5.00
Begin VB.UserControl FOTACustSize 
   BackColor       =   &H008080FF&
   ClientHeight    =   255
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   1935
   ScaleHeight     =   255
   ScaleWidth      =   1935
   ToolboxBitmap   =   "FOTACustSize.ctx":0000
   Begin VB.CheckBox chkCheckbox 
      Caption         =   "Customize Control Size"
      Height          =   255
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   1935
   End
End
Attribute VB_Name = "FOTACustSize"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'Force declaration of variables
Option Explicit

'This is how we link into the form's events
Private WithEvents FormEventLink As Form
Attribute FormEventLink.VB_VarHelpID = -1
Public Event Click()
Public Event HookForm()
Public Event UnHookForm()

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Global Variables
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private sSaveLoc As String 'Property Data stored here
Private bSaveForm As Boolean 'Property Data stored here

'This is to get around the stupid load issue.  Its setting the form pos
'after the load.  So we will do it during the first resize... ONLY ONCE
Private bActivatedBefore As Boolean



''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Properties
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Property Get hwnd() As Long
    hwnd = chkCheckbox.hwnd
End Property
Property Get Caption() As String
    Caption = chkCheckbox.Caption
End Property
Property Let Caption(sNewCaption As String)
    chkCheckbox.Caption = sNewCaption
End Property
Property Get SaveLocation() As String
    SaveLocation = sSaveLoc
End Property
Property Let SaveLocation(sNewSaveLoc As String)
    sSaveLoc = sNewSaveLoc
End Property
Property Get SaveForm() As Boolean
    SaveForm = bSaveForm
End Property
Property Let SaveForm(bNewSaveForm As Boolean)
    bSaveForm = bNewSaveForm
End Property
Property Get Value() As Integer
    Value = chkCheckbox.Value
End Property
Property Let Value(nValue As Integer)
    chkCheckbox.Value = nValue
End Property





''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Events
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub FormEventLink_Unload(Cancel As Integer)

    'If they closed down the form without unhooking
    If nSizeIsChecked = vbChecked Then
        nSizeIsChecked = vbUnchecked
        Call UnHookForm
    End If

    'If were saving... do so
    If bSaveForm = True Then Call SaveControlLayout(FormEventLink, SaveName(sSaveLoc))
    
End Sub
Private Sub chkCheckbox_Click()

    nSizeIsChecked = chkCheckbox.Value
    
    If nSizeIsChecked = vbChecked Then
        Call HookForm
    Else
        Call UnHookForm
    End If
    
    RaiseEvent Click
    
End Sub
Private Sub chkCheckbox_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

    'This is a catch all.  There are some controls that do not handle the mousedown message
    'properly.  Because of this a form click has been added to drop the object
    If bControlSelected = True Then

        Call UnHookControl(nControlHandle)
                                
    End If
    
End Sub
Private Sub FormEventLink_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    
    'This is a catch all.  There are soem controls that donot handle the mousedown message
    'properly.  Because of this a form click has been aded to drop the object
    If bControlSelected = True Then

        Call UnHookControl(nControlHandle)
        
    End If
        
End Sub
Private Sub FormEventLink_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    Call MouseMovedOverMe(X, Y) 'FormEventLink
        
End Sub
'If this is the first resize, then load the form
'Private Sub FormEventLink_Load()
Private Sub FormEventLink_Activate()

    If bActivatedBefore = False Then
        bActivatedBefore = True

        'Is the form in the right mode for this control to work?  Lets check!
        'If the parent form isn't in manual startup, you can't adjust its position
        If FormEventLink.StartUpPosition <> 0 Then
            Call MsgBox("Warning!  The form " & FormEventLink.Name & " is not set to manual StartUpPosition." & Chr$(13) & _
                    "Please change this property if you wish this control to work properly.", vbOKOnly, "FOTATool Kit Warning")
        End If
            
        'If were saving... load it
        If bSaveForm = True Then
            Call LoadControlLayout(FormEventLink, SaveName(sSaveLoc))
        End If
    
    End If

End Sub
'If they click on the conotrl, click
Private Sub UserControl_Click()

    RaiseEvent Click

End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)

    chkCheckbox.Caption = PropBag.ReadProperty("MyCaption", "Customize Form Layout")
    bSaveForm = PropBag.ReadProperty("MySaveForm", False)
    sSaveLoc = PropBag.ReadProperty("MySaveLoc", "FormName (Constant)")
    
    If Ambient.UserMode = False Then Exit Sub

    'This catches all the events for the form
    Set FormEventLink = Parent

    'This stores the form and the form handle for the module
    Set gSizeForm = Parent

End Sub
'Prevent them from resizing the control in design mode
Private Sub UserControl_Resize()

    'If they resize the control, resize the checkbox
    chkCheckbox.Height = UserControl.Height
    chkCheckbox.Width = UserControl.Width

End Sub


'Record the properties for this control
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)

    Call PropBag.WriteProperty("MyCaption", chkCheckbox.Caption, "Customize Form Layout")
    Call PropBag.WriteProperty("MySaveForm", bSaveForm, False)
    Call PropBag.WriteProperty("MySaveLoc", sSaveLoc, "FormName (Constant)")

End Sub




''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Private Member functions
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Grab the message handler for this form and pre-empt. it.  DO NOT shut down
'without returning control to the normal form.
Private Sub HookForm()

    RaiseEvent HookForm
    
    'Create a message sink
    lpSizePrevFormWndProc = SetWindowLong(gSizeForm.hwnd, GWL_WNDPROC, AddressOf WindowProc_FormSize)
        
End Sub
'Return this message handler back to the system
Private Sub UnHookForm()
    
    RaiseEvent UnHookForm
    
    'Undo the message sink.  I am not sure why we catch the value.
    Call SetWindowLong(gSizeForm.hwnd, GWL_WNDPROC, lpSizePrevFormWndProc)
    
End Sub

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Public functions for user consumption
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Set the form back to design layout
Public Sub ResetForm()

    Call Kill(SaveName(sSaveLoc))

End Sub
'Convert the file name into a better form.  If they used the default or
'if they left it blank drop it in this directory with the form name as file name
Public Function SaveName(sName As String) As String

    If UCase(Left(sName, 8)) = "FORMNAME" Or Len(sName) = 0 Then
        SaveName = App.Path & "\" & FormEventLink.Name & ".ini"
    Else
        SaveName = sName
    End If
    
End Function
Private Sub MouseMovedOverMe(nX As Single, nY As Single)

    'Are we in edit mode?
    If bControlSelected = True Then

        'If they moved the mouse cursor off the control, move the control to that
        'side.  I cannot at this point resize it in the opposite direction
        If nX - gSizeForm.Controls(nControlUsed).Left < 0 Then
            gSizeForm.Controls(nControlUsed).Left = nX
        End If
        
        'Set the new width
        gSizeForm.Controls(nControlUsed).Width = Abs(nX - gSizeForm.Controls(nControlUsed).Left)
            
        'Comboboxes can't adjust height
        If Not TypeOf gSizeForm.Controls(nControlUsed) Is ComboBox Then
        
            'If they moved the mouse cursor off the control, move the control to that side.  I
            'cannot at this point resize it in the opposite direction
            If nY - gSizeForm.Controls(nControlUsed).Top < 0 Then
                gSizeForm.Controls(nControlUsed).Top = nY
            End If
            'Set the new height
            gSizeForm.Controls(nControlUsed).Height = Abs(nY - gSizeForm.Controls(nControlUsed).Top)
            
        End If 'End of type check
        
    End If

End Sub
