VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsNetworkFileTransfer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private m_bStarted As Boolean
Private m_nTotalFileSizeInBytes As Long
Private m_nBytesSent As Long

Private m_bForceToAccept As Boolean
Private m_bSilentSend As Boolean
Private m_nStartTime As Long

Private m_sFileName As String
Private m_sGUID As String
Private m_colPlayers_Requesting As New Collection
Private m_colPlayers_Accepted As New Collection
'File we'll use to open the file were sending
Private m_nFreeFile As Long
'This is how many bits we will put into a transmission
Private m_nBitsPerPacket As Long
Private Const m_cByteStrSep As String = ""

'Chris
Private m_oConfirmationWaitList As New clsFOTAArray

Public Property Get Started() As Boolean
    Started = m_bStarted
End Property

Public Sub WaitListReset()
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.WaitListReset"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
    Dim oLoopPlayer As clsNetworkPlayer
    
    Call m_oConfirmationWaitList.RemoveAll
    
    For Each oLoopPlayer In m_colPlayers_Accepted
        Call m_oConfirmationWaitList.Add("", oLoopPlayer.Name & ":" & oLoopPlayer.Number)
    Next oLoopPlayer
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub
Public Function WaitListLength() As Long
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.WaitListLength"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    WaitListLength = m_oConfirmationWaitList.Count
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Function                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Function
Public Sub WaitListRemove(oPlayer As clsNetworkPlayer)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.WaitListRemove"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Dim sKey As String
    sKey = oPlayer.Name & ":" & oPlayer.Number
    If m_oConfirmationWaitList.KeyInList(sKey) = True Then
        Call m_oConfirmationWaitList.Remove(sKey)
    End If
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub
Public Sub WaitListMarkoff(nPlayerNumber As Long)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.WaitListMarkoff"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Dim oLoopPlayer As clsNetworkPlayer
    For Each oLoopPlayer In m_colPlayers_Accepted
        If oLoopPlayer.Number = nPlayerNumber Then
            If m_oConfirmationWaitList.KeyInList(oLoopPlayer.Name & ":" & oLoopPlayer.Number) = True Then
                Call WaitListRemove(oLoopPlayer)
            Else
                Call Err.Raise(-1, "FOTANetworking", "Player not found in network file transfer wait list")
            End If
        End If
    Next oLoopPlayer
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub

Public Property Get PercentDone() As Double
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.PercentDone"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    If m_nTotalFileSizeInBytes = 0 Or m_nBytesSent = 0 Then
        PercentDone = 0
    Else
        PercentDone = CDbl(m_nBytesSent) / CDbl(m_nTotalFileSizeInBytes) * 100
    End If
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property

Public Function PlayersRequestingCount() As Long
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.PlayersRequestingCount"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    PlayersRequestingCount = m_colPlayers_Requesting.Count()
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Function                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Function
Public Function PlayersAcceptedCount() As Long
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.PlayersAcceptedCount"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    PlayersAcceptedCount = m_colPlayers_Accepted.Count()
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Function                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Function

Public Property Get BitsPerPacket() As Long
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.BitsPerPacket"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    BitsPerPacket = m_nBitsPerPacket
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
Public Property Let BitsPerPacket(nNewBitsPerPacket As Long)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.BitsPerPacket"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_nBitsPerPacket = nNewBitsPerPacket
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property

Public Property Get FileName() As String
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.FileName"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    FileName = m_sFileName
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
Public Property Let FileName(sNewName As String)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.FileName"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_sFileName = sNewName
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property

Public Property Get SourceFileSize() As Long
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.SourceFileSize"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_nTotalFileSizeInBytes = FileLen(m_sFileName)
    SourceFileSize = m_nTotalFileSizeInBytes
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
Public Property Let SourceFileSize(nNewName As Long)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.SourceFileSize"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_nTotalFileSizeInBytes = nNewName
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property

Public Property Get GUID() As String
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.GUID"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    GUID = m_sGUID
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
Public Property Let GUID(sNewGUID As String)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.GUID"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_sGUID = sNewGUID
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property

Public Sub RemovePlayer(oPlayer As clsNetworkPlayer)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.RemovePlayer"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error Resume Next
    Call m_colPlayers_Accepted.Remove("#" & oPlayer.Number())
    Call m_colPlayers_Requesting.Remove("#" & oPlayer.Number())
    Call WaitListRemove(oPlayer)
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub

Public Sub AddPlayer(oSendToPlayer As clsNetworkPlayer)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.AddPlayer"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Call m_colPlayers_Requesting.Add(oSendToPlayer, "#" & oSendToPlayer.Number)
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub
Public Sub PlayerResponded(oPlayer As clsNetworkPlayer, bResponse As Boolean)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.PlayerResponded"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    If bResponse = True Then
        Call m_colPlayers_Accepted.Add(oPlayer, "#" & oPlayer.Number())
    End If
    Call m_colPlayers_Requesting.Remove("#" & oPlayer.Number())
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub
Private Sub Class_Initialize()
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.Class_Initialize"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_sGUID = "FileTransfer" & ":" & Timer & Int((10000 * Rnd) + 1)
    m_nBitsPerPacket = 500
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub

'This function must be public so that the network ocx can call it.  However a user
'should never use this function, they should use the StartFileTransfer
Public Sub SYS_SetStartingCriteria()
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.SYS_SetStartingCriteria"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
    Dim sFileError As String
    sFileError = m_sFileName
    
    'This means were a go!  Send the file.
    m_bStarted = True
    m_nFreeFile = FreeFile
    m_nTotalFileSizeInBytes = FileLen(m_sFileName)
    m_nStartTime = Timer

    Open m_sFileName For Binary Access Read As #m_nFreeFile
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description & "  (File:" & sFileError & ")")                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub
'This returns if we have finished the file transfer
Public Function GetNextFilePacket(ByRef oMsg As clsNetworkMessage) As Boolean
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.GetNextFilePacket"                                                 '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Dim sFileError As String
    sFileError = m_sFileName
    
    If m_bStarted = False Then
        Call Err.Raise(-1, "FOTATools.clsNetworkFileTransfer", "File Transfer has not been started.")
        GetNextFilePacket = True
    Else
        Dim sByteString As String
        Dim nNumBytes As Long
        Dim l As Long
        Dim bBite As Byte
    
        'Go through and get all the bites to send
        GetNextFilePacket = False
        For nNumBytes = 0 To m_nBitsPerPacket
            'Still have stuff to get?
            If EOF(m_nFreeFile) = False Then
                'Get the bites
                Get #m_nFreeFile, , bBite
                'Add the bites to the bite string
                sByteString = sByteString & Str(bBite) & m_cByteStrSep
                m_nBytesSent = m_nBytesSent + 1
            Else
                Close #m_nFreeFile
                GetNextFilePacket = True
                Exit For
            End If
        Next nNumBytes
        
        'Create our message
        Call oMsg.AddParamater(sByteString)
    End If
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Exit Function                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description & "  (File:" & sFileError & ")")                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Function
Public Sub WriteNextFilePacket(oMsg As clsNetworkMessage)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.WriteNextFilePacket"                                                 '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Dim i As Long
    Dim sFullData As String
    Dim sPartData As String
    Dim bOpeningFile As Boolean
    Dim sFileError As String
    
    sFileError = m_sFileName

    If m_bStarted = False Then
        'This means were a go!  Send the file.
        m_bStarted = True
        m_nFreeFile = FreeFile

        bOpeningFile = True
        Open m_sFileName For Binary Access Write As #m_nFreeFile
        bOpeningFile = False
    End If
    
    sFullData = oMsg.Paramater(2)
    
    'Parse through the byte stream
    While Len(Trim(sFullData)) > 0

        'Grab the first packet in the listing
        If InStr(1, sFullData, m_cByteStrSep) > 0 Then
            sPartData = Left(sFullData, InStr(1, sFullData, m_cByteStrSep) - 1)
            sFullData = Right(sFullData, Len(sFullData) - InStr(1, sFullData, m_cByteStrSep))
        Else
            sPartData = sFullData
            sFullData = ""
        End If

        'Write it to the file
        If Len(Trim(sPartData)) > 0 Then
            Put #m_nFreeFile, , CByte(sPartData)
            m_nBytesSent = m_nBytesSent + 1
        End If

    Wend
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Exit Sub                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description & "  (File:" & sFileError & ")")                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Sub

Public Property Get ForceToAccept() As Boolean
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.ForceToAccept"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    ForceToAccept = m_bForceToAccept
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
Public Property Let ForceToAccept(bForce As Boolean)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.ForceToAccept"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_bForceToAccept = bForce
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
    
Public Property Get SilentSend() As Boolean
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.SilentSend"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    SilentSend = m_bSilentSend
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
Public Property Let SilentSend(bForce As Boolean)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.SilentSend"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_bSilentSend = bForce
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property

Public Property Get TotalFileSize() As Long
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.TotalFileSize"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    TotalFileSize = m_nTotalFileSizeInBytes
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
Public Property Let TotalFileSize(nTotalFileSize As Long)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.TotalFileSize"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_nTotalFileSizeInBytes = nTotalFileSize
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property

Public Property Get BytesSent() As Long
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.BytesSent"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    BytesSent = m_nBytesSent
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
Public Property Let BytesSent(nBytesSent As Long)
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.BytesSent"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    m_nBytesSent = nBytesSent
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property

Public Property Get TimeRemaining() As String
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.TimeRemaining"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
    Dim nValue As Double
    
    If m_nBytesSent = 0 Then
        TimeRemaining = "0 s"
    Else
        nValue = CDbl(CDbl(Timer - m_nStartTime) / m_nBytesSent) * _
                 CDbl(m_nTotalFileSizeInBytes - m_nBytesSent)
        If nValue <= 60 Then
            TimeRemaining = nValue & "s"
        ElseIf nValue <= 60 * 60 Then
            TimeRemaining = FormatNumber(Fix(nValue / 60), 0) & "m "
            nValue = nValue - Fix(nValue / 60) * 60
            TimeRemaining = TimeRemaining & FormatNumber(Fix(nValue), 0) & "s"
        ElseIf nValue / 60 <= 60 * 60 Then
            nValue = nValue / 60
            TimeRemaining = FormatNumber(Fix(nValue / 60), 0) & "h "
            nValue = nValue - Fix(nValue / 60) * 60
            TimeRemaining = TimeRemaining & FormatNumber(Fix(nValue), 0) & "m"
        Else
            nValue = nValue / (60 * 60)
            TimeRemaining = FormatNumber(Fix(nValue / 24), 0) & "d "
            nValue = nValue - Fix(nValue / 24) * 24
            TimeRemaining = TimeRemaining & FormatNumber(CLng(nValue), 0) & "h"
        End If
    End If
 
                                                                                                                        '<FOTATOOLS_ADDER>
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
Public Property Get TimeSoFar() As String
                                                                                                                        '<FOTATOOLS_ADDER>
    On Error GoTo ErrorHandler                                                                                          '<FOTATOOLS_ADDER>
    Dim sRoutineName As String                                                                                          '<FOTATOOLS_ADDER>
    sRoutineName = "FOTATools.clsNetworkFileTransfer.TimeSoFar"                                                 '<FOTATOOLS_ADDER>
    
                                                                                                                        '<FOTATOOLS_ADDER>
    Dim nValue As Double
    
    nValue = CLng(Timer - m_nStartTime)
    If nValue <= 60 Then
        TimeSoFar = nValue & "s"
    ElseIf nValue <= 60 * 60 Then
        TimeSoFar = FormatNumber(Fix(nValue / 60), 0) & "m "
        nValue = nValue - Fix(nValue / 60) * 60
        TimeSoFar = TimeSoFar & FormatNumber(Fix(nValue), 0) & "s"
    ElseIf nValue / 60 <= 60 * 60 Then
        nValue = nValue / 60
        TimeSoFar = FormatNumber(Fix(nValue / 60), 0) & "h "
        nValue = nValue - Fix(nValue / 60) * 60
        TimeSoFar = TimeSoFar & FormatNumber(Fix(nValue), 0) & "m"
    Else
        nValue = nValue / (60 * 60)
        TimeSoFar = FormatNumber(Fix(nValue / 24), 0) & "d "
        nValue = nValue - Fix(nValue / 24) * 24
        TimeSoFar = TimeSoFar & FormatNumber(CLng(nValue), 0) & "h"
    End If
                                                                                                                    
    
    Exit Property                                                                                               '<FOTATOOLS_ADDER>
ErrorHandler:                                                                                                           '<FOTATOOLS_ADDER>
     Call Err.Raise(Err.Number, sRoutineName, Err.Description)                                                          '<FOTATOOLS_ADDER>
                                                                                                                        '<FOTATOOLS_ADDER>
End Property
