Attribute VB_Name = "modLayout"
'Old Message Handler
Global lpLayoutPrevWndProc As Long

'Global form pointer
Global gLayoutForm As Form

'The place we picked it up.  This is used as a displacement so
'that we know where to put it down.
Global nLayoutPickUpX As Long
Global nLayoutPickUpY As Long

'Is the box checked?  Can't seem to access the property from here
Global nLayoutIsChecked As Long


'Our own handy dandy message handler.
Function WindowProc_Layout(ByVal hw As Long, ByVal uMsg As _
    Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    
    'Place to store
    Dim ptClk As POINTAPI
    Dim ptZero As POINTAPI
    'For parsing out the hi and low bits
    Dim nHi As Long
    Dim nLow As Long

    'Is the custimizing feature turned on?
    If nLayoutIsChecked = vbChecked And (uMsg = WM_MOUSEACTIVITY Or uMsg = WM_LBUTTONDOWN) Then

        'Get the click point
        Call GetCursorPos(ptClk)
        'Get the screen cordinates for the upper left of this form
        Call ClientToScreen(gLayoutForm.hwnd, ptZero)
        
        'Convert the pixel location, to a screen location
        nLow = (ptClk.x * Screen.TwipsPerPixelX) - (Screen.TwipsPerPixelX * ptZero.x)
        nHi = (ptClk.y * Screen.TwipsPerPixelY) - (Screen.TwipsPerPixelY * ptZero.y)

        'Pickup the object
        Call MouseClick_Layout(nLow, nHi)
        
    End If
    
    'Now let the normal Message Handler ahve the message
    WindowProc_Layout = CallWindowProc(lpLayoutPrevWndProc, hw, uMsg, wParam, lParam)
    
End Function
'Nx and Ny are the absolute click locations on the screen
Private Sub MouseClick_Layout(nX As Long, nY As Long)

    On Error Resume Next

    Dim i As Integer
    'Decide which one to grab
    Dim nHighest As Integer
    Dim nHeight As Integer
    nHighest = -1
    
    'Step through all the controls on the form
    For i = 0 To gLayoutForm.Controls.Count - 1
    
        Call FindHighestControl(gLayoutForm, i, nHighest, nHeight, _
                nX, nY, nLayoutPickUpX, nLayoutPickUpY)
        
    Next i 'Move to the next control

    'Did we find one to pick up?
    If nHighest > -1 Then gLayoutForm.Controls(nHighest).Drag

End Sub
